/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.foundation.support.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.foundation.support.bean.ReferEntity;
import com.ejianc.foundation.support.bean.ReferShowfieldEntity;
import com.ejianc.foundation.support.service.IModuleService;
import com.ejianc.foundation.support.service.IReferService;
import com.ejianc.foundation.support.service.IReferShowfieldService;
import com.ejianc.foundation.support.vo.ModuleVO;
import com.ejianc.foundation.support.vo.PublishDataVO;
import com.ejianc.foundation.support.vo.PublishVO;
import com.ejianc.foundation.support.vo.ReferShowfieldVO;
import com.ejianc.foundation.support.vo.ReferVO;
import com.ejianc.foundation.util.DataTransferUtil;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.refer.util.ReferHttpClientUtils;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.Serializable;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"refer"})
public class ReferController
implements Serializable {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private Gson gson = new Gson();
    private static final long serialVersionUID = 1L;
    @Autowired
    private IReferService referService;
    @Autowired
    private IModuleService moduleService;
    @Autowired
    private IReferShowfieldService referShowfieldService;

    @RequestMapping(value={"/pageList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<JSONObject> pageList(@RequestBody QueryParam queryParam) {
        IPage<ReferVO> pageData = this.referService.pageList(queryParam, false);
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("data", pageData);
        return CommonResponse.success((Object)jsonObject);
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<ReferVO> queryDetail(@RequestParam Long id) {
        ReferVO ReferVo = this.referService.queryDetail(id);
        return CommonResponse.success((Object)ReferVo);
    }

    @RequestMapping(value={"/save"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> save(@RequestBody ReferVO ReferVo) {
        return this.referService.saveOrUpdate(ReferVo, false);
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<Long> ids) {
        return this.referService.delete(ids);
    }

    @RequestMapping(value={"/findByCode"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<ReferVO> findByCode(HttpServletRequest request, @RequestParam String refCode) {
        ReferVO vo;
        String authority = request.getHeader("authority");
        if (StringUtils.isNotBlank((CharSequence)authority)) {
            String[] ac;
            HashMap<String, String> authorityMap = new HashMap<String, String>();
            for (String s : ac = authority.split(";")) {
                String[] cookieArr = s.split("=");
                String key = StringUtils.trim((String)cookieArr[0]);
                String value = StringUtils.trim((String)cookieArr[1]);
                authorityMap.put(key, value);
            }
            if (StringUtils.isNotBlank((CharSequence)((CharSequence)authorityMap.get("u_usercode")))) {
                InvocationInfoProxy.setUserid((Long)Long.parseLong((String)authorityMap.get("u_usercode")));
            }
            if (StringUtils.isNotBlank((CharSequence)((CharSequence)authorityMap.get("tenantid")))) {
                InvocationInfoProxy.setTenantid((Long)Long.parseLong((String)authorityMap.get("tenantid")));
            }
        }
        if ((vo = this.referService.findByCode(refCode)).getRefType() != null && vo.getRefType().equals("multiInOne") && StringUtils.isNotEmpty((CharSequence)vo.getMultiRefCode())) {
            String[] codes = vo.getMultiRefCode().split(",");
            for (int i = 0; i < codes.length; ++i) {
                String code = codes[i];
                ReferVO multiRef = this.referService.findByCode(code);
                vo.getMultiRefInfo().add(multiRef);
            }
        }
        return CommonResponse.success((Object)vo);
    }

    @RequestMapping(value={"/refdata"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<ReferVO>> refdata(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String relyCondition, String relyNode, String searchText) {
        QueryParam queryParam = new QueryParam();
        queryParam.setPageIndex(pageNumber.intValue());
        queryParam.setPageSize(pageSize.intValue());
        Map param = queryParam.getParams();
        if (!StringUtils.isEmpty((CharSequence)relyCondition)) {
            param.put("referModule", new Parameter("eq", (Object)relyCondition.split("=")[1]));
        }
        if (!StringUtils.isEmpty((CharSequence)searchText)) {
            param.put("refName", new Parameter("like", (Object)searchText));
        }
        IPage<ReferVO> pageData = this.referService.pageList(queryParam, false);
        return CommonResponse.success((String)"\u67e5\u8be2\u6570\u8868\u53c2\u7167\u6210\u529f", pageData);
    }

    @RequestMapping(value={"/refFields"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<ReferShowfieldVO>> refFields(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, @RequestParam(required=false) String searchText) {
        QueryParam queryParam = new QueryParam();
        queryParam.setPageIndex(pageNumber.intValue());
        queryParam.setPageSize(pageSize.intValue());
        queryParam.setSearchText(searchText);
        queryParam.getFuzzyFields().addAll(Arrays.asList("name", "code"));
        if (StringUtils.isEmpty((CharSequence)condition)) {
            return CommonResponse.error((String)"condition\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        JSONObject _con = JSONObject.parseObject((String)condition);
        String referCode = _con.getString("referCode");
        QueryParam refQ = new QueryParam();
        refQ.getParams().put("refCode", Parameter.getEqInstance((Object)referCode));
        List entityList = this.referService.queryList(refQ, false);
        if (ListUtil.isEmpty((List)entityList)) {
            return CommonResponse.error((String)"\u53c2\u7167\u4e0d\u5b58\u5728\uff01");
        }
        queryParam.getParams().put("referId", Parameter.getEqInstance((Object)((ReferEntity)((Object)entityList.get(0))).getId()));
        queryParam.getOrderMap().put("showOrder", "asc");
        IPage fileds = this.referShowfieldService.queryPage(queryParam);
        Page pageData = new Page(fileds.getCurrent(), fileds.getSize(), fileds.getTotal());
        if (ListUtil.isNotEmpty((List)fileds.getRecords())) {
            List vos = BeanMapper.mapList((Iterable)fileds.getRecords(), ReferShowfieldVO.class);
            pageData.setRecords(vos);
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u5b57\u6bb5\u6210\u529f", (Object)pageData);
    }

    @ResponseBody
    @RequestMapping(value={"publish"})
    public CommonResponse<String> publish(@RequestBody PublishVO publishVO) {
        try {
            String targetEnv = publishVO.getTarget();
            if (StringUtils.isBlank((CharSequence)targetEnv)) {
                return CommonResponse.error((String)"\u53d1\u5e03\u6570\u636e\u5931\u8d25:\u76ee\u6807\u73af\u5883\u57df\u540d\u4e0d\u80fd\u4e3a\u7a7a!");
            }
            String scope = publishVO.getScope();
            if (StringUtils.isBlank((CharSequence)scope)) {
                return CommonResponse.error((String)"\u53d1\u5e03\u6570\u636e\u5931\u8d25:\u6570\u636e\u8303\u56f4\u4e0d\u80fd\u4e3a\u7a7a!");
            }
            ArrayList<Long> ids = null;
            ArrayList<String> codes = null;
            List baseEntities = null;
            List<ReferShowfieldEntity> fieldEntities = null;
            if ("all".equalsIgnoreCase(scope)) {
                QueryParam queryParam = new QueryParam();
                List<ModuleVO> moduleVOs = this.moduleService.queryAllChildrenByPid(publishVO.getModuleId());
                ArrayList<Long> moduleIds = new ArrayList<Long>();
                for (ModuleVO vo : moduleVOs) {
                    moduleIds.add(vo.getId());
                }
                HashMap<String, Parameter> params = new HashMap<String, Parameter>();
                params.put("referModule", new Parameter("in", moduleIds));
                queryParam.setParams(params);
                baseEntities = this.referService.queryList(queryParam, false);
            } else if ("select".equalsIgnoreCase(scope)) {
                if (publishVO.getIdList() != null && publishVO.getIdList().size() > 0) {
                    baseEntities = (List)this.referService.listByIds(publishVO.getIdList());
                } else {
                    return CommonResponse.error((String)"\u672a\u9009\u4e2d\u8981\u53d1\u5e03\u7684\u6570\u636e");
                }
            }
            if (ids == null || ids.isEmpty() || codes == null || codes.isEmpty()) {
                ids = new ArrayList<Long>(baseEntities.size());
                codes = new ArrayList<String>(baseEntities.size());
                for (ReferEntity entity : baseEntities) {
                    if (entity.getId() != null) {
                        ids.add(entity.getId());
                    }
                    if (!StringUtils.isNotBlank((CharSequence)entity.getRefCode())) continue;
                    codes.add(entity.getRefCode());
                }
            }
            QueryWrapper queryWrapper = new QueryWrapper();
            queryWrapper.in((Object)"refer_id", ids);
            queryWrapper.eq((Object)"dr", (Object)0);
            queryWrapper.orderByAsc((Object)"show_order");
            fieldEntities = this.referShowfieldService.querylist((QueryWrapper<ReferShowfieldEntity>)queryWrapper);
            PublishDataVO publishDataVO = new PublishDataVO();
            if (baseEntities != null && baseEntities.size() > 0) {
                baseEntities.forEach(e -> {
                    e.setCreateUserCode(null);
                    e.setCreateTime(null);
                    e.setUpdateUserCode(null);
                    e.setUpdateTime(null);
                });
            }
            if (fieldEntities != null && fieldEntities.size() > 0) {
                fieldEntities.forEach(e -> {
                    e.setCreateUserCode(null);
                    e.setCreateTime(null);
                    e.setUpdateUserCode(null);
                    e.setUpdateTime(null);
                });
            }
            publishDataVO.setReferEntities(baseEntities);
            publishDataVO.setReferShowfieldEntities(fieldEntities);
            publishDataVO.setIds(ids);
            publishDataVO.setType("refer");
            String url = publishVO.getTarget() + "/ejc-support-web/dataTransfer/transferBySql";
            this.gson = new GsonBuilder().disableHtmlEscaping().create();
            String paramterStr = this.gson.toJson((Object)publishDataVO);
            this.logger.info("\u53d1\u5e03\u6570\u636e\u7684url\uff1a---------------" + url);
            try {
                String result = ReferHttpClientUtils.postByJson((String)url, (String)paramterStr);
                this.logger.info("\u53d1\u5e03\u6570\u636e\u8fd4\u56de\u7684\u7ed3\u679c\uff1a---------------" + result);
                return (CommonResponse)this.gson.fromJson(result, CommonResponse.class);
            }
            catch (Exception e2) {
                e2.printStackTrace();
                return CommonResponse.error((String)"\u53d1\u5e03\u53c2\u7167\u6570\u636e\u5931\u8d25");
            }
        }
        catch (Exception e3) {
            return CommonResponse.error((String)("\u53d1\u5e03\u53c2\u7167\u6570\u636e\u5931\u8d25:" + e3.getMessage()));
        }
    }

    private List<String> getDeleteSql(List<Long> ids, List<String> codes) {
        if (ids == null || ids.isEmpty()) {
            return null;
        }
        ArrayList<String> sqlList = new ArrayList<String>();
        String idStr = "";
        for (Long l : ids) {
            idStr = idStr + "'" + l + "',";
        }
        String codeStr = "";
        for (String code : codes) {
            codeStr = codeStr + "'" + code + "',";
        }
        idStr = "(" + idStr.substring(0, idStr.lastIndexOf(",")) + ")";
        codeStr = "(" + codeStr.substring(0, codeStr.lastIndexOf(",")) + ")";
        String string = "ejc_support_refer_showfield";
        String baseTableName = "ejc_support_refer";
        String deleteFieldSql = " delete from " + string + " where refer_id in " + idStr + ";";
        String deleteBaseSql = " delete from " + baseTableName + " where id in " + idStr + ";";
        String deleteByCodeSql = " delete from " + baseTableName + " where dr =1 and ref_code in " + codeStr + ";";
        sqlList.add(deleteFieldSql);
        sqlList.add(deleteBaseSql);
        sqlList.add(deleteByCodeSql);
        return sqlList;
    }

    private List<String> getInsertSql(List<ReferEntity> baseEntityList, List<ReferShowfieldEntity> fieldEntityList) throws Exception {
        ArrayList<String> retList = new ArrayList<String>();
        List<String> baseInsertSql = DataTransferUtil.getInsertSql(baseEntityList);
        List<String> fieldInsertSql = DataTransferUtil.getInsertSql(fieldEntityList);
        if (baseInsertSql != null && !baseInsertSql.isEmpty()) {
            retList.addAll(baseInsertSql);
        }
        if (fieldInsertSql != null && !fieldInsertSql.isEmpty()) {
            retList.addAll(fieldInsertSql);
        }
        return retList;
    }

    @ResponseBody
    @RequestMapping(value={"/exportSQL"})
    public void exportSQL(HttpServletRequest req, HttpServletResponse response, @RequestBody PublishVO publishVO) {
        try {
            String scope = publishVO.getScope();
            if (StringUtils.isBlank((CharSequence)scope)) {
                throw new BusinessException("\u5bfc\u51fa\u811a\u672c\u5931\u8d25:\u6570\u636e\u8303\u56f4\u4e0d\u80fd\u4e3a\u7a7a!");
            }
            ArrayList<Long> ids = null;
            ArrayList<String> codes = null;
            List baseEntities = null;
            List<ReferShowfieldEntity> fieldEntities = null;
            if ("all".equalsIgnoreCase(scope)) {
                QueryParam queryParam = new QueryParam();
                List<ModuleVO> moduleVOs = this.moduleService.queryAllChildrenByPid(publishVO.getModuleId());
                ArrayList<Long> moduleIds = new ArrayList<Long>();
                for (ModuleVO vo : moduleVOs) {
                    moduleIds.add(vo.getId());
                }
                HashMap<String, Parameter> params = new HashMap<String, Parameter>();
                params.put("referModule", new Parameter("in", moduleIds));
                queryParam.setParams(params);
                baseEntities = this.referService.queryList(queryParam, false);
            } else if ("select".equalsIgnoreCase(scope)) {
                if (publishVO.getIdList() != null && publishVO.getIdList().size() > 0) {
                    baseEntities = (List)this.referService.listByIds(publishVO.getIdList());
                } else {
                    throw new BusinessException("\u672a\u9009\u4e2d\u8981\u5bfc\u51fa\u811a\u672c\u7684\u6570\u636e!");
                }
            }
            if (ids == null || ids.isEmpty() || codes == null || codes.isEmpty()) {
                ids = new ArrayList<Long>(baseEntities.size());
                codes = new ArrayList<String>(baseEntities.size());
                for (ReferEntity entity : baseEntities) {
                    if (entity.getId() != null) {
                        ids.add(entity.getId());
                    }
                    if (!StringUtils.isNotBlank((CharSequence)entity.getRefCode())) continue;
                    codes.add(entity.getRefCode());
                }
            }
            QueryWrapper queryWrapper = new QueryWrapper();
            queryWrapper.in((Object)"refer_id", ids);
            queryWrapper.eq((Object)"dr", (Object)0);
            queryWrapper.orderByAsc((Object)"show_order");
            fieldEntities = this.referShowfieldService.querylist((QueryWrapper<ReferShowfieldEntity>)queryWrapper);
            ArrayList<String> sqls = new ArrayList<String>();
            List<String> deleteSql = this.getDeleteSql(ids, codes);
            List<String> insertSql = this.getInsertSql(baseEntities, fieldEntities);
            if (deleteSql != null && !deleteSql.isEmpty()) {
                sqls.addAll(deleteSql);
            }
            if (insertSql != null && !insertSql.isEmpty()) {
                sqls.addAll(insertSql);
            }
            StringBuffer fileName = new StringBuffer();
            fileName.append("billType.sql");
            response.setContentType("application/octet-stream; charset=utf-8");
            response.setHeader("Content-Disposition", "attachment; filename=" + URLEncoder.encode(fileName.toString(), "UTF-8"));
            ServletOutputStream out = response.getOutputStream();
            out.write(String.join((CharSequence)"\r\n", sqls).getBytes());
            out.flush();
            out.close();
        }
        catch (Exception e) {
            this.logger.error(e.getMessage());
            response.setStatus(400);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @RequestMapping(value={"/refReferShowfield"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<ReferShowfieldVO>> refReferShowfield(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        Long refId = null;
        if (!StringUtils.isNotEmpty((CharSequence)condition)) return CommonResponse.error((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u5931\u8d25\uff01");
        JSONObject _con = JSONObject.parseObject((String)condition);
        String refCode = _con.getString("refCode");
        if (StringUtils.isNotEmpty((CharSequence)refCode)) {
            QueryParam queryParam = new QueryParam();
            queryParam.getParams().put("refCode", new Parameter("eq", (Object)refCode));
            List pageData = this.referService.queryList(queryParam, false);
            if (!ListUtil.isNotEmpty((List)pageData)) return CommonResponse.error((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u5931\u8d25\uff01");
            ReferEntity en = (ReferEntity)((Object)pageData.get(0));
            refId = en.getId();
        }
        param.getParams().put("referId", new Parameter("eq", refId));
        param.getOrderMap().put("showOrder", "asc");
        IPage page = this.referShowfieldService.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), ReferShowfieldVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }
}

