/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.foundation.util;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.foundation.dataModel.vo.DataModelColumnVO;
import com.ejianc.framework.core.kit.collection.ListUtil;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;

public class CalculatorUtils {
    public static void main(String[] args) {
        HashMap<String, String> propertyMap = new HashMap<String, String>();
        System.out.println(CalculatorUtils.checkFormula("(amount1+amount2)*amount3", propertyMap));
    }

    public static BigDecimal getResult(String input, JSONObject mainDataset) {
        input = input.replaceAll("\uff08", "(");
        input = input.replaceAll("\uff09", ")");
        String[] inputs = input.split("");
        String format = "";
        for (int i = 0; i < inputs.length; ++i) {
            if (inputs[i].equals(" ")) continue;
            format = inputs[i].equals("(") || inputs[i].equals(")") || inputs[i].equals("+") || inputs[i].equals("-") || inputs[i].equals("*") || inputs[i].equals("/") ? format + " " + inputs[i] + " " : format + inputs[i];
        }
        List<String> strings = CalculatorUtils.changeInfixExpressionToPostfixExpression(format, mainDataset);
        Stack<String> stack = new Stack<String>();
        for (int i = 0; i < strings.size(); ++i) {
            BigDecimal b;
            BigDecimal a;
            if (strings.get(i).equals("+")) {
                a = new BigDecimal((String)stack.pop());
                b = new BigDecimal((String)stack.pop());
                stack.add(b.add(a).toString());
                continue;
            }
            if (strings.get(i).equals("-")) {
                a = new BigDecimal((String)stack.pop());
                b = new BigDecimal((String)stack.pop());
                stack.add(b.subtract(a).toString());
                continue;
            }
            if (strings.get(i).equals("*")) {
                a = new BigDecimal((String)stack.pop());
                b = new BigDecimal((String)stack.pop());
                stack.add(b.multiply(a).toString());
                continue;
            }
            if (strings.get(i).equals("/")) {
                a = new BigDecimal((String)stack.pop());
                b = new BigDecimal((String)stack.pop());
                stack.add(a.compareTo(new BigDecimal(0)) == 0 ? "0" : b.divide(a, 1000, 5).toString());
                continue;
            }
            stack.add(strings.get(i));
        }
        return new BigDecimal((String)stack.pop()).setScale(2, 5);
    }

    public static List<String> changeInfixExpressionToPostfixExpression(String input, JSONObject mainDataset) {
        ArrayList<String> resultList = new ArrayList<String>();
        Stack<String> tempStack = new Stack<String>();
        String[] splitArray = input.split(" ");
        for (int i = 0; i < splitArray.length; ++i) {
            if (splitArray[i].equals("")) continue;
            if (splitArray[i].equals(")")) {
                while (!((String)tempStack.peek()).equals("(")) {
                    resultList.add((String)tempStack.pop());
                }
                tempStack.pop();
                continue;
            }
            if (splitArray[i].equals("(")) {
                tempStack.add("(");
                continue;
            }
            if (splitArray[i].equals("+") || splitArray[i].equals("-")) {
                if (tempStack.empty() || ((String)tempStack.peek()).equals("(")) {
                    tempStack.add(splitArray[i]);
                    continue;
                }
                if (((String)tempStack.peek()).equals("+") || ((String)tempStack.peek()).equals("-")) {
                    resultList.add((String)tempStack.pop());
                    tempStack.add(splitArray[i]);
                    continue;
                }
                while (!tempStack.empty() && !((String)tempStack.peek()).equals("(")) {
                    resultList.add((String)tempStack.pop());
                }
                tempStack.add(splitArray[i]);
                continue;
            }
            if (splitArray[i].equals("*") || splitArray[i].equals("/")) {
                if (!tempStack.empty() && (((String)tempStack.peek()).equals("*") || ((String)tempStack.peek()).equals("/"))) {
                    resultList.add((String)tempStack.pop());
                }
                tempStack.add(splitArray[i]);
                continue;
            }
            if (StringUtils.isNotBlank((CharSequence)mainDataset.getString(splitArray[i]))) {
                resultList.add(mainDataset.getString(splitArray[i]));
                continue;
            }
            resultList.add(splitArray[i]);
        }
        while (!tempStack.empty()) {
            resultList.add((String)tempStack.pop());
        }
        return resultList;
    }

    public static Boolean checkFormula(String formula, Map<String, String> propertyMap) {
        Boolean checked = true;
        formula = formula.replaceAll("\uff08", "(");
        formula = formula.replaceAll("\uff09", ")");
        String[] inputs = formula.split("");
        String format = "";
        for (int i = 0; i < inputs.length; ++i) {
            if (inputs[i].equals(" ")) continue;
            format = inputs[i].equals("(") || inputs[i].equals(")") || inputs[i].equals("+") || inputs[i].equals("-") || inputs[i].equals("*") || inputs[i].equals("/") ? format + " " + inputs[i] + " " : format + inputs[i];
        }
        String[] splitArray = format.split(" ");
        ArrayList<String> tempList = new ArrayList<String>();
        for (int i = 0; i < splitArray.length; ++i) {
            if (splitArray[i].equals("")) continue;
            if (tempList.size() == 0) {
                if ("+".equals(splitArray[i]) || "-".equals(splitArray[i]) || "*".equals(splitArray[i]) || "/".equals(splitArray[i])) {
                    checked = false;
                    break;
                }
            } else {
                tempList.add(splitArray[i]);
            }
            if (splitArray[i].equals(")") || splitArray[i].equals("(") || splitArray[i].equals("+") || splitArray[i].equals("-") || splitArray[i].equals("*") || splitArray[i].equals("/") || propertyMap.containsKey(splitArray[i])) continue;
            checked = false;
            break;
        }
        return checked;
    }

    public static boolean getFiled(String condition, JSONObject billData, List<DataModelColumnVO> columnVOS, Logger logger) {
        logger.info("\u539f\u59cb\u6761\u4ef6\u53c2\u6570 condition -- {} ,\u539f\u59cb\u6570\u636e billData -- {}\uff0c", (Object)condition, (Object)billData);
        Object vv = false;
        if (billData != null) {
            Boolean r;
            String[] array;
            String copyValue;
            String[] condArray;
            ArrayList<String> fieldsSet = new ArrayList<String>();
            String conds = condition.replace("{", "").replace("}", "").replace("$", "");
            ArrayList<String> fields = new ArrayList<String>();
            if (conds.contains("&&") && conds.contains("||")) {
                for (String str : condArray = conds.split("&&")) {
                    if (str.contains("||")) {
                        String[] subArray;
                        for (String s : subArray = str.split("\\|\\|")) {
                            fields.add(s);
                        }
                        continue;
                    }
                    fields.add(str);
                }
            } else if (conds.contains("||")) {
                for (String str : condArray = conds.split("\\|\\|")) {
                    fields.add(str);
                }
            } else if (conds.contains("&&")) {
                for (String str : condArray = conds.split("&&")) {
                    fields.add(str);
                }
            } else {
                fields.add(conds);
            }
            CalculatorUtils.dealFieldsSet(fields, fieldsSet);
            String newCondition = conds;
            logger.info("\u539f\u59cb\u6761\u4ef6\u53c2\u6570 condition -- {} ,\u539f\u59cb\u6570\u636e billData -- {}\uff0c\u65b0\u6761\u4ef6 newCondition -- {}", new Object[]{condition, billData, newCondition});
            Map<String, String> fieldTypeMap = CalculatorUtils.obtainConditionFields(fieldsSet, columnVOS);
            HashMap<String, String> fieldValueMap = new HashMap<String, String>();
            for (String field : fieldTypeMap.keySet()) {
                if (billData.get((Object)field) == null) continue;
                newCondition = newCondition.replaceAll(field, billData.get((Object)field).toString());
                fieldValueMap.put(field, billData.get((Object)field).toString());
            }
            if (newCondition.contains("\u2283")) {
                for (String field : fields) {
                    String v2;
                    if (!field.contains("\u2283")) continue;
                    copyValue = field;
                    array = field.split("\u2283");
                    String v1 = array[0];
                    if ("(".equals(v1.substring(0, 1))) {
                        v1 = v1.substring(1);
                        copyValue = copyValue.substring(1);
                    }
                    if (")".equals((v2 = array[1]).substring(v2.length() - 1))) {
                        v2 = v2.substring(0, v2.length() - 1);
                        copyValue = copyValue.substring(0, copyValue.length() - 1);
                    }
                    if (billData.get((Object)v1) != null) {
                        copyValue = copyValue.replaceAll(v1, '\"' + billData.get((Object)v1).toString() + '\"');
                        v1 = billData.get((Object)v1).toString();
                    } else {
                        v1 = v1.substring(1, v1.length() - 1);
                    }
                    if (billData.get((Object)v2) != null) {
                        copyValue = copyValue.replaceAll(v2, '\"' + billData.get((Object)v2).toString() + '\"');
                        v2 = billData.get((Object)v2).toString();
                    } else {
                        v2 = v2.substring(1, v2.length() - 1);
                    }
                    r = v1.contains(v2);
                    newCondition = newCondition.replaceAll(copyValue, r.toString());
                }
            }
            if (newCondition.contains("\u2285")) {
                for (String field : fields) {
                    String v2;
                    if (!field.contains("\u2285")) continue;
                    copyValue = field;
                    array = field.split("\u2285");
                    String v1 = array[0];
                    if ("(".equals(v1.substring(0, 1))) {
                        v1 = v1.substring(1);
                        copyValue = copyValue.substring(1);
                    }
                    if (")".equals((v2 = array[1]).substring(v2.length() - 1))) {
                        v2 = v2.substring(0, v2.length() - 1);
                        copyValue = copyValue.substring(0, copyValue.length() - 1);
                    }
                    if (billData.get((Object)v1) != null) {
                        copyValue = copyValue.replaceAll(v1, '\"' + billData.get((Object)v1).toString() + '\"');
                        v1 = billData.get((Object)v1).toString();
                    } else {
                        v1 = v1.substring(1, v1.length() - 1);
                    }
                    if (billData.get((Object)v2) != null) {
                        copyValue = copyValue.replaceAll(v2, '\"' + billData.get((Object)v2).toString() + '\"');
                        v2 = billData.get((Object)v2).toString();
                    } else {
                        v2 = v2.substring(1, v2.length() - 1);
                    }
                    r = !v1.contains(v2);
                    newCondition = newCondition.replaceAll(copyValue, r.toString());
                }
            }
            ScriptEngineManager manager = new ScriptEngineManager();
            ScriptEngine factories = manager.getEngineByExtension("js");
            try {
                vv = factories.eval(newCondition);
                logger.info("\u539f\u59cb\u6761\u4ef6\u53c2\u6570 condition -- {} ,\u539f\u59cb\u6570\u636e billData -- {}\uff0c\u65b0\u6761\u4ef6 newCondition -- {} ,\u5224\u5b9a\u7ed3\u679c  vv -- {}", new Object[]{condition, billData, newCondition, vv});
            }
            catch (ScriptException e) {
                e.printStackTrace();
                logger.info("\u539f\u59cb\u6761\u4ef6\u53c2\u6570 condition -- {} ,\u539f\u59cb\u6570\u636e billData -- {}\uff0c\u62a5\u9519 ScriptException -- {}", new Object[]{condition, billData, e.getMessage()});
                vv = false;
            }
        }
        logger.info("\u539f\u59cb\u6761\u4ef6\u53c2\u6570 condition -- {} ,\u539f\u59cb\u6570\u636e billData -- {}\uff0c\u8fd4\u56de\u7ed3\u679c vv -- {}", new Object[]{condition, billData, vv});
        return (Boolean)vv;
    }

    private static void dealFieldsSet(List<String> fields, List<String> fieldsSet) {
        for (String field : fields) {
            String v2;
            String v1;
            String[] array;
            if (field.contains("==")) {
                array = field.split("==");
                v1 = array[0];
                if ("(".equals(v1.substring(0, 1))) {
                    v1 = v1.substring(1);
                }
                fieldsSet.add(v1);
                if (array.length <= 1) continue;
                v2 = array[1];
                if (")".equals(v2.substring(v2.length() - 1))) {
                    v2 = v2.substring(0, v2.length() - 1);
                }
                fieldsSet.add(v2);
                continue;
            }
            if (field.contains("!=")) {
                array = field.split("!=");
                v1 = array[0];
                if ("(".equals(v1.substring(0, 1))) {
                    v1 = v1.substring(1);
                }
                fieldsSet.add(v1);
                if (array.length <= 1) continue;
                v2 = array[1];
                if (")".equals(v2.substring(v2.length() - 1))) {
                    v2 = v2.substring(0, v2.length() - 1);
                }
                fieldsSet.add(v2);
                continue;
            }
            if (field.contains(">=")) {
                array = field.split(">=");
                v1 = array[0];
                if ("(".equals(v1.substring(0, 1))) {
                    v1 = v1.substring(1);
                }
                fieldsSet.add(v1);
                if (array.length <= 1) continue;
                v2 = array[1];
                if (")".equals(v2.substring(v2.length() - 1))) {
                    v2 = v2.substring(0, v2.length() - 1);
                }
                fieldsSet.add(v2);
                continue;
            }
            if (field.contains("<=")) {
                array = field.split("<=");
                v1 = array[0];
                if ("(".equals(v1.substring(0, 1))) {
                    v1 = v1.substring(1);
                }
                fieldsSet.add(v1);
                if (array.length <= 1) continue;
                v2 = array[1];
                if (")".equals(v2.substring(v2.length() - 1))) {
                    v2 = v2.substring(0, v2.length() - 1);
                }
                fieldsSet.add(v2);
                continue;
            }
            if (field.contains(">")) {
                array = field.split(">");
                v1 = array[0];
                if ("(".equals(v1.substring(0, 1))) {
                    v1 = v1.substring(1);
                }
                fieldsSet.add(v1);
                if (array.length <= 1) continue;
                v2 = array[1];
                if (")".equals(v2.substring(v2.length() - 1))) {
                    v2 = v2.substring(0, v2.length() - 1);
                }
                fieldsSet.add(v2);
                continue;
            }
            if (field.contains("<")) {
                array = field.split("<");
                v1 = array[0];
                if ("(".equals(v1.substring(0, 1))) {
                    v1 = v1.substring(1);
                }
                fieldsSet.add(v1);
                if (array.length <= 1) continue;
                v2 = array[1];
                if (")".equals(v2.substring(v2.length() - 1))) {
                    v2 = v2.substring(0, v2.length() - 1);
                }
                fieldsSet.add(v2);
                continue;
            }
            if (field.contains("\u2283")) {
                array = field.split("\u2283");
                v1 = array[0];
                if ("(".equals(v1.substring(0, 1))) {
                    v1 = v1.substring(1);
                }
                fieldsSet.add(v1);
                if (array.length <= 1) continue;
                v2 = array[1];
                if (")".equals(v2.substring(v2.length() - 1))) {
                    v2 = v2.substring(0, v2.length() - 1);
                }
                fieldsSet.add(v2);
                continue;
            }
            if (!field.contains("\u2285")) continue;
            array = field.split("\u2285");
            v1 = array[0];
            if ("(".equals(v1.substring(0, 1))) {
                v1 = v1.substring(1);
            }
            fieldsSet.add(v1);
            if (array.length <= 1) continue;
            v2 = array[1];
            if (")".equals(v2.substring(v2.length() - 1))) {
                v2 = v2.substring(0, v2.length() - 1);
            }
            fieldsSet.add(v2);
        }
    }

    public static Map<String, String> obtainConditionFields(List<String> fieldsSet, List<DataModelColumnVO> columnVOS) {
        HashMap<String, String> fieldTypeMap = new HashMap<String, String>();
        if (ListUtil.isNotEmpty(fieldsSet)) {
            for (String str : fieldsSet) {
                for (DataModelColumnVO vo : columnVOS) {
                    if (!vo.getProperty().equals(str)) continue;
                    fieldTypeMap.put(str, vo.getType());
                }
            }
        }
        return fieldTypeMap;
    }
}

