/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.foundation.util;

import com.ejianc.foundation.supplier.bean.SupplierEntity;
import com.ejianc.framework.core.exception.BusinessException;
import java.sql.Connection;
import java.sql.Date;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import oracle.jdbc.driver.OracleDriver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JdbcOracle {
    public static List<SupplierEntity> getSdbjSupplier(String sql, String systemId) {
        Logger logger = LoggerFactory.getLogger((String)"JdbcOracle");
        ArrayList<SupplierEntity> supplierList = new ArrayList<SupplierEntity>();
        Connection connect = null;
        Statement statement = null;
        ResultSet resultSet = null;
        try {
            OracleDriver driver = new OracleDriver();
            DriverManager.deregisterDriver((Driver)driver);
            logger.info("-------------connect sdbj oracle start-----------");
            connect = DriverManager.getConnection("jdbc:oracle:thin:@10.60.231.45:8721/orcl", "MTUSER", "SdbjinspurDB45GS");
            System.out.println(connect);
            System.out.println("\u94fe\u63a5\u6210\u529f");
            logger.info(connect.toString());
            logger.info("\u94fe\u63a5\u6210\u529f");
            logger.info("-------------connect sdbj oracle end-----------");
            PreparedStatement preState = connect.prepareStatement(sql);
            resultSet = preState.executeQuery();
            while (resultSet.next()) {
                SupplierEntity vo = new SupplierEntity();
                String sourceId = resultSet.getString("LSWLDW_LSWLDWID");
                String socialCreditCode = resultSet.getString("LSWLDW_SH");
                String code = resultSet.getString("LSWLDW_WLDWBH");
                String name = resultSet.getString("LSWLDW_DWMC");
                String state = resultSet.getString("LSWLDW_TYBZ");
                Date updateTime = resultSet.getDate("LASTMODIFIEDTIME");
                Date createTime = resultSet.getDate("CREATEDTIME");
                vo.setName(name);
                vo.setCode(code);
                vo.setSourceId(sourceId.replaceAll("-", ""));
                vo.setSocialCreditCode(socialCreditCode);
                vo.setSystemId(systemId);
                vo.setUpdateTime(updateTime);
                vo.setCreateTime(createTime);
                supplierList.add(vo);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.info("-------------connect sdbj oracle fail-----------");
            logger.info(e.toString());
            throw new BusinessException((Throwable)e);
        }
        finally {
            try {
                if (resultSet != null) {
                    resultSet.close();
                }
                if (statement != null) {
                    statement.close();
                }
                if (connect != null) {
                    connect.close();
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
        return supplierList;
    }
}

