/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.foundation.billcode;

import com.ejianc.foundation.billcode.elemproc.itf.IElemProcessor;
import com.ejianc.foundation.billcode.randomcode.IRandomCodeGenerator;
import com.ejianc.foundation.billcode.randomcode.impl.RandomCodeGenerator;
import com.ejianc.foundation.billcode.sngenerator.ISNGenerator;
import com.ejianc.foundation.billcode.sngenerator.impl.PureDigitalSNGenerator;
import com.ejianc.foundation.billcode.sysdate.ISysDateProvider;
import com.ejianc.foundation.billcode.sysdate.impl.DateProviderJavaDate;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.XMLConfiguration;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.DefaultResourceLoader;
import org.springframework.stereotype.Component;

@Component
public class BillCodeEngineContext {
    private static Logger logger = LoggerFactory.getLogger(BillCodeEngineContext.class);
    private static BillCodeEngineContext context = null;
    private static ISysDateProvider sysdateClss;
    private static HashMap<String, ISNGenerator> snGenerators;
    private static HashMap<Integer, IElemProcessor> processors;
    private static IRandomCodeGenerator rdmCodeClass;

    public static BillCodeEngineContext getInstance() {
        if (null == context) {
            context = BillCodeEngineContext.getInstance("classpath:/billCodeEngineContext.xml");
        }
        return context;
    }

    public static BillCodeEngineContext getInstance(String xmlQualifiedPath) {
        if (null == context) {
            if (StringUtils.isNotBlank((CharSequence)xmlQualifiedPath)) {
                try {
                    DefaultResourceLoader resourceLoader = new DefaultResourceLoader();
                    XMLConfiguration e = new XMLConfiguration();
                    e.load(resourceLoader.getResource(xmlQualifiedPath).getInputStream());
                    String sysDateQualifiedName = e.getString("sysdate");
                    List snGeneratorQualifiedNameLsit = e.getList("snGenerators.generator");
                    List elemProcQualifiedNameList = e.getList("elemProcessors.processor");
                    String rdmCodeQualifiedName = e.getString("randomCode");
                    BillCodeEngineContext.initSysDateImp(sysDateQualifiedName);
                    BillCodeEngineContext.initSNGnneratorMap(snGeneratorQualifiedNameLsit);
                    BillCodeEngineContext.initElemProcesMap(elemProcQualifiedNameList);
                    BillCodeEngineContext.intRdmcodeclass(rdmCodeQualifiedName);
                    context = new BillCodeEngineContext();
                }
                catch (ConfigurationException e1) {
                    logger.error("\u521d\u59cb\u5316\u5355\u636e\u7f16\u7801\u751f\u6210\u5668\u5f15\u64ce\u5f02\u5e38\uff0c", (Throwable)e1);
                }
                catch (IOException e2) {
                    logger.error("\u521d\u59cb\u5316\u5355\u636e\u7f16\u7801\u751f\u6210\u5668\u5f15\u64ce\u5f02\u5e38\uff0c", (Throwable)e2);
                }
            } else {
                context = BillCodeEngineContext.getInstance();
            }
        }
        return context;
    }

    private static void intRdmcodeclass(String rdmCodeQualifiedName) {
        Object obj = BillCodeEngineContext.getInstanceByQualifiedName(rdmCodeQualifiedName);
        rdmCodeClass = null != obj && obj instanceof ISysDateProvider ? (IRandomCodeGenerator)obj : new RandomCodeGenerator();
    }

    private static void initElemProcesMap(List<Object> elemProcQualifiedNameList) {
        processors = new HashMap();
        if (CollectionUtils.isNotEmpty(elemProcQualifiedNameList)) {
            for (Object name : elemProcQualifiedNameList) {
                IElemProcessor processor = (IElemProcessor)BillCodeEngineContext.getInstanceByQualifiedName(name.toString());
                processors.put(processor.getCanProcElemType(), processor);
            }
        }
    }

    private static void initSNGnneratorMap(List<Object> snGeneratorQualifiedNameLsit) {
        snGenerators = new HashMap();
        if (CollectionUtils.isNotEmpty(snGeneratorQualifiedNameLsit)) {
            for (Object name : snGeneratorQualifiedNameLsit) {
                ISNGenerator generator = (ISNGenerator)BillCodeEngineContext.getInstanceByQualifiedName(name.toString());
                snGenerators.put(generator.getSNGeneratorType(), generator);
            }
        }
    }

    private static void initSysDateImp(String sysDateQualifiedName) {
        Object obj = BillCodeEngineContext.getInstanceByQualifiedName(sysDateQualifiedName);
        sysdateClss = null != obj && obj instanceof ISysDateProvider ? (ISysDateProvider)obj : new DateProviderJavaDate();
    }

    private static Object getInstanceByQualifiedName(String sysDateQualifiedName) {
        Object instance = null;
        if (StringUtils.isNotBlank((CharSequence)sysDateQualifiedName)) {
            String className = sysDateQualifiedName.trim();
            try {
                instance = Class.forName(className).newInstance();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            catch (InstantiationException e) {
                e.printStackTrace();
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
            }
        }
        return instance;
    }

    public IElemProcessor getElemProcessor(String elemType) {
        return processors.get(Integer.valueOf(elemType));
    }

    public ISNGenerator getSNGeneratorImpl(String elemValue) {
        return snGenerators.get(elemValue) != null ? snGenerators.get(elemValue) : new PureDigitalSNGenerator();
    }

    public ISysDateProvider getSysDateImp() {
        return sysdateClss;
    }

    public IRandomCodeGenerator getRdmCodeClass() {
        return rdmCodeClass;
    }
}

