/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.foundation.dataModel.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.foundation.dataModel.bean.DataModelColConditionEntity;
import com.ejianc.foundation.dataModel.bean.DataModelColumnEntity;
import com.ejianc.foundation.dataModel.bean.DataModelTenantColumnEntity;
import com.ejianc.foundation.dataModel.service.IDataModelColConditionService;
import com.ejianc.foundation.dataModel.service.IDataModelColumnService;
import com.ejianc.foundation.dataModel.service.IDataModelTenantColumnService;
import com.ejianc.foundation.dataModel.vo.DataModelColConditionVO;
import com.ejianc.foundation.dataModel.vo.DataModelColumnVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.template.BaseEntity;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"dataModelColumn"})
public class DataModelColumnController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    private static final String BILL_CODE = "Invoice_Open_Apply_Code";
    @Autowired
    private IDataModelColumnService service;
    @Autowired
    private IDataModelTenantColumnService iDataModelTenantColumnService;
    @Autowired
    private IDataModelColConditionService dataModelColConditionService;

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<DataModelColumnVO> saveOrUpdate(@RequestBody DataModelColumnVO saveOrUpdateVO) {
        DataModelColumnEntity entity = (DataModelColumnEntity)((Object)BeanMapper.map((Object)saveOrUpdateVO, DataModelColumnEntity.class));
        this.service.saveOrUpdate((Object)entity, false);
        DataModelColumnVO vo = (DataModelColumnVO)BeanMapper.map((Object)((Object)entity), DataModelColumnVO.class);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/saveOrUpdateCustom"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<DataModelColumnVO> saveOrUpdateCustom(@RequestBody DataModelColumnVO saveOrUpdateVO) {
        List colConditionVOS;
        DataModelTenantColumnEntity columnEntity = this.iDataModelTenantColumnService.queryCusColumnByColumnId(saveOrUpdateVO.getId());
        if (columnEntity == null) {
            columnEntity = new DataModelTenantColumnEntity();
        }
        columnEntity.setColumnId(saveOrUpdateVO.getId());
        columnEntity.setColumnName(saveOrUpdateVO.getColumnName());
        columnEntity.setSequence(saveOrUpdateVO.getSequence());
        columnEntity.setVisible(saveOrUpdateVO.getVisible());
        columnEntity.setTenantId(InvocationInfoProxy.getTenantid());
        columnEntity.setAfterStr(saveOrUpdateVO.getAfterStr());
        columnEntity.setAlign(saveOrUpdateVO.getAlign());
        columnEntity.setThousands(saveOrUpdateVO.getThousands());
        columnEntity.setScale(saveOrUpdateVO.getScale());
        columnEntity.setTotalData(saveOrUpdateVO.getTotalData());
        columnEntity.setMemo(saveOrUpdateVO.getMemo());
        this.iDataModelTenantColumnService.saveOrUpdate((Object)columnEntity, false);
        QueryParam param = new QueryParam();
        param.getParams().put("colId", new Parameter("eq", (Object)saveOrUpdateVO.getId()));
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        List conditionEntities = this.dataModelColConditionService.queryList(param, false);
        if (ListUtil.isNotEmpty((List)conditionEntities)) {
            this.dataModelColConditionService.deleteByIds(conditionEntities.stream().map(BaseEntity::getId).collect(Collectors.toList()));
        }
        if (ListUtil.isNotEmpty((List)(colConditionVOS = saveOrUpdateVO.getConditionEntities()))) {
            ArrayList<DataModelColConditionVO> saveVOS = new ArrayList<DataModelColConditionVO>();
            for (DataModelColConditionVO vo : colConditionVOS) {
                if ("del".equals(vo.getRowState())) continue;
                vo.setId(null);
                vo.setTenantId(InvocationInfoProxy.getTenantid());
                vo.setColId(saveOrUpdateVO.getId());
                saveVOS.add(vo);
            }
            if (ListUtil.isNotEmpty(saveVOS)) {
                this.dataModelColConditionService.saveOrUpdateBatch(BeanMapper.mapList(saveVOS, DataModelColConditionEntity.class));
            }
        }
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)saveOrUpdateVO);
    }

    @RequestMapping(value={"/queryFormulaList"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<List<DataModelColumnVO>> queryFormulaList(@RequestParam Long modelId) {
        QueryParam param = new QueryParam();
        param.getParams().put("modelId", new Parameter("eq", (Object)modelId));
        param.getParams().put("type", new Parameter("eq", (Object)"number"));
        param.getParams().put("formula", new Parameter("eq", null));
        List columnList = this.service.queryList(param);
        if (columnList != null) {
            List res = BeanMapper.mapList((Iterable)columnList, DataModelColumnVO.class);
            return CommonResponse.success((Object)res);
        }
        return CommonResponse.success();
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<DataModelColumnVO> queryDetail(Long id) {
        DataModelColumnEntity entity = (DataModelColumnEntity)((Object)this.service.selectById(id));
        DataModelColumnVO vo = (DataModelColumnVO)BeanMapper.map((Object)((Object)entity), DataModelColumnVO.class);
        QueryParam param = new QueryParam();
        param.getParams().put("colId", new Parameter("eq", (Object)id));
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.getOrderMap().put("sequence", "asc");
        List conditionEntities = this.dataModelColConditionService.queryList(param, false);
        if (ListUtil.isNotEmpty((List)conditionEntities)) {
            vo.setConditionEntities(BeanMapper.mapList((Iterable)conditionEntities, DataModelColConditionVO.class));
        } else {
            vo.setConditionEntities(new ArrayList());
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/queryCusDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<DataModelColumnVO> queryCusDetail(Long id) {
        DataModelColumnEntity entity = (DataModelColumnEntity)((Object)this.service.selectById(id));
        DataModelColumnVO vo = (DataModelColumnVO)BeanMapper.map((Object)((Object)entity), DataModelColumnVO.class);
        QueryParam param = new QueryParam();
        DataModelTenantColumnEntity columnEntity = this.iDataModelTenantColumnService.queryCusColumnByColumnId(entity.getId());
        if (columnEntity != null) {
            vo.setColumnName(columnEntity.getColumnName());
            vo.setSequence(columnEntity.getSequence());
            vo.setVisible(columnEntity.getVisible());
            vo.setAfterStr(columnEntity.getAfterStr());
            vo.setAlign(columnEntity.getAlign());
            vo.setThousands(columnEntity.getThousands());
            vo.setScale(columnEntity.getScale());
            vo.setTotalData(columnEntity.getTotalData());
            vo.setMemo(columnEntity.getMemo());
        }
        param.getParams().put("colId", new Parameter("eq", (Object)id));
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.getOrderMap().put("sequence", "asc");
        List conditionEntities = this.dataModelColConditionService.queryList(param, false);
        if (ListUtil.isNotEmpty((List)conditionEntities)) {
            vo.setConditionEntities(BeanMapper.mapList((Iterable)conditionEntities, DataModelColConditionVO.class));
        } else {
            vo.setConditionEntities(new ArrayList());
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<Long> vos) {
        this.service.removeByIds(vos, false);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<DataModelColumnVO>> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        param.setPageSize(-1);
        param.getOrderMap().put("sequence", "asc");
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), DataModelColumnVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/queryCusList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<DataModelColumnVO>> queryCusList(@RequestBody QueryParam param) {
        param.getOrderMap().put("sequence", "asc");
        param.setPageSize(-1);
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        if (ListUtil.isNotEmpty((List)page.getRecords())) {
            for (DataModelColumnEntity record : page.getRecords()) {
                DataModelTenantColumnEntity columnEntity = this.iDataModelTenantColumnService.queryCusColumnByColumnId(record.getId());
                if (columnEntity == null) continue;
                record.setColumnName(columnEntity.getColumnName());
                record.setSequence(columnEntity.getSequence());
                record.setVisible(columnEntity.getVisible());
                record.setAfterStr(columnEntity.getAfterStr());
                record.setAlign(columnEntity.getAlign());
                record.setThousands(columnEntity.getThousands());
                record.setScale(columnEntity.getScale());
                record.setTotalData(columnEntity.getTotalData());
            }
        }
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), DataModelColumnVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{errMsg}) ? errMsg : "\u8c03\u7528Rpc\u670d\u52a1\u5931\u8d25");
        }
        return resp.getData();
    }

    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        List list = this.service.queryList(param);
        HashMap<String, List> beans = new HashMap<String, List>();
        beans.put("records", list);
        ExcelExport.getInstance().export("DataModelColumn-export.xlsx", beans, response);
    }

    @RequestMapping(value={"/refDataModelColumnData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<DataModelColumnVO>> refDataModelColumnData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        if (StringUtils.isNotEmpty((CharSequence)condition)) {
            JSONObject jSONObject = JSONObject.parseObject((String)condition);
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), DataModelColumnVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }
}

