/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.foundation.share.controller.api;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.ejianc.foundation.share.bean.SupplierEntity;
import com.ejianc.foundation.share.service.ISupplierService;
import com.ejianc.foundation.share.vo.SupplierVO;
import com.ejianc.foundation.support.service.IBillTypeService;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.BaseEntity;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/supplierApi/"})
public class SupplierApi {
    @Autowired
    private ISupplierService supplierService;
    @Autowired
    private IBillTypeService billTypeService;

    @GetMapping(value={"queryById"})
    CommonResponse<SupplierVO> queryById(@RequestParam(value="id") Long id) {
        SupplierVO vo = this.supplierService.queryDetail(id);
        return CommonResponse.success((String)"\u67e5\u8be2\u6210\u529f\uff01", (Object)vo);
    }

    @GetMapping(value={"querySupplierByIds"})
    CommonResponse<List<SupplierVO>> querySupplierByIds(@RequestParam(value="ids") List<Long> ids) {
        List vos = new ArrayList();
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"dr", (Object)0);
        queryWrapper.in((Object)"id", ids);
        List entitys = this.supplierService.list((Wrapper)queryWrapper);
        if (entitys != null) {
            vos = BeanMapper.mapList((Iterable)entitys, SupplierVO.class);
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u6210\u529f\uff01", vos);
    }

    @GetMapping(value={"queryBySourceId"})
    CommonResponse<SupplierVO> queryBySourceId(@RequestParam(value="sourceId") String sourceId) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"dr", (Object)0);
        queryWrapper.eq((Object)"source_id", (Object)sourceId);
        List entitys = this.supplierService.list((Wrapper)queryWrapper);
        if (entitys != null) {
            return CommonResponse.success((String)"\u67e5\u8be2\u6210\u529f\uff01", (Object)BeanMapper.map(entitys.get(0), SupplierVO.class));
        }
        return CommonResponse.error((String)"\u6839\u636e\u6765\u6e90ID\u67e5\u8be2\u4f9b\u5e94\u5546\u5931\u8d25\uff01");
    }

    @RequestMapping(value={"saveOrUpdate"}, method={RequestMethod.POST})
    public CommonResponse<SupplierVO> saveOrUpdate(@RequestBody SupplierVO vo) {
        SupplierEntity save = (SupplierEntity)((Object)BeanMapper.map((Object)vo, SupplierEntity.class));
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"dr", (Object)0);
        queryWrapper.eq((Object)"source_id", (Object)vo.getSourceId());
        SupplierEntity entity = (SupplierEntity)((Object)this.supplierService.getOne((Wrapper)queryWrapper));
        if (entity != null) {
            save = entity;
            save.setCode(vo.getCode());
            save.setName(vo.getName());
            save.setSocialCreditCode(vo.getSocialCreditCode());
            save.setBusinessScope(vo.getBusinessScope());
            save.setTelephone(vo.getTelephone());
            save.setEnabled(vo.getEnabled());
            if (StringUtils.isNotEmpty((CharSequence)vo.getBankCode())) {
                save.setBankName(vo.getBankName());
                save.setBankAccount(vo.getBankAccount());
                save.setBankCode(vo.getBankCode());
            }
            save.setGradeId(vo.getGradeId());
            save.setGradeName(vo.getGradeName());
        }
        this.supplierService.saveOrUpdate((Object)save, false);
        return CommonResponse.success((String)"\u6267\u884c\u6210\u529f\uff01", (Object)BeanMapper.map((Object)((Object)save), SupplierVO.class));
    }

    @RequestMapping(value={"saveOrUpdateBatch"}, method={RequestMethod.POST})
    public CommonResponse<String> saveOrUpdateBatch(@RequestBody List<SupplierVO> vos) {
        List saveList = BeanMapper.mapList(vos, SupplierEntity.class);
        ArrayList<SupplierEntity> addList = new ArrayList<SupplierEntity>();
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"dr", (Object)0);
        queryWrapper.in((Object)"source_id", (Collection)vos.stream().map(SupplierVO::getSourceId).collect(Collectors.toList()));
        List list = this.supplierService.list((Wrapper)queryWrapper);
        Map<String, SupplierEntity> mapEntityMap = null;
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            mapEntityMap = list.stream().collect(Collectors.toMap(SupplierEntity::getSourceId, e -> e));
            for (SupplierEntity save : saveList) {
                if (mapEntityMap.containsKey(save.getSourceId())) {
                    SupplierEntity supplierEntity = mapEntityMap.get(save.getSourceId());
                    supplierEntity.setSocialCreditCode(save.getSocialCreditCode());
                    supplierEntity.setBusinessScope(save.getBusinessScope());
                    supplierEntity.setTelephone(save.getTelephone());
                    supplierEntity.setEnabled(save.getEnabled());
                    supplierEntity.setGradeId(save.getGradeId());
                    supplierEntity.setGradeName(save.getGradeName());
                    save = supplierEntity;
                }
                addList.add(save);
            }
        } else {
            addList.addAll(saveList);
        }
        this.supplierService.saveOrUpdateBatch(addList, addList.size());
        return CommonResponse.success((String)"\u6267\u884c\u6210\u529f\uff01");
    }

    @RequestMapping(value={"delete"}, method={RequestMethod.POST})
    public CommonResponse<String> delete(@RequestBody List<Long> sourceIds) {
        if (CollectionUtils.isEmpty(sourceIds)) {
            return CommonResponse.success((String)"\u96c6\u5408\u4e3a\u7a7a\uff01");
        }
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"dr", (Object)0);
        queryWrapper.in((Object)"source_id", sourceIds);
        List list = this.supplierService.list((Wrapper)queryWrapper);
        List<Long> ids = list.stream().map(BaseEntity::getId).collect(Collectors.toList());
        if (ListUtil.isNotEmpty(ids)) {
            for (Long id : ids) {
                CommonResponse<String> response = this.billTypeService.checkQuote("BT200422000000028", id);
                if (response.isSuccess()) continue;
                return CommonResponse.error((String)("\u5220\u9664\u5931\u8d25\uff1a" + response.getMsg()));
            }
        } else {
            return CommonResponse.error((String)"\u5220\u9664\u5931\u8d25\uff1a\u4e3b\u952e\u4e3a\u7a7a!");
        }
        this.supplierService.deleteSupplier(ids);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f");
    }

    @GetMapping(value={"getSupplierBySupplierTenantId"})
    public CommonResponse<SupplierVO> getSupplierBySupplierTenantId(@RequestParam Long supplierTenantId) {
        QueryParam param = new QueryParam();
        param.getParams().put("tenant", Parameter.getEqInstance((Object)supplierTenantId));
        List list = this.supplierService.queryList(param, false);
        SupplierVO res = null;
        if (ListUtil.isNotEmpty((List)list)) {
            res = (SupplierVO)BeanMapper.map(list.get(0), SupplierVO.class);
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u6210\u529f\uff01", res);
    }
}

