package com.ejianc.foundation.dataModel.controller;

import java.io.Serializable;

import com.ejianc.foundation.dataModel.vo.PublishVO;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.core.util.HttpTookit;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.*;
import java.util.stream.Collectors;
import com.alibaba.fastjson.JSONObject;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;
import org.apache.commons.collections.CollectionUtils;
import javax.servlet.http.HttpServletResponse;

import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.kit.collection.ListUtil;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;

import com.ejianc.foundation.dataModel.bean.DataModelDataSetEntity;
import com.ejianc.foundation.dataModel.service.IDataModelDataSetService;
import com.ejianc.foundation.dataModel.vo.DataModelDataSetVO;

/**
 * 数据模型数据集
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("dataModelDataSet")
public class DataModelDataSetController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;

    private static final String BILL_CODE = "Invoice_Open_Apply_Code";//此处需要根据实际修改

    @Autowired
    private IDataModelDataSetService service;

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<DataModelDataSetVO> saveOrUpdate(@RequestBody DataModelDataSetVO saveOrUpdateVO) {
    	DataModelDataSetEntity entity = BeanMapper.map(saveOrUpdateVO, DataModelDataSetEntity.class);
    	if(entity.getId() == null || entity.getId() == 0){
            BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE,InvocationInfoProxy.getTenantid(),saveOrUpdateVO);
            CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
            if(billCode.isSuccess()) {
                entity.setCode(billCode.getData());//此处需要根据实际修改 删除本行或者下一行
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }
    	service.saveOrUpdate(entity, false);
    	DataModelDataSetVO vo = BeanMapper.map(entity, DataModelDataSetVO.class);
    	return CommonResponse.success("保存或修改单据成功！",vo);
    }

    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<DataModelDataSetVO> queryDetail(Long id) {
    	DataModelDataSetEntity entity = service.selectById(id);
    	DataModelDataSetVO vo = BeanMapper.map(entity, DataModelDataSetVO.class);
        return CommonResponse.success("查询详情数据成功！",vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<Long> vos) {
        service.removeByIds(vos,true);
        return CommonResponse.success("删除成功！");
    }

    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<DataModelDataSetVO>> queryList(@RequestBody QueryParam param) {


        IPage<DataModelDataSetEntity> page = service.queryPage(param,false);
        IPage<DataModelDataSetVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
  		pageData.setRecords(BeanMapper.mapList(page.getRecords(), DataModelDataSetVO.class));

        return CommonResponse.success("查询列表数据成功！",pageData);
    }

    /**
     * @Description publishDataset 发布数据集到其他环境
     * @param publishVO
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/publishDataset", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> publishDataset(@RequestBody PublishVO publishVO) {
        logger.info(JSONObject.toJSONString(publishVO));
        if(ListUtil.isEmpty(publishVO.getIds())){
            return CommonResponse.error("发布数据不能为空！");
        }
        if(StringUtils.isEmpty(publishVO.getTarget())){
            return CommonResponse.error("发布目标环境服务器地址不能为空！");
        }
        QueryParam param = new QueryParam();
        param.getParams().put("id",new Parameter(QueryParam.IN,publishVO.getIds()));
        List<DataModelDataSetEntity> dataSetEntities = service.queryList(param);
        if(ListUtil.isEmpty(dataSetEntities)){
            return CommonResponse.error("发布数据不能为空！");
        }
        param = new QueryParam();
        param.getParams().put("parentId",new Parameter(QueryParam.IN,dataSetEntities.stream().map(DataModelDataSetEntity::getId).collect(Collectors.toList())));
        /** 查询子数据集 */
        List<DataModelDataSetEntity> children = service.queryList(param);
        if(ListUtil.isNotEmpty(children)){
            dataSetEntities.addAll(children);
        }
        try {
           String res = HttpTookit.postByJson(publishVO.getTarget()+"/ejc-support-web/dataModelDataSet/receiveDataset",JSONObject.toJSONString(dataSetEntities));
           if(StringUtils.isEmpty(res)){
               return CommonResponse.error("发布失败！目标服务器响应数据为空！");
           }
           CommonResponse<String> response = JSONObject.parseObject(res, CommonResponse.class);
           return response;
        } catch (Exception e) {
            e.printStackTrace();
        }
        return CommonResponse.error("发布失败！");
    }

    /**
     * @Description publishDataset 从主环境接收数据集到本环境保存
     * @param dataSetEntities
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/receiveDataset", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> receiveDataset(@RequestBody List<DataModelDataSetEntity> dataSetEntities) {
        logger.info(JSONObject.toJSONString(dataSetEntities));
        if(ListUtil.isEmpty(dataSetEntities)){
            return CommonResponse.success("发布数据为空！");
        }
        String ids = StringUtils.join(dataSetEntities.stream().map(DataModelDataSetEntity::getId).collect(Collectors.toList()),",");
        service.deleteByIds(ids);
        service.saveOrUpdateBatch(dataSetEntities);
        return CommonResponse.success("发布成功！");
    }

    /**
     * 获取RPC数据
     * resp 返回值
     * isMustSuc 是否必须成功
     * errMsg 失败提示
     */
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if(isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }


    /**
     * @Description 导出
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id",new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        List<DataModelDataSetEntity> list = service.queryList(param);
        //todo:字段翻译等等
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", list);
        ExcelExport.getInstance().export("DataModelDataSet-export.xlsx", beans, response);
    }

    /**
     * @Description 参照
     * @Return void
     */
    @RequestMapping(value = "/refDataModelDataSetData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<DataModelDataSetVO>> refDataModelDataSetData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                        String condition,
                                                                        String searchObject,
                                                                        String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);

        param.getParams().put("parentId",new Parameter(QueryParam.EQ,null));

        if(StringUtils.isNotEmpty(condition)){
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
        }

        IPage<DataModelDataSetEntity> page = service.queryPage(param,false);
        IPage<DataModelDataSetVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), DataModelDataSetVO.class));

        return CommonResponse.success("查询参照数据成功！",pageData);
     }
}
