package com.ejianc.foundation.support.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.ejianc.foundation.metadata.api.IMdRelationApi;
import com.ejianc.foundation.metadata.vo.MdQuoteVO;
import com.ejianc.foundation.support.bean.BillTypeEntity;
import com.ejianc.foundation.support.bean.ModuleEntity;
import com.ejianc.foundation.support.mapper.BillTypeMapper;
import com.ejianc.foundation.support.service.IBillTypeService;
import com.ejianc.foundation.support.service.IModuleService;
import com.ejianc.foundation.support.vo.BillTypeVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.EnvironmentTools;
import com.ejianc.framework.core.util.ResultAsTree;
import com.ejianc.framework.skeleton.billState.param.QueryQuoteParam;
import com.ejianc.framework.skeleton.refer.util.ReferHttpClientUtils;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

import java.util.*;
import java.util.stream.Collectors;

@SuppressWarnings({ "unchecked", "rawtypes" })
@Service
public class BillTypeServiceImpl extends BaseServiceImpl<BillTypeMapper, BillTypeEntity> implements IBillTypeService {
	private Logger logger = LoggerFactory.getLogger(this.getClass());

	@Value("${oms.tenantid}")
	private Long baseTenantId;

	private Gson gson = new Gson();

	@Autowired
	private IModuleService moduleService;
	@Autowired
	private IMdRelationApi mdRelationApi;
	@Autowired
	private EnvironmentTools environmentTools;
	@Autowired
	private BillTypeMapper billTypeMapper;

	@Override
	public void delete(List<Long> ids) {
		baseMapper.deleteBatchIds(ids);
	}

	@Override
	public BillTypeVO queryDetail(Long id) {
		BillTypeEntity entity = baseMapper.selectById(id);
		if(entity != null) {
			return BeanMapper.map(entity, BillTypeVO.class);
		}
		return null;
	}
	
	@Override
	public List<Map<String, Object>> getBillTypeTree() {
		
		QueryParam queryParam = new QueryParam();
		LinkedHashMap<String, String> orderMap = new LinkedHashMap<String, String>();
    	orderMap.put("sequence", "asc");
    	queryParam.setOrderMap(orderMap);
		List<ModuleEntity> moduleList = moduleService.queryList(queryParam, false);
				
		QueryWrapper<BillTypeEntity> query = new QueryWrapper<>();
		query.eq("dr", BaseVO.DR_UNDELETE);
		query.eq("tenant_id", baseTenantId);
		List<BillTypeEntity> list = baseMapper.selectList(query);

		List<Map> resultMapList = new ArrayList<Map>();
    	Map map = null;
    	for(ModuleEntity entity:moduleList) {
    		map = new HashMap<>();
    		map.put("id", entity.getId());
    		map.put("key", entity.getId());
    		map.put("name", entity.getModuleName());
    		map.put("title", entity.getModuleName());
    		map.put("parentId", entity.getParentId());
    		map.put("nodeType", entity.getNodeType());
    		map.put("code", entity.getModuleCode());
    		resultMapList.add(map);
    	}

		if(list != null && list.size() > 0) {
			for(BillTypeEntity entity:list) {
				map = new HashMap<>();
				map.put("id", entity.getId());
				map.put("key", entity.getId());
				map.put("name", entity.getBillName());
				map.put("title", entity.getBillName());
				map.put("parentId", entity.getModuleId());
				map.put("nodeType", "billType");
				map.put("code", entity.getBillCode());
				map.put("metadataId", entity.getMetadataId());
				resultMapList.add(map);
			}
		}

		return ResultAsTree.createTreeData(resultMapList);
	}


	public List<Map<String, Object>> getBillTypeTreeByCodes(String codes) {

		List billCodes= Arrays.asList(codes.split(","));
		QueryWrapper<BillTypeEntity> query = new QueryWrapper<>();
		query.eq("dr", BaseVO.DR_UNDELETE);
		query.eq("tenant_id", baseTenantId);
		query.in("bill_code", billCodes);
		List<BillTypeEntity> list = baseMapper.selectList(query);

		List<Long> moduleIds = list.stream().map(BillTypeEntity::getModuleId).collect(Collectors.toList());

		QueryParam queryParam1 = new QueryParam();
		queryParam1.getParams().put("id",new Parameter("in",moduleIds));
		List<ModuleEntity> moduleList = moduleService.queryList(queryParam1, false);
		//所有模块id
		HashSet moduleIdsAll = new HashSet();
		for (ModuleEntity moduleEntity : moduleList) {
			String[] split = moduleEntity.getInnerCode().split("\\|");
			for (String s : split) {
				moduleIdsAll.add(Long.valueOf(s));
			}
		}
		LambdaQueryWrapper<ModuleEntity> lambdaQueryWrapper = new LambdaQueryWrapper();
		lambdaQueryWrapper.in(ModuleEntity::getId,moduleIdsAll);
		lambdaQueryWrapper.orderByAsc(ModuleEntity::getSequence);
		List<ModuleEntity> moduleListRest = moduleService.list(lambdaQueryWrapper);
		List<Map> resultMapList = new ArrayList<Map>();
		Map map = null;
		for(ModuleEntity entity:moduleListRest) {
			map = new HashMap<>();
			map.put("id", entity.getId());
			map.put("key", entity.getId());
			map.put("name", entity.getModuleName());
			map.put("title", entity.getModuleName());
			map.put("parentId", entity.getParentId());
			map.put("nodeType", entity.getNodeType());
			map.put("code", entity.getModuleCode());
			resultMapList.add(map);
		}

		if(list != null && list.size() > 0) {
			for(BillTypeEntity entity:list) {
				map = new HashMap<>();
				map.put("id", entity.getId());
				map.put("key", entity.getId());
				map.put("name", entity.getBillName());
				map.put("title", entity.getBillName());
				map.put("parentId", entity.getModuleId());
				map.put("nodeType", "billType");
				map.put("code", entity.getBillCode());
				map.put("metadataId", entity.getMetadataId());
				resultMapList.add(map);
			}
		}


		return  ResultAsTree.createTreeData(resultMapList);
	}

	@Override
	public CommonResponse<Map<String, String>> checkQuotes(String billTypeCode, List<Long> billIds) {
		QueryQuoteParam param = new QueryQuoteParam();
		List<String> checkIds = billIds.stream().map(item -> item.toString()).collect(Collectors.toList());
		Map<String, String> checkResult = new HashMap<>();

		try {
			QueryParam queryParam = new QueryParam();
			queryParam.getParams().put("billCode", new Parameter("eq",billTypeCode));
			IPage<BillTypeEntity> pageData = super.queryPage(queryParam, false);
			if(pageData.getTotal()>0){
				BillTypeVO billTypeVo = BeanMapper.map(pageData.getRecords().get(0), BillTypeVO.class);
				//2、根据元数据获取引用关系信息
				CommonResponse<List<MdQuoteVO>> quoteResponse = mdRelationApi.queryQuoteById(billTypeVo.getMetadataId());
				if(quoteResponse.isSuccess()){
					List<MdQuoteVO> quoteVOs = quoteResponse.getData();
					if(quoteVOs!=null&&quoteVOs.size()>0){
						Map checkResultMap = null;
						for(MdQuoteVO vo : quoteVOs){
							param.setBillIds(checkIds);
							param.setTableName(vo.getTableName());
							param.setColumn(vo.getAttributeCode());
							String url = environmentTools.getBaseHost() + vo.getProjectName() + "/commonstate/queryQuoteBatch";
							String paramterStr = gson.toJson(param);
							try {
								String result = ReferHttpClientUtils.postByJson(url, paramterStr);
								logger.info("引用校验：url={},param={},result={}",url,paramterStr,result);
								CommonResponse<Map> data = gson.fromJson(result, new TypeToken<CommonResponse<Map>>() {}.getType());
								if(data.isSuccess()){
									checkResultMap = data.getData();
									for(Object key : checkResultMap.keySet()) {
										if("true".equals(checkResultMap.get(key.toString()).toString())) {
											checkResult.put(key.toString(), "true");
											checkIds.remove(key.toString());
										}
									}
									if(checkIds.size() == 0) {
										break;
									}
								}
							} catch (Exception e) {
								throw new BusinessException(e.getMessage());
							}
						}

						if(CollectionUtils.isNotEmpty(checkIds)) {
							for(String checkId : checkIds) {
								checkResult.put(checkId, "false");
							}
						}
					} else { //未查询到引用配置时
                        if(CollectionUtils.isNotEmpty(checkIds)) {
                            for(String checkId : checkIds) {
                                checkResult.put(checkId, "unknown");
                            }
                        }
                    }
				}else{
					throw new BusinessException("根据元数据id："+billTypeVo.getMetadataId()+"查询引用信息失败！");
				}
			}else {
				throw new BusinessException("根据单据类型编码查询单据类型信息失败！");
			}
		}catch (Exception e){
			return CommonResponse.error(e.getMessage());
		}
		return CommonResponse.success(checkResult);
	}



	public CommonResponse<String> checkQuote(String billTypeCode, QueryQuoteParam param) {
		try {
			QueryParam queryParam = new QueryParam();
			queryParam.getParams().put("billCode", new Parameter("eq",billTypeCode));
			IPage<BillTypeEntity> pageData = super.queryPage(queryParam, false);
			if(pageData.getTotal()>0){
				BillTypeVO billTypeVo = BeanMapper.map(pageData.getRecords().get(0), BillTypeVO.class);
				//2、根据元数据获取引用关系信息
				CommonResponse<List<MdQuoteVO>> quoteResponse = mdRelationApi.queryQuoteById(billTypeVo.getMetadataId());
				if(quoteResponse.isSuccess()){
					List<MdQuoteVO> quoteVOs = quoteResponse.getData();
					if(quoteVOs!=null&&quoteVOs.size()>0){
						for(MdQuoteVO vo : quoteVOs){
							param.setTableName(vo.getTableName());
							param.setColumn(vo.getAttributeCode());
							String url = environmentTools.getBaseHost() + vo.getProjectName() + "/commonstate/queryQuoteById";
							String paramterStr = gson.toJson(param);
							try {
								String result = ReferHttpClientUtils.postByJson(url, paramterStr);
								logger.info("引用校验：url={},param={},result={}",url,paramterStr,result);
								CommonResponse<String> data = gson.fromJson(result, new TypeToken<CommonResponse<String>>() {}.getType());
								if(data.isSuccess()){
									if(data.getData()==null || "0".equals(data.getData())){
										continue;
									}else{
										String msg = "该单据已被下游单据（"+vo.getEntityDisplayName()+"）引用";
										throw new BusinessException(msg);
									}
								}else{
									continue;
								}
							} catch (Exception e) {
								throw new BusinessException(e.getMessage());
							}
						}
					}
				}else{
					throw new BusinessException("根据元数据id："+billTypeVo.getMetadataId()+"查询引用信息失败！");
				}
			}else {
				throw new BusinessException("根据单据类型编码查询单据类型信息失败！");
			}
		}catch (Exception e){
			return CommonResponse.error(e.getMessage());
		}
		return CommonResponse.success();
	}

	/**
	 * @param billTypeCode
	 * @param billId
	 * @Author mrsir_wxp
	 * @Date 2020/7/14 单据编码引用校验
	 * @Description checkQuote
	 * @Param [billTypeCode, billId]
	 * @Return void
	 */
	@Override
	public CommonResponse<String> checkQuote(String billTypeCode, Long billId) {
		QueryQuoteParam param = new QueryQuoteParam();
		param.setBillId(billId.toString());
		return checkQuote(billTypeCode, param);
	}

	@Override
	public BillTypeVO getByMetadataId(Long metadataId) {
		BillTypeVO resp = null;
		QueryWrapper<BillTypeEntity> query = new QueryWrapper<>();
		query.eq("metadata_id", metadataId);
		query.eq("tenant_id", InvocationInfoProxy.getTenantid());
		BillTypeEntity e = super.getOne(query);
		if(null != e) {
			resp = BeanMapper.map(e, BillTypeVO.class);
		}

		return resp;
	}

	@Override
	public List<BillTypeEntity> queryAllBillTypeList() {
		List<BillTypeEntity> billTypeList = billTypeMapper.queryAllBillTypeList();
		return billTypeList;
	}

	/**
	 * @description: 根据单据编码引用检查
	 *
	 * @param billTypeCode
	 * @param billIds
	 * @return {@link CommonResponse< List< Long>>} 返回引用的单据ids
	 * @author songlx
	 * @date: 2024/5/15
	 */
	@Override
	public CommonResponse<List<Long>> checkQuotesAndReturnQuoteBillIds(String billTypeCode, List<Long> billIds) {
		QueryQuoteParam param = new QueryQuoteParam();
		List<String> checkIds = billIds.stream().map(item -> item.toString()).collect(Collectors.toList());
		List<Long> checkResult = new ArrayList<>();

		try {
			QueryParam queryParam = new QueryParam();
			queryParam.getParams().put("billCode", new Parameter("eq", billTypeCode));
			IPage<BillTypeEntity> pageData = super.queryPage(queryParam, false);
			if (pageData.getTotal() > 0) {
				BillTypeVO billTypeVo = BeanMapper.map(pageData.getRecords().get(0), BillTypeVO.class);
				//2、根据元数据获取引用关系信息
				CommonResponse<List<MdQuoteVO>> quoteResponse = mdRelationApi.queryQuoteById(billTypeVo.getMetadataId());
				if (quoteResponse.isSuccess()) {
					List<MdQuoteVO> quoteVOs = quoteResponse.getData();
					if (quoteVOs != null && quoteVOs.size() > 0) {
						Map checkResultMap = null;
						for (MdQuoteVO vo : quoteVOs) {
							param.setBillIds(checkIds);
							param.setTableName(vo.getTableName());
							param.setColumn(vo.getAttributeCode());
							String url = environmentTools.getBaseHost() + vo.getProjectName() + "/commonstate/queryQuoteBatch";
							String paramterStr = gson.toJson(param);
							try {
								String result = ReferHttpClientUtils.postByJson(url, paramterStr);
								logger.info("引用校验：url={},param={},result={}", url, paramterStr, result);
								CommonResponse<Map> data = gson.fromJson(result, new TypeToken<CommonResponse<Map>>() {
								}.getType());
								if (data.isSuccess()) {
									checkResultMap = data.getData();
									for (Object key : checkResultMap.keySet()) {
										if ("true".equals(checkResultMap.get(key.toString()).toString())) {
											checkResult.add(Long.valueOf(key.toString()));
											checkIds.remove(key.toString());
										}
									}
									if (checkIds.size() == 0) {
										break;
									}
								}
							} catch (Exception e) {
								throw new BusinessException(e.getMessage());
							}
						}
					}
				} else {
					throw new BusinessException("根据元数据id：" + billTypeVo.getMetadataId() + "查询引用信息失败！");
				}
			} else {
				throw new BusinessException("根据单据类型编码查询单据类型信息失败！");
			}
		} catch (Exception e) {
			return CommonResponse.error(e.getMessage());
		}
		return CommonResponse.success(checkResult);
	}
}
