package com.ejianc.foundation.share.controller.api;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.ejianc.foundation.share.bean.CategoryBrandEntity;
import com.ejianc.foundation.share.service.ICategoryBrandService;
import com.ejianc.foundation.share.vo.CategoryBrandVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.List;

@RestController
@RequestMapping("/api/categoryBrandApi/")
public class CategoryBrandApi {

    private final Logger logger = LoggerFactory.getLogger(getClass());

    @Autowired
    private ICategoryBrandService categoryBrandService;

    @PostMapping("queryWhetherByCtyIds")
    @ResponseBody
    public CommonResponse<List<CategoryBrandVO>> queryWhetherByCtyIds(@RequestBody List<Long> ctyIdList) {
        LambdaQueryWrapper<CategoryBrandEntity> queryWrapper = new LambdaQueryWrapper<>();
        queryWrapper.eq(CategoryBrandEntity::getTenantId, InvocationInfoProxy.getTenantid());
        queryWrapper.eq(CategoryBrandEntity::getWhether, 1);
        queryWrapper.in(CollectionUtils.isNotEmpty(ctyIdList), CategoryBrandEntity::getCategoryId, ctyIdList);
        List<CategoryBrandEntity> entitys = categoryBrandService.list(queryWrapper);
        if (entitys != null && entitys.size() > 0) {
            return CommonResponse.success(BeanMapper.mapList(entitys, CategoryBrandVO.class));
        }
        return CommonResponse.error("查询失败,未查到物料常用品牌。");
    }
}
