package com.ejianc.foundation.share.controller;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.ejianc.foundation.share.bean.MaterialEntity;
import com.ejianc.foundation.share.bean.MaterialRelationEntity;
import com.ejianc.foundation.share.service.IMaterialCategoryService;
import com.ejianc.foundation.share.service.IMaterialRelationService;
import com.ejianc.foundation.share.service.IMaterialService;
import com.ejianc.foundation.share.vo.MaterialCategoryVO;
import com.ejianc.foundation.share.vo.ZjwjSupplierAccountVO;
import com.ejianc.foundation.share.vo.ZjwjSupplierVO;
import com.ejianc.foundation.util.HttpTookit;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.response.CommonResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.elasticsearch.action.bulk.BulkRequest;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.client.RequestOptions;
import org.elasticsearch.client.RestHighLevelClient;
import org.elasticsearch.common.xcontent.XContentType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

import java.io.IOException;
import java.io.Serializable;
import java.security.GeneralSecurityException;
import java.util.*;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;

/**
 * 供方controller
 *
 * @author guoming
 */
@Controller
@RequestMapping("/zjwjsupplier/")
public class ZjwjSupplierController implements Serializable {

	private static final long serialVersionUID = 1L;

	private final Logger logger = LoggerFactory.getLogger(getClass());

	@Value("${zjwjSupl.addr}")
	private String zjwjHost;

	@Value("${zjwjSupl.appId}")
	private String appId;

	@Value("${zjwjSupl.secret}")
	private String secret;

	@Autowired
	private RedisTemplate<String, Object> redisTemplate;

	@Autowired
	private IMaterialRelationService materialRelationService;

	@Autowired
	private IMaterialService materialService;

	@Autowired
	private IMaterialCategoryService materialCategoryService;


	@Autowired(required=false)
	private RestHighLevelClient client;

	/**
	 *更新是否电子签章
	 *
	 * @return
	 */
	@RequestMapping(value = "/updateIsesign", method = RequestMethod.POST)
	@ResponseBody
	public CommonResponse<Object> updateIsesign(@RequestBody ZjwjSupplierVO zjwjSupplierVO) {
		String url = zjwjHost + "/el/supl/supplier/updatesupplier";
		JSONObject param1 = new JSONObject();
		param1.put("pkSupplier", zjwjSupplierVO.getPkSupplier());
		param1.put("isesign", zjwjSupplierVO.getIsesign());
		return  doPostHttp(url, param1.toJSONString());
	}

	/**
	 *查详情
	 *
	 * @return
	 */
	@RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
	@ResponseBody
	public CommonResponse<ZjwjSupplierVO> queryDetail(String pkSupplier) {
		String url = zjwjHost + "/el/supl/supplier/queryDetail";
		Map<String, Object> params = new HashMap();
		params.put("pkSupplier", pkSupplier);
		Map<String, String> headers = new HashMap();
		// 获取token
		this.getAccessToken(headers);
		try {
			logger.info("------------  url：" + url + "  ------------");
			logger.info("------------  入参：" + params.toString() + "  ------------");
			String back = HttpTookit.get(url, params, headers);
			JSONObject jsonBack = JSONObject.parseObject(back);
			if("200".equals(jsonBack.getString("code"))){
				//调用同步方法成功
				logger.info("------------  请求成功！body = " + jsonBack.getString("body") + "  ------------");
				ZjwjSupplierVO vo = JSONObject.parseObject(((JSONObject) jsonBack.get("body")).toJSONString(), ZjwjSupplierVO.class);
				return CommonResponse.success(vo);
			}else{
				logger.info("------------  请求失败！body = " + jsonBack.toJSONString());
			}
		} catch (Exception e) {
			logger.error(e.getMessage());
		}
		return CommonResponse.error("查询失败");
	}

	@RequestMapping(value = "/getSupplierAccountList", method = RequestMethod.GET)
	@ResponseBody
	public CommonResponse<List<ZjwjSupplierAccountVO>> getSupplierAccountList(String pkSupplier) {
		String url = zjwjHost + "/el/supl/account/getSupplierAccountList";
		Map<String, Object> params = new HashMap();
		params.put("pkSupplier", pkSupplier);
		params.put("order", "desc");
		params.put("page", 1);
		params.put("rows", 100);
		params.put("sort", "ts");
		Map<String, String> headers = new HashMap();
		// 获取token
		this.getAccessToken(headers);
		try {
			logger.info("------------  url：" + url + "  ------------");
			logger.info("------------  入参：" + params.toString() + "  ------------");
			String back = HttpTookit.get(url, params, headers);
			JSONObject jsonBack = JSONObject.parseObject(back);
			if("200".equals(jsonBack.getString("code"))){
				//调用同步方法成功
				logger.info("------------  请求成功！body = " + jsonBack.getString("body") + "  ------------");
				JSONObject jsonObject = (JSONObject) jsonBack.get("body");
				JSONArray jsonArray = (JSONArray) jsonObject.get("records");
				List<ZjwjSupplierAccountVO> voList = JSONObject.parseArray(jsonArray.toJSONString(), ZjwjSupplierAccountVO.class);
				return CommonResponse.success(voList);
			}
		} catch (Exception e) {
			logger.error(e.getMessage());
		}
		return CommonResponse.error("查询失败");
	}

	@RequestMapping(value = "/addSupplierAccount", method = RequestMethod.POST)
	@ResponseBody
	public CommonResponse<Object> addSupplierAccount(@RequestBody ZjwjSupplierAccountVO zjwjSupplierAccountVO) {
		String url = zjwjHost + "/el/supl/account/addSupplierAccount";
		JSONObject param1 = new JSONObject();
		param1.put("pkSupplier", zjwjSupplierAccountVO.getPkSupplier());
		param1.put("account", zjwjSupplierAccountVO.getAccount());
		param1.put("accountStatus", zjwjSupplierAccountVO.getAccountStatus());
		return  doPostHttp(url, param1.toJSONString());
	}

	@RequestMapping(value = "/updateSupplierAccount", method = RequestMethod.POST)
	@ResponseBody
	public CommonResponse<Object> updateSupplierAccount(@RequestBody ZjwjSupplierAccountVO zjwjSupplierAccountVO) {
		String url = zjwjHost + "/el/supl/account/updateSupplierAccount";
		JSONObject param1 = new JSONObject();
		param1.put("accountStatus", zjwjSupplierAccountVO.getAccountStatus());
		param1.put("pkAccount", zjwjSupplierAccountVO.getPkAccount());
		return  doPostHttp(url, param1.toJSONString());
	}

	@RequestMapping(value = "/deleteSupplierAccount", method = RequestMethod.POST)
	@ResponseBody
	public CommonResponse<Object> deleteSupplierAccount( @RequestBody ZjwjSupplierAccountVO zjwjSupplierAccountVO) {
		String url = zjwjHost + "/el/supl/account/deleteSupplierAccount";
		JSONObject param1 = new JSONObject();
		param1.put("pkAccount", zjwjSupplierAccountVO.getPkAccount());
		return  doPostHttp(url, param1.toJSONString());
	}


	/**
	 *重置密码
	 *
	 * @return
	 */
	@RequestMapping(value = "/resetmd", method = RequestMethod.GET)
	@ResponseBody
	public CommonResponse<Object> resetmd(Integer pkAccount) {
		String url = zjwjHost + "/el/supl/account/resetmd";
		Map<String, Object> params = new HashMap();
		params.put("pkAccount", pkAccount);
		Map<String, String> headers = new HashMap();
		// 获取token
		this.getAccessToken(headers);
		try {
			logger.info("------------  url：" + url + "  ------------");
			logger.info("------------  入参：" + params.toString() + "  ------------");
			String back = HttpTookit.get(url, params, headers);
			JSONObject jsonBack = JSONObject.parseObject(back);
			if("200".equals(jsonBack.getString("code"))){
				//调用同步方法成功
				logger.info("------------  请求成功！body = " + jsonBack.getString("body") + "  ------------");
				return CommonResponse.success(jsonBack.get("body"));
			}
		} catch (Exception e) {
			logger.error(e.getMessage());
		}
		return CommonResponse.error("查询失败");
	}

	/**
	 * Post公共方法
	 *
	 * @param url               路径地址
	 * @param parameterStr      参数  JSONString
	 * @return
	 */
	private CommonResponse<Object>  doPostHttp(String url, String parameterStr){
		Map<String, String> headers = new HashMap();
		// 获取token
		this.getAccessToken(headers);
		try {
			logger.info("------------  url：" + url + "  ------------");
			logger.info("------------  入参：" + parameterStr + "  ------------");
			String back = HttpTookit.postByJson(url, parameterStr, headers);
			JSONObject jsonBack = JSONObject.parseObject(back);
			if("200".equals(jsonBack.getString("code"))){
				//调用同步方法成功
				logger.info("------------  请求成功！body = " + jsonBack.getString("body") + "  ------------");
				return CommonResponse.success(jsonBack.get("body"));
			}else{
				//调用同步方法失败，输出错误信息
				logger.error("------------  请求失败！message = " + jsonBack.getString("message") + "  ------------");
				return CommonResponse.error(jsonBack.getString("message"));
			}
		} catch (Exception e) {
			logger.error(e.getMessage());
			return CommonResponse.error("查询失败！");
		}
	}

	/**
	 * 获取access_token服务
	 *
	 * @param headers
	 * @throws GeneralSecurityException
	 * @throws IOException
	 */
	private CommonResponse<String> getAccessToken(Map<String, String> headers) {
		//获取redis中的X-Open-Token，若不存在，则重新请求并放入redis中
		if(redisTemplate.opsForValue().get("X-Open-Token") != null){
			//若存在，直接放到header中
			headers.put("X-Open-Token", redisTemplate.opsForValue().get("X-Open-Token").toString());
		}else{
			String initContextUrl = zjwjHost + "/el/sw/auth/v1/accessToken?appId=" + appId + "&secret=" + secret;
			String responseStr = null;
			try {
				responseStr = HttpTookit.get(initContextUrl, null);
				JSONObject json = JSONObject.parseObject(responseStr);
				if("200".equals(json.get("code").toString())){
					JSONObject data = json.getJSONObject("body");
					String access_token = data.get("token").toString();
					headers.put("X-Open-Token", access_token);
					//将获取到的X-Open-Token放入redis中（可依据自己的redis工具类写,注意：设置的过期时间要小于等于120分钟）
					redisTemplate.opsForValue().set("X-Open-Token", access_token,6000, TimeUnit.SECONDS);
					logger.info("------------  获取access_token服务，请求成功！data = " + data + "  ------------");
				}else{
					//请求失败，输出错误信息
					return CommonResponse.error("获取供方access_token异常");
				}
			} catch (GeneralSecurityException e) {
				logger.info("GeneralSecurityException 异常"+e.getMessage());
				return CommonResponse.error("获取供方access_token异常");
			} catch (IOException e) {
				logger.info("IOException 异常"+e.getMessage());
				return CommonResponse.error("获取供方access_token异常");
			}
		}
		return CommonResponse.success();
	}

	/**
	 *测试插入es
	 *
	 * @return
	 */
	@RequestMapping(value = "/initEs", method = RequestMethod.GET)
	@ResponseBody
	public CommonResponse<Object> initEs(@RequestParam(required = false) String pkCorp, @RequestParam(required = false) String sourceMaterialId,
										 @RequestParam(required = false) String tenantId,
										 @RequestParam(required = false) String beginTime, @RequestParam(required = false) String endTime) {
	    logger.info("make number is 1");
		ExecutorService threadPool  = Executors.newFixedThreadPool(1);
		Callable<CommonResponse<String>> mainDatasetCallable = new MainDatasetCallable(pkCorp, sourceMaterialId,  tenantId, beginTime, endTime);
		threadPool.submit(mainDatasetCallable);
		return CommonResponse.success("成功");
	}


	class MainDatasetCallable implements Callable<CommonResponse<String>> {
		private String pkCorp;
		private String sourceMaterialId;
		private  String tenantId;
		private  String beginTime;
		private  String endTime;


		public MainDatasetCallable(String pkCorp, String sourceMaterialId, String tenantId, String beginTime, String endTime) {
			this.pkCorp = pkCorp;
			this.sourceMaterialId = sourceMaterialId;
			this.tenantId = tenantId;
			this.beginTime = beginTime;
			this.endTime = endTime;
		}

		@Override
		public CommonResponse<String> call() {
			InvocationInfoProxy.setTenantid(Long.valueOf(tenantId));
			boolean flag = true;
			int pageNumber = 1;
			while (flag) {
				List<MaterialRelationEntity> entityList = new ArrayList<>();
				BulkRequest bulkRequest = new BulkRequest();
				LambdaQueryWrapper<MaterialRelationEntity> wrapper = new LambdaQueryWrapper<>();
				if(StringUtils.isNotBlank(pkCorp)){
					wrapper.eq(!"0000".equals(pkCorp), MaterialRelationEntity::getSourceOrgId, pkCorp);
					wrapper.isNull(MaterialRelationEntity::getMaterialId);
				}else if(StringUtils.isNotBlank(sourceMaterialId)){
					wrapper.eq(MaterialRelationEntity::getSourceMaterialId, sourceMaterialId);
				}else if(StringUtils.isNotBlank(beginTime) && StringUtils.isNotBlank(endTime)){
					wrapper.between(MaterialRelationEntity::getCreateTime, beginTime, endTime);
				}else{
					return CommonResponse.error("组织和来源物料主键都为空");
				}
				wrapper.last("limit " + (pageNumber-1)*5000 + ", 5000");
				List<MaterialRelationEntity> relationEntityList = materialRelationService.list(wrapper);
				logger.info("relationEntityList is" + relationEntityList.size());
				if(CollectionUtils.isNotEmpty(relationEntityList)){
					for(MaterialRelationEntity entity : relationEntityList ){
						MaterialEntity materialEntity = materialService.queryBySourceId(entity.getSourceMaterialId());
						if (materialEntity != null) {
							entity.setMaterialId(materialEntity.getId());
							entity.setCategoryId(materialEntity.getCategoryId());
							entity.setCode(materialEntity.getCode());
							entity.setName(materialEntity.getName());
							entity.setSpec(materialEntity.getSpec());
							entity.setUnitName(materialEntity.getUnitName());
							entity.setType(1);
							entity.setEnabled(materialEntity.getEnabled());
							entity.setSourceId(materialEntity.getSourceId());
							entity.setDef1(materialEntity.getDef1());
							entity.setDef2(materialEntity.getDef2());
							entity.setDef3(materialEntity.getDef3());
							entity.setDef4(materialEntity.getDef4());
							entity.setDef5(materialEntity.getDef5());
							entity.setDef6(materialEntity.getDef6());
							entity.setDef7(materialEntity.getDef7());
							entity.setDef8(materialEntity.getDef8());
							entity.setDef9(materialEntity.getDef9());
							entity.setDef10(new Date().toString());

							MaterialCategoryVO materialCategoryVO = materialCategoryService.queryDetail(materialEntity.getCategoryId());
							if (materialCategoryVO != null) {
								entity.setCategoryName(materialCategoryVO.getName());
								entity.setInnerCode(materialCategoryVO.getInnerCode());
							}

							entityList.add(entity);

							Map<String, Object> dataMap = new HashMap<>();
							dataMap.put("materialId", entity.getMaterialId());
							dataMap.put("categoryId", entity.getCategoryId());
							dataMap.put("innerCode", entity.getInnerCode());
							dataMap.put("code", entity.getCode());
							dataMap.put("categoryName", entity.getCategoryName());
							dataMap.put("name", entity.getName());
							dataMap.put("spec", entity.getSpec());
							dataMap.put("model", entity.getModel());
							dataMap.put("unitName", entity.getUnitName());
							dataMap.put("itemType", entity.getType());
							dataMap.put("sourceOrgId", entity.getSourceOrgId());

							IndexRequest indexRequest = new IndexRequest("ejc_wj_org_material_relation_es");
							indexRequest.id(String.valueOf(entity.getId()));
							indexRequest.source(dataMap, XContentType.JSON);
							bulkRequest.add(indexRequest);
						}
					}
					logger.info("保存开始--------》》》" + entityList.size() + ">>>" + new Date());
					materialRelationService.saveOrUpdateBatch(entityList);
					logger.info("保存结束--------》》》" + new Date());

					try {
						client.bulk(bulkRequest, RequestOptions.DEFAULT);
					} catch (Exception e) {
						logger.error(e.getMessage());
					}
				}else{
					flag = false;
					logger.info("no data pageNumber is  ------->" + pageNumber);
				}

				if (relationEntityList.size() < 5000) {
					flag = false;
					logger.info("normal pageNumber is  ------->" + pageNumber);
				}
				pageNumber++;
			}
			return CommonResponse.success("成功");
		}
	}


	/**
	 *新公司同步到ES，直接同步
	 *
	 * @return
	 */
	@RequestMapping(value = "/newCorpToEs", method = RequestMethod.GET)
	@ResponseBody
	public CommonResponse<Object> newCorpToEs(@RequestParam String pkCorp, @RequestParam(required = false) String params, @RequestParam(required = false) String tenantId) {
		ExecutorService threadPool  = Executors.newFixedThreadPool(1);
		Callable<CommonResponse<String>> mainDatasetCallable = new CorpToEsCallable(pkCorp, params,  tenantId);
		threadPool.submit(mainDatasetCallable);
		return CommonResponse.success("成功");
	}


	class CorpToEsCallable implements Callable<CommonResponse<String>> {
		private String pkCorp;
		private String params;
		private  String tenantId;


		public CorpToEsCallable(String pkCorp, String params, String tenantId) {
			this.pkCorp = pkCorp;
			this.params = params;
			this.tenantId = tenantId;
		}

		@Override
		public CommonResponse<String> call() {
			InvocationInfoProxy.setTenantid(Long.valueOf(tenantId));
			boolean flag = true;
			int pageNumber = 1;
			while (flag) {
				List<MaterialRelationEntity> entityList = new ArrayList<>();
				BulkRequest bulkRequest = new BulkRequest();
				LambdaQueryWrapper<MaterialRelationEntity> wrapper = new LambdaQueryWrapper<>();
				wrapper.eq(MaterialRelationEntity::getSourceOrgId, pkCorp);
				wrapper.eq(StringUtils.isNotBlank(params), MaterialRelationEntity::getDef10, params);
				wrapper.last("limit " + (pageNumber-1)*5000 + ", 5000");
				List<MaterialRelationEntity> relationEntityList = materialRelationService.list(wrapper);
				logger.info("relationEntityList is" + relationEntityList.size());
				if(CollectionUtils.isNotEmpty(relationEntityList)){
					for(MaterialRelationEntity entity : relationEntityList ){
						if(null != entity.getMaterialId() && null != entity.getCategoryId()){
							Map<String, Object> dataMap = new HashMap<>();
							dataMap.put("materialId", entity.getMaterialId());
							dataMap.put("categoryId", entity.getCategoryId());
							dataMap.put("innerCode", entity.getInnerCode());
							dataMap.put("code", entity.getCode());
							dataMap.put("categoryName", entity.getCategoryName());
							dataMap.put("name", entity.getName());
							dataMap.put("spec", entity.getSpec());
							dataMap.put("model", entity.getModel());
							dataMap.put("unitName", entity.getUnitName());
							dataMap.put("itemType", entity.getType());
							dataMap.put("sourceOrgId", entity.getSourceOrgId());

							IndexRequest indexRequest = new IndexRequest("ejc_wj_org_material_relation_es");
							indexRequest.id(String.valueOf(entity.getId()));
							indexRequest.source(dataMap, XContentType.JSON);
							bulkRequest.add(indexRequest);
						}else{
							logger.info("no material id or categoryId--------》》》" + entity.getId());
						}
					}
					try {
						logger.info("同步ES开始--------》》》" + entityList.size() + ">>>" + new Date());
						client.bulk(bulkRequest, RequestOptions.DEFAULT);
						logger.info("同步ES结束--------》》》" + new Date());
					} catch (Exception e) {
						logger.error(e.getMessage());
					}
				}else{
					flag = false;
					logger.info("no data pageNumber is  ------->" + pageNumber);
				}

				if (relationEntityList.size() < 5000) {
					flag = false;
					logger.info("normal pageNumber is  ------->" + pageNumber);
				}
				pageNumber++;
			}
			return CommonResponse.success("成功");
		}
	}
}
