package com.ejianc.foundation.util;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.ejianc.foundation.dataModel.vo.DataModelColumnVO;
import com.ejianc.foundation.metadata.vo.MdAttributeVO;
import com.ejianc.foundation.support.vo.BillTypeVO;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.refer.util.ReferObjectUtil;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;

import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import java.math.BigDecimal;
import java.util.*;

public class CalculatorUtils {

	public static void main(String[] args) {
		Map<String, String> propertyMap = new HashMap<String, String>();
		System.out.println(checkFormula("(amount1+amount2)*amount3",propertyMap));
	}

	public static BigDecimal getResult(String input, JSONObject mainDataset) {
		// 规范输入形式,避免用户输入中文括号
		input = input.replaceAll("（", "(");
		input = input.replaceAll("）", ")");
		// 对输入公式,按符号/数字,用空格分开,以便后面分组
		String[] inputs = input.split("");
		String format = "";
		for (int i = 0; i < inputs.length; i++) {
			if (inputs[i].equals(" ")) {
				continue;
			} else if (inputs[i].equals("(") || inputs[i].equals(")") || inputs[i].equals("+") || inputs[i].equals("-") || inputs[i].equals("*") || inputs[i].equals("/")) {
				format += " " + inputs[i] + " ";
			} else {
				format += inputs[i];
			}
		}
		List<String> strings = changeInfixExpressionToPostfixExpression(format, mainDataset);
		Stack<String> stack = new Stack<String>();
		for (int i = 0; i < strings.size(); i++) {
			if (strings.get(i).equals("+")) {
				BigDecimal a = new BigDecimal(stack.pop());
				BigDecimal b = new BigDecimal(stack.pop());
				stack.add(b.add(a).toString());
			} else if (strings.get(i).equals("-")) {
				BigDecimal a = new BigDecimal(stack.pop());
				BigDecimal b = new BigDecimal(stack.pop());
				stack.add(b.subtract(a).toString());
			} else if (strings.get(i).equals("*")) {
				BigDecimal a = new BigDecimal(stack.pop());
				BigDecimal b = new BigDecimal(stack.pop());
				stack.add(b.multiply(a).toString());
			} else if (strings.get(i).equals("/")) {
				BigDecimal a = new BigDecimal(stack.pop());
				BigDecimal b = new BigDecimal(stack.pop());
				// 这里的1000是做除法以后计算的精确位数,就算1000位也并不会拖慢程序速度,一个公式0.01秒内就能算完,后面的是除不尽的四舍五入
				stack.add(a.compareTo(new BigDecimal(0)) == 0 ? "0" : b.divide(a, 1000, BigDecimal.ROUND_HALF_DOWN).toString());
			} else {
				stack.add(strings.get(i));
			}
		}
		// 返回的时候格式化一下,取四舍五入小数点后两位
		return new BigDecimal(stack.pop()).setScale(2, BigDecimal.ROUND_HALF_DOWN);
	}

	public static List<String> changeInfixExpressionToPostfixExpression(String input, JSONObject mainDataset) {
		List<String> resultList = new ArrayList<String>();
		Stack<String> tempStack = new Stack<String>();
		String[] splitArray = input.split(" ");
		for (int i = 0; i < splitArray.length; i++) {
			if (splitArray[i].equals("")) {
				continue;
			}
			// 如果字符是右括号的话,说明前面一定有过左括号,将栈里第一个左括号之前全部添加到List里
			if (splitArray[i].equals(")")) {
				while (!tempStack.peek().equals("(")) {
					resultList.add(tempStack.pop());
				}
				tempStack.pop();// 去除前面的左括号
			} else if (splitArray[i].equals("(")) {
				// 如果是左括号,那么直接添加进去
				tempStack.add("(");
			} else if (splitArray[i].equals("+") || splitArray[i].equals("-")) {
				// 如果是加减号,还需要再判断
				if (tempStack.empty() || tempStack.peek().equals("(")) {
					tempStack.add(splitArray[i]);
				} else if (tempStack.peek().equals("+") || tempStack.peek().equals("-")) {
					// 读临时栈里的顶部数据,如果也是加减就取出来一个到结果列,这个放临时栈,如果是乘除就开始取到右括号为止
					resultList.add(tempStack.pop());
					tempStack.add(splitArray[i]);
				} else {
					while (!tempStack.empty()) {
						if (tempStack.peek().equals("(")) {
							break;
						} else {
							resultList.add(tempStack.pop());
						}
					}
					tempStack.add(splitArray[i]);
				}
			} else if (splitArray[i].equals("*") || splitArray[i].equals("/")) {
				// 如果是乘除
				if (!tempStack.empty()) {
					// 判断临时栈里栈顶是啥,如果是乘除,取一个出来到结果列,添这个进临时栈
					if (tempStack.peek().equals("*") || tempStack.peek().equals("/")) {
						resultList.add(tempStack.pop());
					}
				}
				tempStack.add(splitArray[i]);
			} else {
				// 说明是非符号,都添加进去
				if(StringUtils.isNotBlank(mainDataset.getString(splitArray[i]))) {
					resultList.add(mainDataset.getString(splitArray[i]));
				}else{
					resultList.add(splitArray[i]);
				}
			}
		}
		// 遍历完了,把临时stack里的东西都加到结果stack里去
		while (!tempStack.empty()) {
			resultList.add(tempStack.pop());
		}
		return resultList;
	}
	
	public static  Boolean checkFormula(String formula, Map<String, String> propertyMap) {
		Boolean checked = true;
		// 规范输入形式,避免用户输入中文括号
		formula = formula.replaceAll("（", "(");
		formula = formula.replaceAll("）", ")");
		// 对输入公式,按符号/数字,用空格分开,以便后面分组
		String[] inputs = formula.split("");
		String format = "";
		for (int i = 0; i < inputs.length; i++) {
			if (inputs[i].equals(" ")) {
				continue;
			} else if (inputs[i].equals("(") || inputs[i].equals(")") || inputs[i].equals("+") || inputs[i].equals("-") || inputs[i].equals("*") || inputs[i].equals("/")) {
				format += " " + inputs[i] + " ";
			} else {
				format += inputs[i];
			}
		}
		String[] splitArray = format.split(" ");
		List<String> tempList = new ArrayList<>();
		for (int i = 0; i < splitArray.length; i++) {
			if (splitArray[i].equals("")) {
				continue;
			}
			if(tempList.size() == 0) {
				if("+".equals(splitArray[i]) || "-".equals(splitArray[i]) || "*".equals(splitArray[i]) || "/".equals(splitArray[i])) {
					checked = false;
					break;
				}
			}else{
				tempList.add(splitArray[i]);
			}
			// 如果字符是右括号的话,说明前面一定有过左括号,将栈里第一个左括号之前全部添加到List里
			if (splitArray[i].equals(")")) {
				continue;
			} else if (splitArray[i].equals("(")) {
				continue;
			} else if (splitArray[i].equals("+") || splitArray[i].equals("-")) {
				continue;
			} else if (splitArray[i].equals("*") || splitArray[i].equals("/")) {
				continue;
			} else {
				if(propertyMap.containsKey(splitArray[i])){
					continue;
				}else{
					checked = false;
					break;
				}
			}
		}
		// 遍历完了,把临时stack里的东西都加到结果stack里去
		return checked;
	}


	public static boolean getFiled (String condition, JSONObject billData, List<DataModelColumnVO>  columnVOS, Logger logger){
		logger.info("原始条件参数 condition -- {} ,原始数据 billData -- {}，",condition,billData);
		Object vv = false;
		if(billData!=null){
			List<String> fieldsSet = new ArrayList<>();
			String conds = condition.replace("{", "").replace("}", "").replace("$", "");
			List<String> fields = new ArrayList<>();
			if (conds.contains("&&") && conds.contains("||")) {
				String[] condArray = conds.split("&&");
				for (String str : condArray) {
					if (str.contains("||")) {
						String[] subArray = str.split("\\|\\|");
						for (String s : subArray) {
							fields.add(s);
						}
					} else {
						fields.add(str);
					}
				}
			} else if (conds.contains("||")) {
				String[] condArray = conds.split("\\|\\|");
				for (String str : condArray) {
					fields.add(str);
				}
			} else if (conds.contains("&&")) {
				String[] condArray = conds.split("&&");
				for (String str : condArray) {
					fields.add(str);
				}
			} else {
				fields.add(conds);
			}
			dealFieldsSet(fields,fieldsSet);
			String newCondition = conds;
			logger.info("原始条件参数 condition -- {} ,原始数据 billData -- {}，新条件 newCondition -- {}",condition,billData,newCondition);
			Map<String, String> fieldTypeMap = obtainConditionFields(fieldsSet,columnVOS);
			Map<String, Object> fieldValueMap = new HashMap<>();
			for(String field : fieldTypeMap.keySet()){
				if(billData.get(field)!=null){
					newCondition = newCondition.replaceAll(field, billData.get(field).toString());
					fieldValueMap.put(field, billData.get(field).toString());
				}
			}
			if(newCondition.contains("⊃")){
				for (String field : fields) {
					if (field.contains("⊃")) {
						String copyValue = field;
						String[] array = field.split("⊃");
						String v1 = array[0];
						if("(".equals(v1.substring(0, 1))){
							v1 = v1.substring(1);
							copyValue = copyValue.substring(1);
						}
						String v2 = array[1];
						if(")".equals(v2.substring(v2.length()-1))){
							v2 = v2.substring(0, v2.length()-1);
							copyValue = copyValue.substring(0, copyValue.length()-1);
						}
						if(billData.get(v1)!=null){
							copyValue = copyValue.replaceAll(v1, ('"'+billData.get(v1).toString()+'"'));
							v1 = billData.get(v1).toString();
						}else{
							v1 = v1.substring(1, v1.length()-1);
						}
						if(billData.get(v2)!=null){
							copyValue = copyValue.replaceAll(v2, ('"'+billData.get(v2).toString()+'"'));
							v2 = billData.get(v2).toString();
						}else{
							v2 = v2.substring(1, v2.length()-1);
						}
						Boolean r  = v1.contains(v2);
						newCondition = newCondition.replaceAll(copyValue, r.toString());
					}
				}
			}
			if(newCondition.contains("⊅")){
				for (String field : fields) {
					if (field.contains("⊅")) {
						String copyValue = field;
						String[] array = field.split("⊅");
						String v1 = array[0];
						if("(".equals(v1.substring(0, 1))){
							v1 = v1.substring(1);
							copyValue = copyValue.substring(1);
						}
						String v2 = array[1];
						if(")".equals(v2.substring(v2.length()-1))){
							v2 = v2.substring(0, v2.length()-1);
							copyValue = copyValue.substring(0, copyValue.length()-1);
						}
						if(billData.get(v1)!=null){
							copyValue = copyValue.replaceAll(v1, ('"'+billData.get(v1).toString()+'"'));
							v1 = billData.get(v1).toString();
						}else{
							v1 = v1.substring(1, v1.length()-1);
						}
						if(billData.get(v2)!=null){
							copyValue = copyValue.replaceAll(v2, ('"'+billData.get(v2).toString()+'"'));
							v2 = billData.get(v2).toString();
						}else{
							v2 = v2.substring(1, v2.length()-1);
						}
						Boolean r  = !v1.contains(v2);
						newCondition = newCondition.replaceAll(copyValue, r.toString());
					}
				}
			}
			ScriptEngineManager manager = new ScriptEngineManager();
			ScriptEngine factories = manager.getEngineByExtension("js");
			try {
				vv = factories.eval(newCondition);
				logger.info("原始条件参数 condition -- {} ,原始数据 billData -- {}，新条件 newCondition -- {} ,判定结果  vv -- {}",condition,billData,newCondition,vv);
			} catch (ScriptException e) {
				e.printStackTrace();
				logger.info("原始条件参数 condition -- {} ,原始数据 billData -- {}，报错 ScriptException -- {}",condition,billData,e.getMessage());
				vv = false;
			}
		}
		logger.info("原始条件参数 condition -- {} ,原始数据 billData -- {}，返回结果 vv -- {}",condition,billData,vv);
		return (boolean) vv;
	}

	private static void dealFieldsSet(List<String> fields, List<String> fieldsSet) {
		for (String field : fields) {
			if (field.contains("==")) {
				String[] array = field.split("==");
				String v1 = array[0];
				if("(".equals(v1.substring(0, 1))){
					v1 = v1.substring(1);
				}
				fieldsSet.add(v1);
				if(array.length>1){
					String v2 = array[1];
					if(")".equals(v2.substring(v2.length()-1))){
						v2 = v2.substring(0, v2.length()-1);
					}
					fieldsSet.add(v2);
				}
			} else if (field.contains("!=")) {
				String[] array = field.split("!=");
				String v1 = array[0];
				if("(".equals(v1.substring(0, 1))){
					v1 = v1.substring(1);
				}
				fieldsSet.add(v1);
				if(array.length>1){
					String v2 = array[1];
					if(")".equals(v2.substring(v2.length()-1))){
						v2 = v2.substring(0, v2.length()-1);
					}
					fieldsSet.add(v2);
				}
			} else if (field.contains(">=")) {
				String[] array = field.split(">=");
				String v1 = array[0];
				if("(".equals(v1.substring(0, 1))){
					v1 = v1.substring(1);
				}
				fieldsSet.add(v1);
				if(array.length>1){
					String v2 = array[1];
					if(")".equals(v2.substring(v2.length()-1))){
						v2 = v2.substring(0, v2.length()-1);
					}
					fieldsSet.add(v2);
				}
			} else if (field.contains("<=")) {
				String[] array = field.split("<=");
				String v1 = array[0];
				if("(".equals(v1.substring(0, 1))){
					v1 = v1.substring(1);
				}
				fieldsSet.add(v1);
				if(array.length>1){
					String v2 = array[1];
					if(")".equals(v2.substring(v2.length()-1))){
						v2 = v2.substring(0, v2.length()-1);
					}
					fieldsSet.add(v2);
				}
			} else if (field.contains(">")) {
				String[] array = field.split(">");
				String v1 = array[0];
				if("(".equals(v1.substring(0, 1))){
					v1 = v1.substring(1);
				}
				fieldsSet.add(v1);
				if(array.length>1){
					String v2 = array[1];
					if(")".equals(v2.substring(v2.length()-1))){
						v2 = v2.substring(0, v2.length()-1);
					}
					fieldsSet.add(v2);
				}
			} else if (field.contains("<")) {
				String[] array = field.split("<");
				String v1 = array[0];
				if("(".equals(v1.substring(0, 1))){
					v1 = v1.substring(1);
				}
				fieldsSet.add(v1);
				if(array.length>1){
					String v2 = array[1];
					if(")".equals(v2.substring(v2.length()-1))){
						v2 = v2.substring(0, v2.length()-1);
					}
					fieldsSet.add(v2);
				}
			} else if (field.contains("⊃")) {
				String[] array = field.split("⊃");
				String v1 = array[0];
				if("(".equals(v1.substring(0, 1))){
					v1 = v1.substring(1);
				}
				fieldsSet.add(v1);
				if(array.length>1){
					String v2 = array[1];
					if(")".equals(v2.substring(v2.length()-1))){
						v2 = v2.substring(0, v2.length()-1);
					}
					fieldsSet.add(v2);
				}
			} else if (field.contains("⊅")) {
				String[] array = field.split("⊅");
				String v1 = array[0];
				if("(".equals(v1.substring(0, 1))){
					v1 = v1.substring(1);
				}
				fieldsSet.add(v1);
				if(array.length>1){
					String v2 = array[1];
					if(")".equals(v2.substring(v2.length()-1))){
						v2 = v2.substring(0, v2.length()-1);
					}
					fieldsSet.add(v2);
				}
			}
		}
	}

	public static Map<String, String> obtainConditionFields(List<String> fieldsSet,List<DataModelColumnVO>  columnVOS) {

		Map<String, String> fieldTypeMap = new HashMap<>();

		if (ListUtil.isNotEmpty(fieldsSet)) {
			for (String str : fieldsSet) {
				for (DataModelColumnVO vo : columnVOS) {
					if(vo.getProperty().equals(str)){
						fieldTypeMap.put(str,vo.getType());
					}
				}
			}
		}
		return fieldTypeMap;
	}
}
