package com.ejianc.foundation.share.mapper;

import com.ejianc.foundation.share.bean.MaterialCategoryEntity;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;

import java.util.List;
import java.util.Map;

@Mapper
public interface MaterialCategoryMapper {

	List<MaterialCategoryEntity> queryList(Map<String, Object> condition);

	MaterialCategoryEntity queryDetail(@Param("tenantId") Long tenantId,@Param("id") Long id);

	void update(MaterialCategoryEntity entity);

	void insert(MaterialCategoryEntity entity);

	void insertBatch(@Param("tenantId") Long tenantId,@Param("list") List<MaterialCategoryEntity> list);

	List<MaterialCategoryEntity> queryListByPid(@Param("tenantId") Long tenantId, @Param("id") Long id);

	void delete(@Param("tenantId") Long tenantId,@Param("id") Long id);

	void updateEnabled(@Param("enabled") Integer enabled,@Param("tenantId") Long tenantId,@Param("innerCode") String innerCode);

	List<MaterialCategoryEntity>  queryByCode(@Param("tenantId") Long tenantId, @Param("code") String code);
	List<MaterialCategoryEntity>  queryByName(@Param("tenantId") Long tenantId, @Param("name") String name);

	void insertCategoryListFromPlatform(@Param("tenantId") Long tenantId);

	List<MaterialCategoryEntity> queryListTree(Map<String, Object> params);

	MaterialCategoryEntity queryBySourceId(@Param("sourceId") String sourceId, @Param("tenantId") Long tenantId);

	List<MaterialCategoryEntity> queryListByInnerCode(Map<String, Object> params);

	List<MaterialCategoryEntity> queryListByInnerCodes(Map<String, Object> params);

	List<MaterialCategoryEntity> queryLastCategoryByTime(Map<String, Object> params);

	Long checkArchive(@Param("tenantId") Long tenantId, @Param("type") Integer type, @Param("name") String name);

	MaterialCategoryEntity queryCategoryByTypeAndName(@Param("tenantId") Long tenantId, @Param("type") Integer type, @Param("categoryName") String categoryName);

	List<MaterialCategoryEntity> exitByCode(@Param("code") String code, @Param("tenantId") Long tenantId, @Param("id") Long id);

    List<MaterialCategoryEntity> queryEnableListByPid(@Param("tenantId") Long tenantId, @Param("id") Long id);
}
