package com.ejianc.foundation.share.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.foundation.billcode.BillCodeException;
import com.ejianc.foundation.share.bean.SupplierCategoryEntity;
import com.ejianc.foundation.share.bean.SupplierEntity;
import com.ejianc.foundation.share.bean.SupplierLinkerEntity;
import com.ejianc.foundation.share.mapper.SupplierMapper;
import com.ejianc.foundation.share.service.ISupplierCategoryService;
import com.ejianc.foundation.share.service.ISupplierLinkerService;
import com.ejianc.foundation.share.service.ISupplierService;
import com.ejianc.foundation.share.vo.SupplierLinkerVO;
import com.ejianc.foundation.share.vo.SupplierVO;
import com.ejianc.foundation.support.service.IBillCodeGenerator;
import com.ejianc.foundation.support.service.IDefdocDetailService;
import com.ejianc.foundation.support.vo.DefdocDetailVO;
import com.ejianc.foundation.tenant.api.IEnterpriseApi;
import com.ejianc.foundation.tenant.vo.EnterpriseVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.EnvironmentTools;
import com.ejianc.framework.core.util.HttpTookit;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.support.idworker.util.IdWorker;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.conn.ConnectTimeoutException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.net.SocketTimeoutException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

@Service
@Transactional
public class SupplierServiceImpl extends BaseServiceImpl<SupplierMapper, SupplierEntity> implements ISupplierService {

	private static final String SUPPLIER_BILL_CODE = "SUPPORT_SUPPLIER";

    private Logger logger = LoggerFactory.getLogger(this.getClass());

	@Autowired
	private SupplierMapper supplierMapper;
	@Autowired
	private ISupplierLinkerService supplierLinkerService;
	@Autowired
	private IDefdocDetailService defdocDetailService;
	@Autowired
	private IBillCodeGenerator generator;
	@Autowired
	private ISupplierCategoryService categoryService;
	@Autowired
	private IEnterpriseApi enterpriseApi;

    @Value("${sendMessageTemplateCode}")
    private String sendMessageTemplateCode;

    //生成供方协同管理员账号密码（及租户的默认密码）
    @Value("${supplierCollaborationPassword}")
    private String supplierCollaborationPassword;
    
    @Autowired
    private EnvironmentTools environmentTools;

	@Override
	public List<SupplierVO> queryListByCategoryId(Long categoryId) {
		QueryWrapper<SupplierEntity> wrapper = new QueryWrapper<>();
		wrapper.eq("category_id", categoryId);
		List<SupplierEntity> entities = supplierMapper.selectList(wrapper);
		if(entities != null) {
			return BeanMapper.mapList(entities, SupplierVO.class);
		}
		return null;
	}


	@Override
	public CommonResponse<SupplierVO> saveOrUpdate(SupplierVO supplierVo) {
		Long tenantId = InvocationInfoProxy.getTenantid();
		SupplierEntity entity = null;
		String operateType = null;
		//根据统一信用代码验重
		this.check(supplierVo);

		if(supplierVo.getId() != null && supplierVo.getId() > 0) { //修改
			entity = supplierMapper.selectById(supplierVo.getId());
			entity.setCode(supplierVo.getCode());
			entity.setName(supplierVo.getName());
			entity.setCategoryId(supplierVo.getCategoryId());
			entity.setCategoryName(supplierVo.getCategoryName());
			entity.setSocialCreditCode(supplierVo.getSocialCreditCode());
			entity.setLegal(supplierVo.getLegal());
			entity.setTaxPayerType(supplierVo.getTaxPayerType());
			entity.setBusinessScope(supplierVo.getBusinessScope());
			entity.setArea(supplierVo.getArea());
			entity.setAddress(supplierVo.getAddress());
			entity.setTelephone(supplierVo.getTelephone());
			entity.setBankName(supplierVo.getBankName());
			entity.setBankAccount(supplierVo.getBankAccount());
			entity.setBankCode(supplierVo.getBankCode());
			entity.setDescription(supplierVo.getDescription());
			entity.setEnabled(supplierVo.getEnabled());
			entity.setGradeId(supplierVo.getGradeId());
			entity.setGradeName(supplierVo.getGradeName());
			entity.setAreaStr(supplierVo.getAreaStr());

			operateType = "edit";
		}else{ //新增
			try {
				if(StringUtils.isEmpty(supplierVo.getCode())){
					String billCode = generator.generateBillCodeById(SUPPLIER_BILL_CODE, tenantId);
					supplierVo.setCode(billCode);
				}
			} catch (BillCodeException e) {
				throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
			}
			entity = BeanMapper.map(supplierVo, SupplierEntity.class);

			operateType = "add";
		}

		//处理项目地区，转为省市区
		if(StringUtils.isNotBlank(entity.getArea())){
			String regex = "((?<provinceAndCity>[^市]+市|.*?自治州|.*?区|.*县)(?<town>[^区]+区|.*?市|.*?县|.*?路|.*?街|.*?道|.*?镇|.*?旗)(?<detailAddress>.*))";
			Matcher matcher = Pattern.compile(regex).matcher(entity.getArea());
			while(matcher.find()){
				try {
					entity.setRegion(matcher.group("town"));
				}catch (IllegalArgumentException e){
				}
				String regex2 = "((?<province>[^省]+省|.+自治区|上海市|北京市|天津市|重庆市|上海|北京|天津|重庆|香港特别行政区|澳门特别行政区)(?<city>.*))";
				String provinceAndCity = "";
				try {
					provinceAndCity = matcher.group("provinceAndCity");
				}catch (IllegalArgumentException e){
				}
				Matcher matcher2 = Pattern.compile(regex2).matcher(provinceAndCity);
				while (matcher2.find()){
					try {
						entity.setProvince(matcher.group("province"));
					}catch (IllegalArgumentException e){
					}
					try {
						String city = matcher2.group("city");
						if(StringUtils.isBlank(city)){
							entity.setCity(entity.getProvince());
						}else{
							entity.setCity(matcher.group("city"));
						}
					}catch (IllegalArgumentException e){
					}

				}
			}
		}

		super.saveOrUpdate(entity);

		//子表
		List<SupplierLinkerVO> supplierLinkerVos = supplierVo.getGridheaders();
		List<SupplierLinkerEntity> saveOrUpldates = new ArrayList<>();
		List<Long> deleteIds = new ArrayList<>();
		for(SupplierLinkerVO supplierLinkerVo:supplierLinkerVos) {
			if("add".equals(supplierLinkerVo.getRowState())) {
				SupplierLinkerEntity supplierLinkerEntity = BeanMapper.map(supplierLinkerVo, SupplierLinkerEntity.class);
				supplierLinkerEntity.setSupplierId(entity.getId());
				saveOrUpldates.add(supplierLinkerEntity);
			}else if("edit".equals(supplierLinkerVo.getRowState())) {
				SupplierLinkerEntity supplierLinkerEntity = BeanMapper.map(supplierLinkerVo, SupplierLinkerEntity.class);
				saveOrUpldates.add(supplierLinkerEntity);
			} else if("del".equals(supplierLinkerVo.getRowState())) {
				deleteIds.add(supplierLinkerVo.getId());
			}
		}
		if(saveOrUpldates.size() > 0) {
			supplierLinkerService.saveOrUpdateBatch(saveOrUpldates, saveOrUpldates.size(), false);
		}
		if(deleteIds.size() > 0) {
			supplierLinkerService.removeByIds(deleteIds, false);
		}

		supplierVo = BeanMapper.map(entity,SupplierVO.class);
		if("add".equals(operateType)) {
			return CommonResponse.success("保存成功",supplierVo);
		}else{
			return CommonResponse.success("修改成功",supplierVo);
		}
	}
	public CommonResponse<SupplierVO> saveOrUpdateReturn(SupplierVO supplierVo){
		Long tenantId = InvocationInfoProxy.getTenantid();
		SupplierEntity entity = null;
		String operateType = null;
		//根据统一信用代码验重
		this.check(supplierVo);

		if(supplierVo.getId() != null && supplierVo.getId() > 0) { //修改
			entity = supplierMapper.selectById(supplierVo.getId());
			entity.setCode(supplierVo.getCode());
			entity.setName(supplierVo.getName());
			entity.setCategoryId(supplierVo.getCategoryId());
			entity.setCategoryName(supplierVo.getCategoryName());
			entity.setSocialCreditCode(supplierVo.getSocialCreditCode());
			entity.setLegal(supplierVo.getLegal());
			entity.setTaxPayerType(supplierVo.getTaxPayerType());
			entity.setBusinessScope(supplierVo.getBusinessScope());
			entity.setArea(supplierVo.getArea());
			entity.setAddress(supplierVo.getAddress());
			entity.setTelephone(supplierVo.getTelephone());
			entity.setBankName(supplierVo.getBankName());
			entity.setBankAccount(supplierVo.getBankAccount());
			entity.setBankCode(supplierVo.getBankCode());
			entity.setDescription(supplierVo.getDescription());
			entity.setEnabled(supplierVo.getEnabled());
			entity.setAreaStr(supplierVo.getAreaStr());

			operateType = "edit";
		}else{ //新增
			try {
				String billCode = generator.generateBillCodeById(SUPPLIER_BILL_CODE, tenantId);
				supplierVo.setCode(billCode);
			} catch (BillCodeException e) {
				throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
			}
			entity = BeanMapper.map(supplierVo, SupplierEntity.class);

			operateType = "add";
		}

		//处理项目地区，转为省市区
		if(StringUtils.isNotBlank(entity.getArea())){
			String regex = "((?<provinceAndCity>[^市]+市|.*?自治州|.*?区|.*县)(?<town>[^区]+区|.*?市|.*?县|.*?路|.*?街|.*?道|.*?镇|.*?旗)(?<detailAddress>.*))";
			Matcher matcher = Pattern.compile(regex).matcher(entity.getArea());
			while(matcher.find()){
				try {
					entity.setRegion(matcher.group("town"));
				}catch (IllegalArgumentException e){
				}
				String regex2 = "((?<province>[^省]+省|.+自治区|上海市|北京市|天津市|重庆市|上海|北京|天津|重庆|香港特别行政区|澳门特别行政区)(?<city>.*))";
				String provinceAndCity = "";
				try {
					provinceAndCity = matcher.group("provinceAndCity");
				}catch (IllegalArgumentException e){
				}
				Matcher matcher2 = Pattern.compile(regex2).matcher(provinceAndCity);
				while (matcher2.find()){
					try {
						entity.setProvince(matcher.group("province"));
					}catch (IllegalArgumentException e){
					}
					try {
						String city = matcher2.group("city");
						if(StringUtils.isBlank(city)){
							entity.setCity(entity.getProvince());
						}else{
							entity.setCity(matcher.group("city"));
						}
					}catch (IllegalArgumentException e){
					}

				}
			}
		}

		super.saveOrUpdate(entity);

		//子表
		List<SupplierLinkerVO> supplierLinkerVos = supplierVo.getGridheaders();
		List<SupplierLinkerEntity> saveOrUpldates = new ArrayList<>();
		List<Long> deleteIds = new ArrayList<>();
		for(SupplierLinkerVO supplierLinkerVo:supplierLinkerVos) {
			if("add".equals(supplierLinkerVo.getRowState())) {
				SupplierLinkerEntity supplierLinkerEntity = BeanMapper.map(supplierLinkerVo, SupplierLinkerEntity.class);
				supplierLinkerEntity.setSupplierId(entity.getId());
				saveOrUpldates.add(supplierLinkerEntity);
			}else if("edit".equals(supplierLinkerVo.getRowState())) {
				SupplierLinkerEntity supplierLinkerEntity = BeanMapper.map(supplierLinkerVo, SupplierLinkerEntity.class);
				saveOrUpldates.add(supplierLinkerEntity);
			} else if("del".equals(supplierLinkerVo.getRowState())) {
				deleteIds.add(supplierLinkerVo.getId());
			}
		}
		if(saveOrUpldates.size() > 0) {
			supplierLinkerService.saveOrUpdateBatch(saveOrUpldates, saveOrUpldates.size(), false);
		}
		if(deleteIds.size() > 0) {
			supplierLinkerService.removeByIds(deleteIds, false);
		}
		return CommonResponse.success("保存成功",BeanMapper.map(entity,SupplierVO.class));
	}

	private void check(SupplierVO supplierVo) {
		QueryWrapper<SupplierEntity> queryWrapper = new QueryWrapper<>();
		if(supplierVo.getId()!=null){
			queryWrapper.ne("id", supplierVo.getId());
		}
		queryWrapper.eq("tenant_id", InvocationInfoProxy.getTenantid());
		queryWrapper.eq("dr", 0);
		queryWrapper.eq("social_credit_code", supplierVo.getSocialCreditCode());
		List<SupplierEntity> list = this.list(queryWrapper );
		if(list!=null&&list.size()>0){
			throw new BusinessException("统一社会信用代码已存在！！！");
		}
	}

	@Override
	public SupplierVO queryDetail(Long id) {
		SupplierEntity entity = supplierMapper.selectById(id);
		if(entity != null) {
			SupplierVO supplierVo = BeanMapper.map(entity, SupplierVO.class);

			QueryParam queryParam = new QueryParam();
			queryParam.getParams().put("supplierId", new Parameter(QueryParam.EQ, supplierVo.getId()));
			queryParam.getOrderMap().put("createTime", "desc");
			List<SupplierLinkerEntity> supplierLinkers = supplierLinkerService.queryList(queryParam, false);
			if(supplierLinkers != null && supplierLinkers.size() > 0) {
				List<SupplierLinkerVO> supplierLinkerVos = BeanMapper.mapList(supplierLinkers, SupplierLinkerVO.class);
				supplierVo.setGridheaders(supplierLinkerVos);
			}
			return supplierVo;
		}
		return null;
	}

	@Override
	public void deleteSupplier(List<Long> ids) {
		for(Long id:ids) {
			//先删除供方联系人
			supplierLinkerService.deleteBySupplierId(id);

			supplierMapper.deleteById(id);
		}
	}

	/**
	 * 处理供方合租不合作状态
	 *
	 * @param data
	 */
	@Override
	public void enableSupplierOrNot(Map<String, Object> data) {
		supplierMapper.enableSupplierOrNot(data);
	}


	@Override
	public IPage<SupplierVO> queryPageList(QueryParam queryParam) {
		Map<String, Parameter> paramMap = queryParam.getParams();
		Map<String, Object> condition = new HashMap<String, Object>();
		for(Map.Entry<String, Parameter> entry:paramMap.entrySet()) {
			if("categoryId".equals(entry.getKey())) {
				if(StringUtils.isNotBlank(entry.getValue().getValue().toString())){
					SupplierCategoryEntity categoryEntity = categoryService.queryDetail(Long.parseLong(entry.getValue().getValue().toString()));
					if(categoryEntity != null) {
						condition.put("innerCode", categoryEntity.getInnerCode());
					}
				}
			}else{
				condition.put(entry.getKey(), entry.getValue().getValue());
			}
		}
		condition.put("pageIndex", (queryParam.getPageIndex()-1)*queryParam.getPageSize());
		condition.put("pageSize", queryParam.getPageSize());
		condition.put("tenantId", InvocationInfoProxy.getTenantid());
		condition.put("searchText", queryParam.getSearchText());

		List<SupplierEntity> supplierEntities = supplierMapper.queryList(condition);
		Long count = supplierMapper.queryCount(condition);

		List<SupplierVO> supplierVos = new ArrayList<SupplierVO>();
		SupplierVO supplierVo = null;
		for(SupplierEntity entity:supplierEntities) {
			supplierVo = BeanMapper.map(entity, SupplierVO.class);

			DefdocDetailVO taxPayerTypeVo = defdocDetailService.queryDetail(supplierVo.getTaxPayerType());
			if(taxPayerTypeVo != null) {
				supplierVo.setTaxPayerTypeName(taxPayerTypeVo.getName());
			}
			supplierVos.add(supplierVo);
		}

		IPage<SupplierVO> resultPage = new Page<>();
		resultPage.setCurrent(queryParam.getPageIndex());
		resultPage.setRecords(supplierVos);
		resultPage.setTotal(count);
		return resultPage;
	}


	@Override
	public List<SupplierVO> queryExportList(QueryParam queryParam) {
		Map<String, Parameter> paramMap = queryParam.getParams();
		Map<String, Object> condition = new HashMap<String, Object>();
		for(Map.Entry<String, Parameter> entry:paramMap.entrySet()) {
			condition.put(entry.getKey(), entry.getValue().getValue());
		}
		List<SupplierEntity> supplierEntities = supplierMapper.queryExportList(condition);

		List<SupplierVO> supplierVos = new ArrayList<SupplierVO>();
		SupplierVO supplierVo = null;
		for(SupplierEntity entity:supplierEntities) {
			supplierVo = BeanMapper.map(entity, SupplierVO.class);

			DefdocDetailVO taxPayerTypeVo = defdocDetailService.queryDetail(supplierVo.getTaxPayerType());
			if(taxPayerTypeVo != null) {
				supplierVo.setTaxPayerTypeName(taxPayerTypeVo.getName());
			}

			QueryParam linkerQueryParam = new QueryParam();
			linkerQueryParam.getParams().put("supplierId", new Parameter(QueryParam.EQ, supplierVo.getId()));
			List<SupplierLinkerEntity> linkerEntities = supplierLinkerService.queryList(linkerQueryParam, false);
			if(linkerEntities != null && linkerEntities.size() > 0) {
				SupplierLinkerEntity linkerEntity = linkerEntities.get(0);
				supplierVo.setLinkman(linkerEntity.getLinkman());
				supplierVo.setCellphone(linkerEntity.getCellphone());
			}
			if(supplierVo.getEnabled()!=null){
				if(supplierVo.getEnabled() == 1){
					supplierVo.setCoState("合作");
				}else {
					supplierVo.setCoState("不合作");
				}
			}
			supplierVos.add(supplierVo);
		}

		return supplierVos;
	}


	@Override
	public SupplierVO queryDetailBySocialCode(String socialCode) {
		QueryWrapper<SupplierEntity> queryWrapper = new QueryWrapper<>();
		queryWrapper.eq("social_credit_code", socialCode);
		queryWrapper.eq("tenant_id", InvocationInfoProxy.getTenantid());
		List<SupplierEntity> entities = supplierMapper.selectList(queryWrapper);
		if(entities != null && entities.size() > 0) {
			return BeanMapper.map(entities.get(0), SupplierVO.class);
		}
		return null;
	}


	@Override
	public IPage<SupplierVO> queryRefMaterialPage(Map<String, Object> params) {
		List<SupplierEntity> supplierEntities = supplierMapper.queryList(params);
		Long count = supplierMapper.queryCount(params);

		List<SupplierVO> supplierVos = new ArrayList<SupplierVO>();
		SupplierVO supplierVo = null;
		for(SupplierEntity entity:supplierEntities) {
			supplierVo = BeanMapper.map(entity, SupplierVO.class);

			DefdocDetailVO taxPayerTypeVo = defdocDetailService.queryDetail(supplierVo.getTaxPayerType());
			if(taxPayerTypeVo != null) {
				supplierVo.setTaxPayerTypeName(taxPayerTypeVo.getName());
			}
			supplierVos.add(supplierVo);
		}

		IPage<SupplierVO> resultPage = new Page<>();
		resultPage.setRecords(supplierVos);
		resultPage.setTotal(count);
		return resultPage;
	}

	/**
	 * 查询供方参照
	 *
	 * @param params 参数
	 *
	 * @return {@link List}<{@link SupplierVO}>
	 */
	@Override
	public List<SupplierVO> querySupplierList(Map<String, Object> params) {
		List<SupplierEntity> supplierEntities = supplierMapper.queryList(params);
		List<SupplierVO> supplierVos = new ArrayList<>();
		SupplierVO supplierVo;
		for(SupplierEntity entity:supplierEntities) {
			supplierVo = BeanMapper.map(entity, SupplierVO.class);

			DefdocDetailVO taxPayerTypeVo = defdocDetailService.queryDetail(supplierVo.getTaxPayerType());
			if(taxPayerTypeVo != null) {
				supplierVo.setTaxPayerTypeName(taxPayerTypeVo.getName());
			}
			supplierVos.add(supplierVo);
		}
		return supplierVos;
	}

	/**
	 * 供方协同（生成企业信息、租户、超级管理员等信息）
	 *
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> supplierCollaboration(SupplierVO supplierVO) {
		EnterpriseVO enterpriseVO = new EnterpriseVO();
		enterpriseVO.setName(supplierVO.getName());
		enterpriseVO.setId(IdWorker.getId());
		enterpriseVO.setCode(String.valueOf(enterpriseVO.getId()+1));
		enterpriseVO.setTelephone(supplierVO.getTelephone());
		enterpriseVO.setSocialCreditCode(supplierVO.getSocialCreditCode());
		enterpriseVO.setExamineState("1");
		enterpriseVO.setAuditName(supplierVO.getLegal());
		enterpriseVO.setPassword(supplierCollaborationPassword);
		enterpriseVO.setRegisterPhoneNum(supplierVO.getTelephone());
		CommonResponse<EnterpriseVO> back = enterpriseApi.supplierCollaboration(enterpriseVO );
		if(back.isSuccess()){
			if(StringUtils.isNotBlank(sendMessageTemplateCode)){
				JSONObject messageParam = new JSONObject();
				messageParam.put("phone", supplierVO.getTelephone());
				if(StringUtils.isBlank(sendMessageTemplateCode)) {
					messageParam.put("templateCode", "SMS_195335074"); //登录验证模板
				}else{
					messageParam.put("templateCode", sendMessageTemplateCode);
				}
				Map<String, String> params = new HashMap<>();
				params.put("account", supplierVO.getTelephone());
				if(StringUtils.isBlank(supplierCollaborationPassword)){
					params.put("password", supplierCollaborationPassword);
				}else{
					params.put("password", "a123456");
				}
				
				messageParam.put("params", params);
				String messageUrl = environmentTools.getBaseHost() + "/ejc-message-web/no_auth/sms/sendMessage";
				try {
					String responseStr = HttpTookit.postByJson(messageUrl, JSON.toJSONString(messageParam));
					logger.info("向手机号[{}]发送消息结果：[{}]", supplierVO.getTelephone(), responseStr);

					@SuppressWarnings("unchecked")
					CommonResponse<String> response = JSON.parseObject(responseStr, CommonResponse.class);
					if(response.isSuccess()) {
						logger.info("短信发送成功");
					}
				} catch (ConnectTimeoutException e) {
					logger.info(e.toString());
					e.printStackTrace();
				} catch (SocketTimeoutException e) {
					logger.info(e.toString());
					e.printStackTrace();
				} catch (Exception e) {
					logger.info(e.toString());
					e.printStackTrace();
				}
			}
			logger.info("回写供方租户信息开始----------->");
			EnterpriseVO enterprise = back.getData();
			SupplierEntity entity = this.getById(supplierVO.getId());
			entity.setTelephone(supplierVO.getTelephone());
			entity.setTenant(enterprise.getTenantId());
			entity.setTenantName(supplierVO.getName());
			entity.setTenantPhone(supplierVO.getTelephone());
			entity.setTenantUserName(supplierVO.getLegal());
			this.saveOrUpdate(entity, false);
			logger.info("----------->回写供方租户信息结束");
			return CommonResponse.success("生成企业账号成功！");
		}else{
			return CommonResponse.error(back.getMsg());
		}
	}


	@Override
	public SupplierVO querySupplierByTenantId(Long tenant) {
		QueryWrapper<SupplierEntity> wrapper = new QueryWrapper<>();
		wrapper.eq("tenant", tenant);
		List<SupplierEntity> entities = supplierMapper.selectList(wrapper);
		if(entities != null&&entities.size()>0) {
			return BeanMapper.map(entities.get(0), SupplierVO.class);
		}
		return null;
	}

	/**
	 *  根据供应商名称或者纳税人识别号查询供应商
	 *  1>名称存在、纳税人识别号不存在：新增供应商档案
	 * 2>名称存在、纳税人识别号存在;
	 * 3>名称不存在、纳税人识别号不存在：新增供应商档案；
	 * 4>名称不存在、纳税人识别号存在;
	 * @param supplierName
	 * @param socialCreditCode
	 * @return
	 */
	@Override
	public JSONObject querySupplierByNameOrSocialCreditCode(String supplierName,String socialCreditCode){
		JSONObject jsonObject = new JSONObject();
		LambdaQueryWrapper<SupplierEntity> queryByNameOrCode = new LambdaQueryWrapper<>();
		queryByNameOrCode.eq(SupplierEntity::getTenantId, InvocationInfoProxy.getTenantid());
		queryByNameOrCode.and(wrapper-> wrapper.eq(SupplierEntity::getName,supplierName).or().eq(SupplierEntity::getSocialCreditCode,socialCreditCode));
		List<SupplierEntity> list = super.list(queryByNameOrCode);
		if (CollectionUtils.isNotEmpty(list)){
			for (SupplierEntity entity:list){
				String name = " ";
				if (entity.getName()!=null){
					name = entity.getName();
				}


				String code = " ";
				if (entity.getSocialCreditCode()!=null){
					code = entity.getSocialCreditCode();
				}
				if (name.equals(supplierName)&&code.equals(socialCreditCode)){
					jsonObject.put("11",BeanMapper.map(entity,SupplierVO.class));
					break;
				}else if (code.equals(socialCreditCode)){
					jsonObject.put("10",BeanMapper.map(entity,SupplierVO.class));
				}else if (name.equals(supplierName)){
					jsonObject.put("01",null);
				}
			}
		}else {
			jsonObject.put("00",null);
		}
		JSONObject returnJsonObject = new JSONObject();
		if (jsonObject.containsKey("11")){
			returnJsonObject.put("level",2);
			returnJsonObject.put("record",jsonObject.get("11"));
		}else if (jsonObject.containsKey("10")){
			returnJsonObject.put("level",4);
			returnJsonObject.put("record",jsonObject.get("10"));
		}else if (jsonObject.containsKey("01")){
			returnJsonObject.put("level",1);
		}else {
			returnJsonObject.put("level",3);
		}
		return returnJsonObject;
	}
}
