package com.ejianc.foundation.init.mapper;

import java.util.Map;

import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;

@Mapper
public interface InitMapper {
    /**
     * @Author mrsir_wxp
     * @Date 2020/7/7 创建租户级物料分类、物料明细、自定义档案三个表结构
     * @Description createThreeTables
     * @Param [tenantId]
     * @Return void
     */
    void createThreeTables(@Param("tenantId") Long tenantId);
    /**
     * @Author mrsir_wxp
     * @Date 2020/7/7 删除租户级物料分类、物料明细、自定义档案三个表结构，回滚
     * @Description dropThreeTables
     * @Param [tenantId]
     * @Return void
     */
    void dropThreeTables(@Param("tenantId") Long tenantId);
    
    /**
     * @Author liyongjia
     * @Date 2021/12/27 根据参数创建租户级物料分类、物料明细、自定义档案三个表结构
     * @Description createThreeTablesByParams
     * @Param [tenantId]
     * @Return void
     */
    void createThreeTablesByParams(Map<String, Object> params);
    /**
     * @Author liyongjia
     * @Date 2021/12/27 根据参数删除租户级物料分类、物料明细、自定义档案三个表结构，回滚
     * @Description dropThreeTablesByParams
     * @Param [tenantId]
     * @Return void
     */
    void dropThreeTablesByParams(Map<String, Object> params);
}
