package com.ejianc.foundation.supplier.service.impl;

import com.ejianc.foundation.supplier.bean.SupplierEntity;
import com.ejianc.foundation.supplier.bean.SupplierGradeEntity;
import com.ejianc.foundation.supplier.mapper.SupplierMapper;
import com.ejianc.foundation.supplier.service.ISupplierGradeService;
import com.ejianc.foundation.supplier.service.ISupplierService;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * 供应商库
 * 
 * @author generator
 * 
 */
@Service("supplierService")
public class SupplierServiceImpl extends BaseServiceImpl<SupplierMapper, SupplierEntity> implements ISupplierService{
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private ISupplierGradeService gradeService;
    /**
     * 根据供应商等级设置 更新供应商等级
     */
    @Override
    public String updateAllSupplierGrade(List<SupplierGradeEntity> gradeEntities) {

        if(ListUtil.isEmpty(gradeEntities)){
            QueryParam queryParam = new QueryParam();
            queryParam.getOrderMap().put("id",QueryParam.ASC);
            gradeEntities = gradeService.queryList(queryParam,false);
            if(ListUtil.isEmpty(gradeEntities)){
                logger.info("执行失败！没有找到任何供应商等级设置！");
                return "执行更新供应商等级失败！没有找到任何供应商等级设置！";
            }
        }
        Map<String, BigDecimal> gradeMap = gradeEntities.stream().collect(Collectors.toMap(SupplierGradeEntity::getName, SupplierGradeEntity::getReachScore));
        Map<String, BigDecimal> gradeTakeMap = gradeEntities.stream().collect(Collectors.toMap(SupplierGradeEntity::getName, SupplierGradeEntity::getLevelRate));
        if(!gradeMap.containsKey("A")){
            logger.info("执行失败！没有找到A级供应商等级设置！");
            return "执行更新供应商等级失败！没有找到A级供应商等级设置！";
        }
        if(!gradeMap.containsKey("B")){
            logger.info("执行失败！没有找到B级供应商等级设置！");
            return "执行更新供应商等级失败！没有找到B级供应商等级设置！";
        }
        if(!gradeMap.containsKey("C")){
            logger.info("执行失败！没有找到C级供应商等级设置！");
            return  "执行更新供应商等级失败！没有找到C级供应商等级设置！";
        }
        if(!gradeMap.containsKey("D")){
            logger.info("执行失败！没有找到D级供应商等级设置！");
            return "执行更新供应商等级失败！没有找到D级供应商等级设置！";
        }

        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("billState", Parameter.getInInstance(new String[]{"1","3"}));
        List<SupplierEntity> supplierTotal = this.queryList(queryParam,false);
        int total = supplierTotal.size();
        queryParam.getParams().put("yearScore", new Parameter(QueryParam.GE, gradeMap.get("A")));
        queryParam.getOrderMap().put("yearScore",QueryParam.ASC);
        List<SupplierEntity> supplierA = this.queryList(queryParam,false);
        int a = supplierA.size();
        for (int i = 0; i < a; i++) {
            SupplierEntity supplier = supplierA.get(i);
            supplier.setGradeName("A");
        }
        int mostNum = BigDecimal.valueOf(total).multiply(gradeTakeMap.get("A")).divide(BigDecimal.valueOf(100),0, RoundingMode.DOWN).intValue();
        if(a>mostNum){
            /** 超过比例 */
            int over = a - mostNum;
            for (int i = 0; i < over; i++) {
                SupplierEntity supplier = supplierA.get(i);
                logger.info("供应商总数：{}，根据A级供应商规则，其达标分数为：{}，其数量占比为：{} ，最多{}个，供应商【{}】等级被调整到为B",total, gradeMap.get("A"), gradeTakeMap.get("A"), mostNum, supplier.getName());
                supplier.setGradeName("B");
            }
        }
        if(a>0){
            saveOrUpdateBatch(supplierA);
        }

        queryParam.getParams().put("yearScore", new Parameter(QueryParam.SQL, " year_score >="+gradeMap.get("B")+" and year_score < "+gradeMap.get("A")+" or ( year_score >="+gradeMap.get("A")+" and grade_name = 'B'  )" ));
        List<SupplierEntity> supplierB = this.queryList(queryParam,false);
        int b = supplierB.size();
        for (int i = 0; i < b; i++) {
            SupplierEntity supplier = supplierB.get(i);
            supplier.setGradeName("B");
        }
        mostNum= BigDecimal.valueOf(total).multiply(gradeTakeMap.get("B")).divide(BigDecimal.valueOf(100),0, RoundingMode.DOWN).intValue();
        if(b>mostNum){
            /** 超过比例 */
            int over = b - mostNum;
            for (int i = 0; i < over; i++) {
                SupplierEntity supplier = supplierB.get(i);
                logger.info("供应商总数：{}，根据B级供应商规则，其达标分数为：{}，其数量占比为：{} ，最多{}个，供应商【{}】等级被调整到为C",total, gradeMap.get("B"), gradeTakeMap.get("B"), mostNum, supplier.getName());
                supplier.setGradeName("C");
            }
        }
        if(b>0){
            saveOrUpdateBatch(supplierB);
        }

        queryParam.getParams().put("yearScore", new Parameter(QueryParam.SQL, " year_score >="+gradeMap.get("C")+" and year_score < "+gradeMap.get("B")+" or ( year_score >="+gradeMap.get("B")+" and grade_name = 'C'  )" ));
        List<SupplierEntity> supplierC = this.queryList(queryParam,false);
        int c = supplierC.size();
        for (int i = 0; i < c; i++) {
            SupplierEntity supplier = supplierC.get(i);
            supplier.setGradeName("C");
        }
        mostNum= BigDecimal.valueOf(total).multiply(gradeTakeMap.get("C")).divide(BigDecimal.valueOf(100),0, RoundingMode.DOWN).intValue();
        if(c>mostNum){
            /** 超过比例 */
            int over = c - mostNum;
            for (int i = 0; i < over; i++) {
                SupplierEntity supplier = supplierC.get(i);
                logger.info("供应商总数：{}，根据C级供应商规则，其达标分数为：{}，其数量占比为：{} ，最多{}个，供应商【{}】等级被调整到为D",total, gradeMap.get("C"), gradeTakeMap.get("C"), mostNum, supplier.getName());
                supplier.setGradeName("D");
            }
        }
        if(c>0){
            saveOrUpdateBatch(supplierC);
        }

        queryParam.getParams().put("yearScore", new Parameter(QueryParam.LT,  gradeMap.get("C") ));
        List<SupplierEntity> supplierD = this.queryList(queryParam,false);
        int d = supplierD.size();
        for (int i = 0; i < d; i++) {
            SupplierEntity supplier = supplierD.get(i);
            supplier.setGradeName("D");
        }
        if(d>0){
            saveOrUpdateBatch(supplierD);
        }
        return null;
    }
}
