package com.ejianc.foundation.support.controller;

import java.io.Serializable;

import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.bean.BillParamCustomEntity;
import com.ejianc.foundation.support.service.IBillParamCustomService;
import com.ejianc.foundation.support.service.IDefdocDetailService;
import com.ejianc.foundation.support.vo.BillParamCustomVO;
import com.ejianc.foundation.support.vo.DefdocDetailVO;
import com.ejianc.foundation.support.vo.PublishVO;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.response.ComplexParam;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;

import com.ejianc.foundation.support.bean.BillParamEntity;
import com.ejianc.foundation.support.service.IBillParamService;
import com.ejianc.foundation.support.vo.BillParamVO;

/**
 * 业务单据控制参数
 * 
 * @author generator
 * 
 */
@Controller
@RequestMapping("billParam")
public class BillParamController implements Serializable {
	private static final long serialVersionUID = 1L;
	
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    
    @Autowired
    private IBillParamService service;

    @Value("${oms.tenantid}")
    private Long omsTenantId;

    @Autowired
    private IBillCodeApi billCodeApi;

    @Autowired
    private IBillParamCustomService billParamCustomService;

    @Autowired
    private IDefdocDetailService defdocDetailService;

    @Autowired
    private IOrgApi iOrgApi;
    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<BillParamVO> saveOrUpdate(@RequestBody BillParamVO billParamVO) {
        Long tenantId = InvocationInfoProxy.getTenantid();
        if(billParamVO.getId()==null && billParamVO.getCode() == null){

            if(omsTenantId.equals(tenantId)){
                String billCode = "";
                try {
                    CommonResponse<String> codeResp = billCodeApi.getCodeBatchByRuleCode("param-register-001", InvocationInfoProxy.getTenantid());
                    if(!codeResp.isSuccess()) {
                        throw new BusinessException("生成单据编码失败：" + codeResp.getMsg());
                    }
                    billCode = codeResp.getData();
                } catch (Exception e) {
                    return CommonResponse.error(e.getMessage());
                }
                billParamVO.setCode(billCode);
            }else {
                return CommonResponse.error("无权新增！");
            }
        }

        /** 判定组织是否已配置参数 */
        if(billParamVO.getOrgId()!=null){
            QueryParam param = new QueryParam();
            param.getParams().put("orgId",new Parameter(QueryParam.EQ,billParamVO.getOrgId()));
            param.getParams().put("code",new Parameter(QueryParam.EQ,billParamVO.getCode()));
            param.getParams().put("id",new Parameter(QueryParam.NE,billParamVO.getId()));
            List<BillParamEntity> billParamEntities = service.queryList(param);
            if(ListUtil.isNotEmpty(billParamEntities)){
                return CommonResponse.error("该组织已配置！");
            }
        }
        BillParamEntity entity = BeanMapper.map(billParamVO, BillParamEntity.class);
        if(billParamVO.getId()!=null){
            BillParamEntity db = service.getById(entity.getId());
            if(db.getTenantId().equals(999999L) && StringUtils.isEmpty(db.getOrgName())){
                if(billParamVO.getCustomVOS().isEmpty()){
                    /** 平台保存该控制单据 允许保存*/
                    entity.setTenantId(tenantId);
                    service.saveOrUpdate(entity, false);
                }else {
                    /** 租户保存该配置的子表，主表不修改，不允许保存 */
                }
            }else {
                /** 租户组织修改保存自己的配置 允许保存*/
                entity.setTenantId(tenantId);
                service.saveOrUpdate(entity, false);
            }
        }else {
            /** 没有生成的配置 允许保存*/
            entity.setTenantId(tenantId);
            service.saveOrUpdate(entity, false);
        }


        BillParamVO vo = BeanMapper.map(entity, BillParamVO.class);
        if(!billParamVO.getCustomVOS().isEmpty()){
            QueryParam param = new QueryParam();
            param.getParams().put("tenantId",new Parameter(QueryParam.EQ,tenantId));
            param.getParams().put("pid",new Parameter(QueryParam.EQ,billParamVO.getId()));
            List<BillParamCustomEntity> customEntities = billParamCustomService.queryList(param,false);
            /** 先将旧数据删除*/
            if(ListUtil.isNotEmpty(customEntities)){
                billParamCustomService.removeByIds(customEntities.stream().map(BillParamCustomEntity::getId).collect(Collectors.toList()));
            }
            customEntities = BeanMapper.mapList(billParamVO.getCustomVOS(),BillParamCustomEntity.class);
            for (BillParamCustomEntity customEntity : customEntities) {
                customEntity.setTenantId(tenantId);
                customEntity.setPid(entity.getId());
            }
            billParamCustomService.saveOrUpdateBatch(customEntities);
        }
    	return CommonResponse.success("保存或修改单据成功！",vo);
    }
    
    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<BillParamVO> queryDetail(Long id) {
    	BillParamEntity entity = service.selectById(id);
    	BillParamVO vo = BeanMapper.map(entity, BillParamVO.class);
        QueryParam param = new QueryParam();
        param.getParams().put("tenantId",new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));
        param.getParams().put("pid",new Parameter(QueryParam.EQ,id));
        List<BillParamCustomEntity> customEntities = billParamCustomService.queryList(param,false);
        if(ListUtil.isNotEmpty(customEntities)){
            vo.setCustomVOS(BeanMapper.mapList(customEntities, BillParamCustomVO.class));
        }
        DefdocDetailVO defdocDetailVo = defdocDetailService.queryDetail(Long.parseLong(entity.getModuleId()));
        if(defdocDetailVo == null){
            return CommonResponse.error("没有查到参数分类！");
        }
        vo.setModuleName(defdocDetailVo.getName());
        return CommonResponse.success("查询详情数据成功！",vo);
    }
    
    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<BillParamVO> vos) {
        if(vos.size()>1){
            return CommonResponse.error("只能单个删除！");
        }
        BillParamEntity billParamEntity = service.selectById(vos.get(0).getId());
        if(!billParamEntity.getTenantId().equals(InvocationInfoProxy.getTenantid())){
            return CommonResponse.error("无权删除！");
        }
        service.removeByIds(vos.stream().map(BillParamVO::getId).collect(Collectors.toList()),false);
        QueryParam param = new QueryParam();
        param.getParams().put("pid",new Parameter(QueryParam.IN,vos.stream().map(BillParamVO::getId).collect(Collectors.toList())));
        param.getParams().put("tenantId",new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));
        List<BillParamCustomEntity> customEntities = billParamCustomService.queryList(param,false);
        if(ListUtil.isNotEmpty(customEntities)){
            billParamCustomService.removeByIds(customEntities.stream().map(BillParamCustomEntity::getId).collect(Collectors.toList()),true);
        }
        return CommonResponse.success("删除成功！");
    }
    
    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<BillParamVO>> queryList(@RequestBody QueryParam param) {
        if(!InvocationInfoProxy.getTenantid().equals(omsTenantId)){
            return CommonResponse.error("无权查询！");
        }
        param.getParams().put("tenantId",new Parameter(QueryParam.EQ,omsTenantId));
        param.getParams().put("orgId", new Parameter(QueryParam.EQ, null));
        param.getOrderMap().put("code",QueryParam.ASC);
        IPage<BillParamEntity> page = service.queryPage(param,false);
        IPage<BillParamVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        List<BillParamVO> records = BeanMapper.mapList(page.getRecords(), BillParamVO.class);
        pageData.setRecords(records);
        return CommonResponse.success("查询列表数据成功！",pageData);
    }

    /**
     * @Description queryList 租户查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryListCus", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<BillParamVO>> queryListCus(@RequestBody QueryParam param) {

        param.getOrderMap().put("code",QueryParam.ASC);
        if(param.getParams().get("groupOnly")!=null){
            /** 只查看集团 */
            param.getParams().remove("groupOnly");
            CommonResponse<OrgVO> root = getRootOrg();

            ComplexParam complexParam = new ComplexParam();
            complexParam.setLogic(ComplexParam.AND);
            complexParam.getParams().put("orgId", new Parameter(QueryParam.EQ, root.getData().getId()));
            ComplexParam c1 = new ComplexParam();
            c1.setLogic(ComplexParam.OR);
            c1.getParams().put("orgId", new Parameter(QueryParam.EQ, null));
            c1.getParams().put("tenantId", new Parameter(QueryParam.EQ, omsTenantId));
            complexParam.getComplexParams().add(c1);
            param.getComplexParams().add(complexParam);
        }else {
            ComplexParam complexParam = new ComplexParam();
            complexParam.setLogic(ComplexParam.AND);
            ComplexParam c1 = new ComplexParam();
            c1.setLogic(ComplexParam.OR);
            c1.getParams().put("orgId", new Parameter(QueryParam.EQ, null));
            c1.getParams().put("tenantId", new Parameter(QueryParam.EQ, omsTenantId));
            /** 查询本上 */
            List<Long> orgIds = new ArrayList<>();
            CommonResponse<List<OrgVO>> response = iOrgApi.findParentsByOrgId(InvocationInfoProxy.getOrgId());
            if(!response.isSuccess() || ListUtil.isEmpty(response.getData())){
                return CommonResponse.error("查询本上组织出错");
            }
            orgIds.addAll(response.getData().stream().map(OrgVO::getId).collect(Collectors.toList()));

            response = iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId());
            if(!response.isSuccess() || ListUtil.isEmpty(response.getData())){
                return CommonResponse.error("查询本下组织出错");
            }
            orgIds.addAll(response.getData().stream().map(OrgVO::getId).collect(Collectors.toList()));

            ComplexParam c2 = new ComplexParam();
            c2.setLogic(ComplexParam.OR);
            c2.getParams().put("orgId", new Parameter(QueryParam.IN, orgIds));

            complexParam.getComplexParams().add(c1);
            complexParam.getComplexParams().add(c2);

            param.getComplexParams().add(complexParam);
        }

        IPage<BillParamEntity> page = service.queryPage(param,false);
        IPage<BillParamVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        List<BillParamVO> records = BeanMapper.mapList(page.getRecords(), BillParamVO.class);
        if(ListUtil.isNotEmpty(records)){
            for (BillParamVO vo : records) {
                QueryParam p = new QueryParam();
                p.getParams().put("tenantId",new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));
                p.getParams().put("pid",new Parameter(QueryParam.EQ,vo.getId()));
                List<BillParamCustomEntity> customEntities = billParamCustomService.queryList(p,false);
                if(ListUtil.isNotEmpty(customEntities)){
                    vo.setCustomVOS(BeanMapper.mapList(customEntities, BillParamCustomVO.class));
                }
            }
        }
        pageData.setRecords(records);
        return CommonResponse.success("查询列表数据成功！",pageData);
    }

    /**
     * @Author mrsir_wxp
     * @Date 2021/1/15 查询当前租户根节点
     */
    @RequestMapping(value = "/getRootOrg", method = RequestMethod.GET)
    @ResponseBody
    private CommonResponse<OrgVO> getRootOrg(){
        return iOrgApi.findOrgByTenantId(InvocationInfoProxy.getTenantid());
    }

    /**
     * @Author mrsir_wxp
     * @Date 2021/1/15 发布参数
     * @Description publishParamConfig
     * @Param [publishVO]
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.Boolean>
     */
    @RequestMapping(value = "/publishParamConfig", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> publishParamConfig(@RequestBody PublishVO publishVO){
        return service.publishParamConfig(publishVO);
    }
}
