package com.ejianc.foundation.support.service.impl;

import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.foundation.support.bean.ModuleEntity;
import com.ejianc.foundation.support.mapper.ModuleMapper;
import com.ejianc.foundation.support.service.IModuleService;
import com.ejianc.foundation.support.vo.ModuleVO;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

/**
 * 模块管理服务
 */
@Service("moduleService")
public class ModuleServiceImpl extends BaseServiceImpl<ModuleMapper, ModuleEntity> implements IModuleService {

	@Autowired
	private ModuleMapper moduleMapper;

	@Override
	public ModuleEntity queryDetail(Long id) {
		ModuleEntity entity = moduleMapper.selectById(id);
		return entity;
	}

	@Override
	public List<ModuleEntity> queryListByPid(Long id) {
		QueryWrapper<ModuleEntity> wrapper = new QueryWrapper<>();
		wrapper.eq("parent_id", id);
		
		List<ModuleEntity> entities = moduleMapper.selectList(wrapper);
		return entities;
	}

	@Override
	public void delete(Long id) {
		moduleMapper.deleteById(id);
	}

	@Override
	public List<ModuleVO> queryAllChildrenByPid(Long moduleId) {
		ModuleEntity entity = moduleMapper.selectById(moduleId);
		
		QueryWrapper<ModuleEntity> wrapper = new QueryWrapper<>();
		wrapper.likeRight("inner_code", entity.getInnerCode());
		List<ModuleEntity> moduleList = moduleMapper.selectList(wrapper);
		return BeanMapper.mapList(moduleList, ModuleVO.class);
	}

	@Override
	public List<ModuleVO> queryAllTopModuleList() {
		List<ModuleVO> moduleVos = moduleMapper.queryAllTopModuleList();
		return moduleVos;
	}

}
