package com.ejianc.foundation.quota.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.foundation.quota.bean.QuotaEntity;
import com.ejianc.foundation.quota.service.IQuotaService;
import com.ejianc.foundation.quota.vo.QuotaTypeVO;
import com.ejianc.foundation.quota.vo.QuotaVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.support.idworker.util.IdWorker;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletResponse;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.*;
import java.util.stream.Collectors;

/**
 * 正元定额档案
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("quota")
public class QuotaController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillCodeApi billCodeApi;

    private static final String BILL_CODE = "ZY_QUOTA_CODE";//此处需要根据实际修改

    @Autowired
    private IQuotaService service;

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<QuotaVO> saveOrUpdate(@RequestBody QuotaVO saveOrUpdateVO) {
    	QuotaEntity entity = BeanMapper.map(saveOrUpdateVO, QuotaEntity.class);
        boolean isNew = false;
    	if(entity.getId() == null || entity.getId() == 0){
            isNew = true;
            BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE,InvocationInfoProxy.getTenantid(),saveOrUpdateVO);
            CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
            if(billCode.isSuccess()) {
                entity.setCode(billCode.getData());//此处需要根据实际修改 删除本行或者下一行
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
            Long id = IdWorker.getId();
            entity.setId(id);
            if(entity.getParentId()==null){
                entity.setInnerCode(id.toString());
            }else {
                QuotaEntity p = service.selectById(entity.getParentId());
                entity.setInnerCode(p.getInnerCode()+"|"+id);
            }
            if(entity.getPrice()==null){
                entity.setPrice(BigDecimal.ZERO);
            }
        }
    	service.saveOrUpdate(entity, false);
        processPrice(entity,isNew);
    	QuotaVO vo = BeanMapper.map(entity, QuotaVO.class);
    	return CommonResponse.success("保存或修改单据成功！",vo);
    }

    /**
     * 处理价格
     * */
    private void processPrice(QuotaEntity entity,boolean isNew) {
        boolean needUpdate = false;
       if(isNew){
           /** 新增的单据，一定是子节点，只需考虑其父节点即可 */
           if(entity.getParentId()!=null){
               /** 上级为空，说明其是根节点，不用处理，只需要处理父节点不为空的数据 */
               needUpdate = true;
           }
       }else {
           /** 修改的单据 看看其是否有下级节点，如果有下级节点，说明其为中间节点，则不更新价格，没有下级节点，说明其是末子节点，则需要更新其上级的价格 */
           QueryParam param = QueryParam.getInstance();
           param.getParams().put("parentId",new Parameter(QueryParam.EQ,entity.getId()));
           List<QuotaEntity> list = service.queryList(param,false);
           if(ListUtil.isEmpty(list)){
               if(entity.getParentId()!=null){
                   /** 上级为空，说明其是根节点，不用处理，只需要处理父节点不为空的数据 */
                   needUpdate = true;
               }
           }
       }
       if(needUpdate){
           String[] split = entity.getInnerCode().split("\\|");
           /** 从父级结点开始，逐级向上汇总价格数据 */
           QueryParam param = QueryParam.getInstance();
           for (int i = split.length-2; i > -1; i--) {
               QuotaEntity quotaEntity = service.selectById(Long.valueOf(split[i]));
               param.getParams().put("parentId",new Parameter(QueryParam.EQ,quotaEntity.getId()));
               List<QuotaEntity> list = service.queryList(param,false);
               BigDecimal price = list.stream().map(QuotaEntity::getPrice).filter(Objects::nonNull).reduce(BigDecimal.ZERO, BigDecimal::add);
               quotaEntity.setPrice(price);
               service.saveOrUpdate(quotaEntity,false);
           }
       }
    }

    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<QuotaVO> queryDetail(Long id) {
    	QuotaEntity entity = service.selectById(id);
    	QuotaVO vo = BeanMapper.map(entity, QuotaVO.class);
        return CommonResponse.success("查询详情数据成功！",vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<QuotaVO> vos) {
        if(ListUtil.isNotEmpty(vos)){
            for (QuotaVO vo : vos) {
                // 参数是单据类型编码字符串 根据需求是否打开下面代码
                /* CommonResponse<String> resp = billTypeApi.checkQuote("billTypeCode", vo.getId());
                if(!resp.isSuccess()){
                    return CommonResponse.error("删除失败！"+resp.getMsg());
                }*/
            }
        }
        service.removeByIds(vos.stream().map(QuotaVO::getId).collect(Collectors.toList()),true);
        return CommonResponse.success("删除成功！");
    }

    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<QuotaVO>> queryList(@RequestBody QueryParam param) {

        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("name");
        fuzzyFields.add("code");
        fuzzyFields.add("memo");
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        param.getParams().put("parentId", new Parameter(QueryParam.EQ, null));

        IPage<QuotaEntity> page = service.queryPage(param,false);
        IPage<QuotaVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        List<QuotaVO> list = BeanMapper.mapList(page.getRecords(), QuotaVO.class);
        setChildren(list);
  		pageData.setRecords(list);
        return CommonResponse.success("查询列表数据成功！",pageData);
    }

    private void setChildren(List<QuotaVO> list){
        if(ListUtil.isNotEmpty(list)){
            for (QuotaVO quotaVO : list) {
                QueryParam param = QueryParam.getInstance();
                param.getParams().put("parentId",new Parameter(QueryParam.EQ,quotaVO.getId()));
                List<QuotaEntity> entities = service.queryList(param,false);
                if(ListUtil.isNotEmpty(entities)){
                    quotaVO.setChildren(BeanMapper.mapList(entities, QuotaVO.class));
                    setChildren(quotaVO.getChildren());
                }
            }
        }
    }

    /**
     * @Description 导出
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id",new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        List<QuotaEntity> list = service.queryList(param);
        //todo:字段翻译等等
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", list);
        ExcelExport.getInstance().export("Quota-export.xlsx", beans, response);
    }

    /**
     * @Description 参照
     * @Return void
     */
    @RequestMapping(value = "/refQuotaData", method = RequestMethod.GET)
    @ResponseBody
    public List<QuotaVO> refQuotaData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                       @RequestParam(value = "condition", required = false) String condition,
                                                       @RequestParam("relyCondition") String relyCondition,
                                                       @RequestParam(value = "searchObject", required = false) String searchObject,
                                                       @RequestParam(value = "searchText", required = false) String searchText) {
        List<QuotaVO> vos = new ArrayList<>();
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("name");
        fuzzyFields.add("code");
        fuzzyFields.add("memo");
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if(StringUtils.isEmpty(relyCondition)){
           return vos;
        }
        param.getParams().put("pid", new Parameter(QueryParam.EQ, relyCondition.split("=")[1]));
        if(StringUtils.isEmpty(searchText)){
            param.getParams().put("parentId", new Parameter(QueryParam.EQ, null));
        }
        if(StringUtils.isNotEmpty(condition)){
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
        }

        List<QuotaEntity> list = service.queryList(param,false);
        vos = BeanMapper.mapList(list, QuotaVO.class);
        for (QuotaVO vo : vos) {
            String name = vo.getName() + "(编号：" + (StringUtils.isNotBlank(vo.getCode())?vo.getCode():"") +
                    ",单位："+ (StringUtils.isNotBlank(vo.getUnit())?vo.getUnit():"") + ",单价成本："+
                    (vo.getPrice()!=null?vo.getPrice():"") + ")";
            vo.setName(name);
        }
        setChildren(vos);
        return vos;
     }

}
