package com.ejianc.foundation.dataModel.controller;

import java.io.Serializable;

import com.ejianc.foundation.dataModel.bean.DataModelColConditionEntity;
import com.ejianc.foundation.dataModel.bean.DataModelTenantColumnEntity;
import com.ejianc.foundation.dataModel.service.IDataModelColConditionService;
import com.ejianc.foundation.dataModel.service.IDataModelTenantColumnService;
import com.ejianc.foundation.dataModel.vo.DataModelColConditionVO;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.util.ExcelExport;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.*;
import java.util.stream.Collectors;
import com.alibaba.fastjson.JSONObject;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;
import org.apache.commons.collections.CollectionUtils;
import javax.servlet.http.HttpServletResponse;

import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.kit.collection.ListUtil;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;

import com.ejianc.foundation.dataModel.bean.DataModelColumnEntity;
import com.ejianc.foundation.dataModel.service.IDataModelColumnService;
import com.ejianc.foundation.dataModel.vo.DataModelColumnVO;

/**
 * 数据模型显示字段
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("dataModelColumn")
public class DataModelColumnController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;

    private static final String BILL_CODE = "Invoice_Open_Apply_Code";//此处需要根据实际修改

    @Autowired
    private IDataModelColumnService service;

    @Autowired
    private IDataModelTenantColumnService iDataModelTenantColumnService;

    @Autowired
    private IDataModelColConditionService dataModelColConditionService;


    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<DataModelColumnVO> saveOrUpdate(@RequestBody DataModelColumnVO saveOrUpdateVO) {
    	DataModelColumnEntity entity = BeanMapper.map(saveOrUpdateVO, DataModelColumnEntity.class);
    	service.saveOrUpdate(entity, false);
    	DataModelColumnVO vo = BeanMapper.map(entity, DataModelColumnVO.class);
    	return CommonResponse.success("保存或修改单据成功！",vo);
    }

    /**
     * @Description saveOrUpdate 修改客户自己的字段
     */
    @RequestMapping(value = "/saveOrUpdateCustom", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<DataModelColumnVO> saveOrUpdateCustom(@RequestBody DataModelColumnVO saveOrUpdateVO) {
        DataModelTenantColumnEntity columnEntity = iDataModelTenantColumnService.queryCusColumnByColumnId(saveOrUpdateVO.getId());
        if(columnEntity==null){
            columnEntity = new DataModelTenantColumnEntity();
        }
        columnEntity.setColumnId(saveOrUpdateVO.getId());
        columnEntity.setColumnName(saveOrUpdateVO.getColumnName());
        columnEntity.setSequence(saveOrUpdateVO.getSequence());
        columnEntity.setVisible(saveOrUpdateVO.getVisible());
        columnEntity.setTenantId(InvocationInfoProxy.getTenantid());

        columnEntity.setAfterStr(saveOrUpdateVO.getAfterStr());
        columnEntity.setAlign(saveOrUpdateVO.getAlign());
        columnEntity.setThousands(saveOrUpdateVO.getThousands());
        columnEntity.setScale(saveOrUpdateVO.getScale());
        columnEntity.setTotalData(saveOrUpdateVO.getTotalData());
        columnEntity.setMemo(saveOrUpdateVO.getMemo());

        iDataModelTenantColumnService.saveOrUpdate(columnEntity,false);

        /** 删除所有本租户设置 */
        QueryParam param = new QueryParam();
        param.getParams().put("colId",new Parameter(QueryParam.EQ,saveOrUpdateVO.getId()));
        param.getParams().put("tenantId",new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));
        List<DataModelColConditionEntity> conditionEntities = dataModelColConditionService.queryList(param,false);
        if(ListUtil.isNotEmpty(conditionEntities)){
            dataModelColConditionService.deleteByIds(conditionEntities.stream().map(DataModelColConditionEntity::getId).collect(Collectors.toList()));
        }
        List<DataModelColConditionVO> colConditionVOS = saveOrUpdateVO.getConditionEntities();
        if(ListUtil.isNotEmpty(colConditionVOS)){
            List<DataModelColConditionVO> saveVOS = new ArrayList<>();
            for (DataModelColConditionVO vo : colConditionVOS) {
                if(!"del".equals(vo.getRowState())){
                    vo.setId(null);
                    vo.setTenantId(InvocationInfoProxy.getTenantid());
                    vo.setColId(saveOrUpdateVO.getId());
                    saveVOS.add(vo);
                }
            }
            if(ListUtil.isNotEmpty(saveVOS)){
                dataModelColConditionService.saveOrUpdateBatch(BeanMapper.mapList(saveVOS,DataModelColConditionEntity.class));
            }
        }

        return CommonResponse.success("保存或修改单据成功！",saveOrUpdateVO);
    }

    /**
     * 查询可计算的列
     *
     * @param
     * @return
     */
    @RequestMapping(value = "/queryFormulaList", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<List<DataModelColumnVO>> queryFormulaList(@RequestParam Long modelId) {
        QueryParam param = new QueryParam();
        param.getParams().put("modelId",new Parameter(QueryParam.EQ,modelId));
        param.getParams().put("type",new Parameter(QueryParam.EQ,"number"));
        param.getParams().put("formula",new Parameter(QueryParam.EQ,null));
        List<DataModelColumnEntity> columnList = service.queryList(param);
        if(columnList!=null){
            List<DataModelColumnVO> res = BeanMapper.mapList(columnList,DataModelColumnVO.class);
            return CommonResponse.success(res);
        }
        return CommonResponse.success();
    }


    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<DataModelColumnVO> queryDetail(Long id) {
    	DataModelColumnEntity entity = service.selectById(id);
    	DataModelColumnVO vo = BeanMapper.map(entity, DataModelColumnVO.class);
        QueryParam param = new QueryParam();
        param.getParams().put("colId",new Parameter(QueryParam.EQ,id));
        param.getParams().put("tenantId",new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));
        param.getOrderMap().put("sequence",QueryParam.ASC);
        List<DataModelColConditionEntity> conditionEntities = dataModelColConditionService.queryList(param,false);
        if(ListUtil.isNotEmpty(conditionEntities)){
            vo.setConditionEntities(BeanMapper.mapList(conditionEntities,DataModelColConditionVO.class));
        }else {
            vo.setConditionEntities(new ArrayList<>());
        }
        return CommonResponse.success("查询详情数据成功！",vo);
    }


    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryCusDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<DataModelColumnVO> queryCusDetail(Long id) {
    	DataModelColumnEntity entity = service.selectById(id);
    	DataModelColumnVO vo = BeanMapper.map(entity, DataModelColumnVO.class);
        QueryParam param = new QueryParam();
        DataModelTenantColumnEntity columnEntity = iDataModelTenantColumnService.queryCusColumnByColumnId(entity.getId());
        if(columnEntity!=null){
            vo.setColumnName(columnEntity.getColumnName());
            vo.setSequence(columnEntity.getSequence());
            vo.setVisible(columnEntity.getVisible());
            vo.setAfterStr(columnEntity.getAfterStr());
            vo.setAlign(columnEntity.getAlign());
            vo.setThousands(columnEntity.getThousands());
            vo.setScale(columnEntity.getScale());
            vo.setTotalData(columnEntity.getTotalData());
            vo.setMemo(columnEntity.getMemo());
        }
        param.getParams().put("colId",new Parameter(QueryParam.EQ,id));
        param.getParams().put("tenantId",new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));
        param.getOrderMap().put("sequence",QueryParam.ASC);
        List<DataModelColConditionEntity> conditionEntities = dataModelColConditionService.queryList(param,false);
        if(ListUtil.isNotEmpty(conditionEntities)){
            vo.setConditionEntities(BeanMapper.mapList(conditionEntities,DataModelColConditionVO.class));
        }else {
            vo.setConditionEntities(new ArrayList<>());
        }
        return CommonResponse.success("查询详情数据成功！",vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<Long> vos) {
        service.removeByIds(vos,false);
        return CommonResponse.success("删除成功！");
    }

    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<DataModelColumnVO>> queryList(@RequestBody QueryParam param) {

        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        param.setPageSize(-1);
        param.getOrderMap().put("sequence",QueryParam.ASC);
        IPage<DataModelColumnEntity> page = service.queryPage(param,false);
        IPage<DataModelColumnVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
  		pageData.setRecords(BeanMapper.mapList(page.getRecords(), DataModelColumnVO.class));

        return CommonResponse.success("查询列表数据成功！",pageData);
    }

    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryCusList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<DataModelColumnVO>> queryCusList(@RequestBody QueryParam param) {

        param.getOrderMap().put("sequence",QueryParam.ASC);
        param.setPageSize(-1);
        IPage<DataModelColumnEntity> page = service.queryPage(param,false);
        IPage<DataModelColumnVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        if(ListUtil.isNotEmpty(page.getRecords())){
            for (DataModelColumnEntity record : page.getRecords()) {
                DataModelTenantColumnEntity columnEntity = iDataModelTenantColumnService.queryCusColumnByColumnId(record.getId());
                if(columnEntity!=null){
                    record.setColumnName(columnEntity.getColumnName());
                    record.setSequence(columnEntity.getSequence());
                    record.setVisible(columnEntity.getVisible());

                    record.setAfterStr(columnEntity.getAfterStr());
                    record.setAlign(columnEntity.getAlign());
                    record.setThousands(columnEntity.getThousands());
                    record.setScale(columnEntity.getScale());
                    record.setTotalData(columnEntity.getTotalData());
                }
            }
        }
  		pageData.setRecords(BeanMapper.mapList(page.getRecords(), DataModelColumnVO.class));

        return CommonResponse.success("查询列表数据成功！",pageData);
    }

    /**
     * 获取RPC数据
     * resp 返回值
     * isMustSuc 是否必须成功
     * errMsg 失败提示
     */
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if(isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }


    /**
     * @Description 导出
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id",new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        List<DataModelColumnEntity> list = service.queryList(param);
        //todo:字段翻译等等
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", list);
        ExcelExport.getInstance().export("DataModelColumn-export.xlsx", beans, response);
    }

    /**
     * @Description 参照
     * @Return void
     */
    @RequestMapping(value = "/refDataModelColumnData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<DataModelColumnVO>> refDataModelColumnData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                        String condition,
                                                                        String searchObject,
                                                                        String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        if(StringUtils.isNotEmpty(condition)){
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
        }

        IPage<DataModelColumnEntity> page = service.queryPage(param,false);
        IPage<DataModelColumnVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), DataModelColumnVO.class));

        return CommonResponse.success("查询参照数据成功！",pageData);
     }
}
