/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.foundation.support.controller;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.refer.util.ReferHttpClientUtils;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.security.GeneralSecurityException;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"weather"})
public class WeatherController {
    private final String qqWeatherUrl = "https://wis.qq.com/weather/common?source=pc&weather_type=forecast_24h&province=";
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @RequestMapping(value={"/queryWeatherByProvinceAndCity"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<JSONObject> queryWeatherByProvinceAndCity(@RequestParam(value="province") String province, @RequestParam(value="city") String city, HttpServletRequest request) throws UnsupportedEncodingException {
        JSONObject res = new JSONObject();
        String url = "https://wis.qq.com/weather/common?source=pc&weather_type=forecast_24h&province=" + URLEncoder.encode(province, "UTF-8");
        url = StringUtils.isEmpty((CharSequence)city) ? url + "&city=" + URLEncoder.encode(province, "UTF-8") : url + "&city=" + URLEncoder.encode(city, "UTF-8");
        String weather = null;
        this.logger.info("\u8bf7\u6c42\u5929\u6c14\u53c2\u6570\uff1a{}", (Object)url);
        try {
            weather = ReferHttpClientUtils.get((String)url, (HttpServletRequest)request);
        }
        catch (GeneralSecurityException e) {
            this.logger.error("\u83b7\u53d6\u5929\u6c14\u5f02\u5e38\uff1aprovince-{}, city-{}", new Object[]{province, city, e});
        }
        catch (IOException e) {
            this.logger.error("\u83b7\u53d6\u5929\u6c14\u5f02\u5e38\uff1aprovince-{}, city-{}", new Object[]{province, city, e});
        }
        this.logger.info("{}{}{}", new Object[]{province, city, weather});
        if (StringUtils.isNotEmpty((CharSequence)weather)) {
            res.put("weather", (Object)JSONObject.parseObject((String)weather));
        } else {
            res.put("weather", null);
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)res);
    }
}

