/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.foundation.supplier.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.foundation.supplier.bean.SupplierEntity;
import com.ejianc.foundation.supplier.bean.SupplierGradeEntity;
import com.ejianc.foundation.supplier.mapper.SupplierMapper;
import com.ejianc.foundation.supplier.service.ISupplierGradeService;
import com.ejianc.foundation.supplier.service.ISupplierService;
import com.ejianc.foundation.supplier.vo.SupplierVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="supplierService")
public class SupplierServiceImpl
extends BaseServiceImpl<SupplierMapper, SupplierEntity>
implements ISupplierService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private ISupplierGradeService gradeService;
    @Autowired
    private SupplierMapper supplierMapper;

    @Override
    public String updateAllSupplierGrade(List<SupplierGradeEntity> gradeEntities) {
        if (ListUtil.isEmpty(gradeEntities)) {
            QueryParam queryParam = new QueryParam();
            queryParam.getOrderMap().put("id", "asc");
            gradeEntities = this.gradeService.queryList(queryParam, false);
            if (ListUtil.isEmpty((List)gradeEntities)) {
                this.logger.info("\u6267\u884c\u5931\u8d25\uff01\u6ca1\u6709\u627e\u5230\u4efb\u4f55\u4f9b\u5e94\u5546\u7b49\u7ea7\u8bbe\u7f6e\uff01");
                return "\u6267\u884c\u66f4\u65b0\u4f9b\u5e94\u5546\u7b49\u7ea7\u5931\u8d25\uff01\u6ca1\u6709\u627e\u5230\u4efb\u4f55\u4f9b\u5e94\u5546\u7b49\u7ea7\u8bbe\u7f6e\uff01";
            }
        }
        Map<String, BigDecimal> gradeMap = gradeEntities.stream().collect(Collectors.toMap(SupplierGradeEntity::getName, SupplierGradeEntity::getReachScore));
        Map<String, BigDecimal> gradeTakeMap = gradeEntities.stream().collect(Collectors.toMap(SupplierGradeEntity::getName, SupplierGradeEntity::getLevelRate));
        if (!gradeMap.containsKey("A")) {
            this.logger.info("\u6267\u884c\u5931\u8d25\uff01\u6ca1\u6709\u627e\u5230A\u7ea7\u4f9b\u5e94\u5546\u7b49\u7ea7\u8bbe\u7f6e\uff01");
            return "\u6267\u884c\u66f4\u65b0\u4f9b\u5e94\u5546\u7b49\u7ea7\u5931\u8d25\uff01\u6ca1\u6709\u627e\u5230A\u7ea7\u4f9b\u5e94\u5546\u7b49\u7ea7\u8bbe\u7f6e\uff01";
        }
        if (!gradeMap.containsKey("B")) {
            this.logger.info("\u6267\u884c\u5931\u8d25\uff01\u6ca1\u6709\u627e\u5230B\u7ea7\u4f9b\u5e94\u5546\u7b49\u7ea7\u8bbe\u7f6e\uff01");
            return "\u6267\u884c\u66f4\u65b0\u4f9b\u5e94\u5546\u7b49\u7ea7\u5931\u8d25\uff01\u6ca1\u6709\u627e\u5230B\u7ea7\u4f9b\u5e94\u5546\u7b49\u7ea7\u8bbe\u7f6e\uff01";
        }
        if (!gradeMap.containsKey("C")) {
            this.logger.info("\u6267\u884c\u5931\u8d25\uff01\u6ca1\u6709\u627e\u5230C\u7ea7\u4f9b\u5e94\u5546\u7b49\u7ea7\u8bbe\u7f6e\uff01");
            return "\u6267\u884c\u66f4\u65b0\u4f9b\u5e94\u5546\u7b49\u7ea7\u5931\u8d25\uff01\u6ca1\u6709\u627e\u5230C\u7ea7\u4f9b\u5e94\u5546\u7b49\u7ea7\u8bbe\u7f6e\uff01";
        }
        if (!gradeMap.containsKey("D")) {
            this.logger.info("\u6267\u884c\u5931\u8d25\uff01\u6ca1\u6709\u627e\u5230D\u7ea7\u4f9b\u5e94\u5546\u7b49\u7ea7\u8bbe\u7f6e\uff01");
            return "\u6267\u884c\u66f4\u65b0\u4f9b\u5e94\u5546\u7b49\u7ea7\u5931\u8d25\uff01\u6ca1\u6709\u627e\u5230D\u7ea7\u4f9b\u5e94\u5546\u7b49\u7ea7\u8bbe\u7f6e\uff01";
        }
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("billState", Parameter.getInInstance((Object)new String[]{"1", "3"}));
        List supplierTotal = this.queryList(queryParam, false);
        int total = supplierTotal.size();
        queryParam.getParams().put("yearScore", new Parameter("ge", (Object)gradeMap.get("A")));
        queryParam.getOrderMap().put("yearScore", "asc");
        List supplierA = this.queryList(queryParam, false);
        int a = supplierA.size();
        for (int i = 0; i < a; ++i) {
            SupplierEntity supplier = (SupplierEntity)((Object)supplierA.get(i));
            supplier.setGradeName("A");
        }
        int mostNum = BigDecimal.valueOf(total).multiply(gradeTakeMap.get("A")).divide(BigDecimal.valueOf(100L), 0, RoundingMode.DOWN).intValue();
        if (a > mostNum) {
            int over = a - mostNum;
            for (int i = 0; i < over; ++i) {
                SupplierEntity supplier = (SupplierEntity)((Object)supplierA.get(i));
                this.logger.info("\u4f9b\u5e94\u5546\u603b\u6570\uff1a{}\uff0c\u6839\u636eA\u7ea7\u4f9b\u5e94\u5546\u89c4\u5219\uff0c\u5176\u8fbe\u6807\u5206\u6570\u4e3a\uff1a{}\uff0c\u5176\u6570\u91cf\u5360\u6bd4\u4e3a\uff1a{} \uff0c\u6700\u591a{}\u4e2a\uff0c\u4f9b\u5e94\u5546\u3010{}\u3011\u7b49\u7ea7\u88ab\u8c03\u6574\u5230\u4e3aB", new Object[]{total, gradeMap.get("A"), gradeTakeMap.get("A"), mostNum, supplier.getName()});
                supplier.setGradeName("B");
            }
        }
        if (a > 0) {
            this.saveOrUpdateBatch(supplierA);
        }
        queryParam.getParams().put("yearScore", new Parameter("sql", (Object)(" year_score >=" + gradeMap.get("B") + " and year_score < " + gradeMap.get("A") + " or ( year_score >=" + gradeMap.get("A") + " and grade_name = 'B'  )")));
        List supplierB = this.queryList(queryParam, false);
        int b = supplierB.size();
        for (int i = 0; i < b; ++i) {
            SupplierEntity supplier = (SupplierEntity)((Object)supplierB.get(i));
            supplier.setGradeName("B");
        }
        mostNum = BigDecimal.valueOf(total).multiply(gradeTakeMap.get("B")).divide(BigDecimal.valueOf(100L), 0, RoundingMode.DOWN).intValue();
        if (b > mostNum) {
            int over = b - mostNum;
            for (int i = 0; i < over; ++i) {
                SupplierEntity supplier = (SupplierEntity)((Object)supplierB.get(i));
                this.logger.info("\u4f9b\u5e94\u5546\u603b\u6570\uff1a{}\uff0c\u6839\u636eB\u7ea7\u4f9b\u5e94\u5546\u89c4\u5219\uff0c\u5176\u8fbe\u6807\u5206\u6570\u4e3a\uff1a{}\uff0c\u5176\u6570\u91cf\u5360\u6bd4\u4e3a\uff1a{} \uff0c\u6700\u591a{}\u4e2a\uff0c\u4f9b\u5e94\u5546\u3010{}\u3011\u7b49\u7ea7\u88ab\u8c03\u6574\u5230\u4e3aC", new Object[]{total, gradeMap.get("B"), gradeTakeMap.get("B"), mostNum, supplier.getName()});
                supplier.setGradeName("C");
            }
        }
        if (b > 0) {
            this.saveOrUpdateBatch(supplierB);
        }
        queryParam.getParams().put("yearScore", new Parameter("sql", (Object)(" year_score >=" + gradeMap.get("C") + " and year_score < " + gradeMap.get("B") + " or ( year_score >=" + gradeMap.get("B") + " and grade_name = 'C'  )")));
        List supplierC = this.queryList(queryParam, false);
        int c = supplierC.size();
        for (int i = 0; i < c; ++i) {
            SupplierEntity supplier = (SupplierEntity)((Object)supplierC.get(i));
            supplier.setGradeName("C");
        }
        mostNum = BigDecimal.valueOf(total).multiply(gradeTakeMap.get("C")).divide(BigDecimal.valueOf(100L), 0, RoundingMode.DOWN).intValue();
        if (c > mostNum) {
            int over = c - mostNum;
            for (int i = 0; i < over; ++i) {
                SupplierEntity supplier = (SupplierEntity)((Object)supplierC.get(i));
                this.logger.info("\u4f9b\u5e94\u5546\u603b\u6570\uff1a{}\uff0c\u6839\u636eC\u7ea7\u4f9b\u5e94\u5546\u89c4\u5219\uff0c\u5176\u8fbe\u6807\u5206\u6570\u4e3a\uff1a{}\uff0c\u5176\u6570\u91cf\u5360\u6bd4\u4e3a\uff1a{} \uff0c\u6700\u591a{}\u4e2a\uff0c\u4f9b\u5e94\u5546\u3010{}\u3011\u7b49\u7ea7\u88ab\u8c03\u6574\u5230\u4e3aD", new Object[]{total, gradeMap.get("C"), gradeTakeMap.get("C"), mostNum, supplier.getName()});
                supplier.setGradeName("D");
            }
        }
        if (c > 0) {
            this.saveOrUpdateBatch(supplierC);
        }
        queryParam.getParams().put("yearScore", new Parameter("lt", (Object)gradeMap.get("C")));
        List supplierD = this.queryList(queryParam, false);
        int d = supplierD.size();
        for (int i = 0; i < d; ++i) {
            SupplierEntity supplier = (SupplierEntity)((Object)supplierD.get(i));
            supplier.setGradeName("D");
        }
        if (d > 0) {
            this.saveOrUpdateBatch(supplierD);
        }
        return null;
    }

    @Override
    public JSONObject querySupplierByNameOrSocialCreditCode(String supplierName, String socialCreditCode) {
        JSONObject jsonObject = new JSONObject();
        LambdaQueryWrapper queryByNameOrCode = new LambdaQueryWrapper();
        queryByNameOrCode.eq(BaseEntity::getTenantId, (Object)InvocationInfoProxy.getTenantid());
        queryByNameOrCode.and(wrapper -> (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper.eq(SupplierEntity::getName, (Object)supplierName)).or()).eq(SupplierEntity::getTaxNum, (Object)socialCreditCode));
        List list = super.list((Wrapper)queryByNameOrCode);
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            for (SupplierEntity entity : list) {
                String name = " ";
                if (entity.getName() != null) {
                    name = entity.getName();
                }
                String code = " ";
                if (entity.getTaxNum() != null) {
                    code = entity.getTaxNum();
                }
                if (name.equals(supplierName) && code.equals(socialCreditCode)) {
                    jsonObject.put("11", BeanMapper.map((Object)((Object)entity), SupplierVO.class));
                    break;
                }
                if (code.equals(socialCreditCode)) {
                    jsonObject.put("10", BeanMapper.map((Object)((Object)entity), SupplierVO.class));
                    continue;
                }
                if (!name.equals(supplierName)) continue;
                jsonObject.put("01", null);
            }
        } else {
            jsonObject.put("00", null);
        }
        JSONObject returnJsonObject = new JSONObject();
        if (jsonObject.containsKey((Object)"11")) {
            returnJsonObject.put("level", (Object)2);
            returnJsonObject.put("record", jsonObject.get((Object)"11"));
        } else if (jsonObject.containsKey((Object)"10")) {
            returnJsonObject.put("level", (Object)4);
            returnJsonObject.put("record", jsonObject.get((Object)"10"));
        } else if (jsonObject.containsKey((Object)"01")) {
            returnJsonObject.put("level", (Object)1);
        } else {
            returnJsonObject.put("level", (Object)3);
        }
        return returnJsonObject;
    }

    @Override
    public SupplierVO syncSuppler(SupplierVO supplierVO) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"social_credit_code", (Object)supplierVO.getSocialCreditCode());
        List entities = this.supplierMapper.selectList((Wrapper)queryWrapper);
        SupplierEntity entity = null;
        if (entities != null && entities.size() > 0) {
            entity = (SupplierEntity)((Object)entities.get(0));
            entity.setCode(supplierVO.getCode());
            entity.setName(supplierVO.getName());
            entity.setSocialCreditCode(supplierVO.getSocialCreditCode());
        } else {
            entity = (SupplierEntity)((Object)BeanMapper.map((Object)supplierVO, SupplierEntity.class));
        }
        this.saveOrUpdate((Object)entity, false);
        return (SupplierVO)BeanMapper.map((Object)((Object)entity), SupplierVO.class);
    }
}

