package com.ejianc.business.zhht.vo;

import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * 项目策划
 * 
 * @author generator
 * 
 */
public class BuildDutyVO extends BaseVO {

    private static final long serialVersionUID = -6419519141250474139L;
    private Long projectId; // 项目主键
    private String projectName; // 项目名称
    private String unitsName; // 建设单位
    private Long orgId; // 项目部主键
    private String orgName; // 项目部名称
    private String orgCode; // 项目组织编码
    private Long parentOrgId; // 组织ID
    private String parentOrgName; // 组织名称
    private String parentOrgCode; // 组织编码
    private String billCode; // 单据编码
    private String name; // 目标责任成本名称
    private Long feeId; // 费用模板主键
    private String feeName; // 费用模板名称
    private Long wbsId; // 核算对象主键
    private String wbsCode; // 核算对象编号
    private String wbsName; // 核算对象名称
    private BigDecimal mny; // 目标成本金额(无税)
    private BigDecimal taxMny; // 目标成本金额
    private BigDecimal beforeMny; // 变更前金额(无税)
    private BigDecimal beforeTaxMny; // 变更前金额
    private Integer convertFlag; // 转换状态 1-是 0-否
    private Integer latestFlag; // 是否最新版本
    private Integer enableState; // 是否生效
    private String memo; // 备注
    private Integer dutyVersion; // 目标责任成本版本
    private Long lastDutyId; // 上一版本主键
    private Long changeId; // 变更单主键
    private Integer changeState; // 变更状态(0-未变更1-变更中2-已变更)
    private Integer billState; // 审批状态
    private Long employeeId; // 经办人
    private String employeeName; // 经办人名称
    private Long departmentId; // 经办部门
    private String departmentName; // 经办部门名称
    private Integer beforeDutyVersion; // 历史版本号
    @JsonFormat(
            shape = JsonFormat.Shape.STRING,
            pattern = "yyyy-MM-dd",
            timezone = "GMT+8"
    )
    private Date oneTime; // 第一版本创建时间
    private Long baseDutyId; // 原始版本主键
    private String projectCode; // 项目编码
    private BigDecimal additionalTaxRate; // 附加税率
    private BigDecimal planedTotalCostMny; // 策划总成本（无税）
    private BigDecimal planedTotalCostTaxMny; // 策划总金额（含税）
    private BigDecimal profitAndLossTaxMny; // 盈亏金额（含税）
    private BigDecimal planProfitRate; // 策划利润率（含税）

    private BigDecimal beforePlanedTotalCostMny; // 变更前策划总成本(无税)
    private BigDecimal beforePlanedTotalCostTaxMny; // 变更前策划总金额（含税）
    private BigDecimal beforeProfitAndLossTaxMny; // 变更前盈亏金额（含税）
    private BigDecimal beforePlanProfitRate; // 变更前策划利润率（含税）
    
    private List<BuildDutySumDetailVO> sumDetailList = new ArrayList<>(); // 项目策划-汇总子表
    private List<BuildDutyLaborCostDetailVO> laborDetailList = new ArrayList<>(); // 项目测试-人工费
    private List<BuildDutyMaterialDetailVO> materialDetailList = new ArrayList<>(); // 项目策划-材料费
    private List<BuildDutyEquipDetailVO> equipDetailList = new ArrayList<>(); // 项目策划-机械费
    private List<BuildDutyProSubDetailVO> proSubDetailList = new ArrayList<>(); // 项目策划-专业分包费
    private List<BuildDutyMeasureDetailVO> measureDetailList = new ArrayList<>(); // 项目策划-措施费
    private List<BuildDutyOtherDetailVO> otherDetailList = new ArrayList<>(); // 项目策划-其他费

    List<BuildDutyHisVO> hisList = new ArrayList<>(); //历史版本

    public List<BuildDutyHisVO> getHisList() {
        return hisList;
    }

    public void setHisList(List<BuildDutyHisVO> hisList) {
        this.hisList = hisList;
    }

    public BigDecimal getBeforePlanedTotalCostMny() {
        return beforePlanedTotalCostMny;
    }

    public void setBeforePlanedTotalCostMny(BigDecimal beforePlanedTotalCostMny) {
        this.beforePlanedTotalCostMny = beforePlanedTotalCostMny;
    }

    public BigDecimal getBeforePlanedTotalCostTaxMny() {
        return beforePlanedTotalCostTaxMny;
    }

    public void setBeforePlanedTotalCostTaxMny(BigDecimal beforePlanedTotalCostTaxMny) {
        this.beforePlanedTotalCostTaxMny = beforePlanedTotalCostTaxMny;
    }

    public BigDecimal getBeforeProfitAndLossTaxMny() {
        return beforeProfitAndLossTaxMny;
    }

    public void setBeforeProfitAndLossTaxMny(BigDecimal beforeProfitAndLossTaxMny) {
        this.beforeProfitAndLossTaxMny = beforeProfitAndLossTaxMny;
    }

    public BigDecimal getBeforePlanProfitRate() {
        return beforePlanProfitRate;
    }

    public void setBeforePlanProfitRate(BigDecimal beforePlanProfitRate) {
        this.beforePlanProfitRate = beforePlanProfitRate;
    }

    @ReferSerialTransfer(referCode="project-set")
    public Long getProjectId() {
        return projectId;
    }
    @ReferDeserialTransfer
    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    public String getUnitsName() {
        return unitsName;
    }

    public void setUnitsName(String unitsName) {
        this.unitsName = unitsName;
    }
    @ReferSerialTransfer(referCode="idm-org")
    public Long getOrgId() {
        return orgId;
    }
    @ReferDeserialTransfer
    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    public String getOrgCode() {
        return orgCode;
    }

    public void setOrgCode(String orgCode) {
        this.orgCode = orgCode;
    }
    @ReferSerialTransfer(referCode="idm-org")
    public Long getParentOrgId() {
        return parentOrgId;
    }
    @ReferDeserialTransfer
    public void setParentOrgId(Long parentOrgId) {
        this.parentOrgId = parentOrgId;
    }
    public String getParentOrgName() {
        return parentOrgName;
    }

    public void setParentOrgName(String parentOrgName) {
        this.parentOrgName = parentOrgName;
    }
    public String getParentOrgCode() {
        return parentOrgCode;
    }

    public void setParentOrgCode(String parentOrgCode) {
        this.parentOrgCode = parentOrgCode;
    }
    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }
    @ReferSerialTransfer(referCode="tc-fee")
    public Long getFeeId() {
        return feeId;
    }
    @ReferDeserialTransfer
    public void setFeeId(Long feeId) {
        this.feeId = feeId;
    }
    public String getFeeName() {
        return feeName;
    }

    public void setFeeName(String feeName) {
        this.feeName = feeName;
    }
    @ReferSerialTransfer(referCode="subject-project-wbs-ref")
    public Long getWbsId() {
        return wbsId;
    }
    @ReferDeserialTransfer
    public void setWbsId(Long wbsId) {
        this.wbsId = wbsId;
    }
    public String getWbsCode() {
        return wbsCode;
    }

    public void setWbsCode(String wbsCode) {
        this.wbsCode = wbsCode;
    }
    public String getWbsName() {
        return wbsName;
    }

    public void setWbsName(String wbsName) {
        this.wbsName = wbsName;
    }
    public BigDecimal getMny() {
        return mny;
    }

    public void setMny(BigDecimal mny) {
        this.mny = mny;
    }
    public BigDecimal getTaxMny() {
        return taxMny;
    }

    public void setTaxMny(BigDecimal taxMny) {
        this.taxMny = taxMny;
    }
    public BigDecimal getBeforeMny() {
        return beforeMny;
    }

    public void setBeforeMny(BigDecimal beforeMny) {
        this.beforeMny = beforeMny;
    }
    public BigDecimal getBeforeTaxMny() {
        return beforeTaxMny;
    }

    public void setBeforeTaxMny(BigDecimal beforeTaxMny) {
        this.beforeTaxMny = beforeTaxMny;
    }
    public Integer getConvertFlag() {
        return convertFlag;
    }

    public void setConvertFlag(Integer convertFlag) {
        this.convertFlag = convertFlag;
    }
    public Integer getLatestFlag() {
        return latestFlag;
    }

    public void setLatestFlag(Integer latestFlag) {
        this.latestFlag = latestFlag;
    }
    public Integer getEnableState() {
        return enableState;
    }

    public void setEnableState(Integer enableState) {
        this.enableState = enableState;
    }
    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }
    public Integer getDutyVersion() {
        return dutyVersion;
    }

    public void setDutyVersion(Integer dutyVersion) {
        this.dutyVersion = dutyVersion;
    }
    public Long getLastDutyId() {
        return lastDutyId;
    }

    public void setLastDutyId(Long lastDutyId) {
        this.lastDutyId = lastDutyId;
    }
    public Long getChangeId() {
        return changeId;
    }

    public void setChangeId(Long changeId) {
        this.changeId = changeId;
    }
    public Integer getChangeState() {
        return changeState;
    }

    public void setChangeState(Integer changeState) {
        this.changeState = changeState;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    @ReferSerialTransfer(referCode="idm-employee")
    public Long getEmployeeId() {
        return employeeId;
    }
    @ReferDeserialTransfer
    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }
    public String getEmployeeName() {
        return employeeName;
    }

    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }
    @ReferSerialTransfer(referCode="idm-dept")
    public Long getDepartmentId() {
        return departmentId;
    }
    @ReferDeserialTransfer
    public void setDepartmentId(Long departmentId) {
        this.departmentId = departmentId;
    }
    public String getDepartmentName() {
        return departmentName;
    }

    public void setDepartmentName(String departmentName) {
        this.departmentName = departmentName;
    }
    public Integer getBeforeDutyVersion() {
        return beforeDutyVersion;
    }

    public void setBeforeDutyVersion(Integer beforeDutyVersion) {
        this.beforeDutyVersion = beforeDutyVersion;
    }
    public Date getOneTime() {
        return oneTime;
    }

    public void setOneTime(Date oneTime) {
        this.oneTime = oneTime;
    }
    public Long getBaseDutyId() {
        return baseDutyId;
    }

    public void setBaseDutyId(Long baseDutyId) {
        this.baseDutyId = baseDutyId;
    }
    public String getProjectCode() {
        return projectCode;
    }

    public void setProjectCode(String projectCode) {
        this.projectCode = projectCode;
    }
    public BigDecimal getAdditionalTaxRate() {
        return additionalTaxRate;
    }

    public void setAdditionalTaxRate(BigDecimal additionalTaxRate) {
        this.additionalTaxRate = additionalTaxRate;
    }
    public BigDecimal getPlanedTotalCostMny() {
        return planedTotalCostMny;
    }

    public void setPlanedTotalCostMny(BigDecimal planedTotalCostMny) {
        this.planedTotalCostMny = planedTotalCostMny;
    }
    public BigDecimal getPlanedTotalCostTaxMny() {
        return planedTotalCostTaxMny;
    }

    public void setPlanedTotalCostTaxMny(BigDecimal planedTotalCostTaxMny) {
        this.planedTotalCostTaxMny = planedTotalCostTaxMny;
    }
    public BigDecimal getProfitAndLossTaxMny() {
        return profitAndLossTaxMny;
    }

    public void setProfitAndLossTaxMny(BigDecimal profitAndLossTaxMny) {
        this.profitAndLossTaxMny = profitAndLossTaxMny;
    }
    public BigDecimal getPlanProfitRate() {
        return planProfitRate;
    }

    public void setPlanProfitRate(BigDecimal planProfitRate) {
        this.planProfitRate = planProfitRate;
    }

    public List<BuildDutySumDetailVO> getSumDetailList() {
        return sumDetailList;
    }

    public void setSumDetailList(List<BuildDutySumDetailVO> sumDetailList) {
        this.sumDetailList = sumDetailList;
    }

    public List<BuildDutyLaborCostDetailVO> getLaborDetailList() {
        return laborDetailList;
    }

    public void setLaborDetailList(List<BuildDutyLaborCostDetailVO> laborDetailList) {
        this.laborDetailList = laborDetailList;
    }

    public List<BuildDutyMaterialDetailVO> getMaterialDetailList() {
        return materialDetailList;
    }

    public void setMaterialDetailList(List<BuildDutyMaterialDetailVO> materialDetailList) {
        this.materialDetailList = materialDetailList;
    }

    public List<BuildDutyEquipDetailVO> getEquipDetailList() {
        return equipDetailList;
    }

    public void setEquipDetailList(List<BuildDutyEquipDetailVO> equipDetailList) {
        this.equipDetailList = equipDetailList;
    }

    public List<BuildDutyProSubDetailVO> getProSubDetailList() {
        return proSubDetailList;
    }

    public void setProSubDetailList(List<BuildDutyProSubDetailVO> proSubDetailList) {
        this.proSubDetailList = proSubDetailList;
    }

    public List<BuildDutyMeasureDetailVO> getMeasureDetailList() {
        return measureDetailList;
    }

    public void setMeasureDetailList(List<BuildDutyMeasureDetailVO> measureDetailList) {
        this.measureDetailList = measureDetailList;
    }

    public List<BuildDutyOtherDetailVO> getOtherDetailList() {
        return otherDetailList;
    }

    public void setOtherDetailList(List<BuildDutyOtherDetailVO> otherDetailList) {
        this.otherDetailList = otherDetailList;
    }
}
