package com.ejianc.business.costcheck.vo;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;

import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;

import com.ejianc.business.costcheck.vo.ProjectCheckCollectDetailEntitVO;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * 检查汇总表
 * 
 * @author generator
 * 
 */
public class ProjectCheckCollectVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    
    private String billCode; // 单据编码
    private Long orgId; // 组织id
    private String orgName; // 组织名称
    private Integer billState; // 单据状态（审批必须字段）
    private String createUserName; // 编制人
    private Long personCheckId; // 检查人ID
    private String personCheckName; // 检查人
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date collectDate; // 汇总时间
    private String remark; // 备注
    private Integer projectNum; // 本期总项目数
    private List<ProjectCheckCollectDetailEntitVO> projectCheckCollectDetailEntitList = new ArrayList<>(); // 检查汇总明细


    public Integer getProjectNum() {
        return projectNum;
    }

    public void setProjectNum(Integer projectNum) {
        this.projectNum = projectNum;
    }

    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    public String getCreateUserName() {
        return createUserName;
    }

    public void setCreateUserName(String createUserName) {
        this.createUserName = createUserName;
    }

    @ReferSerialTransfer(referCode = "idm-user")
    public Long getPersonCheckId() {
        return personCheckId;
    }
    @ReferDeserialTransfer
    public void setPersonCheckId(Long personCheckId) {
        this.personCheckId = personCheckId;
    }
    public String getPersonCheckName() {
        return personCheckName;
    }

    public void setPersonCheckName(String personCheckName) {
        this.personCheckName = personCheckName;
    }
    public Date getCollectDate() {
        return collectDate;
    }

    public void setCollectDate(Date collectDate) {
        this.collectDate = collectDate;
    }
    public String getRemark() {
        return remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }
    
     public List<ProjectCheckCollectDetailEntitVO> getProjectCheckCollectDetailEntitList() {
        return projectCheckCollectDetailEntitList;
     }

     public void setProjectCheckCollectDetailEntitList(List<ProjectCheckCollectDetailEntitVO> projectCheckCollectDetailEntitList) {
        this.projectCheckCollectDetailEntitList = projectCheckCollectDetailEntitList;
     }
}
