package com.ejianc.business.costinspection.vo;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;

import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;


/**
 * 成本巡检报告
 * 
 * @author generator
 * 
 */
public class InspectionReportVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    
    private Long orgId; // 项目部主键
    private String orgName; // 项目部名称
    private String orgCode; // 项目组织编码
    private Long parentOrgId; // 组织ID
    private String parentOrgName; // 组织名称
    private String parentOrgCode; // 组织编码
    private Long projectId; // 项目主键
    private String projectName; // 项目名称
    private String billCode; // 通知单编号
    private Integer billState; // 审批状态
    private String memo; // 备注
    private Long trackingId; // 跟踪单
    private String trackingCode; // 跟踪单编号

    @JsonFormat(
            shape = JsonFormat.Shape.STRING,
            pattern = "yyyy-MM-dd",
            timezone = "GMT+8"
    )
    private Date inspectionTime; // 巡检时间
    private Long inspectionPersonId; // 成本巡检人员
    private String inspectionPersonName; // 成本巡检人员名称
    private Long projectCategory; // 工程类别
    private String projectCategoryName; // 工程类别名称
    private Long contractMode; // 承包模式
    private String contractModeName; // 承包模式名称
    @JsonFormat(
            shape = JsonFormat.Shape.STRING,
            pattern = "yyyy-MM-dd",
            timezone = "GMT+8"
    )
    private Date contractStart; // 合同开工日期
    @JsonFormat(
            shape = JsonFormat.Shape.STRING,
            pattern = "yyyy-MM-dd",
            timezone = "GMT+8"
    )
    private Date contractEnd; // 合同竣工日期
    private BigDecimal nicContractMny; // 内部管控金额
    private BigDecimal secondaryOperation; // 二次经营
    private BigDecimal sumOutputval; // 总产值
    private BigDecimal sumIncome; // 总收款
    private BigDecimal sumCost; // 总成本
    private BigDecimal sumPay; // 总支出
    private String measurement; // 度量方式
    private BigDecimal measurementValue; // 度量值
    private String targetCostInfo; // 目标成本执行情况
    private String isAtRisk; // 是否存在风险

    private List<InspectionReportContentVO> inspectionReportContentList = new ArrayList<>(); // 成本巡检报告子表


    public List<InspectionReportContentVO> getInspectionReportContentList() {
        return inspectionReportContentList;
    }

    public void setInspectionReportContentList(List<InspectionReportContentVO> inspectionReportContentList) {
        this.inspectionReportContentList = inspectionReportContentList;
    }


    public Long getProjectCategory() {
        return projectCategory;
    }

    public void setProjectCategory(Long projectCategory) {
        this.projectCategory = projectCategory;
    }

    public String getProjectCategoryName() {
        return projectCategoryName;
    }

    public void setProjectCategoryName(String projectCategoryName) {
        this.projectCategoryName = projectCategoryName;
    }


    @ReferSerialTransfer(referCode="support-defdoc")
    public Long getContractMode() {
        return contractMode;
    }
    @ReferDeserialTransfer
    public void setContractMode(Long contractMode) {
        this.contractMode = contractMode;
    }

    public String getContractModeName() {
        return contractModeName;
    }

    public void setContractModeName(String contractModeName) {
        this.contractModeName = contractModeName;
    }

    public Date getContractStart() {
        return contractStart;
    }

    public void setContractStart(Date contractStart) {
        this.contractStart = contractStart;
    }

    public Date getContractEnd() {
        return contractEnd;
    }

    public void setContractEnd(Date contractEnd) {
        this.contractEnd = contractEnd;
    }

    public BigDecimal getNicContractMny() {
        return nicContractMny;
    }

    public void setNicContractMny(BigDecimal nicContractMny) {
        this.nicContractMny = nicContractMny;
    }

    public BigDecimal getSecondaryOperation() {
        return secondaryOperation;
    }

    public void setSecondaryOperation(BigDecimal secondaryOperation) {
        this.secondaryOperation = secondaryOperation;
    }

    public BigDecimal getSumOutputval() {
        return sumOutputval;
    }

    public void setSumOutputval(BigDecimal sumOutputval) {
        this.sumOutputval = sumOutputval;
    }

    public BigDecimal getSumIncome() {
        return sumIncome;
    }

    public void setSumIncome(BigDecimal sumIncome) {
        this.sumIncome = sumIncome;
    }

    public BigDecimal getSumCost() {
        return sumCost;
    }

    public void setSumCost(BigDecimal sumCost) {
        this.sumCost = sumCost;
    }

    public BigDecimal getSumPay() {
        return sumPay;
    }

    public void setSumPay(BigDecimal sumPay) {
        this.sumPay = sumPay;
    }

    public String getMeasurement() {
        return measurement;
    }

    public void setMeasurement(String measurement) {
        this.measurement = measurement;
    }

    public BigDecimal getMeasurementValue() {
        return measurementValue;
    }

    public void setMeasurementValue(BigDecimal measurementValue) {
        this.measurementValue = measurementValue;
    }

    public String getTargetCostInfo() {
        return targetCostInfo;
    }

    public void setTargetCostInfo(String targetCostInfo) {
        this.targetCostInfo = targetCostInfo;
    }

    public String getIsAtRisk() {
        return isAtRisk;
    }

    public void setIsAtRisk(String isAtRisk) {
        this.isAtRisk = isAtRisk;
    }

    @ReferSerialTransfer(referCode = "idm-org")
    public Long getOrgId() {
        return orgId;
    }
    @ReferDeserialTransfer
    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    public String getOrgCode() {
        return orgCode;
    }

    public void setOrgCode(String orgCode) {
        this.orgCode = orgCode;
    }
    public Long getParentOrgId() {
        return parentOrgId;
    }

    public void setParentOrgId(Long parentOrgId) {
        this.parentOrgId = parentOrgId;
    }
    public String getParentOrgName() {
        return parentOrgName;
    }

    public void setParentOrgName(String parentOrgName) {
        this.parentOrgName = parentOrgName;
    }
    public String getParentOrgCode() {
        return parentOrgCode;
    }

    public void setParentOrgCode(String parentOrgCode) {
        this.parentOrgCode = parentOrgCode;
    }

    @ReferSerialTransfer(referCode="project-set")
    public Long getProjectId() {
        return projectId;
    }
    @ReferDeserialTransfer
    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }

    @ReferSerialTransfer(referCode="site_tracking")
    public Long getTrackingId() {
        return trackingId;
    }
    @ReferDeserialTransfer
    public void setTrackingId(Long trackingId) {
        this.trackingId = trackingId;
    }
    public String getTrackingCode() {
        return trackingCode;
    }

    public void setTrackingCode(String trackingCode) {
        this.trackingCode = trackingCode;
    }
    public Date getInspectionTime() {
        return inspectionTime;
    }

    public void setInspectionTime(Date inspectionTime) {
        this.inspectionTime = inspectionTime;
    }

    @ReferSerialTransfer(referCode = "idm-user")
    public Long getInspectionPersonId() {
        return inspectionPersonId;
    }
    @ReferDeserialTransfer
    public void setInspectionPersonId(Long inspectionPersonId) {
        this.inspectionPersonId = inspectionPersonId;
    }
    public String getInspectionPersonName() {
        return inspectionPersonName;
    }

    public void setInspectionPersonName(String inspectionPersonName) {
        this.inspectionPersonName = inspectionPersonName;
    }
    
}
