/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.targetcost.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.ejianc.business.center.api.IWarnCenterApi;
import com.ejianc.business.targetcost.bean.DutyEntity;
import com.ejianc.business.targetcost.bean.TotalExecutionEntity;
import com.ejianc.business.targetcost.enums.DocTypeEnum;
import com.ejianc.business.targetcost.mapper.TotalExecutionMapper;
import com.ejianc.business.targetcost.service.IDetailCacheService;
import com.ejianc.business.targetcost.service.IDetailExecutionService;
import com.ejianc.business.targetcost.service.IDutyDetailItemService;
import com.ejianc.business.targetcost.service.IDutyDetailService;
import com.ejianc.business.targetcost.service.IDutyService;
import com.ejianc.business.targetcost.service.IFeeDetailScopeService;
import com.ejianc.business.targetcost.service.IFeeDetailService;
import com.ejianc.business.targetcost.service.IRuleDetailService;
import com.ejianc.business.targetcost.service.IRuleReceiverService;
import com.ejianc.business.targetcost.service.IRuleService;
import com.ejianc.business.targetcost.service.ITotalCacheService;
import com.ejianc.business.targetcost.service.ITotalExecutionService;
import com.ejianc.business.targetcost.utils.PushCalcExecCallable;
import com.ejianc.business.targetcost.utils.ReCalcExecCallable;
import com.ejianc.business.targetcost.utils.TargetcostCtrl;
import com.ejianc.business.targetcost.utils.TargetcostWarnCallable;
import com.ejianc.business.targetcost.vo.DetailExecutionVO;
import com.ejianc.business.targetcost.vo.ExecutionVO;
import com.ejianc.business.targetcost.vo.TotalExecutionVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.share.api.IShareLabsubApi;
import com.ejianc.foundation.share.api.IShareMaterialApi;
import com.ejianc.foundation.share.api.IShareProsubApi;
import com.ejianc.foundation.share.api.IShareSubjectOrgApi;
import com.ejianc.foundation.share.vo.LabsubCategoryVO;
import com.ejianc.foundation.share.vo.MaterialCategoryVO;
import com.ejianc.foundation.share.vo.ProsubCategoryVO;
import com.ejianc.foundation.share.vo.SubjectOrgVO;
import com.ejianc.foundation.support.api.IParamConfigApi;
import com.ejianc.foundation.support.vo.ParamRegisterSetVO;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.redisson.api.RedissonClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.web.context.request.RequestContextHolder;

@Service(value="totalExecutionService")
public class TotalExecutionServiceImpl
extends BaseServiceImpl<TotalExecutionMapper, TotalExecutionEntity>
implements ITotalExecutionService {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IParamConfigApi paramConfigApi;
    @Autowired
    private IOrgApi orgApi;
    @Autowired
    private IWarnCenterApi warnCenterApi;
    @Autowired
    private RedissonClient redissonClient;
    @Autowired
    private ITotalCacheService totalCacheService;
    @Autowired
    private IDetailCacheService detailCacheService;
    @Autowired
    private IDutyService dutyService;
    @Autowired
    private IDutyDetailService dutyDetailService;
    @Autowired
    private IDutyDetailItemService dutyDetailItemService;
    @Autowired
    private IFeeDetailService feeDetailService;
    @Autowired
    private IFeeDetailScopeService feeDetailScopeService;
    @Autowired
    private ITotalExecutionService totalExecutionService;
    @Autowired
    private IDetailExecutionService detailExecutionService;
    @Autowired
    private TargetcostCtrl targetcostCtrl;
    @Autowired
    private IShareMaterialApi shareMaterialApi;
    @Autowired
    private IShareLabsubApi shareLabsubApi;
    @Autowired
    private IShareProsubApi shareProsubApi;
    @Autowired
    private IShareSubjectOrgApi shareSubjectOrgApi;
    @Autowired
    private IRuleService ruleService;
    @Autowired
    private IRuleDetailService ruleDetailService;
    @Autowired
    private IRuleReceiverService ruleReceiverService;
    private final String CHECK_PARAM = "P-55h7p20112";

    @Override
    public CommonResponse<String> aggPush(ExecutionVO executionVO) {
        String msg = this.checkAgg(executionVO);
        if (StringUtils.isNotBlank((CharSequence)msg)) {
            return CommonResponse.error((String)msg);
        }
        TotalExecutionVO totalExecutionVO = executionVO.getTotalVO();
        TotalExecutionVO dbTotalVO = new TotalExecutionVO();
        ArrayList<DetailExecutionVO> detailListDb = new ArrayList<DetailExecutionVO>();
        this.totalSave(totalExecutionVO, dbTotalVO, true);
        this.detailExecutionService.detailSaveBatch(executionVO.getDetailList(), detailListDb, totalExecutionVO, dbTotalVO, true);
        CommonResponse response = this.paramConfigApi.getByCode("P-55h7p20112");
        if (response.isSuccess() && null != response.getData() && ((ParamRegisterSetVO)response.getData()).getValueData().equals("1")) {
            String authority = (String)RequestContextHolder.getRequestAttributes().getAttribute("authority", 0);
            ExecutorService threadPool = null;
            if (null != dbTotalVO && null != dbTotalVO.getId()) {
                threadPool = Executors.newFixedThreadPool(2);
                PushCalcExecCallable callable = this.getPushCalcExecCallable(authority, executionVO);
                threadPool.submit(callable);
                ExecutionVO executionVOdb = new ExecutionVO();
                executionVOdb.setTotalVO(dbTotalVO);
                executionVOdb.setDetailList(detailListDb);
                PushCalcExecCallable callabledb = this.getPushCalcExecCallable(authority, executionVOdb);
                threadPool.submit(callabledb);
            } else {
                threadPool = Executors.newFixedThreadPool(1);
                PushCalcExecCallable callable = this.getPushCalcExecCallable(authority, executionVO);
                threadPool.submit(callable);
            }
        }
        return CommonResponse.success((String)"\u63a8\u9001\u6267\u884c\u8868\u6210\u529f");
    }

    @Override
    public CommonResponse<String> aggDel(List<TotalExecutionVO> totalExecutionVOList) {
        for (TotalExecutionVO totalExecutionVO : totalExecutionVOList) {
            ArrayList<DetailExecutionVO> detailList = new ArrayList<DetailExecutionVO>();
            if (StringUtils.isBlank((CharSequence)totalExecutionVO.getProperty())) {
                totalExecutionVO.setProperty("1");
            }
            TotalExecutionVO totalExecutionVO1 = this.totalDelete(totalExecutionVO);
            this.detailExecutionService.detailDeleteBatch(totalExecutionVO1, detailList);
            CommonResponse response = this.paramConfigApi.getByCode("P-55h7p20112");
            if (!response.isSuccess() || null == response.getData() || !((ParamRegisterSetVO)response.getData()).getValueData().equals("1")) continue;
            ExecutionVO executionVO = new ExecutionVO();
            executionVO.setTotalVO(totalExecutionVO1);
            executionVO.setDetailList(detailList);
            ExecutorService threadPool = Executors.newFixedThreadPool(1);
            PushCalcExecCallable callable = this.getPushCalcExecCallable(null, executionVO);
            threadPool.submit(callable);
        }
        return CommonResponse.success((String)"\u5220\u9664\u6267\u884c\u8868\u6210\u529f");
    }

    @Override
    public CommonResponse<String> reCalc(Long projectId) {
        DutyEntity dutyEntity = this.beforeReCalc(projectId);
        ExecutorService threadPool = Executors.newFixedThreadPool(1);
        ReCalcExecCallable callable = this.getReCalcExecCallable(dutyEntity, projectId);
        threadPool.submit(callable);
        return CommonResponse.success((String)"\u91cd\u7b97\u540e\u53f0\u6267\u884c\u4e2d\uff0c\u8bf7\u7a0d\u5019\u5237\u65b0\u67e5\u770b\u6570\u636e");
    }

    @Override
    public CommonResponse<JSONObject> ctrlJson(ExecutionVO executionVO) {
        String msg = this.checkAgg(executionVO);
        if (StringUtils.isNotBlank((CharSequence)msg)) {
            return CommonResponse.error((String)msg);
        }
        TotalExecutionVO totalExecutionVO = executionVO.getTotalVO();
        TotalExecutionVO dbTotalVO = new TotalExecutionVO();
        ArrayList<DetailExecutionVO> detailListDb = new ArrayList<DetailExecutionVO>();
        this.totalSave(totalExecutionVO, dbTotalVO, false);
        this.detailExecutionService.detailSaveBatch(executionVO.getDetailList(), detailListDb, totalExecutionVO, dbTotalVO, false);
        return this.targetcostCtrl.ctrl(executionVO);
    }

    private DutyEntity beforeReCalc(Long projectId) {
        LambdaQueryWrapper feeQuery = new LambdaQueryWrapper();
        feeQuery.eq(DutyEntity::getProjectId, (Object)projectId);
        feeQuery.eq(DutyEntity::getEnableState, (Object)true);
        List dutyEntities = this.dutyService.list((Wrapper)feeQuery);
        if (CollectionUtils.isEmpty((Collection)dutyEntities)) {
            return null;
        }
        return (DutyEntity)((Object)dutyEntities.get(0));
    }

    private void totalSave(TotalExecutionVO totalExecutionVO, TotalExecutionVO dbTotalVO, Boolean isDb) {
        TotalExecutionEntity entity = (TotalExecutionEntity)((Object)BeanMapper.map((Object)totalExecutionVO, TotalExecutionEntity.class));
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(TotalExecutionEntity::getSourceId, (Object)totalExecutionVO.getSourceId());
        queryWrapper.eq(TotalExecutionEntity::getBillType, (Object)totalExecutionVO.getBillType());
        queryWrapper.eq(TotalExecutionEntity::getBussinessType, (Object)totalExecutionVO.getBussinessType());
        queryWrapper.eq(TotalExecutionEntity::getProperty, (Object)totalExecutionVO.getProperty());
        List list = this.list((Wrapper)queryWrapper);
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            TotalExecutionEntity dbEntity = (TotalExecutionEntity)((Object)list.get(0));
            if (dbEntity.getProjectId().compareTo(totalExecutionVO.getProjectId()) != 0) {
                dbTotalVO = (TotalExecutionVO)BeanMapper.map((Object)((Object)dbEntity), TotalExecutionVO.class);
                dbTotalVO.setMoney(ComputeUtil.safeSub((BigDecimal)BigDecimal.ZERO, (BigDecimal)dbTotalVO.getMoney()));
                dbTotalVO.setTaxMoney(ComputeUtil.safeSub((BigDecimal)BigDecimal.ZERO, (BigDecimal)dbTotalVO.getTaxMoney()));
            } else {
                totalExecutionVO.setMoney(ComputeUtil.safeSub((BigDecimal)totalExecutionVO.getMoney(), (BigDecimal)dbEntity.getMoney()));
                totalExecutionVO.setTaxMoney(ComputeUtil.safeSub((BigDecimal)totalExecutionVO.getTaxMoney(), (BigDecimal)dbEntity.getTaxMoney()));
            }
            if (isDb.booleanValue()) {
                ((TotalExecutionMapper)this.baseMapper).deleteByIdPhy(dbEntity.getId());
            }
        }
        if (!isDb.booleanValue() && null != totalExecutionVO.getLastSourceId() && totalExecutionVO.getSourceId().compareTo(totalExecutionVO.getLastSourceId()) != 0) {
            LambdaQueryWrapper lastQueryWrapper = new LambdaQueryWrapper();
            lastQueryWrapper.eq(TotalExecutionEntity::getSourceId, (Object)totalExecutionVO.getLastSourceId());
            lastQueryWrapper.eq(TotalExecutionEntity::getBussinessType, (Object)totalExecutionVO.getBussinessType());
            lastQueryWrapper.eq(TotalExecutionEntity::getProperty, (Object)totalExecutionVO.getProperty());
            List lastList = this.list((Wrapper)lastQueryWrapper);
            if (CollectionUtils.isNotEmpty((Collection)lastList)) {
                TotalExecutionEntity dbEntity = (TotalExecutionEntity)((Object)lastList.get(0));
                totalExecutionVO.setMoney(ComputeUtil.safeSub((BigDecimal)totalExecutionVO.getMoney(), (BigDecimal)dbEntity.getMoney()));
                totalExecutionVO.setTaxMoney(ComputeUtil.safeSub((BigDecimal)totalExecutionVO.getTaxMoney(), (BigDecimal)dbEntity.getTaxMoney()));
            }
        }
        if (isDb.booleanValue()) {
            this.saveOrUpdate((Object)entity);
        }
    }

    private TotalExecutionVO totalDelete(TotalExecutionVO totalExecutionVO) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(TotalExecutionEntity::getSourceId, (Object)totalExecutionVO.getSourceId());
        queryWrapper.eq(TotalExecutionEntity::getBillType, (Object)totalExecutionVO.getBillType());
        queryWrapper.eq(TotalExecutionEntity::getBussinessType, (Object)totalExecutionVO.getBussinessType());
        queryWrapper.eq(TotalExecutionEntity::getProperty, (Object)totalExecutionVO.getProperty());
        List list = this.list((Wrapper)queryWrapper);
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            TotalExecutionEntity dbEntity = (TotalExecutionEntity)((Object)list.get(0));
            totalExecutionVO = (TotalExecutionVO)BeanMapper.map((Object)((Object)dbEntity), TotalExecutionVO.class);
            totalExecutionVO.setMoney(ComputeUtil.safeSub((BigDecimal)BigDecimal.ZERO, (BigDecimal)totalExecutionVO.getMoney()));
            totalExecutionVO.setTaxMoney(ComputeUtil.safeSub((BigDecimal)BigDecimal.ZERO, (BigDecimal)totalExecutionVO.getTaxMoney()));
            ((TotalExecutionMapper)this.baseMapper).deleteByIdPhy(dbEntity.getId());
        }
        return totalExecutionVO;
    }

    private String checkAgg(ExecutionVO executionVO) {
        TotalExecutionVO totalExecutionVO = executionVO.getTotalVO();
        if (null == totalExecutionVO) {
            return "\u8868\u5934\u5fc5\u4f20";
        }
        if (null == totalExecutionVO.getOrgId()) {
            return "\u6240\u5c5e\u7ec4\u7ec7\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (null == totalExecutionVO.getProjectId()) {
            return "\u9879\u76ee\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (null == totalExecutionVO.getBillCategory()) {
            return "\u5355\u636e\u5206\u7c7b\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (StringUtils.isBlank((CharSequence)totalExecutionVO.getBillType())) {
            return "\u5355\u636e\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (StringUtils.isBlank((CharSequence)totalExecutionVO.getBussinessType())) {
            return "\u4e1a\u52a1\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (StringUtils.isBlank((CharSequence)totalExecutionVO.getProperty())) {
            totalExecutionVO.setProperty("1");
        }
        if (null == totalExecutionVO.getSourceId()) {
            return "\u6765\u6e90\u4e3b\u952e\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (CollectionUtils.isNotEmpty((Collection)executionVO.getDetailList())) {
            for (DetailExecutionVO detailExecutionVO : executionVO.getDetailList()) {
                if (null == detailExecutionVO.getDocType()) {
                    return "\u8868\u4f53\u6863\u6848\uff08\u5206\u7c7b\uff09\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a";
                }
                if (null == detailExecutionVO.getDocId()) {
                    return "\u6863\u6848ID\u4e0d\u80fd\u4e3a\u7a7a";
                }
                if (null == detailExecutionVO.getCategoryId()) {
                    return "\u5206\u7c7bID\u4e0d\u80fd\u4e3a\u7a7a";
                }
                if (null == detailExecutionVO.getSourceId()) {
                    return "\u6765\u6e90\u4e3b\u952e\u4e0d\u80fd\u4e3a\u7a7a";
                }
                if (null != detailExecutionVO.getSourceBillId()) continue;
                return "\u6765\u6e90\u4e3b\u8868ID\u4e0d\u80fd\u4e3a\u7a7a";
            }
        }
        this.fullDetailCategoryInfo(executionVO);
        return null;
    }

    private PushCalcExecCallable getPushCalcExecCallable(String authority, ExecutionVO executionVO) {
        return new PushCalcExecCallable(RequestContextHolder.getRequestAttributes(), authority, executionVO, this.redissonClient, this.totalCacheService, this.detailCacheService, this.dutyService, this.dutyDetailService, this.dutyDetailItemService, this.feeDetailService, this.feeDetailScopeService);
    }

    private ReCalcExecCallable getReCalcExecCallable(DutyEntity dutyEntity, Long projectId) {
        return new ReCalcExecCallable(RequestContextHolder.getRequestAttributes(), projectId, dutyEntity, this.redissonClient, this.totalCacheService, this.detailCacheService, this.dutyDetailService, this.dutyDetailItemService, this.feeDetailService, this.feeDetailScopeService, this.totalExecutionService, this.detailExecutionService);
    }

    private TargetcostWarnCallable getTargetcostWarnCallable(List<DutyEntity> dutyEntities, String authority) {
        return new TargetcostWarnCallable(authority, RequestContextHolder.getRequestAttributes(), this.warnCenterApi, this.redissonClient, this.totalCacheService, this.detailCacheService, dutyEntities, this.ruleService, this.ruleDetailService, this.ruleReceiverService, this.feeDetailService, this.feeDetailScopeService);
    }

    private void fullDetailCategoryInfo(ExecutionVO executionVO) {
        block7: {
            ArrayList<Long> categoryList;
            Integer docType;
            block10: {
                List categoryVOS;
                CommonResponse response;
                block9: {
                    block8: {
                        docType = -1;
                        if (!CollectionUtils.isNotEmpty((Collection)executionVO.getDetailList())) break block7;
                        categoryList = new ArrayList<Long>();
                        for (DetailExecutionVO detailExecutionVO : executionVO.getDetailList()) {
                            if (!StringUtils.isBlank((CharSequence)detailExecutionVO.getCategoryInnerCode())) continue;
                            categoryList.add(detailExecutionVO.getCategoryId());
                            docType = detailExecutionVO.getDocType();
                        }
                        if (!DocTypeEnum.\u7269\u6599\u6863\u6848.getCode().equals(docType) && !DocTypeEnum.\u8bbe\u5907\u6863\u6848.getCode().equals(docType)) break block8;
                        response = this.shareMaterialApi.queryCategoryListByIds(categoryList);
                        if (!response.isSuccess() || !CollectionUtils.isNotEmpty((Collection)((Collection)response.getData()))) break block7;
                        categoryVOS = (List)response.getData();
                        Map map = categoryVOS.stream().collect(Collectors.toMap(MaterialCategoryVO::getId, Function.identity(), (key1, key2) -> key1));
                        for (DetailExecutionVO detailExecutionVO : executionVO.getDetailList()) {
                            if (!StringUtils.isBlank((CharSequence)detailExecutionVO.getCategoryInnerCode())) continue;
                            MaterialCategoryVO categoryVO = (MaterialCategoryVO)map.get(detailExecutionVO.getCategoryId());
                            detailExecutionVO.setCategoryInnerCode(categoryVO.getInnerCode());
                            detailExecutionVO.setCategoryCode(categoryVO.getCode());
                            detailExecutionVO.setCategoryName(categoryVO.getName());
                            detailExecutionVO.setUnitId(categoryVO.getUnitId());
                            detailExecutionVO.setUnitName(categoryVO.getUnitName());
                        }
                        break block7;
                    }
                    if (!DocTypeEnum.\u4e13\u4e1a\u5206\u5305\u6863\u6848.getCode().equals(docType)) break block9;
                    response = this.shareProsubApi.queryCategoryListByIds(categoryList);
                    if (!response.isSuccess() || !CollectionUtils.isNotEmpty((Collection)((Collection)response.getData()))) break block7;
                    categoryVOS = (List)response.getData();
                    Map map = categoryVOS.stream().collect(Collectors.toMap(BaseVO::getId, Function.identity(), (key1, key2) -> key1));
                    for (DetailExecutionVO detailExecutionVO : executionVO.getDetailList()) {
                        if (!StringUtils.isBlank((CharSequence)detailExecutionVO.getCategoryInnerCode())) continue;
                        ProsubCategoryVO categoryVO = (ProsubCategoryVO)map.get(detailExecutionVO.getCategoryId());
                        detailExecutionVO.setCategoryInnerCode(categoryVO.getInnerCode());
                        detailExecutionVO.setCategoryCode(categoryVO.getCategoryCode());
                        detailExecutionVO.setCategoryName(categoryVO.getCategoryName());
                    }
                    break block7;
                }
                if (!DocTypeEnum.\u52b3\u52a1\u5206\u5305\u6863\u6848.getCode().equals(docType)) break block10;
                response = this.shareLabsubApi.queryCategoryListByIds(categoryList);
                if (!response.isSuccess() || !CollectionUtils.isNotEmpty((Collection)((Collection)response.getData()))) break block7;
                categoryVOS = (List)response.getData();
                Map map = categoryVOS.stream().collect(Collectors.toMap(BaseVO::getId, Function.identity(), (key1, key2) -> key1));
                for (DetailExecutionVO detailExecutionVO : executionVO.getDetailList()) {
                    if (!StringUtils.isBlank((CharSequence)detailExecutionVO.getCategoryInnerCode())) continue;
                    LabsubCategoryVO categoryVO = (LabsubCategoryVO)map.get(detailExecutionVO.getCategoryId());
                    detailExecutionVO.setCategoryInnerCode(categoryVO.getInnerCode());
                    detailExecutionVO.setCategoryCode(categoryVO.getCategoryCode());
                    detailExecutionVO.setCategoryName(categoryVO.getCategoryName());
                }
                break block7;
            }
            if (DocTypeEnum.\u6210\u672c\u79d1\u76ee.getCode().equals(docType)) {
                QueryParam queryParam = new QueryParam();
                queryParam.getParams().put("id", new Parameter("in", categoryList));
                CommonResponse response = this.shareSubjectOrgApi.querySubjectOrg(queryParam);
                if (response.isSuccess() && CollectionUtils.isNotEmpty((Collection)((Collection)response.getData()))) {
                    List categoryVOS = (List)response.getData();
                    Map map = categoryVOS.stream().collect(Collectors.toMap(BaseVO::getId, Function.identity(), (key1, key2) -> key1));
                    for (DetailExecutionVO detailExecutionVO : executionVO.getDetailList()) {
                        if (!StringUtils.isBlank((CharSequence)detailExecutionVO.getCategoryInnerCode())) continue;
                        SubjectOrgVO categoryVO = (SubjectOrgVO)map.get(detailExecutionVO.getCategoryId());
                        detailExecutionVO.setCategoryInnerCode(categoryVO.getInnerCode());
                        detailExecutionVO.setCategoryCode(categoryVO.getSubjectCode());
                        detailExecutionVO.setCategoryName(categoryVO.getSubjectName());
                    }
                }
            }
        }
    }

    @Override
    public CommonResponse<String> ctrlWarn(HttpServletRequest request) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(DutyEntity::getEnableState, (Object)1);
        List dutyEntities = this.dutyService.list((Wrapper)queryWrapper);
        if (CollectionUtils.isNotEmpty((Collection)dutyEntities)) {
            for (DutyEntity dutyEntity : dutyEntities) {
                CommonResponse parents = this.orgApi.findParentsByOrgId(dutyEntity.getOrgId());
                if (!parents.isSuccess() || parents.getData() == null || ((List)parents.getData()).size() <= 0) continue;
                dutyEntity.setOrgList((List)parents.getData());
            }
            ExecutorService threadPool = Executors.newFixedThreadPool(1);
            TargetcostWarnCallable callable = this.getTargetcostWarnCallable(dutyEntities, request.getHeader("authority"));
            threadPool.submit(callable);
        }
        return CommonResponse.success((String)"\u76ee\u6807\u6210\u672c\u9884\u8b66\u6210\u529f");
    }

    public List<List<DutyEntity>> averageAssign(List<DutyEntity> source, int n) {
        ArrayList<List<DutyEntity>> result = new ArrayList<List<DutyEntity>>();
        int remainder = source.size() % n;
        int number = source.size() / n;
        int offset = 0;
        for (int i = 0; i < n; ++i) {
            List<DutyEntity> value;
            if (remainder > 0) {
                value = source.subList(i * number + offset, (i + 1) * number + offset + 1);
                --remainder;
                ++offset;
            } else {
                value = source.subList(i * number + offset, (i + 1) * number + offset);
            }
            result.add(value);
        }
        return result;
    }
}

