package com.ejianc.business.sx2j.build.service.impl;

import com.ejianc.business.sx2j.build.bean.BuildDutyEntity;
import com.ejianc.business.sx2j.build.service.IBuildDutyService;
import com.ejianc.business.sx2j.build.vo.BuildDutyVO;
import com.ejianc.business.targetcost.enums.ChangeStateEnum;
import com.ejianc.business.targetcost.enums.ConversionEnum;
import com.ejianc.business.targetcost.service.IDutyService;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.BooleanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service("buildDuty")
public class BuildDutyBpmServiceImpl implements ICommonBusinessService {

	@Autowired
	private IDutyService dutyService;

	@Autowired
	private IBuildDutyService buildDutyService;

	/**
	 * 提交前回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
		BuildDutyEntity buildDutyEntity =buildDutyService.selectById(billId);
		if(CollectionUtils.isNotEmpty(buildDutyEntity.getBuildPlansList())){
			return CommonResponse.error("单据需有子表信息后才能提交");
		}
		if(buildDutyEntity.getConvertFlag()==0){
			return CommonResponse.error("未转换的目标成本不允许提交，请点击转换按钮进行目标成本转换");
		}
		//TODO
		return CommonResponse.success();
	};

	/**
	 * 提交完回调
	 *
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode){
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 有审批流的撤回前回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
		BuildDutyEntity buildDutyEntity =buildDutyService.selectById(billId);
		if (state == 0){ // 点击撤回进入流程，   驳回state传4，直接成功
			if(buildDutyEntity.getLastDutyId()==null) {
				if (BooleanUtils.isFalse(buildDutyEntity.getLatestFlag()) || (1 != buildDutyEntity.getDutyVersion() && BooleanUtils.isFalse(buildDutyEntity.getEnableState()))) {
					throw new BusinessException("非最新生效版本，不能撤回！");
				}
			}
		}
		return CommonResponse.success();
	};

	/**
	 * 有审批流的撤回后回调
	 *
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode){
		//弃审是否生效修改为否
		updateEnableAndWriteBack(billId, false);
		return CommonResponse.success();
	};

	/**
	 * 审批节点审批中时节点审批前回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
		return CommonResponse.success();
	};

	/**
	 * 终审审核前回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 终审审核完回调
	 *
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		BuildDutyEntity buildDutyEntity =buildDutyService.selectById(billId);
		if(buildDutyEntity.getConvertFlag()==0){
			return CommonResponse.error("未转换的目标成本，请点击转换按钮进行目标成本转换");
		}
		//审核完成是否生效修改为是
		updateEnableAndWriteBack(billId, true);
		dutyService.pushFromImport(BeanMapper.map(buildDutyEntity,BuildDutyVO.class),true, ConversionEnum.云南房建.getCode());
		return CommonResponse.success();
	}

	/**
	 * 弃审前事件回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		BuildDutyEntity dutyEntity =buildDutyService.selectById(billId);
		if(!(dutyEntity.getEnableState() && dutyEntity.getLatestFlag())){
			throw new BusinessException("非最新生效版本，不能弃审！");
		}
		return CommonResponse.success();
	}

	/**
	 * 弃审后事件回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		BuildDutyEntity dutyEntity =buildDutyService.selectById(billId);
		//TODO
		// 参数是单据类型编码字符串 根据需求是否打开下面代码
        /**CommonResponse<String> resp = billTypeApi.checkQuote(billTypeCode, billId);
        if(!resp.isSuccess()){
            return CommonResponse.error("无法撤回！"+resp.getMsg());
        }*/
		//弃审是否生效修改为否
		updateEnableAndWriteBack(billId, false);
		dutyService.pushFromImport(BeanMapper.map(dutyEntity,BuildDutyVO.class),false, ConversionEnum.云南房建.getCode());
		return CommonResponse.success();
	}

	private void updateEnableAndWriteBack(Long billId, Boolean isPass){
		BuildDutyEntity dutyEntity =buildDutyService.selectById(billId);
		dutyEntity.setEnableState(isPass);
		buildDutyService.saveOrUpdate(dutyEntity);
		//弃审,存在前版本，单据是否生效为是
		if(dutyEntity.getLastDutyId()!=null){
			BuildDutyEntity revise = buildDutyService.getById(dutyEntity.getLastDutyId());
			revise.setChangeState(isPass ? ChangeStateEnum.已变更.getCode() : ChangeStateEnum.变更中.getCode());
			revise.setEnableState(!isPass);
			buildDutyService.saveOrUpdate(revise);
		}
	}

}
