package com.ejianc.business.sx2j.build.vo;

import java.math.*;
import java.util.List;
import java.util.ArrayList;

import com.ejianc.business.targetcost.utils.ITreeNodeB;
import com.ejianc.framework.skeleton.template.BaseVO;


/**
 * 房建-排水、降水费
 *
 * @author generator
 *
 */
public class BuildPrecipitationVO extends CommonImportDataVO implements ITreeNodeB {
    private static final long serialVersionUID = 1L;

    private Long dutyId; // 目标责任成本主键
    private Long parentId; // pid
    private Long tid; // 前端生成树形主键
    private Boolean leafFlag; // 是否末级
    private String treeIndex; // 序号
    private String precipitationName; // 分项名称
    private String precipitationCode; // 编码
    private String precipitationUnitName; // 单位
    private BigDecimal precipitationNum; // 数量
    private BigDecimal precipitationTaxPrice; // 含税单价（元）
    private BigDecimal precipitationRate; // 专项进项税税率(%)
    private BigDecimal precipitationPrice; // 不含进项税单价
    private BigDecimal precipitationTaxMny; // 进项税合计
    private BigDecimal precipitationMny; // 不含进项税合计
    private BigDecimal precipitationTax; // 进项税合计
    private String precipitationMemo; // 备注
    private String precipitationFeatures; // 特征

    public String getPrecipitationFeatures() {
        return precipitationFeatures;
    }

    public void setPrecipitationFeatures(String precipitationFeatures) {
        this.precipitationFeatures = precipitationFeatures;
    }

    private String tpid; // 前端生成树形父主键
    private String indexCode;//序号
    // 列是否可以导入，true=可以导入，false=不可导入
    private Boolean importFlag;
    //错误信息
    private String warnType;
    private List<ITreeNodeB> children;
    @Override
    public Long getNodeID() {
        return getId();
    }

    @Override
    public Long getParentID() {
        return parentId;
    }

    @Override
    public List<ITreeNodeB> getChildren() {
        if (children == null) {
            children = new ArrayList<>();
        }
        return children;
    }

    public String getTpid() {
        return tpid;
    }

    public void setTpid(String tpid) {
        this.tpid = tpid;
    }

    public String getIndexCode() {
        return indexCode;
    }

    public void setIndexCode(String indexCode) {
        this.indexCode = indexCode;
    }

    public Boolean getImportFlag() {
        return importFlag;
    }

    public void setImportFlag(Boolean importFlag) {
        this.importFlag = importFlag;
    }

    public String getWarnType() {
        return warnType;
    }

    public void setWarnType(String warnType) {
        this.warnType = warnType;
    }


    public Long getDutyId() {
        return dutyId;
    }

    public void setDutyId(Long dutyId) {
        this.dutyId = dutyId;
    }
    public Long getParentId() {
        return parentId;
    }

    public void setParentId(Long parentId) {
        this.parentId = parentId;
    }
    public Long getTid() {
        return tid;
    }

    public void setTid(Long tid) {
        this.tid = tid;
    }
    public Boolean getLeafFlag() {
        return leafFlag;
    }

    public void setLeafFlag(Boolean leafFlag) {
        this.leafFlag = leafFlag;
    }
    public String getTreeIndex() {
        return treeIndex;
    }

    public void setTreeIndex(String treeIndex) {
        this.treeIndex = treeIndex;
    }
    public String getPrecipitationName() {
        return precipitationName;
    }

    public void setPrecipitationName(String precipitationName) {
        this.precipitationName = precipitationName;
    }
    public String getPrecipitationCode() {
        return precipitationCode;
    }

    public void setPrecipitationCode(String precipitationCode) {
        this.precipitationCode = precipitationCode;
    }
    public String getPrecipitationUnitName() {
        return precipitationUnitName;
    }

    public void setPrecipitationUnitName(String precipitationUnitName) {
        this.precipitationUnitName = precipitationUnitName;
    }
    public BigDecimal getPrecipitationNum() {
        return precipitationNum;
    }

    public void setPrecipitationNum(BigDecimal precipitationNum) {
        this.precipitationNum = precipitationNum;
    }
    public BigDecimal getPrecipitationTaxPrice() {
        return precipitationTaxPrice;
    }

    public void setPrecipitationTaxPrice(BigDecimal precipitationTaxPrice) {
        this.precipitationTaxPrice = precipitationTaxPrice;
    }
    public BigDecimal getPrecipitationRate() {
        return precipitationRate;
    }

    public void setPrecipitationRate(BigDecimal precipitationRate) {
        this.precipitationRate = precipitationRate;
    }
    public BigDecimal getPrecipitationPrice() {
        return precipitationPrice;
    }

    public void setPrecipitationPrice(BigDecimal precipitationPrice) {
        this.precipitationPrice = precipitationPrice;
    }
    public BigDecimal getPrecipitationTaxMny() {
        return precipitationTaxMny;
    }

    public void setPrecipitationTaxMny(BigDecimal precipitationTaxMny) {
        this.precipitationTaxMny = precipitationTaxMny;
    }
    public BigDecimal getPrecipitationMny() {
        return precipitationMny;
    }

    public void setPrecipitationMny(BigDecimal precipitationMny) {
        this.precipitationMny = precipitationMny;
    }
    public BigDecimal getPrecipitationTax() {
        return precipitationTax;
    }

    public void setPrecipitationTax(BigDecimal precipitationTax) {
        this.precipitationTax = precipitationTax;
    }
    public String getPrecipitationMemo() {
        return precipitationMemo;
    }

    public void setPrecipitationMemo(String precipitationMemo) {
        this.precipitationMemo = precipitationMemo;
    }
    /***转换使用**/

    @Override
    public String getcCode() {
        return this.precipitationCode;
    }

    @Override
    public String getcName() {
        return this.precipitationName;
    }

    @Override
    public String getcUnitName() {
        return this.precipitationUnitName;
    }

    @Override
    public Long getcId() {
        return this.getId();
    }

    @Override
    public BigDecimal getcTaxRate() {
        return this.precipitationRate;
    }

    @Override
    public BigDecimal getcPrice() {
        return this.precipitationPrice;
    }

    @Override
    public BigDecimal getcTaxPrice() {
        return this.precipitationTaxPrice;
    }

    @Override
    public BigDecimal getcAmount() {
        return this.precipitationNum;
    }

    @Override
    public BigDecimal getcMny() {
        return this.precipitationMny;
    }

    @Override
    public BigDecimal getcTaxMny() {
        return this.precipitationTaxMny;
    }
}
