package com.ejianc.business.targetcost.handler;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.ejianc.business.promaterial.pricelib.api.IMaterialPriceHistoryApi;
import com.ejianc.business.promaterial.pricelib.vo.MaterialPriceHistoryApiVO;
import com.ejianc.business.prosub.api.IPriceContractCollectApi;
import com.ejianc.business.prosub.pricelib.vo.PriceContractCollectVO;
import com.ejianc.business.targetcost.bean.DutyDetailEntity;
import com.ejianc.business.targetcost.bean.DutyDetailItemEntity;
import com.ejianc.business.targetcost.bean.DutyEntity;
import com.ejianc.business.targetcost.enums.ChangeStateEnum;
import com.ejianc.business.targetcost.enums.DocTypeEnum;
import com.ejianc.business.targetcost.mapper.DutyMapper;
import com.ejianc.business.targetcost.service.*;
import com.ejianc.business.targetcost.vo.DutyVO;
import com.ejianc.business.targetcost.vo.FeeDetailVO;
import com.ejianc.business.targetcost.vo.FeeVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.core.util.ResultAsTree;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.ejianc.support.idworker.util.IdWorker;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.util.*;
import java.util.function.Function;
import java.util.stream.Collectors;


@Service
public abstract class ConversionBaseHandler{

    private static final String BILL_CODE = "TC_DUTY";
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private ITotalExecutionService totalExecutionService;
    @Autowired
    private IDutyService dutyService;
    @Autowired
    private IFeeService feeService;
    @Autowired
    private DutyMapper dutyMapper;
    @Autowired
    private IDutyDetailItemService dutyDetailItemService;
    @Autowired
    private IDutyDetailService dutyDetailService;
    @Autowired
    private IMaterialPriceHistoryApi materialPriceHistoryApi;
    @Autowired
    private IPriceContractCollectApi priceContractCollectApi;

    public void handlerHead(DutyEntity dutyEntity, Boolean isEff, BaseVO baseVO) {
        if (!isEff) {
            checkFeeId(dutyEntity);
            FeeVO feeVO = feeService.queryDetailForPush(dutyEntity.getFeeId(), false);
            checkFeeCode(feeVO);
            LambdaQueryWrapper<DutyEntity> queryWrapper = new LambdaQueryWrapper<>();
            queryWrapper.eq(DutyEntity::getProjectId, dutyEntity.getProjectId());
            queryWrapper.eq(DutyEntity::getFirstImportId, dutyEntity.getFirstImportId());
            queryWrapper.eq(DutyEntity::getGatherFlag, false);
            queryWrapper.orderByDesc(DutyEntity::getDutyVersion);
            queryWrapper.last("limit 1");
            DutyEntity entity = dutyService.getOne(queryWrapper, false);
            //该导入第一次保存
            if (null == entity) {
                dutyEntity.setId(IdWorker.getId());
                BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE, InvocationInfoProxy.getTenantid(), BeanMapper.map(dutyEntity, DutyVO.class));
                CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
                if (billCode.isSuccess()) {
                    dutyEntity.setBillCode(billCode.getData());
                } else {
                    throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
                }
                dutyEntity.setShowFlag(false);
                dutyEntity.setGatherFlag(false);
                dutyEntity.setBillState(BillStateEnum.UNCOMMITED_STATE.getBillStateCode());
                dutyEntity.setLatestFlag(true);
                dutyEntity.setChangeState(ChangeStateEnum.未变更.getCode());
                dutyEntity.setEnableState(false);
                dutyEntity.setDutyVersion(1);
                dutyEntity.setFirstDutyId(dutyEntity.getId());
                dutyEntity.setCreateTime(null);
                dutyEntity.setCreateUserCode(null);
                dutyEntity.setVersion(1);

                mainSaveAndDealDetail(dutyEntity, feeVO, baseVO);
            }else{
                queryWrapper = new LambdaQueryWrapper<>();
                queryWrapper.eq(DutyEntity::getProjectId, dutyEntity.getProjectId());
                queryWrapper.eq(DutyEntity::getFirstImportId, dutyEntity.getFirstImportId());
                queryWrapper.eq(DutyEntity::getImportId, dutyEntity.getImportId());
                queryWrapper.last("limit 1");
                DutyEntity oldEntity = dutyService.getOne(queryWrapper, false);
                //变更推送
                if (null == oldEntity) {
                    dutyEntity.setId(IdWorker.getId());
                    BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE, InvocationInfoProxy.getTenantid(), BeanMapper.map(dutyEntity, DutyVO.class));
                    CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
                    if (billCode.isSuccess()) {
                        dutyEntity.setBillCode(billCode.getData());
                    } else {
                        throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
                    }
                    dutyEntity.setBeforeMny(null);
                    dutyEntity.setBeforeTaxMny(null);
                    dutyEntity.setLastDutyId(entity.getId());
                    dutyEntity.setShowFlag(false);
                    dutyEntity.setGatherFlag(false);
                    dutyEntity.setBillState(BillStateEnum.UNCOMMITED_STATE.getBillStateCode());
                    dutyEntity.setLatestFlag(true);
                    dutyEntity.setEnableState(false);
                    dutyEntity.setDutyVersion(entity.getDutyVersion() + 1);
                    dutyEntity.setFirstDutyId(entity.getFirstDutyId());
                    dutyEntity.setCreateTime(null);
                    dutyEntity.setCreateUserCode(null);

                    mainSaveAndDealDetail(dutyEntity, feeVO, baseVO);

                    entity.setLatestFlag(false);
                    entity.setChangeId(dutyEntity.getId());
                    entity.setChangeState(ChangeStateEnum.变更中.getCode());
                    dutyService.saveOrUpdate(entity);

                } else {
                    if(oldEntity.getDutyVersion() < entity.getDutyVersion()){//存在费用模式的变更单
                        throw new BusinessException("该项目存在后续责任成本变更单据！");
                    }
                    if (oldEntity.getEnableState()) {//弃审
                        oldEntity.setEnableState(false);
                        oldEntity.setBillState(BillStateEnum.UNCOMMITED_STATE.getBillStateCode());
                        oldEntity.setShowFlag(false);
                        dutyService.saveOrUpdate(oldEntity);
                        //弃审,存在前版本，单据是否生效为是
                        if (oldEntity.getLastDutyId() != null) {
                            DutyEntity revise = dutyService.getById(oldEntity.getLastDutyId());
                            revise.setChangeState(ChangeStateEnum.未变更.getCode());
                            revise.setEnableState(true);
                            revise.setShowFlag(true);
                            dutyService.saveOrUpdate(revise);
                        }
                        dutyService.gatherDuty(oldEntity.getId());
                        totalExecutionService.reCalc(oldEntity.getProjectId());
                    } else {//修改推送
                        dutyEntity.setId(IdWorker.getId());
                        dutyEntity.setBeforeMny(null);
                        dutyEntity.setBeforeTaxMny(null);
                        dutyEntity.setBillCode(oldEntity.getBillCode());
                        dutyEntity.setLastDutyId(oldEntity.getLastDutyId());
                        dutyEntity.setShowFlag(false);
                        dutyEntity.setGatherFlag(false);
                        dutyEntity.setBillState(BillStateEnum.UNCOMMITED_STATE.getBillStateCode());
                        dutyEntity.setLatestFlag(true);
                        dutyEntity.setEnableState(false);
                        dutyEntity.setDutyVersion(oldEntity.getDutyVersion());
                        dutyEntity.setFirstDutyId(oldEntity.getFirstDutyId());
                        dutyEntity.setCreateTime(null);
                        dutyEntity.setCreateUserCode(null);

                        mainSaveAndDealDetail(dutyEntity, feeVO, baseVO);

                        //物理删除
                        dutyMapper.deleteByDutyIdPhy(oldEntity.getId());
                        dutyDetailService.deleteByDutyIdPhy(oldEntity.getId());
                        dutyDetailItemService.deleteByDutyIdPhy(oldEntity.getId());

                        //变更单保存
                        if (entity.getLastDutyId() != null) {
                            DutyEntity revise = dutyService.getById(entity.getLastDutyId());
                            revise.setLatestFlag(false);
                            revise.setChangeId(dutyEntity.getId());
                            revise.setChangeState(ChangeStateEnum.变更中.getCode());
                            dutyService.saveOrUpdate(revise);
                        }
                    }
                }
            }
        } else {
            LambdaQueryWrapper<DutyEntity> queryWrapper = new LambdaQueryWrapper<>();
            queryWrapper.eq(DutyEntity::getProjectId, dutyEntity.getProjectId());
            queryWrapper.eq(DutyEntity::getFirstImportId, dutyEntity.getFirstImportId());
            queryWrapper.eq(DutyEntity::getImportId, dutyEntity.getImportId());
            queryWrapper.last("limit 1");
            DutyEntity oldEntity = dutyService.getOne(queryWrapper, false);
            oldEntity.setEnableState(true);
            oldEntity.setShowFlag(true);
            oldEntity.setBillState(BillStateEnum.COMMITED_STATE.getBillStateCode());
            dutyService.saveOrUpdate(oldEntity);
            if (oldEntity.getLastDutyId() != null) {
                DutyEntity revise = dutyService.getById(oldEntity.getLastDutyId());
                revise.setChangeState(ChangeStateEnum.已变更.getCode());
                revise.setEnableState(false);
                dutyService.saveOrUpdate(revise);
            }
            dutyService.gatherDuty(oldEntity.getId());
            totalExecutionService.reCalc(oldEntity.getProjectId());
        }
    }

    public void deleteDuty(Long importId) {
        LambdaQueryWrapper<DutyEntity> queryWrapper = new LambdaQueryWrapper<>();
        queryWrapper.eq(DutyEntity::getImportId, importId);
        DutyEntity dutyEntity = dutyService.getOne(queryWrapper, false);
        if (null != dutyEntity) {
            //物理删除
            dutyMapper.deleteByDutyIdPhy(dutyEntity.getId());
            dutyDetailService.deleteByDutyIdPhy(dutyEntity.getId());
            dutyDetailItemService.deleteByDutyIdPhy(dutyEntity.getId());
        }
    }

    private void mainSaveAndDealDetail(DutyEntity dutyEntity, FeeVO feeVO, BaseVO baseVO){
        List<DutyDetailEntity> detailEntities = new ArrayList<>();
        Map<Long, Long> pMap = new HashMap<>();
        for (FeeDetailVO detailVO : feeVO.getFeeDetailList()) {
            DutyDetailEntity detailEntity = BeanMapper.map(detailVO, DutyDetailEntity.class);
            Long newId = IdWorker.getId();
            pMap.put(detailEntity.getId(), newId);
            detailEntity.setId(newId);
            detailEntity.setDutyId(dutyEntity.getId());
            detailEntity.setFeeDetailId(detailVO.getId());
            detailEntity.setFeeDetailCode(detailVO.getCode());
            detailEntity.setFeeDetailName(detailVO.getName());
            detailEntity.setSubjectId(detailVO.getSubjectId());
            detailEntity.setSubjectCode(detailVO.getSubjectCode());
            detailEntity.setSubjectName(detailVO.getSubjectName());
            detailEntity.setOrgId(dutyEntity.getOrgId());
            detailEntity.setOrgName(dutyEntity.getOrgName());
            detailEntity.setProjectId(dutyEntity.getProjectId());
            detailEntity.setProjectName(dutyEntity.getProjectName());
            detailEntity.setCreateTime(null);
            detailEntity.setCreateUserCode(null);
            detailEntity.setUpdateTime(null);
            detailEntity.setUpdateUserCode(null);
            detailEntity.setVersion(1);
            detailEntities.add(detailEntity);
        }

        for (DutyDetailEntity detailEntity : detailEntities) {
            detailEntity.setParentId(pMap.get(detailEntity.getParentId()));
            detailEntity.setInvolveFlag(false);
        }
        dutyEntity.setDutyDetailList(detailEntities);

        handlerDetail(dutyEntity, feeVO, baseVO);

        List<DutyDetailItemEntity> itemEntities = fullMnyAndBaseInfo(dutyEntity);

        dutyService.saveOrUpdate(dutyEntity, false);

        dutyDetailItemService.saveOrUpdateBatch(itemEntities);
    }

    /**
     * 处理子表数据，不同模板需重写
     * @param dutyEntity
     * @param feeVO
     * @param baseVO 导入vo
     */
    public abstract void  handlerDetail(DutyEntity dutyEntity, FeeVO feeVO, BaseVO baseVO);

    /**
     * 校验费用模板，不同模板需重写
     * @param feeVO 费用模板VO
     */
    public abstract void checkFeeCode(FeeVO feeVO);

    private List<DutyDetailItemEntity> fullMnyAndBaseInfo(DutyEntity dutyEntity) {
        List<DutyDetailItemEntity> itemList = new ArrayList<>();
        Set<Long> materialIdSet = new HashSet<>();
        Set<Long> subIdSet = new HashSet<>();
        for (DutyDetailEntity detailEntity : dutyEntity.getDutyDetailList()) {
            if (CollectionUtils.isNotEmpty(detailEntity.getDutyDetailItemList())) {
                for (DutyDetailItemEntity itemEntity : detailEntity.getDutyDetailItemList()) {
                    itemEntity.setDutyId(dutyEntity.getId());
                    itemEntity.setDutyDetailId(detailEntity.getId());
                    itemEntity.setOrgId(dutyEntity.getOrgId());
                    itemEntity.setOrgName(dutyEntity.getOrgName());
                    itemEntity.setProjectId(dutyEntity.getProjectId());
                    itemEntity.setProjectName(dutyEntity.getProjectName());
                    itemEntity.setFeeDetailId(detailEntity.getFeeDetailId());
                    itemEntity.setFeeDetailCode(detailEntity.getFeeDetailCode());
                    itemEntity.setFeeDetailName(detailEntity.getFeeDetailName());
                    if (null == itemEntity.getSubjectId()) {
                        itemEntity.setSubjectId(detailEntity.getSubjectId());
                        itemEntity.setSubjectCode(detailEntity.getSubjectCode());
                        itemEntity.setSubjectName(detailEntity.getSubjectName());
                    }

                    detailEntity.setGatherMny(ComputeUtil.safeAdd(detailEntity.getGatherMny(), itemEntity.getMny()));
                    detailEntity.setGatherTaxMny(ComputeUtil.safeAdd(detailEntity.getGatherTaxMny(), itemEntity.getMny()));

                    if (null != itemEntity.getDocType() && DocTypeEnum.物料档案.getCode().equals(itemEntity.getDocType()) && null != itemEntity.getDocId()) {
                        materialIdSet.add(itemEntity.getDocId());
                    } if (null != itemEntity.getDocType() && (DocTypeEnum.专业分包档案.getCode().equals(itemEntity.getDocType()) || DocTypeEnum.劳务分包档案.getCode().equals(itemEntity.getDocType())) && null != itemEntity.getDocId()) {
                        subIdSet.add(itemEntity.getDocId());
                    }
                }
                itemList.addAll(detailEntity.getDutyDetailItemList());
                if (null == detailEntity.getMny() || ComputeUtil.isGreaterThan(detailEntity.getGatherMny(), detailEntity.getMny())) {
                    detailEntity.setMny(detailEntity.getGatherMny());
                    detailEntity.setTaxMny(detailEntity.getGatherTaxMny());
                }
            }
        }

        fullGuaidPrice(itemList, materialIdSet, subIdSet);

        List<Map> resultMapList = BeanMapper.mapList(dutyEntity.getDutyDetailList(), Map.class);
        List<Map<String, Object>> treeData =  ResultAsTree.createTreeData(resultMapList);
        gatherMny(null, treeData);

        List<DutyDetailEntity> entities = new ArrayList<>();
        treeToList(treeData, entities);

        dutyEntity.setDutyDetailList(entities);

        BigDecimal totalMny = BigDecimal.ZERO;
        BigDecimal totalTaxMny = BigDecimal.ZERO;
        for (DutyDetailEntity detailEntity : dutyEntity.getDutyDetailList()) {
            if (null == detailEntity.getParentId()) {
                totalMny = ComputeUtil.safeAdd(totalMny, detailEntity.getMny());
                totalTaxMny = ComputeUtil.safeAdd(totalTaxMny, detailEntity.getTaxMny());
            }
            //转换时把配置了下级分类的的费用项的下级分类ID按xx&xx的方式放到了innerCode字段，用完清空
            if(null == detailEntity.getCategoryId() && StringUtils.isNotBlank(detailEntity.getCategoryInnerCode()) && detailEntity.getCategoryInnerCode().contains("&")){
                detailEntity.setCategoryInnerCode(null);
            }
        }
        dutyEntity.setMny(totalMny);
        dutyEntity.setTaxMny(totalTaxMny);
        return itemList;
    }

    private void fullGuaidPrice(List<DutyDetailItemEntity> itemList, Set<Long> materialIdSet, Set<Long> subIdSet){
        Map<Long, MaterialPriceHistoryApiVO> matPriceMap = new HashMap<>();
        if (CollectionUtils.isNotEmpty(materialIdSet)) {
            CommonResponse<List<MaterialPriceHistoryApiVO>> response = materialPriceHistoryApi.getMaterialPriceHistoryApiVOS(new ArrayList<>(materialIdSet));
            if (response.isSuccess() && CollectionUtils.isNotEmpty(response.getData())) {
                matPriceMap = response.getData().stream().collect(Collectors.toMap(MaterialPriceHistoryApiVO::getMaterialId, Function.identity(), (key1, key2) -> key1));
            }
        }
        Map<Long, PriceContractCollectVO> subPriceMap = new HashMap<>();
        if (CollectionUtils.isNotEmpty(subIdSet)) {
            CommonResponse<List<PriceContractCollectVO>> response = priceContractCollectApi.getPriceContractByDocIds(new ArrayList<>(subIdSet));
            if (response.isSuccess() && CollectionUtils.isNotEmpty(response.getData())) {
                subPriceMap = response.getData().stream().collect(Collectors.toMap(PriceContractCollectVO::getDocId, Function.identity(), (key1, key2) -> key1));
            }
        }

        for (DutyDetailItemEntity itemEntity : itemList) {
            if (null != itemEntity.getDocType() && DocTypeEnum.物料档案.getCode().equals(itemEntity.getDocType()) && null != itemEntity.getDocId() && matPriceMap.containsKey(itemEntity.getDocId())) {
                MaterialPriceHistoryApiVO historyVO = matPriceMap.get(itemEntity.getDocId());
                itemEntity.setHistoricalPrice(historyVO.getHistoryPriceArea());
                itemEntity.setGuidePriceArea(historyVO.getGuidePriceArea());
            } if (null != itemEntity.getDocType()
                    && (DocTypeEnum.专业分包档案.getCode().equals(itemEntity.getDocType()) || DocTypeEnum.劳务分包档案.getCode().equals(itemEntity.getDocType()))
                    && null != itemEntity.getDocId() && subPriceMap.containsKey(itemEntity.getDocId())) {
                PriceContractCollectVO historyVO = subPriceMap.get(itemEntity.getDocId());
                itemEntity.setHistoricalPrice(historyVO.getContractPriceArea());
                itemEntity.setGuidePriceArea(historyVO.getGuidePriceArea());
            }
        }

    }

    /**
     * 汇总金额
     */
    private void gatherMny(Map<String, Object> now, List<Map<String, Object>> list) {
        BigDecimal mny = null;
        BigDecimal taxMny = null;
        BigDecimal gatherMny = null;
        BigDecimal gatherTaxMny = null;
        for (Map<String, Object> ypd : list) {
            if (ypd.get("children") != null) {
                gatherMny(ypd, (List) ypd.get("children"));
            }
            mny = ComputeUtil.safeAdd(mny, getBigDecimalValue(ypd, "mny"));
            taxMny = ComputeUtil.safeAdd(taxMny, getBigDecimalValue(ypd, "taxMny"));

            gatherMny = ComputeUtil.safeAdd(gatherMny, getBigDecimalValue(ypd, "gatherMny"));
            gatherTaxMny = ComputeUtil.safeAdd(gatherTaxMny, getBigDecimalValue(ypd, "gatherTaxMny"));
        }
        if (now != null) {
            now.put("gatherMny", gatherMny);
            now.put("gatherTaxMny", gatherTaxMny);
            if (ComputeUtil.isGreaterThan(mny, getBigDecimalValue(now, "mny")) || ComputeUtil.isGreaterThan(taxMny, getBigDecimalValue(now, "taxMny"))) {
                now.put("mny", mny);
                now.put("taxMny", taxMny);
            }
        }
    }

    private void treeToList(List<Map<String, Object>> treeData, List<DutyDetailEntity> entities) {
        for (Map<String, Object> ypd : treeData) {
            if (ypd.get("children") != null) {
                treeToList((List) ypd.get("children"), entities);
            }
            entities.add(BeanMapper.map(ypd, DutyDetailEntity.class));
        }
    }

    private BigDecimal getBigDecimalValue(Map<String, Object> ypd, String code) {
        return ypd.get(code) == null ? null : (BigDecimal) ypd.get(code);
    }



    private void checkFeeId(DutyEntity dutyEntity) {
        LambdaQueryWrapper<DutyEntity> queryWrapper = new LambdaQueryWrapper<>();
        queryWrapper.eq(DutyEntity::getProjectId, dutyEntity.getProjectId());
        queryWrapper.ne(DutyEntity::getImportId, dutyEntity.getImportId());
        List<DutyEntity> list = dutyService.list(queryWrapper);
        for (DutyEntity dbDutyEntity : list) {
            if (dbDutyEntity.getFeeId().compareTo(dutyEntity.getFeeId()) != 0) {
                throw new BusinessException("同一项目只能使用同一费用模板！");
            }
        }
    }
}
