/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.targetcost.handler;

import com.ejianc.business.sx2j.build.vo.BuildDutyVO;
import com.ejianc.business.sx2j.build.vo.BuildEquipmentVO;
import com.ejianc.business.sx2j.build.vo.BuildMaterialVO;
import com.ejianc.business.sx2j.build.vo.BuildRgcostVO;
import com.ejianc.business.sx2j.build.vo.BuildSubVO;
import com.ejianc.business.sx2j.build.vo.CommonImportDataVO;
import com.ejianc.business.targetcost.bean.DutyDetailEntity;
import com.ejianc.business.targetcost.bean.DutyDetailItemEntity;
import com.ejianc.business.targetcost.bean.DutyEntity;
import com.ejianc.business.targetcost.enums.ConversionEnum;
import com.ejianc.business.targetcost.enums.DocTypeEnum;
import com.ejianc.business.targetcost.handler.ConversionBaseHandler;
import com.ejianc.business.targetcost.handler.IConversioneHandler;
import com.ejianc.business.targetcost.utils.TreeNodeBUtil;
import com.ejianc.business.targetcost.vo.FeeDetailVO;
import com.ejianc.business.targetcost.vo.FeeVO;
import com.ejianc.foundation.share.api.IShareEquipmentApi;
import com.ejianc.foundation.share.api.IShareLabsubApi;
import com.ejianc.foundation.share.api.IShareMaterialApi;
import com.ejianc.foundation.share.api.IShareProsubApi;
import com.ejianc.foundation.share.vo.EquipmentCategoryVO;
import com.ejianc.foundation.share.vo.EquipmentVO;
import com.ejianc.foundation.share.vo.LabsubCategoryVO;
import com.ejianc.foundation.share.vo.LabsubItemVO;
import com.ejianc.foundation.share.vo.MaterialCategoryVO;
import com.ejianc.foundation.share.vo.MaterialVO;
import com.ejianc.foundation.share.vo.ProsubCategoryVO;
import com.ejianc.foundation.share.vo.ProsubItemVO;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.ejianc.support.idworker.util.IdWorker;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.RequestContextHolder;

@Service(value="sX2JBuildHandler")
public class SX2JBuildHandler
extends ConversionBaseHandler
implements IConversioneHandler {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IShareMaterialApi shareMaterialApi;
    @Autowired
    private IShareEquipmentApi shareEquipmentApi;
    @Autowired
    private IShareLabsubApi shareLabsubApi;
    @Autowired
    private IShareProsubApi shareProsubApi;

    @Override
    public CommonResponse<String> push(BaseVO baseVO, Boolean isEff) {
        BuildDutyVO buildDutyVO = (BuildDutyVO)baseVO;
        DutyEntity dutyEntity = (DutyEntity)((Object)BeanMapper.map((Object)((Object)buildDutyVO), DutyEntity.class));
        dutyEntity.setFirstImportId(buildDutyVO.getBaseDutyId());
        dutyEntity.setImportId(buildDutyVO.getId());
        dutyEntity.setImportType(ConversionEnum.\u9655\u5efa\u623f\u5efa.getCode());
        this.handlerHead(dutyEntity, isEff, baseVO);
        return CommonResponse.success((String)"\u5bfc\u5165\u8f6c\u6362\u76ee\u6807\u6210\u672c\u5355\u636e\u6210\u529f\uff01");
    }

    @Override
    public CommonResponse<String> delete(Long importId) {
        this.deleteDuty(importId);
        return CommonResponse.success((String)"\u5220\u9664\u76ee\u6807\u6210\u672c\u5355\u636e\u6210\u529f\uff01");
    }

    /*
     * WARNING - void declaration
     */
    private DutyEntity dealLasubData(BuildDutyVO buildDutyVO, DutyEntity sourceDutyEntity, FeeVO feeVO, Object restApi) {
        void var9_12;
        DutyEntity dutyEntity = (DutyEntity)((Object)BeanMapper.map((Object)((Object)sourceDutyEntity), DutyEntity.class));
        IShareLabsubApi _restApi = (IShareLabsubApi)restApi;
        Long rgfId = null;
        for (FeeDetailVO feeDetailVO : feeVO.getFeeDetailList()) {
            if (!Long.valueOf("546645586985238533").equals(feeDetailVO.getFeePropId())) continue;
            rgfId = feeDetailVO.getId();
        }
        if (null == rgfId) {
            throw new BusinessException("\u8d39\u7528\u6a21\u677f\u4e2d\u672a\u914d\u7f6e\u3010\u4eba\u5de5\u8d39\u3011\u7684\u8d39\u7528\u9879\uff0c\u65e0\u6cd5\u8f6c\u6362\uff01");
        }
        HashSet<Long> rgfSet = new HashSet<Long>();
        for (FeeDetailVO feeDetailVO : feeVO.getFeeDetailList()) {
            if (!feeDetailVO.getInnerCode().contains(String.valueOf(rgfId))) continue;
            rgfSet.add(feeDetailVO.getId());
        }
        Object var9_11 = null;
        for (FeeDetailVO detailVO : feeVO.getFeeDetailList()) {
            if (!Long.valueOf("546645586985238534").equals(detailVO.getFeePropId()) || !rgfSet.contains(detailVO.getId())) continue;
            Long l = detailVO.getId();
        }
        if (null == var9_12) {
            throw new BusinessException("\u8d39\u7528\u6a21\u677f\u4e2d\u672a\u914d\u7f6e\u3010\u5176\u4ed6\u4eba\u5de5\u8d39\u3011\u7684\u8d39\u7528\u9879\uff0c\u65e0\u6cd5\u8f6c\u6362\uff01");
        }
        List list = buildDutyVO.getBuildRgcostList().stream().filter(rgcostVO -> null != rgcostVO.getLeafFlag() && rgcostVO.getLeafFlag() != false && StringUtils.isNotBlank((CharSequence)rgcostVO.getRgcostCode())).map(BuildRgcostVO::getRgcostCode).collect(Collectors.toList());
        CommonResponse labCtyResponse = _restApi.queryCategoryListByIds(new ArrayList());
        Map<Object, Object> labCtyInnerCodeMap = new HashMap();
        if (labCtyResponse.isSuccess() && CollectionUtils.isNotEmpty((Collection)((Collection)labCtyResponse.getData()))) {
            labCtyInnerCodeMap = ((List)labCtyResponse.getData()).stream().collect(Collectors.toMap(BaseVO::getId, LabsubCategoryVO::getInnerCode, (key1, key2) -> key1));
        }
        Map<Object, Object> labSubMap = new HashMap();
        CommonResponse labItemResponse = _restApi.queryItemListByCodes(list);
        if (labItemResponse.isSuccess() && CollectionUtils.isNotEmpty((Collection)((Collection)labItemResponse.getData()))) {
            labSubMap = ((List)labItemResponse.getData()).stream().collect(Collectors.toMap(LabsubItemVO::getTrawlingCode, Function.identity(), (key1, key2) -> key1));
        }
        for (BuildRgcostVO rgcostVO2 : buildDutyVO.getBuildRgcostList()) {
            if (null == rgcostVO2.getLeafFlag() || !rgcostVO2.getLeafFlag().booleanValue()) continue;
            for (DutyDetailEntity detailEntity : dutyEntity.getDutyDetailList()) {
                if (!detailEntity.getLeafFlag().booleanValue()) continue;
                if (StringUtils.isNotBlank((CharSequence)rgcostVO2.getRgcostCode()) && labSubMap.containsKey(rgcostVO2.getRgcostCode())) {
                    LabsubItemVO labsubItemVO = (LabsubItemVO)labSubMap.get(rgcostVO2.getRgcostCode());
                    String innerCode = (String)labCtyInnerCodeMap.get(labsubItemVO.getCategoryId());
                    if ((null == detailEntity.getCategoryId() || !innerCode.contains(String.valueOf(detailEntity.getCategoryId()))) && (null != detailEntity.getCategoryId() || !TreeNodeBUtil.judgeContain(innerCode, detailEntity.getCategoryInnerCode()) || !rgfSet.contains(detailEntity.getFeeDetailId()))) continue;
                    ArrayList<DutyDetailItemEntity> itemList = CollectionUtils.isNotEmpty(detailEntity.getDutyDetailItemList()) ? detailEntity.getDutyDetailItemList() : new ArrayList<DutyDetailItemEntity>();
                    DutyDetailItemEntity itemEntity = new DutyDetailItemEntity();
                    itemEntity.setId(IdWorker.getId());
                    itemEntity.setCode(labsubItemVO.getTrawlingCode());
                    itemEntity.setName(labsubItemVO.getTrawlingName());
                    itemEntity.setPriceType(labsubItemVO.getPriceType());
                    itemEntity.setJobContent(labsubItemVO.getJobContent());
                    itemEntity.setUnitName(labsubItemVO.getUnitName());
                    itemEntity.setTaxRate(rgcostVO2.getRgcostRate());
                    itemEntity.setPrice(rgcostVO2.getRgcostPrice());
                    itemEntity.setTaxPrice(rgcostVO2.getRgcostTaxPrice());
                    itemEntity.setAmount(rgcostVO2.getRgcostNum());
                    itemEntity.setMny(rgcostVO2.getRgcostMny());
                    itemEntity.setTaxMny(rgcostVO2.getRgcostTaxMny());
                    itemEntity.setCategoryId(labsubItemVO.getCategoryId());
                    itemEntity.setCategoryInnerCode(innerCode);
                    itemEntity.setCategoryName(labsubItemVO.getCategoryName());
                    itemEntity.setDocType(DocTypeEnum.\u52b3\u52a1\u5206\u5305\u6863\u6848.getCode());
                    itemEntity.setDocId(labsubItemVO.getId());
                    itemList.add(itemEntity);
                    detailEntity.setDutyDetailItemList(itemList);
                    continue;
                }
                if (!detailEntity.getFeeDetailId().equals(var9_12)) continue;
                ArrayList<DutyDetailItemEntity> itemList = CollectionUtils.isNotEmpty(detailEntity.getDutyDetailItemList()) ? detailEntity.getDutyDetailItemList() : new ArrayList<DutyDetailItemEntity>();
                DutyDetailItemEntity itemEntity = new DutyDetailItemEntity();
                itemEntity.setId(IdWorker.getId());
                itemEntity.setCode(rgcostVO2.getRgcostCode());
                itemEntity.setName(rgcostVO2.getRgcostName());
                itemEntity.setUnitName(rgcostVO2.getRgcostUnitName());
                itemEntity.setTaxRate(rgcostVO2.getRgcostRate());
                itemEntity.setPrice(rgcostVO2.getRgcostPrice());
                itemEntity.setTaxPrice(rgcostVO2.getRgcostTaxPrice());
                itemEntity.setAmount(rgcostVO2.getRgcostNum());
                itemEntity.setMny(rgcostVO2.getRgcostMny());
                itemEntity.setTaxMny(rgcostVO2.getRgcostTaxMny());
                itemEntity.setDocType(6);
                itemList.add(itemEntity);
                detailEntity.setDutyDetailItemList(itemList);
            }
        }
        return dutyEntity;
    }

    /*
     * WARNING - void declaration
     */
    private DutyEntity dealProsubData(BuildDutyVO buildDutyVO, DutyEntity sourceDutyEntity, FeeVO feeVO, Object restApi) {
        void var9_12;
        DutyEntity dutyEntity = (DutyEntity)((Object)BeanMapper.map((Object)((Object)sourceDutyEntity), DutyEntity.class));
        IShareProsubApi _restApi = (IShareProsubApi)restApi;
        Long zyfbId = null;
        for (FeeDetailVO feeDetailVO : feeVO.getFeeDetailList()) {
            if (!Long.valueOf("546645586985238540").equals(feeDetailVO.getFeePropId())) continue;
            zyfbId = feeDetailVO.getId();
        }
        if (null == zyfbId) {
            throw new BusinessException("\u8d39\u7528\u6a21\u677f\u4e2d\u672a\u914d\u7f6e\u3010\u4e13\u4e1a\u5206\u5305\u8d39\u3011\u7684\u8d39\u7528\u9879\uff0c\u65e0\u6cd5\u8f6c\u6362\uff01");
        }
        HashSet<Long> zyfbSet = new HashSet<Long>();
        for (FeeDetailVO feeDetailVO : feeVO.getFeeDetailList()) {
            if (!feeDetailVO.getInnerCode().contains(String.valueOf(zyfbId))) continue;
            zyfbSet.add(feeDetailVO.getId());
        }
        Object var9_11 = null;
        for (FeeDetailVO detailVO : feeVO.getFeeDetailList()) {
            if (!Long.valueOf("546645586985238541").equals(detailVO.getFeePropId()) || !zyfbSet.contains(detailVO.getId())) continue;
            Long l = detailVO.getId();
        }
        if (null == var9_12) {
            throw new BusinessException("\u8d39\u7528\u6a21\u677f\u4e2d\u672a\u914d\u7f6e\u3010\u5176\u4ed6\u4e13\u4e1a\u5206\u5305\u8d39\u3011\u7684\u8d39\u7528\u9879\uff0c\u65e0\u6cd5\u8f6c\u6362\uff01");
        }
        List list = buildDutyVO.getBuildSubList().stream().filter(subVO -> null != subVO.getLeafFlag() && subVO.getLeafFlag() != false && StringUtils.isNotBlank((CharSequence)subVO.getSubCode())).map(BuildSubVO::getSubCode).collect(Collectors.toList());
        CommonResponse proCtyResponse = _restApi.queryCategoryListByIds(new ArrayList());
        Map<Object, Object> proCtyInnerCodeMap = new HashMap();
        if (proCtyResponse.isSuccess() && CollectionUtils.isNotEmpty((Collection)((Collection)proCtyResponse.getData()))) {
            proCtyInnerCodeMap = ((List)proCtyResponse.getData()).stream().collect(Collectors.toMap(BaseVO::getId, ProsubCategoryVO::getInnerCode, (key1, key2) -> key1));
        }
        Map<Object, Object> proSubMap = new HashMap();
        CommonResponse proItemResponse = _restApi.queryItemListByCodes(list);
        if (proItemResponse.isSuccess() && CollectionUtils.isNotEmpty((Collection)((Collection)proItemResponse.getData()))) {
            proSubMap = ((List)proItemResponse.getData()).stream().collect(Collectors.toMap(ProsubItemVO::getTrawlingCode, Function.identity(), (key1, key2) -> key1));
        }
        for (BuildSubVO subVO2 : buildDutyVO.getBuildSubList()) {
            if (null == subVO2.getLeafFlag() || !subVO2.getLeafFlag().booleanValue()) continue;
            for (DutyDetailEntity detailEntity : dutyEntity.getDutyDetailList()) {
                if (!detailEntity.getLeafFlag().booleanValue()) continue;
                if (StringUtils.isNotBlank((CharSequence)subVO2.getSubCode()) && proSubMap.containsKey(subVO2.getSubCode())) {
                    ProsubItemVO prosubItemVO = (ProsubItemVO)proSubMap.get(subVO2.getSubCode());
                    String innerCode = (String)proCtyInnerCodeMap.get(prosubItemVO.getCategoryId());
                    if ((null == detailEntity.getCategoryId() || !innerCode.contains(String.valueOf(detailEntity.getCategoryId()))) && (null != detailEntity.getCategoryId() || !TreeNodeBUtil.judgeContain(innerCode, detailEntity.getCategoryInnerCode()) || !zyfbSet.contains(detailEntity.getFeeDetailId()))) continue;
                    ArrayList<DutyDetailItemEntity> itemList = CollectionUtils.isNotEmpty(detailEntity.getDutyDetailItemList()) ? detailEntity.getDutyDetailItemList() : new ArrayList<DutyDetailItemEntity>();
                    DutyDetailItemEntity itemEntity = new DutyDetailItemEntity();
                    itemEntity.setId(IdWorker.getId());
                    itemEntity.setCode(prosubItemVO.getTrawlingCode());
                    itemEntity.setName(prosubItemVO.getTrawlingName());
                    itemEntity.setPriceType(prosubItemVO.getPriceType());
                    itemEntity.setJobContent(prosubItemVO.getJobContent());
                    itemEntity.setUnitName(prosubItemVO.getUnitName());
                    itemEntity.setTaxRate(subVO2.getSubRate());
                    itemEntity.setPrice(subVO2.getSubPrice());
                    itemEntity.setTaxPrice(subVO2.getSubTaxPrice());
                    itemEntity.setAmount(subVO2.getSubNum());
                    itemEntity.setMny(subVO2.getSubMny());
                    itemEntity.setTaxMny(subVO2.getSubTaxMny());
                    itemEntity.setCategoryId(prosubItemVO.getCategoryId());
                    itemEntity.setCategoryInnerCode(innerCode);
                    itemEntity.setCategoryName(prosubItemVO.getCategoryName());
                    itemEntity.setDocType(DocTypeEnum.\u4e13\u4e1a\u5206\u5305\u6863\u6848.getCode());
                    itemEntity.setDocId(prosubItemVO.getId());
                    itemList.add(itemEntity);
                    detailEntity.setDutyDetailItemList(itemList);
                    continue;
                }
                if (!detailEntity.getFeeDetailId().equals(var9_12)) continue;
                ArrayList<DutyDetailItemEntity> itemList = CollectionUtils.isNotEmpty(detailEntity.getDutyDetailItemList()) ? detailEntity.getDutyDetailItemList() : new ArrayList<DutyDetailItemEntity>();
                DutyDetailItemEntity itemEntity = new DutyDetailItemEntity();
                itemEntity.setId(IdWorker.getId());
                itemEntity.setCode(subVO2.getSubCode());
                itemEntity.setName(subVO2.getSubName());
                itemEntity.setUnitName(subVO2.getSubUnitName());
                itemEntity.setTaxRate(subVO2.getSubRate());
                itemEntity.setPrice(subVO2.getSubPrice());
                itemEntity.setTaxPrice(subVO2.getSubTaxPrice());
                itemEntity.setAmount(subVO2.getSubNum());
                itemEntity.setMny(subVO2.getSubMny());
                itemEntity.setTaxMny(subVO2.getSubTaxMny());
                itemEntity.setDocType(6);
                itemList.add(itemEntity);
                detailEntity.setDutyDetailItemList(itemList);
            }
        }
        return dutyEntity;
    }

    /*
     * WARNING - void declaration
     */
    private DutyEntity dealMaterialData(BuildDutyVO buildDutyVO, DutyEntity sourceDutyEntity, FeeVO feeVO, Object restApi) {
        void var11_14;
        DutyEntity dutyEntity = (DutyEntity)((Object)BeanMapper.map((Object)((Object)sourceDutyEntity), DutyEntity.class));
        IShareMaterialApi _restApi = (IShareMaterialApi)restApi;
        HashMap<Long, String> matCtyLongInnerMap = new HashMap<Long, String>();
        HashMap<String, String> matCtyStringInnerMap = new HashMap<String, String>();
        Long clfId = null;
        for (FeeDetailVO feeDetailVO : feeVO.getFeeDetailList()) {
            if (!Long.valueOf("546645586985238535").equals(feeDetailVO.getFeePropId())) continue;
            clfId = feeDetailVO.getId();
        }
        if (null == clfId) {
            throw new BusinessException("\u8d39\u7528\u6a21\u677f\u4e2d\u672a\u914d\u7f6e\u3010\u6750\u6599\u8d39\u3011\u7684\u8d39\u7528\u9879\uff0c\u65e0\u6cd5\u8f6c\u6362\uff01");
        }
        HashSet<Long> clfSet = new HashSet<Long>();
        for (FeeDetailVO feeDetailVO : feeVO.getFeeDetailList()) {
            if (!feeDetailVO.getInnerCode().contains(String.valueOf(clfId))) continue;
            clfSet.add(feeDetailVO.getId());
        }
        Object var11_13 = null;
        for (FeeDetailVO detailVO : feeVO.getFeeDetailList()) {
            if (!Long.valueOf("546645586985238539").equals(detailVO.getFeePropId()) || !clfSet.contains(detailVO.getId())) continue;
            Long l = detailVO.getId();
        }
        if (null == var11_14) {
            throw new BusinessException("\u8d39\u7528\u6a21\u677f\u4e2d\u672a\u914d\u7f6e\u3010\u5176\u4ed6\u6750\u6599\u8d39\u3011\u7684\u8d39\u7528\u9879\uff0c\u65e0\u6cd5\u8f6c\u6362\uff01");
        }
        List list = buildDutyVO.getBuildMaterialList().stream().filter(item -> null != item.getLeafFlag() && item.getLeafFlag() != false && StringUtils.isNotBlank((CharSequence)item.getMaterialCode())).map(BuildMaterialVO::getMaterialCode).collect(Collectors.toList());
        CommonResponse matResponse = _restApi.queryMaterialListByCodes(list);
        Map<Object, Object> matMap = new HashMap();
        if (matResponse.isSuccess() && CollectionUtils.isNotEmpty((Collection)((Collection)matResponse.getData()))) {
            matMap = ((List)matResponse.getData()).stream().collect(Collectors.toMap(MaterialVO::getCode, Function.identity(), (key1, key2) -> key1));
        }
        int num = 1;
        for (BuildMaterialVO buildMaterialVO : buildDutyVO.getBuildMaterialList()) {
            if (null == buildMaterialVO.getLeafFlag() || !buildMaterialVO.getLeafFlag().booleanValue()) continue;
            for (DutyDetailEntity detailEntity : dutyEntity.getDutyDetailList()) {
                MaterialVO materialVO;
                if (!detailEntity.getLeafFlag().booleanValue()) continue;
                if (StringUtils.isNotBlank((CharSequence)buildMaterialVO.getMaterialCode())) {
                    CommonResponse response;
                    if (matMap.containsKey(buildMaterialVO.getMaterialCode())) {
                        materialVO = (MaterialVO)matMap.get(buildMaterialVO.getMaterialCode());
                        if (!matCtyLongInnerMap.containsKey(materialVO.getCategoryId())) {
                            CommonResponse response2 = _restApi.queryCategoryById(materialVO.getCategoryId());
                            MaterialCategoryVO categoryVO = (MaterialCategoryVO)response2.getData();
                            matCtyLongInnerMap.put(categoryVO.getId(), categoryVO.getInnerCode());
                            matCtyStringInnerMap.put(categoryVO.getCode(), categoryVO.getInnerCode());
                        }
                    } else if (!matCtyStringInnerMap.containsKey(buildMaterialVO.getMaterialCode()) && (response = _restApi.queryCategoryByCode(buildMaterialVO.getMaterialCode())).isSuccess() && null != response.getData()) {
                        MaterialCategoryVO categoryVO = (MaterialCategoryVO)response.getData();
                        matCtyLongInnerMap.put(categoryVO.getId(), categoryVO.getInnerCode());
                        matCtyStringInnerMap.put(categoryVO.getCode(), categoryVO.getInnerCode());
                    }
                }
                if (StringUtils.isNotBlank((CharSequence)buildMaterialVO.getMaterialCode()) && matMap.containsKey(buildMaterialVO.getMaterialCode())) {
                    materialVO = (MaterialVO)matMap.get(buildMaterialVO.getMaterialCode());
                    String innerCode = (String)matCtyLongInnerMap.get(materialVO.getCategoryId());
                    if ((null == detailEntity.getCategoryId() || !innerCode.contains(String.valueOf(detailEntity.getCategoryId()))) && (null != detailEntity.getCategoryId() || !TreeNodeBUtil.judgeContain(innerCode, detailEntity.getCategoryInnerCode()) || !clfSet.contains(detailEntity.getFeeDetailId()))) continue;
                    ArrayList<DutyDetailItemEntity> itemList = CollectionUtils.isNotEmpty(detailEntity.getDutyDetailItemList()) ? detailEntity.getDutyDetailItemList() : new ArrayList<DutyDetailItemEntity>();
                    DutyDetailItemEntity itemEntity = new DutyDetailItemEntity();
                    itemEntity.setId(IdWorker.getId());
                    itemEntity.setCode(materialVO.getCode());
                    itemEntity.setName(materialVO.getName());
                    itemEntity.setModel(materialVO.getSpec());
                    itemEntity.setUnitId(materialVO.getUnitId());
                    itemEntity.setUnitName(materialVO.getUnitName());
                    itemEntity.setTaxRate(buildMaterialVO.getMaterialRate());
                    itemEntity.setPrice(buildMaterialVO.getMaterialPrice());
                    itemEntity.setTaxPrice(buildMaterialVO.getMaterialTaxPrice());
                    itemEntity.setAmount(buildMaterialVO.getMaterialNum());
                    itemEntity.setMny(buildMaterialVO.getMaterialMny());
                    itemEntity.setTaxMny(buildMaterialVO.getMaterialTaxMny());
                    itemEntity.setCategoryId(materialVO.getCategoryId());
                    itemEntity.setCategoryInnerCode(innerCode);
                    itemEntity.setCategoryName(materialVO.getCategoryName());
                    itemEntity.setDocType(DocTypeEnum.\u7269\u6599\u6863\u6848.getCode());
                    itemEntity.setDocId(materialVO.getId());
                    itemList.add(itemEntity);
                    detailEntity.setDutyDetailItemList(itemList);
                    continue;
                }
                if (StringUtils.isNotBlank((CharSequence)buildMaterialVO.getMaterialCode()) && matCtyStringInnerMap.containsKey(buildMaterialVO.getMaterialCode())) {
                    String innerCode = (String)matCtyStringInnerMap.get(buildMaterialVO.getMaterialCode());
                    if ((null == detailEntity.getCategoryId() || !innerCode.contains(String.valueOf(detailEntity.getCategoryId()))) && (null != detailEntity.getCategoryId() || !TreeNodeBUtil.judgeContain(innerCode, detailEntity.getCategoryInnerCode()) || !clfSet.contains(detailEntity.getFeeDetailId()))) continue;
                    detailEntity.setPreTypeAmount(ComputeUtil.safeAdd((BigDecimal)detailEntity.getPreTypeAmount(), (BigDecimal)buildMaterialVO.getMaterialNum()));
                    detailEntity.setMny(ComputeUtil.safeAdd((BigDecimal)detailEntity.getMny(), (BigDecimal)buildMaterialVO.getMaterialMny()));
                    detailEntity.setTaxMny(ComputeUtil.safeAdd((BigDecimal)detailEntity.getTaxMny(), (BigDecimal)buildMaterialVO.getMaterialTaxMny()));
                    continue;
                }
                if (!detailEntity.getFeeDetailId().equals(var11_14)) continue;
                ArrayList<DutyDetailItemEntity> itemList = CollectionUtils.isNotEmpty(detailEntity.getDutyDetailItemList()) ? detailEntity.getDutyDetailItemList() : new ArrayList<DutyDetailItemEntity>();
                DutyDetailItemEntity itemEntity = new DutyDetailItemEntity();
                itemEntity.setId(IdWorker.getId());
                if (StringUtils.isBlank((CharSequence)buildMaterialVO.getMaterialCode())) {
                    itemEntity.setCode(String.valueOf(num));
                    ++num;
                } else {
                    itemEntity.setCode(buildMaterialVO.getMaterialCode());
                }
                itemEntity.setName(buildMaterialVO.getMaterialName());
                itemEntity.setUnitName(buildMaterialVO.getMaterialUnitName());
                itemEntity.setTaxRate(buildMaterialVO.getMaterialRate());
                itemEntity.setPrice(buildMaterialVO.getMaterialPrice());
                itemEntity.setTaxPrice(buildMaterialVO.getMaterialTaxPrice());
                itemEntity.setAmount(buildMaterialVO.getMaterialNum());
                itemEntity.setMny(buildMaterialVO.getMaterialMny());
                itemEntity.setTaxMny(buildMaterialVO.getMaterialTaxMny());
                itemEntity.setDocType(6);
                itemList.add(itemEntity);
                detailEntity.setDutyDetailItemList(itemList);
            }
        }
        return dutyEntity;
    }

    /*
     * WARNING - void declaration
     */
    private DutyEntity dealEquipData(BuildDutyVO buildDutyVO, DutyEntity sourceDutyEntity, FeeVO feeVO, Object restApi) {
        void var9_12;
        DutyEntity dutyEntity = (DutyEntity)((Object)BeanMapper.map((Object)((Object)sourceDutyEntity), DutyEntity.class));
        IShareEquipmentApi _restApi = (IShareEquipmentApi)restApi;
        Long jxfId = null;
        for (FeeDetailVO feeDetailVO : feeVO.getFeeDetailList()) {
            if (!Long.valueOf("546645586985238542").equals(feeDetailVO.getFeePropId())) continue;
            jxfId = feeDetailVO.getId();
        }
        if (null == jxfId) {
            throw new BusinessException("\u8d39\u7528\u6a21\u677f\u4e2d\u672a\u914d\u7f6e\u3010\u673a\u68b0\u8bbe\u5907\u8d39\u3011\u7684\u8d39\u7528\u9879\uff0c\u65e0\u6cd5\u8f6c\u6362\uff01");
        }
        HashSet<Long> jxfSet = new HashSet<Long>();
        for (FeeDetailVO feeDetailVO : feeVO.getFeeDetailList()) {
            if (!feeDetailVO.getInnerCode().contains(String.valueOf(jxfId))) continue;
            jxfSet.add(feeDetailVO.getId());
        }
        Object var9_11 = null;
        for (FeeDetailVO detailVO : feeVO.getFeeDetailList()) {
            if (!Long.valueOf("546645586985238543").equals(detailVO.getFeePropId()) || !jxfSet.contains(detailVO.getId())) continue;
            Long l = detailVO.getId();
        }
        if (null == var9_12) {
            throw new BusinessException("\u8d39\u7528\u6a21\u677f\u4e2d\u672a\u914d\u7f6e\u3010\u5176\u4ed6\u673a\u68b0\u8bbe\u5907\u8d39\u3011\u7684\u8d39\u7528\u9879\uff0c\u65e0\u6cd5\u8f6c\u6362\uff01");
        }
        CommonResponse commonResponse = _restApi.queryCategoryListByIds(new ArrayList());
        HashMap<Long, String> equipCtyLongInnerMap = new HashMap<Long, String>();
        HashMap<String, String> equipCtyStringInnerMap = new HashMap<String, String>();
        for (EquipmentCategoryVO categoryVO : (List)commonResponse.getData()) {
            equipCtyLongInnerMap.put(categoryVO.getId(), categoryVO.getInnerCode());
            equipCtyStringInnerMap.put(categoryVO.getCode(), categoryVO.getInnerCode());
        }
        List codeList = buildDutyVO.getBuildEquipmentList().stream().filter(equipmentVO -> null != equipmentVO.getLeafFlag() && equipmentVO.getLeafFlag() != false && StringUtils.isNotBlank((CharSequence)equipmentVO.getEquipmentCode())).map(BuildEquipmentVO::getEquipmentCode).collect(Collectors.toList());
        CommonResponse equipResponse = _restApi.queryEquipmentListByCodes(codeList);
        Map<Object, Object> equipMap = new HashMap();
        if (equipResponse.isSuccess() && CollectionUtils.isNotEmpty((Collection)((Collection)equipResponse.getData()))) {
            equipMap = ((List)equipResponse.getData()).stream().collect(Collectors.toMap(EquipmentVO::getCode, Function.identity(), (key1, key2) -> key1));
        }
        int num = 1;
        for (BuildEquipmentVO buildEquipmentVO : buildDutyVO.getBuildEquipmentList()) {
            if (null == buildEquipmentVO.getLeafFlag() || !buildEquipmentVO.getLeafFlag().booleanValue()) continue;
            for (DutyDetailEntity detailEntity : dutyEntity.getDutyDetailList()) {
                if (!detailEntity.getLeafFlag().booleanValue()) continue;
                if (StringUtils.isNotBlank((CharSequence)buildEquipmentVO.getEquipmentCode()) && equipMap.containsKey(buildEquipmentVO.getEquipmentCode())) {
                    EquipmentVO equipmentVO2 = (EquipmentVO)equipMap.get(buildEquipmentVO.getEquipmentCode());
                    String innerCode = (String)equipCtyLongInnerMap.get(equipmentVO2.getCategoryId());
                    if ((null == detailEntity.getCategoryId() || !innerCode.contains(String.valueOf(detailEntity.getCategoryId()))) && (null != detailEntity.getCategoryId() || !TreeNodeBUtil.judgeContain(innerCode, detailEntity.getCategoryInnerCode()) || !jxfSet.contains(detailEntity.getFeeDetailId()))) continue;
                    ArrayList<DutyDetailItemEntity> itemList = CollectionUtils.isNotEmpty(detailEntity.getDutyDetailItemList()) ? detailEntity.getDutyDetailItemList() : new ArrayList<DutyDetailItemEntity>();
                    DutyDetailItemEntity itemEntity = new DutyDetailItemEntity();
                    itemEntity.setId(IdWorker.getId());
                    itemEntity.setCode(equipmentVO2.getCode());
                    itemEntity.setName(equipmentVO2.getName());
                    itemEntity.setModel(equipmentVO2.getSpec());
                    itemEntity.setUnitId(equipmentVO2.getUnitId());
                    itemEntity.setUnitName(equipmentVO2.getUnitName());
                    itemEntity.setTaxRate(buildEquipmentVO.getEquipmentRate());
                    itemEntity.setPrice(buildEquipmentVO.getEquipmentPrice());
                    itemEntity.setTaxPrice(buildEquipmentVO.getEquipmentTaxPrice());
                    itemEntity.setAmount(buildEquipmentVO.getEquipmentNum());
                    itemEntity.setMny(buildEquipmentVO.getEquipmentMny());
                    itemEntity.setTaxMny(buildEquipmentVO.getEquipmentTaxMny());
                    itemEntity.setRmatRentMonth(buildEquipmentVO.getEquipmentRentMonth());
                    itemEntity.setCategoryId(equipmentVO2.getCategoryId());
                    itemEntity.setCategoryInnerCode(innerCode);
                    itemEntity.setCategoryName(equipmentVO2.getCategoryName());
                    itemEntity.setDocType(DocTypeEnum.\u8bbe\u5907\u6863\u6848.getCode());
                    itemEntity.setDocId(equipmentVO2.getId());
                    itemList.add(itemEntity);
                    detailEntity.setDutyDetailItemList(itemList);
                    continue;
                }
                if (StringUtils.isNotBlank((CharSequence)buildEquipmentVO.getEquipmentCode()) && equipCtyStringInnerMap.containsKey(buildEquipmentVO.getEquipmentCode())) {
                    String innerCode = (String)equipCtyStringInnerMap.get(buildEquipmentVO.getEquipmentCode());
                    if ((null == detailEntity.getCategoryId() || !innerCode.contains(String.valueOf(detailEntity.getCategoryId()))) && (null != detailEntity.getCategoryId() || !TreeNodeBUtil.judgeContain(innerCode, detailEntity.getCategoryInnerCode()) || !jxfSet.contains(detailEntity.getFeeDetailId()))) continue;
                    detailEntity.setPreTypeAmount(ComputeUtil.safeAdd((BigDecimal)detailEntity.getPreTypeAmount(), (BigDecimal)buildEquipmentVO.getEquipmentNum()));
                    detailEntity.setMny(ComputeUtil.safeAdd((BigDecimal)detailEntity.getMny(), (BigDecimal)buildEquipmentVO.getEquipmentMny()));
                    detailEntity.setTaxMny(ComputeUtil.safeAdd((BigDecimal)detailEntity.getTaxMny(), (BigDecimal)buildEquipmentVO.getEquipmentTaxMny()));
                    continue;
                }
                if (!detailEntity.getFeeDetailId().equals(var9_12)) continue;
                ArrayList<DutyDetailItemEntity> itemList = CollectionUtils.isNotEmpty(detailEntity.getDutyDetailItemList()) ? detailEntity.getDutyDetailItemList() : new ArrayList<DutyDetailItemEntity>();
                DutyDetailItemEntity itemEntity = new DutyDetailItemEntity();
                itemEntity.setId(IdWorker.getId());
                if (StringUtils.isBlank((CharSequence)buildEquipmentVO.getEquipmentCode())) {
                    itemEntity.setCode(String.valueOf(num));
                } else {
                    itemEntity.setCode(buildEquipmentVO.getEquipmentCode());
                }
                itemEntity.setName(buildEquipmentVO.getEquipmentName());
                itemEntity.setUnitName(buildEquipmentVO.getEquipmentUnitName());
                itemEntity.setTaxRate(buildEquipmentVO.getEquipmentRate());
                itemEntity.setPrice(buildEquipmentVO.getEquipmentPrice());
                itemEntity.setTaxPrice(buildEquipmentVO.getEquipmentTaxPrice());
                itemEntity.setAmount(buildEquipmentVO.getEquipmentNum());
                itemEntity.setMny(buildEquipmentVO.getEquipmentMny());
                itemEntity.setTaxMny(buildEquipmentVO.getEquipmentTaxMny());
                itemEntity.setRmatRentMonth(buildEquipmentVO.getEquipmentRentMonth());
                itemEntity.setDocType(6);
                itemList.add(itemEntity);
                detailEntity.setDutyDetailItemList(itemList);
            }
            if (!StringUtils.isBlank((CharSequence)buildEquipmentVO.getEquipmentCode())) continue;
            ++num;
        }
        return dutyEntity;
    }

    @Override
    public List<DutyEntity> handlerDetail(DutyEntity dutyEntity, FeeVO feeVO, BaseVO baseVO) {
        ArrayList<DutyEntity> resp = new ArrayList<DutyEntity>();
        BuildDutyVO buildDutyVO = (BuildDutyVO)baseVO;
        HashMap<String, Object> handleApi = new HashMap<String, Object>();
        handleApi.put("\u4eba\u5de5\u8d39", this.shareLabsubApi);
        handleApi.put("\u4e13\u4e1a\u5206\u5305\u8d39", this.shareProsubApi);
        handleApi.put("\u4e3b\u8981\u6750\u6599\u8d39", this.shareMaterialApi);
        handleApi.put("\u5b89\u6587\u73af\u4fdd\u4e34\u8bbe\u4e8c\u6b21\u642c\u8fd0", null);
        handleApi.put("\u51ac\u96e8\u5b63\u591c\u95f4\u65bd\u5de5", null);
        handleApi.put("\u6392\u964d\u6c34", null);
        handleApi.put("\u5df2\u5b8c\u5de5\u7a0b\u53ca\u8bbe\u5907\u4fdd\u62a4", null);
        handleApi.put("\u6a21\u677f\u53ca\u652f\u6491\u8d39\u7528", null);
        handleApi.put("\u811a\u624b\u67b6", null);
        handleApi.put("\u5176\u4ed6\u63aa\u65bd\u8d39", null);
        handleApi.put("\u95f4\u63a5\u8d39", null);
        handleApi.put("\u6fc0\u52b1\u5956", null);
        ExecutorService threadPool = Executors.newFixedThreadPool(6);
        ArrayList<Future<DutyEntity>> futures = new ArrayList<Future<DutyEntity>>();
        CommonCallable call = null;
        Future<DutyEntity> future = null;
        for (String string : handleApi.keySet()) {
            call = new CommonCallable(buildDutyVO, dutyEntity, feeVO, string, handleApi.get(string));
            future = threadPool.submit(call);
            futures.add(future);
        }
        try {
            for (Future future2 : futures) {
                resp.add((DutyEntity)((Object)future2.get()));
            }
        }
        catch (Exception e) {
            this.logger.error("\u76ee\u6807\u6210\u672c\u8f6c\u6362\u5f02\u5e38\uff1a", (Throwable)e);
            throw new BusinessException("\u76ee\u6807\u6210\u672c\u8f6c\u6362\u5f02\u5e38, ", (Throwable)e);
        }
        finally {
            threadPool.shutdown();
        }
        return resp;
    }

    private <T extends CommonImportDataVO> DutyEntity dealCommonData(List<T> vos, DutyEntity sourceDutyEntity, FeeVO feeVO, String feeName) {
        DutyEntity dutyEntity = (DutyEntity)((Object)BeanMapper.map((Object)((Object)sourceDutyEntity), DutyEntity.class));
        Long aqwmsgfId = null;
        for (FeeDetailVO detailVO : feeVO.getFeeDetailList()) {
            if (!feeName.equals(detailVO.getName())) continue;
            aqwmsgfId = detailVO.getId();
        }
        int num = 1;
        for (CommonImportDataVO cData : vos) {
            if (null == cData.getcLeafFlag() || !cData.getcLeafFlag().booleanValue()) continue;
            for (DutyDetailEntity detailEntity : dutyEntity.getDutyDetailList()) {
                if (!detailEntity.getLeafFlag().booleanValue() || !detailEntity.getFeeDetailId().equals(aqwmsgfId)) continue;
                ArrayList<DutyDetailItemEntity> itemList = CollectionUtils.isNotEmpty(detailEntity.getDutyDetailItemList()) ? detailEntity.getDutyDetailItemList() : new ArrayList<DutyDetailItemEntity>();
                DutyDetailItemEntity itemEntity = new DutyDetailItemEntity();
                itemEntity.setId(IdWorker.getId());
                if (StringUtils.isBlank((CharSequence)cData.getcCode())) {
                    itemEntity.setCode(String.valueOf(num));
                } else {
                    itemEntity.setCode(cData.getcCode());
                }
                itemEntity.setName(cData.getcName());
                itemEntity.setUnitName(cData.getcUnitName());
                itemEntity.setTaxRate(cData.getcTaxRate());
                itemEntity.setPrice(cData.getcPrice());
                itemEntity.setTaxPrice(cData.getcTaxPrice());
                itemEntity.setAmount(cData.getcAmount());
                itemEntity.setMny(cData.getcMny());
                itemEntity.setTaxMny(cData.getcTaxMny());
                itemEntity.setDocType(6);
                itemList.add(itemEntity);
                detailEntity.setDutyDetailItemList(itemList);
            }
            ++num;
        }
        return dutyEntity;
    }

    @Override
    public void checkFeeCode(FeeVO feeVO) {
        ArrayList<String> handWriteFeeNames = new ArrayList<String>();
        handWriteFeeNames.add("\u5b89\u5168\u6587\u660e\u3001\u73af\u5883\u4fdd\u62a4\u3001\u4e34\u65f6\u8bbe\u65bd\u3001\u4e8c\u6b21\u642c\u8fd0");
        handWriteFeeNames.add("\u51ac\u96e8\u5b63\u3001\u591c\u95f4\u65bd\u5de5");
        handWriteFeeNames.add("\u6392\u3001\u964d\u6c34");
        handWriteFeeNames.add("\u5df2\u5b8c\u5de5\u7a0b\u53ca\u8bbe\u5907\u4fdd\u62a4");
        handWriteFeeNames.add("\u6a21\u677f\u53ca\u652f\u6491");
        handWriteFeeNames.add("\u811a\u624b\u67b6");
        handWriteFeeNames.add("\u5176\u4ed6\u63aa\u65bd\u8d39");
        handWriteFeeNames.add("\u95f4\u63a5\u8d39\uff081\uff09");
        handWriteFeeNames.add("\u6fc0\u52b1\u5956");
        handWriteFeeNames.removeAll(feeVO.getFeeDetailList().stream().filter(detail -> null == detail.getParentId()).map(FeeDetailVO::getName).collect(Collectors.toList()));
        if (CollectionUtils.isNotEmpty(handWriteFeeNames)) {
            this.logger.info("***** \u8d39\u7528\u6a21\u677f\u7f3a\u5c11\u914d\u7f6e\u7684\u8d39\u7528\u9879\u540d\u79f0\uff1a{}", (Object)StringUtils.join(handWriteFeeNames, (String)","));
            throw new BusinessException("\u8d39\u7528\u6a21\u677f\u4e2d\u672a\u914d\u7f6e\u3010" + (String)handWriteFeeNames.get(0) + "\u3011\u7684\u8d39\u7528\u9879\uff0c\u65e0\u6cd5\u8f6c\u6362\uff01");
        }
    }

    class CommonCallable
    implements Callable<DutyEntity> {
        private RequestAttributes context = RequestContextHolder.getRequestAttributes();
        private BuildDutyVO buildDutyVO;
        private DutyEntity baseDutyEntity;
        private FeeVO feeVO;
        private String handleType;
        private Object restApi;

        public CommonCallable(BuildDutyVO buildDutyVO, DutyEntity baseDutyEntity, FeeVO feeVO, String handleType, Object restApi) {
            this.buildDutyVO = buildDutyVO;
            this.baseDutyEntity = baseDutyEntity;
            this.feeVO = feeVO;
            this.handleType = handleType;
            this.restApi = restApi;
        }

        @Override
        public DutyEntity call() throws Exception {
            RequestContextHolder.setRequestAttributes((RequestAttributes)this.context);
            switch (this.handleType) {
                case "\u4eba\u5de5\u8d39": {
                    return SX2JBuildHandler.this.dealLasubData(this.buildDutyVO, this.baseDutyEntity, this.feeVO, this.restApi);
                }
                case "\u4e13\u4e1a\u5206\u5305\u8d39": {
                    return SX2JBuildHandler.this.dealProsubData(this.buildDutyVO, this.baseDutyEntity, this.feeVO, this.restApi);
                }
                case "\u4e3b\u8981\u6750\u6599\u8d39": {
                    return SX2JBuildHandler.this.dealMaterialData(this.buildDutyVO, this.baseDutyEntity, this.feeVO, this.restApi);
                }
                case "\u673a\u68b0\u8bbe\u5907\u8d39": {
                    return SX2JBuildHandler.this.dealEquipData(this.buildDutyVO, this.baseDutyEntity, this.feeVO, this.restApi);
                }
            }
            return SX2JBuildHandler.this.dealCommonData(this.buildDutyVO.getBuildSafeList(), this.baseDutyEntity, this.feeVO, this.handleType);
        }
    }
}

