package com.ejianc.business.targetcost.handler;

import com.ejianc.business.sx2j.build.vo.*;
import com.ejianc.business.targetcost.bean.DutyDetailEntity;
import com.ejianc.business.targetcost.bean.DutyDetailItemEntity;
import com.ejianc.business.targetcost.bean.DutyEntity;
import com.ejianc.business.targetcost.enums.ConversionEnum;
import com.ejianc.business.targetcost.enums.DocTypeEnum;
import com.ejianc.business.targetcost.utils.TreeNodeBUtil;
import com.ejianc.business.targetcost.vo.FeeDetailVO;
import com.ejianc.business.targetcost.vo.FeeVO;
import com.ejianc.foundation.share.api.IShareEquipmentApi;
import com.ejianc.foundation.share.api.IShareLabsubApi;
import com.ejianc.foundation.share.api.IShareMaterialApi;
import com.ejianc.foundation.share.api.IShareProsubApi;
import com.ejianc.foundation.share.vo.*;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.ejianc.support.idworker.util.IdWorker;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.RequestContextHolder;

import java.util.*;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.function.Function;
import java.util.stream.Collectors;


@Service("sX2JBuildHandler")
public class SX2JBuildHandler extends ConversionBaseHandler implements IConversioneHandler{

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IShareMaterialApi shareMaterialApi;
    @Autowired
    private IShareEquipmentApi shareEquipmentApi;
    @Autowired
    private IShareLabsubApi shareLabsubApi;
    @Autowired
    private IShareProsubApi shareProsubApi;

    @Override
    public CommonResponse<String> push(BaseVO baseVO, Boolean isEff) {
        BuildDutyVO buildDutyVO = (BuildDutyVO) baseVO;
        DutyEntity dutyEntity = BeanMapper.map(buildDutyVO, DutyEntity.class);
        dutyEntity.setFirstImportId(buildDutyVO.getBaseDutyId());
        dutyEntity.setImportId(buildDutyVO.getId());
        dutyEntity.setImportType(ConversionEnum.陕建房建.getCode());

        handlerHead(dutyEntity, isEff, baseVO);

        return CommonResponse.success("导入转换目标成本单据成功！");
    }

    @Override
    public CommonResponse<String> delete(Long importId) {
        deleteDuty(importId);
        return CommonResponse.success("删除目标成本单据成功！");
    }

    private DutyEntity dealLasubData(BuildDutyVO buildDutyVO, DutyEntity sourceDutyEntity, FeeVO feeVO, Object restApi) {
        DutyEntity dutyEntity = BeanMapper.map(sourceDutyEntity, DutyEntity.class);
        IShareLabsubApi _restApi = (IShareLabsubApi) restApi;
        //先判断费用模板有无关联人工费
        //人工费
        Long rgfId = null;
        for (FeeDetailVO detailVO : feeVO.getFeeDetailList()) {
            if (Long.valueOf("546645586985238533").equals(detailVO.getFeePropId())) {
                rgfId = detailVO.getId();
            }
        }
        if (null == rgfId) {
            throw new BusinessException("费用模板中未配置【人工费】的费用项，无法转换！");
        }
        //人工费下的主键集合
        Set<Long> rgfSet = new HashSet<>();
        for (FeeDetailVO detailVO : feeVO.getFeeDetailList()) {
            if (detailVO.getInnerCode().contains(String.valueOf(rgfId))) {
                rgfSet.add(detailVO.getId());
            }
        }
        //其他人工费
        Long qtrgfId = null;
        for (FeeDetailVO detailVO : feeVO.getFeeDetailList()) {
            if (Long.valueOf("546645586985238534").equals(detailVO.getFeePropId()) && rgfSet.contains(detailVO.getId())) {
                qtrgfId = detailVO.getId();
            }
        }
        if (null == qtrgfId) {
            throw new BusinessException("费用模板中未配置【其他人工费】的费用项，无法转换！");
        }

        List<String> codeList = buildDutyVO.getBuildRgcostList().stream()
                .filter(rgcostVO -> null != rgcostVO.getLeafFlag() && rgcostVO.getLeafFlag() && StringUtils.isNotBlank(rgcostVO.getRgcostCode()))
                .map(BuildRgcostVO::getRgcostCode).collect(Collectors.toList());

        CommonResponse<List<LabsubCategoryVO>> labCtyResponse = _restApi.queryCategoryListByIds(new ArrayList<>());
        //劳务分包分类的内码map
        Map<Long, String> labCtyInnerCodeMap = new HashMap<>();
        if (labCtyResponse.isSuccess() && CollectionUtils.isNotEmpty(labCtyResponse.getData())) {
            labCtyInnerCodeMap = labCtyResponse.getData().stream().collect(Collectors.toMap(LabsubCategoryVO::getId, LabsubCategoryVO::getInnerCode, (key1, key2) -> key1));
        }

        Map<String, LabsubItemVO> labSubMap = new HashMap<>();
        CommonResponse<List<LabsubItemVO>> labItemResponse = _restApi.queryItemListByCodes(codeList);
        if (labItemResponse.isSuccess() && CollectionUtils.isNotEmpty(labItemResponse.getData())) {
            labSubMap = labItemResponse.getData().stream().collect(Collectors.toMap(LabsubItemVO::getTrawlingCode, Function.identity(), (key1, key2) -> key1));
        }

        for (BuildRgcostVO rgcostVO : buildDutyVO.getBuildRgcostList()) {
            if (null == rgcostVO.getLeafFlag() || !rgcostVO.getLeafFlag()) {
                continue;
            }
            for (DutyDetailEntity detailEntity : dutyEntity.getDutyDetailList()) {
                if (!detailEntity.getLeafFlag()) {
                    continue;
                }
                //匹配到档案
                if (StringUtils.isNotBlank(rgcostVO.getRgcostCode()) && labSubMap.containsKey(rgcostVO.getRgcostCode())) {
                    LabsubItemVO labsubItemVO = labSubMap.get(rgcostVO.getRgcostCode());
                    String innerCode = labCtyInnerCodeMap.get(labsubItemVO.getCategoryId());
                    //1.有分类主键说明是选分类添加 2.内码包含分类主键 3.是“人工费”下的
                    if (((null != detailEntity.getCategoryId() && innerCode.contains(String.valueOf(detailEntity.getCategoryId())))
                            || (null == detailEntity.getCategoryId() && TreeNodeBUtil.judgeContain(innerCode, detailEntity.getCategoryInnerCode()))
                            && rgfSet.contains(detailEntity.getFeeDetailId()))) {
                        List<DutyDetailItemEntity> itemList = CollectionUtils.isNotEmpty(detailEntity.getDutyDetailItemList()) ? detailEntity.getDutyDetailItemList() : new ArrayList<>();
                        DutyDetailItemEntity itemEntity = new DutyDetailItemEntity();
                        itemEntity.setId(IdWorker.getId());
                        itemEntity.setCode(labsubItemVO.getTrawlingCode());
                        itemEntity.setName(labsubItemVO.getTrawlingName());
                        itemEntity.setPriceType(labsubItemVO.getPriceType());
                        itemEntity.setJobContent(labsubItemVO.getJobContent());
                        itemEntity.setUnitName(labsubItemVO.getUnitName());
                        itemEntity.setTaxRate(rgcostVO.getRgcostRate());
                        itemEntity.setPrice(rgcostVO.getRgcostPrice());
                        itemEntity.setTaxPrice(rgcostVO.getRgcostTaxPrice());
                        itemEntity.setAmount(rgcostVO.getRgcostNum());
                        itemEntity.setMny(rgcostVO.getRgcostMny());
                        itemEntity.setTaxMny(rgcostVO.getRgcostTaxMny());
                        itemEntity.setCategoryId(labsubItemVO.getCategoryId());
                        itemEntity.setCategoryInnerCode(innerCode);
                        itemEntity.setCategoryName(labsubItemVO.getCategoryName());
                        itemEntity.setDocType(DocTypeEnum.劳务分包档案.getCode());
                        itemEntity.setDocId(labsubItemVO.getId());
                        itemList.add(itemEntity);
                        detailEntity.setDutyDetailItemList(itemList);
                    }
                }else if (detailEntity.getFeeDetailId().equals(qtrgfId)) {//匹配不到档案且子表为“其他人工费”
                    List<DutyDetailItemEntity> itemList = CollectionUtils.isNotEmpty(detailEntity.getDutyDetailItemList()) ? detailEntity.getDutyDetailItemList() : new ArrayList<>();
                    DutyDetailItemEntity itemEntity = new DutyDetailItemEntity();
                    itemEntity.setId(IdWorker.getId());
                    itemEntity.setCode(rgcostVO.getRgcostCode());
                    itemEntity.setName(rgcostVO.getRgcostName());
                    itemEntity.setUnitName(rgcostVO.getRgcostUnitName());
                    itemEntity.setTaxRate(rgcostVO.getRgcostRate());
                    itemEntity.setPrice(rgcostVO.getRgcostPrice());
                    itemEntity.setTaxPrice(rgcostVO.getRgcostTaxPrice());
                    itemEntity.setAmount(rgcostVO.getRgcostNum());
                    itemEntity.setMny(rgcostVO.getRgcostMny());
                    itemEntity.setTaxMny(rgcostVO.getRgcostTaxMny());
                    itemEntity.setDocType(6);
                    itemList.add(itemEntity);
                    detailEntity.setDutyDetailItemList(itemList);
                }
            }
        }

        return dutyEntity;
    }

    private DutyEntity dealProsubData(BuildDutyVO buildDutyVO, DutyEntity sourceDutyEntity, FeeVO feeVO, Object restApi) {
        DutyEntity dutyEntity = BeanMapper.map(sourceDutyEntity, DutyEntity.class);
        IShareProsubApi _restApi = (IShareProsubApi) restApi;
        //先判断费用模板有无关联专业分包费
        //专业分包费
        Long zyfbId = null;
        for (FeeDetailVO detailVO : feeVO.getFeeDetailList()) {
            if (Long.valueOf("546645586985238540").equals(detailVO.getFeePropId())) {
                zyfbId = detailVO.getId();
            }
        }
        if (null == zyfbId) {
            throw new BusinessException("费用模板中未配置【专业分包费】的费用项，无法转换！");
        }
        //专业分包费下的主键集合
        Set<Long> zyfbSet = new HashSet<>();
        for (FeeDetailVO detailVO : feeVO.getFeeDetailList()) {
            if (detailVO.getInnerCode().contains(String.valueOf(zyfbId))) {
                zyfbSet.add(detailVO.getId());
            }
        }
        //其他专业分包费
        Long qtzyfbId = null;
        for (FeeDetailVO detailVO : feeVO.getFeeDetailList()) {
            if (Long.valueOf("546645586985238541").equals(detailVO.getFeePropId()) && zyfbSet.contains(detailVO.getId())) {
                qtzyfbId = detailVO.getId();
            }
        }
        if (null == qtzyfbId) {
            throw new BusinessException("费用模板中未配置【其他专业分包费】的费用项，无法转换！");
        }

        List<String> codeList = buildDutyVO.getBuildSubList().stream()
                .filter(subVO -> null != subVO.getLeafFlag() && subVO.getLeafFlag() && StringUtils.isNotBlank(subVO.getSubCode()))
                .map(BuildSubVO::getSubCode).collect(Collectors.toList());

        CommonResponse<List<ProsubCategoryVO>> proCtyResponse = _restApi.queryCategoryListByIds(new ArrayList<>());
        //专业分包分类的内码map
        Map<Long, String> proCtyInnerCodeMap = new HashMap<>();
        if (proCtyResponse.isSuccess() && CollectionUtils.isNotEmpty(proCtyResponse.getData())) {
            proCtyInnerCodeMap = proCtyResponse.getData().stream().collect(Collectors.toMap(ProsubCategoryVO::getId, ProsubCategoryVO::getInnerCode, (key1, key2) -> key1));
        }

        Map<String, ProsubItemVO> proSubMap = new HashMap<>();
        CommonResponse<List<ProsubItemVO>> proItemResponse = _restApi.queryItemListByCodes(codeList);
        if (proItemResponse.isSuccess() && CollectionUtils.isNotEmpty(proItemResponse.getData())) {
            proSubMap = proItemResponse.getData().stream().collect(Collectors.toMap(ProsubItemVO::getTrawlingCode, Function.identity(), (key1, key2) -> key1));
        }

        for (BuildSubVO subVO : buildDutyVO.getBuildSubList()) {
            if (null == subVO.getLeafFlag() || !subVO.getLeafFlag()) {
                continue;
            }
            for (DutyDetailEntity detailEntity : dutyEntity.getDutyDetailList()) {
                if (!detailEntity.getLeafFlag()) {
                    continue;
                }
                //匹配到档案
                if (StringUtils.isNotBlank(subVO.getSubCode()) && proSubMap.containsKey(subVO.getSubCode())) {
                    ProsubItemVO prosubItemVO = proSubMap.get(subVO.getSubCode());
                    String innerCode = proCtyInnerCodeMap.get(prosubItemVO.getCategoryId());
                    if (((null != detailEntity.getCategoryId() && innerCode.contains(String.valueOf(detailEntity.getCategoryId())))
                            || (null == detailEntity.getCategoryId() && TreeNodeBUtil.judgeContain(innerCode, detailEntity.getCategoryInnerCode()))
                            && zyfbSet.contains(detailEntity.getFeeDetailId()))) {
                        List<DutyDetailItemEntity> itemList = CollectionUtils.isNotEmpty(detailEntity.getDutyDetailItemList()) ? detailEntity.getDutyDetailItemList() : new ArrayList<>();
                        DutyDetailItemEntity itemEntity = new DutyDetailItemEntity();
                        itemEntity.setId(IdWorker.getId());
                        itemEntity.setCode(prosubItemVO.getTrawlingCode());
                        itemEntity.setName(prosubItemVO.getTrawlingName());
                        itemEntity.setPriceType(prosubItemVO.getPriceType());
                        itemEntity.setJobContent(prosubItemVO.getJobContent());
                        itemEntity.setUnitName(prosubItemVO.getUnitName());
                        itemEntity.setTaxRate(subVO.getSubRate());
                        itemEntity.setPrice(subVO.getSubPrice());
                        itemEntity.setTaxPrice(subVO.getSubTaxPrice());
                        itemEntity.setAmount(subVO.getSubNum());
                        itemEntity.setMny(subVO.getSubMny());
                        itemEntity.setTaxMny(subVO.getSubTaxMny());
                        itemEntity.setCategoryId(prosubItemVO.getCategoryId());
                        itemEntity.setCategoryInnerCode(innerCode);
                        itemEntity.setCategoryName(prosubItemVO.getCategoryName());
                        itemEntity.setDocType(DocTypeEnum.专业分包档案.getCode());
                        itemEntity.setDocId(prosubItemVO.getId());
                        itemList.add(itemEntity);
                        detailEntity.setDutyDetailItemList(itemList);
                    }
                }else if (detailEntity.getFeeDetailId().equals(qtzyfbId)) {//匹配不到档案且子表为“其他专业分包费”
                    List<DutyDetailItemEntity> itemList = CollectionUtils.isNotEmpty(detailEntity.getDutyDetailItemList()) ? detailEntity.getDutyDetailItemList() : new ArrayList<>();
                    DutyDetailItemEntity itemEntity = new DutyDetailItemEntity();
                    itemEntity.setId(IdWorker.getId());
                    itemEntity.setCode(subVO.getSubCode());
                    itemEntity.setName(subVO.getSubName());
                    itemEntity.setUnitName(subVO.getSubUnitName());
                    itemEntity.setTaxRate(subVO.getSubRate());
                    itemEntity.setPrice(subVO.getSubPrice());
                    itemEntity.setTaxPrice(subVO.getSubTaxPrice());
                    itemEntity.setAmount(subVO.getSubNum());
                    itemEntity.setMny(subVO.getSubMny());
                    itemEntity.setTaxMny(subVO.getSubTaxMny());
                    itemEntity.setDocType(6);
                    itemList.add(itemEntity);
                    detailEntity.setDutyDetailItemList(itemList);
                }
            }
        }

        return dutyEntity;
    }

    private DutyEntity dealProsub2Data(BuildDutyVO buildDutyVO, DutyEntity sourceDutyEntity, FeeVO feeVO, Object restApi) {
        DutyEntity dutyEntity = BeanMapper.map(sourceDutyEntity, DutyEntity.class);
        IShareProsubApi _restApi = (IShareProsubApi) restApi;
        //先判断费用模板有无关联专业分包费
        //专业分包费
        Long zyfbId = null;
        for (FeeDetailVO detailVO : feeVO.getFeeDetailList()) {
            if (Long.valueOf("546645586985238540").equals(detailVO.getFeePropId())) {
                zyfbId = detailVO.getId();
            }
        }
        if (null == zyfbId) {
            throw new BusinessException("费用模板中未配置【专业分包费】的费用项，无法转换！");
        }
        //专业分包费下的主键集合
        Set<Long> zyfbSet = new HashSet<>();
        for (FeeDetailVO detailVO : feeVO.getFeeDetailList()) {
            if (detailVO.getInnerCode().contains(String.valueOf(zyfbId))) {
                zyfbSet.add(detailVO.getId());
            }
        }
        //其他专业分包费
        Long qtzyfbId = null;
        for (FeeDetailVO detailVO : feeVO.getFeeDetailList()) {
            if (Long.valueOf("546645586985238541").equals(detailVO.getFeePropId()) && zyfbSet.contains(detailVO.getId())) {
                qtzyfbId = detailVO.getId();
            }
        }
        if (null == qtzyfbId) {
            throw new BusinessException("费用模板中未配置【其他专业分包费】的费用项，无法转换！");
        }

        List<String> codeList = buildDutyVO.getBuildAppointList().stream()
                .filter(subVO -> null != subVO.getLeafFlag() && subVO.getLeafFlag() && StringUtils.isNotBlank(subVO.getAppointCode()))
                .map(BuildAppointVO::getAppointCode).collect(Collectors.toList());

        CommonResponse<List<ProsubCategoryVO>> proCtyResponse = _restApi.queryCategoryListByIds(new ArrayList<>());
        //专业分包分类的内码map
        Map<Long, String> proCtyInnerCodeMap = new HashMap<>();
        if (proCtyResponse.isSuccess() && CollectionUtils.isNotEmpty(proCtyResponse.getData())) {
            proCtyInnerCodeMap = proCtyResponse.getData().stream().collect(Collectors.toMap(ProsubCategoryVO::getId, ProsubCategoryVO::getInnerCode, (key1, key2) -> key1));
        }

        Map<String, ProsubItemVO> proSubMap = new HashMap<>();
        CommonResponse<List<ProsubItemVO>> proItemResponse = _restApi.queryItemListByCodes(codeList);
        if (proItemResponse.isSuccess() && CollectionUtils.isNotEmpty(proItemResponse.getData())) {
            proSubMap = proItemResponse.getData().stream().collect(Collectors.toMap(ProsubItemVO::getTrawlingCode, Function.identity(), (key1, key2) -> key1));
        }

        for (BuildAppointVO subVO : buildDutyVO.getBuildAppointList()) {
            if (null == subVO.getLeafFlag() || !subVO.getLeafFlag()) {
                continue;
            }
            for (DutyDetailEntity detailEntity : dutyEntity.getDutyDetailList()) {
                if (!detailEntity.getLeafFlag()) {
                    continue;
                }
                //匹配到档案
                if (StringUtils.isNotBlank(subVO.getAppointCode()) && proSubMap.containsKey(subVO.getAppointCode())) {
                    ProsubItemVO prosubItemVO = proSubMap.get(subVO.getAppointCode());
                    String innerCode = proCtyInnerCodeMap.get(prosubItemVO.getCategoryId());
                    if (((null != detailEntity.getCategoryId() && innerCode.contains(String.valueOf(detailEntity.getCategoryId())))
                            || (null == detailEntity.getCategoryId() && TreeNodeBUtil.judgeContain(innerCode, detailEntity.getCategoryInnerCode()))
                            && zyfbSet.contains(detailEntity.getFeeDetailId()))) {
                        List<DutyDetailItemEntity> itemList = CollectionUtils.isNotEmpty(detailEntity.getDutyDetailItemList()) ? detailEntity.getDutyDetailItemList() : new ArrayList<>();
                        DutyDetailItemEntity itemEntity = new DutyDetailItemEntity();
                        itemEntity.setId(IdWorker.getId());
                        itemEntity.setCode(prosubItemVO.getTrawlingCode());
                        itemEntity.setName(prosubItemVO.getTrawlingName());
                        itemEntity.setPriceType(prosubItemVO.getPriceType());
                        itemEntity.setJobContent(prosubItemVO.getJobContent());
                        itemEntity.setUnitName(prosubItemVO.getUnitName());
                        itemEntity.setTaxRate(subVO.getAppointRate());
                        itemEntity.setPrice(subVO.getAppointPrice());
                        itemEntity.setTaxPrice(subVO.getAppointTaxPrice());
                        itemEntity.setAmount(subVO.getAppointNum());
                        itemEntity.setMny(subVO.getAppointMny());
                        itemEntity.setTaxMny(subVO.getAppointTaxMny());
                        itemEntity.setCategoryId(prosubItemVO.getCategoryId());
                        itemEntity.setCategoryInnerCode(innerCode);
                        itemEntity.setCategoryName(prosubItemVO.getCategoryName());
                        itemEntity.setDocType(DocTypeEnum.专业分包档案.getCode());
                        itemEntity.setDocId(prosubItemVO.getId());
                        itemList.add(itemEntity);
                        detailEntity.setDutyDetailItemList(itemList);
                    }
                }else if (detailEntity.getFeeDetailId().equals(qtzyfbId)) {//匹配不到档案且子表为“其他专业分包费”
                    List<DutyDetailItemEntity> itemList = CollectionUtils.isNotEmpty(detailEntity.getDutyDetailItemList()) ? detailEntity.getDutyDetailItemList() : new ArrayList<>();
                    DutyDetailItemEntity itemEntity = new DutyDetailItemEntity();
                    itemEntity.setId(IdWorker.getId());
                    itemEntity.setCode(subVO.getAppointCode());
                    itemEntity.setName(subVO.getAppointName());
                    itemEntity.setUnitName(subVO.getAppointUnitName());
                    itemEntity.setTaxRate(subVO.getAppointRate());
                    itemEntity.setPrice(subVO.getAppointPrice());
                    itemEntity.setTaxPrice(subVO.getAppointTaxPrice());
                    itemEntity.setAmount(subVO.getAppointNum());
                    itemEntity.setMny(subVO.getAppointMny());
                    itemEntity.setTaxMny(subVO.getAppointTaxMny());
                    itemEntity.setDocType(6);
                    itemList.add(itemEntity);
                    detailEntity.setDutyDetailItemList(itemList);
                }
            }
        }

        return dutyEntity;
    }

    //    , Map<Long, String> matCtyLongInnerMap, Map<String, String> matCtyStringInnerMap
    private DutyEntity dealMaterialData(BuildDutyVO buildDutyVO, DutyEntity sourceDutyEntity, FeeVO feeVO, Object restApi) {
        DutyEntity dutyEntity = BeanMapper.map(sourceDutyEntity, DutyEntity.class);
        IShareMaterialApi _restApi = (IShareMaterialApi) restApi;
        //物资分类的内码map
        Map<Long, String> matCtyLongInnerMap = new HashMap<>();
        Map<String, String> matCtyStringInnerMap = new HashMap<>();

        //先判断费用模板有无关联材料费
        //材料费
        Long clfId = null;
        for (FeeDetailVO detailVO : feeVO.getFeeDetailList()) {
            if (Long.valueOf("546645586985238535").equals(detailVO.getFeePropId())) {
                clfId = detailVO.getId();
            }
        }
        if (null == clfId) {
            throw new BusinessException("费用模板中未配置【材料费】的费用项，无法转换！");
        }
        //材料费下的主键集合
        Set<Long> clfSet = new HashSet<>();
        for (FeeDetailVO detailVO : feeVO.getFeeDetailList()) {
            if (detailVO.getInnerCode().contains(String.valueOf(clfId))) {
                clfSet.add(detailVO.getId());
            }
        }
        //其他材料费
        Long qtclfId = null;
        for (FeeDetailVO detailVO : feeVO.getFeeDetailList()) {
            if (Long.valueOf("546645586985238539").equals(detailVO.getFeePropId()) && clfSet.contains(detailVO.getId())) {
                qtclfId = detailVO.getId();
            }
        }
        if (null == qtclfId) {
            throw new BusinessException("费用模板中未配置【其他材料费】的费用项，无法转换！");
        }
        List<String> codeList = buildDutyVO.getBuildMaterialList().stream()
                .filter(item -> null != item.getLeafFlag() && item.getLeafFlag() && StringUtils.isNotBlank(item.getMaterialCode()))
                .map(BuildMaterialVO::getMaterialCode).collect(Collectors.toList());

        CommonResponse<List<MaterialVO>> matResponse = _restApi.queryMaterialListByCodes(codeList);

        Map<String, MaterialVO> matMap = new HashMap<>();
        if (matResponse.isSuccess() && CollectionUtils.isNotEmpty(matResponse.getData())) {
            matMap = matResponse.getData().stream().collect(Collectors.toMap(MaterialVO::getCode, Function.identity(), (key1, key2) -> key1));
        }

        int num = 1;
        for (BuildMaterialVO buildMaterialVO : buildDutyVO.getBuildMaterialList()) {
            if (null == buildMaterialVO.getLeafFlag() || !buildMaterialVO.getLeafFlag()) {
                continue;
            }
            for (DutyDetailEntity detailEntity : dutyEntity.getDutyDetailList()) {
                if (!detailEntity.getLeafFlag()) {
                    continue;
                }
                if(StringUtils.isNotBlank(buildMaterialVO.getMaterialCode())){
                    if(matMap.containsKey(buildMaterialVO.getMaterialCode())){
                        MaterialVO materialVO = matMap.get(buildMaterialVO.getMaterialCode());
                        if(!matCtyLongInnerMap.containsKey(materialVO.getCategoryId())){
                            CommonResponse<MaterialCategoryVO> response = _restApi.queryCategoryById(materialVO.getCategoryId());
                            MaterialCategoryVO categoryVO = response.getData();
                            matCtyLongInnerMap.put(categoryVO.getId(), categoryVO.getInnerCode());
                            matCtyStringInnerMap.put(categoryVO.getCode(), categoryVO.getInnerCode());
                        }
                    }else{
                        if(!matCtyStringInnerMap.containsKey(buildMaterialVO.getMaterialCode())){
                            CommonResponse<MaterialCategoryVO> response = _restApi.queryCategoryByCode(buildMaterialVO.getMaterialCode());
                            if (response.isSuccess() && null != response.getData()) {
                                MaterialCategoryVO categoryVO = response.getData();
                                matCtyLongInnerMap.put(categoryVO.getId(), categoryVO.getInnerCode());
                                matCtyStringInnerMap.put(categoryVO.getCode(), categoryVO.getInnerCode());
                            }
                        }
                    }
                }
                //匹配到档案
                if (StringUtils.isNotBlank(buildMaterialVO.getMaterialCode()) && matMap.containsKey(buildMaterialVO.getMaterialCode())) {
                    MaterialVO materialVO = matMap.get(buildMaterialVO.getMaterialCode());
                    String innerCode = matCtyLongInnerMap.get(materialVO.getCategoryId());
                    //1.有分类主键说明是选分类添加 2.内码包含分类主键 3.是“材料费”下的
                    if (((null != detailEntity.getCategoryId() && innerCode.contains(String.valueOf(detailEntity.getCategoryId())))
                            || (null == detailEntity.getCategoryId() && TreeNodeBUtil.judgeContain(innerCode, detailEntity.getCategoryInnerCode()))
                            && clfSet.contains(detailEntity.getFeeDetailId()))) {
                        List<DutyDetailItemEntity> itemList = CollectionUtils.isNotEmpty(detailEntity.getDutyDetailItemList()) ? detailEntity.getDutyDetailItemList() : new ArrayList<>();
                        DutyDetailItemEntity itemEntity = new DutyDetailItemEntity();
                        itemEntity.setId(IdWorker.getId());
                        itemEntity.setCode(materialVO.getCode());
                        itemEntity.setName(materialVO.getName());
                        itemEntity.setModel(materialVO.getSpec());
                        itemEntity.setUnitId(materialVO.getUnitId());
                        itemEntity.setUnitName(materialVO.getUnitName());
                        itemEntity.setTaxRate(buildMaterialVO.getMaterialRate());
                        itemEntity.setPrice(buildMaterialVO.getMaterialPrice());
                        itemEntity.setTaxPrice(buildMaterialVO.getMaterialTaxPrice());
                        itemEntity.setAmount(buildMaterialVO.getMaterialNum());
                        itemEntity.setMny(buildMaterialVO.getMaterialMny());
                        itemEntity.setTaxMny(buildMaterialVO.getMaterialTaxMny());
                        itemEntity.setCategoryId(materialVO.getCategoryId());
                        itemEntity.setCategoryInnerCode(innerCode);
                        itemEntity.setCategoryName(materialVO.getCategoryName());
                        itemEntity.setDocType(DocTypeEnum.物料档案.getCode());
                        itemEntity.setDocId(materialVO.getId());
                        itemList.add(itemEntity);
                        detailEntity.setDutyDetailItemList(itemList);
                    }
                } else if (StringUtils.isNotBlank(buildMaterialVO.getMaterialCode()) && matCtyStringInnerMap.containsKey(buildMaterialVO.getMaterialCode())) {//匹配到分类
                    String innerCode = matCtyStringInnerMap.get(buildMaterialVO.getMaterialCode());
                    //1.有分类主键说明是选分类添加 2.内码包含分类主键 3.是“材料费”下的
                    if (((null != detailEntity.getCategoryId() && innerCode.contains(String.valueOf(detailEntity.getCategoryId())))
                            || (null == detailEntity.getCategoryId() && TreeNodeBUtil.judgeContain(innerCode, detailEntity.getCategoryInnerCode()))
                            && clfSet.contains(detailEntity.getFeeDetailId()))) {
                        detailEntity.setPreTypeAmount(ComputeUtil.safeAdd(detailEntity.getPreTypeAmount(), buildMaterialVO.getMaterialNum()));
                        detailEntity.setMny(ComputeUtil.safeAdd(detailEntity.getMny(), buildMaterialVO.getMaterialMny()));
                        detailEntity.setTaxMny(ComputeUtil.safeAdd(detailEntity.getTaxMny(), buildMaterialVO.getMaterialTaxMny()));
                    }
                } else if (detailEntity.getFeeDetailId().equals(qtclfId)) {//匹配不到档案且子表为“其他材料费”
                    List<DutyDetailItemEntity> itemList = CollectionUtils.isNotEmpty(detailEntity.getDutyDetailItemList()) ? detailEntity.getDutyDetailItemList() : new ArrayList<>();
                    DutyDetailItemEntity itemEntity = new DutyDetailItemEntity();
                    itemEntity.setId(IdWorker.getId());
                    if (StringUtils.isBlank(buildMaterialVO.getMaterialCode())) {
                        itemEntity.setCode(String.valueOf(num));
                        num++;
                    }else{
                        itemEntity.setCode(buildMaterialVO.getMaterialCode());
                    }
                    itemEntity.setName(buildMaterialVO.getMaterialName());
                    itemEntity.setUnitName(buildMaterialVO.getMaterialUnitName());
                    itemEntity.setTaxRate(buildMaterialVO.getMaterialRate());
                    itemEntity.setPrice(buildMaterialVO.getMaterialPrice());
                    itemEntity.setTaxPrice(buildMaterialVO.getMaterialTaxPrice());
                    itemEntity.setAmount(buildMaterialVO.getMaterialNum());
                    itemEntity.setMny(buildMaterialVO.getMaterialMny());
                    itemEntity.setTaxMny(buildMaterialVO.getMaterialTaxMny());
                    itemEntity.setDocType(6);
                    itemList.add(itemEntity);
                    detailEntity.setDutyDetailItemList(itemList);
                }
            }
        }

        return dutyEntity;
    }

//    private void dealRmatData(BuildDutyVO buildDutyVO, DutyEntity dutyEntity, FeeVO feeVO, Map<Long, String> matCtyLongInnerMap, Map<String, String> matCtyStringInnerMap) {
//        //先判断费用模板有无关联周转材材料费
//        //周转材材料费
//        Long zzcId = null;
//        for (FeeDetailVO detailVO : feeVO.getFeeDetailList()) {
//            if (Long.valueOf("546645586985238537").equals(detailVO.getFeePropId())) {
//                zzcId = detailVO.getId();
//            }
//        }
//        if (null == zzcId) {
//            throw new BusinessException("费用模板中未配置【周转材料费】的费用项，无法转换！");
//        }
//        //周转材材料费下的主键集合
//        Set<Long> zzcSet = new HashSet<>();
//        for (FeeDetailVO detailVO : feeVO.getFeeDetailList()) {
//            if (detailVO.getInnerCode().contains(String.valueOf(zzcId))) {
//                zzcSet.add(detailVO.getId());
//            }
//        }
//        //其他周转材材料费
//        Long qtzzcId = null;
//        for (FeeDetailVO detailVO : feeVO.getFeeDetailList()) {
//            if (Long.valueOf("546645586985238538").equals(detailVO.getFeePropId()) && zzcSet.contains(detailVO.getId())) {
//                qtzzcId = detailVO.getId();
//            }
//        }
//        if (null == qtzzcId) {
//            throw new BusinessException("费用模板中未配置【其他周转材料费】的费用项，无法转换！");
//        }
//
//        List<String> codeList = buildDutyVO.getBuildRmatList().stream()
//                .filter(rmatVO -> null != rmatVO.getLeafFlag() && rmatVO.getLeafFlag() && StringUtils.isNotBlank(rmatVO.getRmatCode()))
//                .map(BuildRmatVO::getRmatCode).collect(Collectors.toList());
//
//        CommonResponse<List<MaterialVO>> matResponse = shareMaterialApi.queryMaterialListByCodes(codeList);
//        Map<String, MaterialVO> matMap = new HashMap<>();
//        if (matResponse.isSuccess() && CollectionUtils.isNotEmpty(matResponse.getData())) {
//            matMap = matResponse.getData().stream().collect(Collectors.toMap(MaterialVO::getCode, Function.identity(), (key1, key2) -> key1));
//        }
//
//        int num = 1;
//        for (BuildRmatVO rmatVO : buildDutyVO.getBuildRmatList()) {
//            if (null == rmatVO.getLeafFlag() || !rmatVO.getLeafFlag()) {
//                continue;
//            }
//            for (DutyDetailEntity detailEntity : dutyEntity.getDutyDetailList()) {
//                if (!detailEntity.getLeafFlag()) {
//                    continue;
//                }
//                if(StringUtils.isNotBlank(rmatVO.getRmatCode())){
//                    if(matMap.containsKey(rmatVO.getRmatCode())){
//                        MaterialVO materialVO = matMap.get(rmatVO.getRmatCode());
//                        if(!matCtyLongInnerMap.containsKey(materialVO.getCategoryId())){
//                            CommonResponse<MaterialCategoryVO> response = shareMaterialApi.queryCategoryById(materialVO.getCategoryId());
//                            MaterialCategoryVO categoryVO = response.getData();
//                            matCtyLongInnerMap.put(categoryVO.getId(), categoryVO.getInnerCode());
//                            matCtyStringInnerMap.put(categoryVO.getCode(), categoryVO.getInnerCode());
//                        }
//                    }else{
//                        if(!matCtyStringInnerMap.containsKey(rmatVO.getRmatCode())){
//                            CommonResponse<MaterialCategoryVO> response = shareMaterialApi.queryCategoryByCode(rmatVO.getRmatCode());
//                            if (response.isSuccess() && null != response.getData()) {
//                                MaterialCategoryVO categoryVO = response.getData();
//                                matCtyLongInnerMap.put(categoryVO.getId(), categoryVO.getInnerCode());
//                                matCtyStringInnerMap.put(categoryVO.getCode(), categoryVO.getInnerCode());
//                            }
//                        }
//                    }
//                }
//                //匹配到档案
//                if (StringUtils.isNotBlank(rmatVO.getRmatCode()) && matMap.containsKey(rmatVO.getRmatCode())) {
//                    MaterialVO materialVO = matMap.get(rmatVO.getRmatCode());
//                    String innerCode = matCtyLongInnerMap.get(materialVO.getCategoryId());
//                    //1.有分类主键说明是选分类添加 2.内码包含分类主键 3.是“材料费”下的
//                    if (((null != detailEntity.getCategoryId() && innerCode.contains(String.valueOf(detailEntity.getCategoryId())))
//                            || (null == detailEntity.getCategoryId() && TreeNodeBUtil.judgeContain(innerCode, detailEntity.getCategoryInnerCode()))
//                            && zzcSet.contains(detailEntity.getFeeDetailId()))) {
//                        List<DutyDetailItemEntity> itemList = CollectionUtils.isNotEmpty(detailEntity.getDutyDetailItemList()) ? detailEntity.getDutyDetailItemList() : new ArrayList<>();
//                        DutyDetailItemEntity itemEntity = new DutyDetailItemEntity();
//                        itemEntity.setId(IdWorker.getId());
//                        itemEntity.setCode(materialVO.getCode());
//                        itemEntity.setName(materialVO.getName());
//                        itemEntity.setModel(materialVO.getSpec());
//                        itemEntity.setUnitId(materialVO.getUnitId());
//                        itemEntity.setUnitName(materialVO.getUnitName());
//                        itemEntity.setTaxRate(rmatVO.getRmatRate());
//                        itemEntity.setPrice(rmatVO.getRmatPrice());
//                        itemEntity.setTaxPrice(rmatVO.getRmatTaxPrice());
//                        itemEntity.setAmount(rmatVO.getRmatNum());
//                        itemEntity.setMny(rmatVO.getRmatMny());
//                        itemEntity.setTaxMny(rmatVO.getRmatTaxMny());
//                        itemEntity.setRmatRentMonth(rmatVO.getRmatRentMonth());
//                        itemEntity.setCategoryId(materialVO.getCategoryId());
//                        itemEntity.setCategoryInnerCode(innerCode);
//                        itemEntity.setCategoryName(materialVO.getCategoryName());
//                        itemEntity.setDocType(DocTypeEnum.物料档案.getCode());
//                        itemEntity.setDocId(materialVO.getId());
//                        itemList.add(itemEntity);
//                        detailEntity.setDutyDetailItemList(itemList);
//                    }
//                } else if (StringUtils.isNotBlank(rmatVO.getRmatCode()) && matCtyStringInnerMap.containsKey(rmatVO.getRmatCode())) {//匹配到分类
//                    String innerCode = matCtyStringInnerMap.get(rmatVO.getRmatCode());
//                    //1.有分类主键说明是选分类添加 2.内码包含分类主键 3.是“周转材料费”下的
//                    if (((null != detailEntity.getCategoryId() && innerCode.contains(String.valueOf(detailEntity.getCategoryId())))
//                            || (null == detailEntity.getCategoryId() && TreeNodeBUtil.judgeContain(innerCode, detailEntity.getCategoryInnerCode()))
//                            && zzcSet.contains(detailEntity.getFeeDetailId()))) {
//                        detailEntity.setPreTypeAmount(ComputeUtil.safeAdd(detailEntity.getPreTypeAmount(), rmatVO.getRmatNum()));
//                        detailEntity.setMny(ComputeUtil.safeAdd(detailEntity.getMny(), rmatVO.getRmatMny()));
//                        detailEntity.setTaxMny(ComputeUtil.safeAdd(detailEntity.getTaxMny(), rmatVO.getRmatTaxMny()));
//                    }
//                } else if (detailEntity.getFeeDetailId().equals(qtzzcId)) {//匹配不到档案且子表为“其他周转材料费”
//                    List<DutyDetailItemEntity> itemList = CollectionUtils.isNotEmpty(detailEntity.getDutyDetailItemList()) ? detailEntity.getDutyDetailItemList() : new ArrayList<>();
//                    DutyDetailItemEntity itemEntity = new DutyDetailItemEntity();
//                    itemEntity.setId(IdWorker.getId());
//                    if (StringUtils.isBlank(rmatVO.getRmatCode())) {
//                        itemEntity.setCode(String.valueOf(num));
//                        num++;
//                    }else{
//                        itemEntity.setCode(rmatVO.getRmatCode());
//                    }
//                    itemEntity.setName(rmatVO.getRmatName());
//                    itemEntity.setUnitName(rmatVO.getRmatUnitName());
//                    itemEntity.setRmatRentMonth(rmatVO.getRmatRentMonth());
//                    itemEntity.setTaxRate(rmatVO.getRmatRate());
//                    itemEntity.setPrice(rmatVO.getRmatPrice());
//                    itemEntity.setTaxPrice(rmatVO.getRmatTaxPrice());
//                    itemEntity.setAmount(rmatVO.getRmatNum());
//                    itemEntity.setMny(rmatVO.getRmatMny());
//                    itemEntity.setTaxMny(rmatVO.getRmatTaxMny());
//                    itemEntity.setDocType(6);
//                    itemList.add(itemEntity);
//                    detailEntity.setDutyDetailItemList(itemList);
//                }
//            }
//        }
//    }

    private DutyEntity dealEquipData(BuildDutyVO buildDutyVO, DutyEntity sourceDutyEntity, FeeVO feeVO, Object restApi) {
        DutyEntity dutyEntity = BeanMapper.map(sourceDutyEntity, DutyEntity.class);
        IShareEquipmentApi _restApi = (IShareEquipmentApi) restApi;
        //机械设备费
        Long jxfId = null;
        for (FeeDetailVO detailVO : feeVO.getFeeDetailList()) {
            if (Long.valueOf("546645586985238542").equals(detailVO.getFeePropId())) {
                jxfId = detailVO.getId();
            }
        }
        if (null == jxfId) {
            throw new BusinessException("费用模板中未配置【机械设备费】的费用项，无法转换！");
        }
        //机械设备费下的主键集合
        Set<Long> jxfSet = new HashSet<>();
        for (FeeDetailVO detailVO : feeVO.getFeeDetailList()) {
            if (detailVO.getInnerCode().contains(String.valueOf(jxfId))) {
                jxfSet.add(detailVO.getId());
            }
        }
        //其他机械设备费
        Long qtjxfId = null;
        for (FeeDetailVO detailVO : feeVO.getFeeDetailList()) {
            if (Long.valueOf("546645586985238543").equals(detailVO.getFeePropId()) && jxfSet.contains(detailVO.getId())) {
                qtjxfId = detailVO.getId();
            }
        }
        if (null == qtjxfId) {
            throw new BusinessException("费用模板中未配置【其他机械设备费】的费用项，无法转换！");
        }

        CommonResponse<List<EquipmentCategoryVO>> equipCtyResponse = _restApi.queryCategoryListByIds(new ArrayList<>());
        Map<Long, String> equipCtyLongInnerMap = new HashMap<>();
        Map<String, String> equipCtyStringInnerMap = new HashMap<>();
        for (EquipmentCategoryVO categoryVO : equipCtyResponse.getData()) {
            equipCtyLongInnerMap.put(categoryVO.getId(), categoryVO.getInnerCode());
            equipCtyStringInnerMap.put(categoryVO.getCode(), categoryVO.getInnerCode());
        }

        List<String> codeList = buildDutyVO.getBuildEquipmentList().stream()
                .filter(equipmentVO -> null != equipmentVO.getLeafFlag() && equipmentVO.getLeafFlag() && StringUtils.isNotBlank(equipmentVO.getEquipmentCode()))
                .map(BuildEquipmentVO::getEquipmentCode).collect(Collectors.toList());

        CommonResponse<List<EquipmentVO>> equipResponse = _restApi.queryEquipmentListByCodes(codeList);
        Map<String, EquipmentVO> equipMap = new HashMap<>();
        if (equipResponse.isSuccess() && CollectionUtils.isNotEmpty(equipResponse.getData())) {
            equipMap = equipResponse.getData().stream().collect(Collectors.toMap(EquipmentVO::getCode, Function.identity(), (key1, key2) -> key1));
        }

        int num = 1;
        for (BuildEquipmentVO buildEquipmentVO : buildDutyVO.getBuildEquipmentList()) {
            if (null == buildEquipmentVO.getLeafFlag() || !buildEquipmentVO.getLeafFlag()) {
                continue;
            }
            for (DutyDetailEntity detailEntity : dutyEntity.getDutyDetailList()) {
                if (!detailEntity.getLeafFlag()) {
                    continue;
                }
                //匹配到档案
                if (StringUtils.isNotBlank(buildEquipmentVO.getEquipmentCode()) && equipMap.containsKey(buildEquipmentVO.getEquipmentCode())) {
                    EquipmentVO equipmentVO = equipMap.get(buildEquipmentVO.getEquipmentCode());
                    String innerCode = equipCtyLongInnerMap.get(equipmentVO.getCategoryId());
                    //1.有分类主键说明是选分类添加 2.内码包含分类主键 3.是“材料费”下的
                    if (((null != detailEntity.getCategoryId() && innerCode.contains(String.valueOf(detailEntity.getCategoryId())))
                            || (null == detailEntity.getCategoryId() && TreeNodeBUtil.judgeContain(innerCode, detailEntity.getCategoryInnerCode()))
                            && jxfSet.contains(detailEntity.getFeeDetailId()))) {
                        List<DutyDetailItemEntity> itemList = CollectionUtils.isNotEmpty(detailEntity.getDutyDetailItemList()) ? detailEntity.getDutyDetailItemList() : new ArrayList<>();
                        DutyDetailItemEntity itemEntity = new DutyDetailItemEntity();
                        itemEntity.setId(IdWorker.getId());
                        itemEntity.setCode(equipmentVO.getCode());
                        itemEntity.setName(equipmentVO.getName());
                        itemEntity.setModel(equipmentVO.getSpec());
                        itemEntity.setUnitId(equipmentVO.getUnitId());
                        itemEntity.setUnitName(equipmentVO.getUnitName());
                        itemEntity.setTaxRate(buildEquipmentVO.getEquipmentRate());
                        itemEntity.setPrice(buildEquipmentVO.getEquipmentPrice());
                        itemEntity.setTaxPrice(buildEquipmentVO.getEquipmentTaxPrice());
                        itemEntity.setAmount(buildEquipmentVO.getEquipmentNum());
                        itemEntity.setMny(buildEquipmentVO.getEquipmentMny());
                        itemEntity.setTaxMny(buildEquipmentVO.getEquipmentTaxMny());
                        itemEntity.setRmatRentMonth(buildEquipmentVO.getEquipmentRentMonth());
                        itemEntity.setCategoryId(equipmentVO.getCategoryId());
                        itemEntity.setCategoryInnerCode(innerCode);
                        itemEntity.setCategoryName(equipmentVO.getCategoryName());
                        itemEntity.setDocType(DocTypeEnum.设备档案.getCode());
                        itemEntity.setDocId(equipmentVO.getId());
                        itemList.add(itemEntity);
                        detailEntity.setDutyDetailItemList(itemList);
                    }
                } else if (StringUtils.isNotBlank(buildEquipmentVO.getEquipmentCode()) && equipCtyStringInnerMap.containsKey(buildEquipmentVO.getEquipmentCode())) {//匹配到分类
                    String innerCode = equipCtyStringInnerMap.get(buildEquipmentVO.getEquipmentCode());
                    //1.有分类主键说明是选分类添加 2.内码包含分类主键 3.是“材料费”下的
                    if (((null != detailEntity.getCategoryId() && innerCode.contains(String.valueOf(detailEntity.getCategoryId())))
                            || (null == detailEntity.getCategoryId() && TreeNodeBUtil.judgeContain(innerCode, detailEntity.getCategoryInnerCode()))
                            && jxfSet.contains(detailEntity.getFeeDetailId()))) {
                        detailEntity.setPreTypeAmount(ComputeUtil.safeAdd(detailEntity.getPreTypeAmount(), buildEquipmentVO.getEquipmentNum()));
                        detailEntity.setMny(ComputeUtil.safeAdd(detailEntity.getMny(), buildEquipmentVO.getEquipmentMny()));
                        detailEntity.setTaxMny(ComputeUtil.safeAdd(detailEntity.getTaxMny(), buildEquipmentVO.getEquipmentTaxMny()));
                    }
                } else if (detailEntity.getFeeDetailId().equals(qtjxfId)) {//匹配不到档案且子表为“其他机械设备费”
                    List<DutyDetailItemEntity> itemList = CollectionUtils.isNotEmpty(detailEntity.getDutyDetailItemList()) ? detailEntity.getDutyDetailItemList() : new ArrayList<>();
                    DutyDetailItemEntity itemEntity = new DutyDetailItemEntity();
                    itemEntity.setId(IdWorker.getId());
                    if (StringUtils.isBlank(buildEquipmentVO.getEquipmentCode())) {
                        itemEntity.setCode(String.valueOf(num));
                    } else {
                        itemEntity.setCode(buildEquipmentVO.getEquipmentCode());
                    }
                    itemEntity.setName(buildEquipmentVO.getEquipmentName());
                    itemEntity.setUnitName(buildEquipmentVO.getEquipmentUnitName());
                    itemEntity.setTaxRate(buildEquipmentVO.getEquipmentRate());
                    itemEntity.setPrice(buildEquipmentVO.getEquipmentPrice());
                    itemEntity.setTaxPrice(buildEquipmentVO.getEquipmentTaxPrice());
                    itemEntity.setAmount(buildEquipmentVO.getEquipmentNum());
                    itemEntity.setMny(buildEquipmentVO.getEquipmentMny());
                    itemEntity.setTaxMny(buildEquipmentVO.getEquipmentTaxMny());
                    itemEntity.setRmatRentMonth(buildEquipmentVO.getEquipmentRentMonth());
                    itemEntity.setDocType(6);
                    itemList.add(itemEntity);
                    detailEntity.setDutyDetailItemList(itemList);
                }
            }
            if (StringUtils.isBlank(buildEquipmentVO.getEquipmentCode())) {
                num++;
            }
        }

        return dutyEntity;
    }

    @Override
    public List<DutyEntity> handlerDetail(DutyEntity dutyEntity, FeeVO feeVO, BaseVO baseVO) {
        List<DutyEntity> resp = new ArrayList<>();
        BuildDutyVO buildDutyVO = (BuildDutyVO) baseVO;
        //物资分类的内码map
//        Map<Long, String> matCtyLongInnerMap = new HashMap<>();
//        Map<String, String> matCtyStringInnerMap = new HashMap<>();

        //人工费
//        dealLasubData(buildDutyVO, dutyEntity, feeVO, shareLabsubApi);
        //专业分包费
//        dealProsubData(buildDutyVO, dutyEntity, feeVO, shareProsubApi);
        //主要材料费
//        dealMaterialData(buildDutyVO, dutyEntity, feeVO, shareMaterialApi); //, matCtyLongInnerMap, matCtyStringInnerMap
        //机械设备费
//        dealEquipData(buildDutyVO, dutyEntity, feeVO, shareEquipmentApi);

//        dealCommonData(buildDutyVO.getBuildSafeList(), dutyEntity, feeVO, "安文环保临设二次搬运");
//        dealCommonData(buildDutyVO.getBuildNightList(), dutyEntity, feeVO, "冬雨季夜间施工");
//        dealCommonData(buildDutyVO.getBuildPrecipitationList(), dutyEntity, feeVO, "排降水");
//        dealCommonData(buildDutyVO.getBuildCompleteList(), dutyEntity, feeVO, "已完工程及设备保护");
//        dealCommonData(buildDutyVO.getBuildTemplatesList(), dutyEntity, feeVO, "模板及支撑费用");
//        dealCommonData(buildDutyVO.getBuildScaffoldList(), dutyEntity, feeVO, "脚手架");
//        dealCommonData(buildDutyVO.getBuildMeasureList(), dutyEntity, feeVO, "其他措施费");
//        dealCommonData(buildDutyVO.getBuildIndirectList(), dutyEntity, feeVO, "间接费");
//        dealCommonData(buildDutyVO.getBuildStimulateList(), dutyEntity, feeVO, "激励奖");

        Map<String, Object> handleApi = new HashMap<>();
        handleApi.put("人工费", shareLabsubApi);
        handleApi.put("专业分包费", shareProsubApi);
        handleApi.put("甲指分包", shareProsubApi);
        handleApi.put("主要材料费", shareMaterialApi);
        handleApi.put("机具使用费", shareEquipmentApi);
        handleApi.put("安文环保临设二次搬运", null);
        handleApi.put("冬雨季夜间施工", null);
        handleApi.put("排降水", null);
        handleApi.put("已完工程及设备保护", null);
        handleApi.put("模板及支撑", null);
        handleApi.put("脚手架", null);
        handleApi.put("其他措施费", null);
        handleApi.put("间接费", null);
        handleApi.put("激励奖", null);

//        List<String>
//        Callable<DutyEntity> labsubCallable = new LasubChangeCallable(labsubApi, buildDutyVO, dutyEntity, feeVO);
//        Future<DutyEntity> labsubFuture = threadPool.submit(labsubCallable);

        ExecutorService threadPool = Executors.newFixedThreadPool(6);
        List<Future<DutyEntity>> futures = new ArrayList<>();
        CommonCallable call = null;
        Future<DutyEntity> future = null;
        for(String handleType : handleApi.keySet()) {
            call = new CommonCallable(buildDutyVO, dutyEntity, feeVO, handleType, handleApi.get(handleType));
            future = threadPool.submit(call);
            futures.add(future);
        }

        try {
            for(Future<DutyEntity> f : futures) {
                resp.add(f.get());
            }
        } catch (Exception e) {
            logger.error("目标成本转换异常：", e);
            throw new BusinessException("目标成本转换异常, ", e);
        } finally {
            threadPool.shutdown();
        }

        return resp;
    }

    private <T extends CommonImportDataVO> DutyEntity dealCommonData(List<T> vos, DutyEntity sourceDutyEntity, FeeVO feeVO, String feeName) {
        DutyEntity dutyEntity = BeanMapper.map(sourceDutyEntity, DutyEntity.class);
        //安全文明施工费
        Long aqwmsgfId = null;
        for (FeeDetailVO detailVO : feeVO.getFeeDetailList()) {
            if (feeName.equals(detailVO.getName())) {
                aqwmsgfId = detailVO.getId();
            }
        }

        int num = 1;
        for (CommonImportDataVO cData : vos) {
            if (null == cData.getcLeafFlag() || !cData.getcLeafFlag()) {
                continue;
            }
            for (DutyDetailEntity detailEntity : dutyEntity.getDutyDetailList()) {
                if (!detailEntity.getLeafFlag()) {
                    continue;
                }
                if (detailEntity.getFeeDetailId().equals(aqwmsgfId)) {
                    List<DutyDetailItemEntity> itemList = CollectionUtils.isNotEmpty(detailEntity.getDutyDetailItemList()) ? detailEntity.getDutyDetailItemList() : new ArrayList<>();
                    DutyDetailItemEntity itemEntity = new DutyDetailItemEntity();
                    itemEntity.setId(IdWorker.getId());
                    if (StringUtils.isBlank(cData.getcCode())) {
                        itemEntity.setCode(String.valueOf(num));
                    } else {
                        itemEntity.setCode(cData.getcCode());
                    }
                    itemEntity.setName(cData.getcName());
                    itemEntity.setUnitName(cData.getcUnitName());
                    itemEntity.setTaxRate(cData.getcTaxRate());
                    itemEntity.setPrice(cData.getcPrice());
                    itemEntity.setTaxPrice(cData.getcTaxPrice());
                    itemEntity.setAmount(cData.getcAmount());
                    itemEntity.setMny(cData.getcMny());
                    itemEntity.setTaxMny(cData.getcTaxMny());
                    itemEntity.setDocType(6);
                    itemList.add(itemEntity);
                    detailEntity.setDutyDetailItemList(itemList);
                }
            }
            num++;
        }

        return dutyEntity;
    }

    @Override
    public void checkFeeCode(FeeVO feeVO) {
        //检测费用模板中是否配置对应的费用项
        List<String> handWriteFeeNames = new ArrayList<>();
        handWriteFeeNames.add("安全文明、环境保护、临时设施、二次搬运");
        handWriteFeeNames.add("冬雨季、夜间施工");
        handWriteFeeNames.add("排、降水");
        handWriteFeeNames.add("已完工程及设备保护");
        handWriteFeeNames.add("模板及支撑");
        handWriteFeeNames.add("脚手架");
        handWriteFeeNames.add("其他措施费");
        handWriteFeeNames.add("间接费");
        handWriteFeeNames.add("激励奖");

        handWriteFeeNames.removeAll(feeVO.getFeeDetailList().stream().filter(detail -> null == detail.getParentId()).map(FeeDetailVO::getName).collect(Collectors.toList()));

        if(CollectionUtils.isNotEmpty(handWriteFeeNames)) {
            logger.info("***** 费用模板缺少配置的费用项名称：{}", StringUtils.join(handWriteFeeNames, ","));
            throw new BusinessException("费用模板中未配置【"+handWriteFeeNames.get(0)+"】的费用项，无法转换！");
        }
    }

    class CommonCallable implements Callable<DutyEntity> {
        private RequestAttributes context = RequestContextHolder.getRequestAttributes();
        private BuildDutyVO buildDutyVO;
        private DutyEntity baseDutyEntity;
        private FeeVO feeVO;
        private String handleType;
        private Object restApi;

        public CommonCallable(BuildDutyVO buildDutyVO, DutyEntity baseDutyEntity, FeeVO feeVO, String handleType, Object restApi) {
            this.buildDutyVO = buildDutyVO;
            this.baseDutyEntity = baseDutyEntity;
            this.feeVO = feeVO;
            this.handleType = handleType;
            this.restApi = restApi;
        }

        @Override
        public DutyEntity call() throws Exception {
            RequestContextHolder.setRequestAttributes(context);
            switch (handleType) {
                case "人工费":
                    return dealLasubData(buildDutyVO, baseDutyEntity, feeVO, restApi);
                case "专业分包费":
                    return dealProsubData(buildDutyVO, baseDutyEntity, feeVO, restApi);
                case "甲指分包":
                    return dealProsub2Data(buildDutyVO, baseDutyEntity, feeVO, restApi);
                case "主要材料费":
                    return dealMaterialData(buildDutyVO, baseDutyEntity, feeVO, restApi);
                case "机具使用费":
                    return dealEquipData(buildDutyVO, baseDutyEntity, feeVO, restApi);
                case "安全文明、环境保护、临时设施、二次搬运":
                    return dealCommonData(buildDutyVO.getBuildSafeList(), baseDutyEntity, feeVO, handleType);
                case "冬雨季、夜间施工":
                    return dealCommonData(buildDutyVO.getBuildNightList(), baseDutyEntity, feeVO, handleType);
                case "排、降水":
                    return dealCommonData(buildDutyVO.getBuildPrecipitationList(), baseDutyEntity, feeVO, handleType);
                case "已完工程及设备保护":
                    return dealCommonData(buildDutyVO.getBuildCompleteList(), baseDutyEntity, feeVO, handleType);
                case "模板及支撑":
                    return dealCommonData(buildDutyVO.getBuildTemplatesList(), baseDutyEntity, feeVO, handleType);
                case "脚手架":
                    return dealCommonData(buildDutyVO.getBuildScaffoldList(), baseDutyEntity, feeVO, handleType);
                case "其他措施费":
                    return dealCommonData(buildDutyVO.getBuildMeasureList(), baseDutyEntity, feeVO, handleType);
                case "间接费":
                    return dealCommonData(buildDutyVO.getBuildIndirectList(), baseDutyEntity, feeVO, handleType);
                case "激励奖":
                    return dealCommonData(buildDutyVO.getBuildStimulateList(), baseDutyEntity, feeVO, handleType);
                default:
                    throw new BusinessException("错误的费用名称" + handleType);
            }
        }
    }
}
