package com.ejianc.business.roadbridge.bean;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
/**
 * 路桥-目标责任成本
 *
 * @author generator
 *
 */
 @TableName("ejc_targetcost_roadbridge_duty")
public class RoadbridgeDutyEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;

    @TableField(value="project_id")
    private Long projectId; // 项目主键
    @TableField(value="project_code")
    private String projectCode; // 项目编号
    @TableField(value="project_name")
    private String projectName; // 项目名称
    @TableField(value="units_name")
    private String unitsName; // 建设单位
    @TableField(value="org_id")
    private Long orgId; // 项目部主键
    @TableField(value="org_name")
    private String orgName; // 项目部名称
    @TableField(value="org_code")
    private String orgCode; // 项目组织编码
    @TableField(value="parent_org_id")
    private Long parentOrgId; // 组织ID
    @TableField(value="parent_org_name")
    private String parentOrgName; // 组织名称
    @TableField(value="parent_org_code")
    private String parentOrgCode; // 组织编码
    @TableField(value="bill_code")
    private String billCode; // 单据编码
    @TableField(value="name")
    private String name; // 目标责任成本名称
    @TableField(value="fee_id")
    private Long feeId; // 费用模板主键
    @TableField(value="fee_name")
    private String feeName; // 费用模板名称
    @TableField(value="wbs_id")
    private Long wbsId; // 核算对象主键
    @TableField(value="wbs_code")
    private String wbsCode; // 核算对象编号
    @TableField(value="wbs_name")
    private String wbsName; // 核算对象名称
    @TableField(value="scale")
    private BigDecimal scale; // 不可预见费比例
    @TableField(value="tax_rate")
    private BigDecimal taxRate; // 税率
    @TableField(value="mny")
    private BigDecimal mny; // 目标成本金额(无税)
    @TableField(value="tax_mny")
    private BigDecimal taxMny; // 目标成本金额
    @TableField(value="before_mny")
    private BigDecimal beforeMny; // 变更前金额(无税)
    @TableField(value="before_tax_mny")
    private BigDecimal beforeTaxMny; // 变更前金额
    @TableField(value="convert_flag")
    private Integer convertFlag; // 转换状态 1-是 0-否
    @TableField(value="latest_flag")
    private Boolean latestFlag; // 是否最新版本
    @TableField(value="enable_state")
    private Boolean enableState; // 是否生效
    @TableField(value="memo")
    private String memo; // 备注
    @TableField(value="project_profile")
    private String projectProfile; // 工程概况
    @TableField(value="duty_version")
    private Integer dutyVersion; // 目标责任成本版本
    @TableField(value="last_duty_id")
    private Long lastDutyId; // 上一版本主键
    @TableField(value="change_id")
    private Long changeId; // 变更单主键
    @TableField(value="change_state")
    private Integer changeState; // 变更状态(0-未变更1-变更中2-已变更)
    @TableField(value="bill_state")
    private Integer billState; // 审批状态
    @TableField(value="employee_id")
    private Long employeeId; // 经办人
    @TableField(value="employee_name")
    private String employeeName; // 经办人名称
    @TableField(value="department_id")
    private Long departmentId; // 经办部门
    @TableField(value="department_name")
    private String departmentName; // 经办部门名称
    @TableField(value="before_duty_version")
    private Integer beforeDutyVersion; // 历史版本号
    @TableField(value="one_time")
    private Date oneTime; // 第一版本创建时间
    @TableField(value="base_duty_id")
    private Long baseDutyId; // 原始版本主键


    @TableField(exist=false)
    @SubEntity(serviceName="dutyPlansService", pidName = "dutyId")//此处有pid="xxx"，默认值pid="pid"
    private List<DutyPlansEntity> dutyPlansList = new ArrayList<>(); // 路桥-目标成本-计划汇总表
    @TableField(exist=false)
    @SubEntity(serviceName="dutyOneService", pidName = "dutyId")//此处有pid="xxx"，默认值pid="pid"
    private List<DutyOneEntity> dutyOneList = new ArrayList<>(); // 路桥-目标成本-100章
    @TableField(exist=false)
    @SubEntity(serviceName="dutyTwoService", pidName = "dutyId")//此处有pid="xxx"，默认值pid="pid"
    private List<DutyTwoEntity> dutyTwoList = new ArrayList<>(); // 路桥-目标成本-200章
    @TableField(exist=false)
    @SubEntity(serviceName="dutyMaterialService", pidName = "dutyId")//此处有pid="xxx"，默认值pid="pid"
    private List<DutyMaterialEntity> dutyMaterialList = new ArrayList<>(); // 路桥-目标成本-主要材料费
    @TableField(exist=false)
    @SubEntity(serviceName="dutyRmatService", pidName = "dutyId")//此处有pid="xxx"，默认值pid="pid"
    private List<DutyRmatEntity> dutyRmatList = new ArrayList<>(); // 路桥-目标成本-周转材料费
    @TableField(exist=false)
    @SubEntity(serviceName="dutyEquipmentService", pidName = "dutyId")//此处有pid="xxx"，默认值pid="pid"
    private List<DutyEquipmentEntity> dutyEquipmentList = new ArrayList<>(); // 路桥-目标成本-机械设备费
    @TableField(exist=false)
    @SubEntity(serviceName="dutyJjfService", pidName = "dutyId")//此处有pid="xxx"，默认值pid="pid"
    private List<DutyJjfEntity> dutyJjfList = new ArrayList<>(); // 路桥-目标成本-间接费
    @TableField(exist=false)
    @SubEntity(serviceName="dutyOtherService", pidName = "dutyId")//此处有pid="xxx"，默认值pid="pid"
    private List<DutyOtherEntity> dutyOtherList = new ArrayList<>(); // 路桥-目标成本-其他工程费
    @TableField(exist=false)
    @SubEntity(serviceName="dutyUsenumService", pidName = "dutyId")//此处有pid="xxx"，默认值pid="pid"
    private List<DutyUsenumEntity> dutyUsenumList = new ArrayList<>(); // 路桥-目标成本-主要材料用量表


    public Long getProjectId() {
        return projectId;
    }

    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }

    public String getProjectCode() {
        return projectCode;
    }

    public void setProjectCode(String projectCode) {
        this.projectCode = projectCode;
    }

    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    public String getUnitsName() {
        return unitsName;
    }

    public void setUnitsName(String unitsName) {
        this.unitsName = unitsName;
    }
    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    public String getOrgCode() {
        return orgCode;
    }

    public void setOrgCode(String orgCode) {
        this.orgCode = orgCode;
    }
    public Long getParentOrgId() {
        return parentOrgId;
    }

    public void setParentOrgId(Long parentOrgId) {
        this.parentOrgId = parentOrgId;
    }
    public String getParentOrgName() {
        return parentOrgName;
    }

    public void setParentOrgName(String parentOrgName) {
        this.parentOrgName = parentOrgName;
    }
    public String getParentOrgCode() {
        return parentOrgCode;
    }

    public void setParentOrgCode(String parentOrgCode) {
        this.parentOrgCode = parentOrgCode;
    }
    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }
    public Long getFeeId() {
        return feeId;
    }

    public void setFeeId(Long feeId) {
        this.feeId = feeId;
    }
    public String getFeeName() {
        return feeName;
    }

    public void setFeeName(String feeName) {
        this.feeName = feeName;
    }

    public Long getWbsId() {
        return wbsId;
    }

    public void setWbsId(Long wbsId) {
        this.wbsId = wbsId;
    }
    public String getWbsCode() {
        return wbsCode;
    }

    public void setWbsCode(String wbsCode) {
        this.wbsCode = wbsCode;
    }
    public String getWbsName() {
        return wbsName;
    }

    public void setWbsName(String wbsName) {
        this.wbsName = wbsName;
    }
    public BigDecimal getScale() {
        return scale;
    }

    public void setScale(BigDecimal scale) {
        this.scale = scale;
    }
    public BigDecimal getTaxRate() {
        return taxRate;
    }

    public void setTaxRate(BigDecimal taxRate) {
        this.taxRate = taxRate;
    }
    public BigDecimal getMny() {
        return mny;
    }

    public void setMny(BigDecimal mny) {
        this.mny = mny;
    }
    public BigDecimal getTaxMny() {
        return taxMny;
    }

    public void setTaxMny(BigDecimal taxMny) {
        this.taxMny = taxMny;
    }
    public BigDecimal getBeforeMny() {
        return beforeMny;
    }

    public void setBeforeMny(BigDecimal beforeMny) {
        this.beforeMny = beforeMny;
    }
    public BigDecimal getBeforeTaxMny() {
        return beforeTaxMny;
    }

    public void setBeforeTaxMny(BigDecimal beforeTaxMny) {
        this.beforeTaxMny = beforeTaxMny;
    }
    public Integer getConvertFlag() {
        return convertFlag;
    }

    public void setConvertFlag(Integer convertFlag) {
        this.convertFlag = convertFlag;
    }

    public Boolean getLatestFlag() {
        return latestFlag;
    }

    public void setLatestFlag(Boolean latestFlag) {
        this.latestFlag = latestFlag;
    }

    public Boolean getEnableState() {
        return enableState;
    }

    public void setEnableState(Boolean enableState) {
        this.enableState = enableState;
    }

    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }
    public String getProjectProfile() {
        return projectProfile;
    }

    public void setProjectProfile(String projectProfile) {
        this.projectProfile = projectProfile;
    }
    public Integer getDutyVersion() {
        return dutyVersion;
    }

    public void setDutyVersion(Integer dutyVersion) {
        this.dutyVersion = dutyVersion;
    }
    public Long getLastDutyId() {
        return lastDutyId;
    }

    public void setLastDutyId(Long lastDutyId) {
        this.lastDutyId = lastDutyId;
    }
    public Long getChangeId() {
        return changeId;
    }

    public void setChangeId(Long changeId) {
        this.changeId = changeId;
    }
    public Integer getChangeState() {
        return changeState;
    }

    public void setChangeState(Integer changeState) {
        this.changeState = changeState;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }

    public Long getEmployeeId() {
        return employeeId;
    }

    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }
    public String getEmployeeName() {
        return employeeName;
    }

    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }

    public Long getDepartmentId() {
        return departmentId;
    }

    public void setDepartmentId(Long departmentId) {
        this.departmentId = departmentId;
    }
    public String getDepartmentName() {
        return departmentName;
    }

    public void setDepartmentName(String departmentName) {
        this.departmentName = departmentName;
    }
    public Integer getBeforeDutyVersion() {
        return beforeDutyVersion;
    }

    public void setBeforeDutyVersion(Integer beforeDutyVersion) {
        this.beforeDutyVersion = beforeDutyVersion;
    }
    public Date getOneTime() {
        return oneTime;
    }

    public void setOneTime(Date oneTime) {
        this.oneTime = oneTime;
    }
    public Long getBaseDutyId() {
        return baseDutyId;
    }

    public void setBaseDutyId(Long baseDutyId) {
        this.baseDutyId = baseDutyId;
    }

    public List<DutyPlansEntity> getDutyPlansList() {
        return dutyPlansList;
    }

    public void setDutyPlansList(List<DutyPlansEntity> dutyPlansList) {
        this.dutyPlansList = dutyPlansList;
    }
    public List<DutyOneEntity> getDutyOneList() {
        return dutyOneList;
    }

    public void setDutyOneList(List<DutyOneEntity> dutyOneList) {
        this.dutyOneList = dutyOneList;
    }
    public List<DutyTwoEntity> getDutyTwoList() {
        return dutyTwoList;
    }

    public void setDutyTwoList(List<DutyTwoEntity> dutyTwoList) {
        this.dutyTwoList = dutyTwoList;
    }
    public List<DutyMaterialEntity> getDutyMaterialList() {
        return dutyMaterialList;
    }

    public void setDutyMaterialList(List<DutyMaterialEntity> dutyMaterialList) {
        this.dutyMaterialList = dutyMaterialList;
    }
    public List<DutyRmatEntity> getDutyRmatList() {
        return dutyRmatList;
    }

    public void setDutyRmatList(List<DutyRmatEntity> dutyRmatList) {
        this.dutyRmatList = dutyRmatList;
    }
    public List<DutyEquipmentEntity> getDutyEquipmentList() {
        return dutyEquipmentList;
    }

    public void setDutyEquipmentList(List<DutyEquipmentEntity> dutyEquipmentList) {
        this.dutyEquipmentList = dutyEquipmentList;
    }
    public List<DutyJjfEntity> getDutyJjfList() {
        return dutyJjfList;
    }

    public void setDutyJjfList(List<DutyJjfEntity> dutyJjfList) {
        this.dutyJjfList = dutyJjfList;
    }
    public List<DutyOtherEntity> getDutyOtherList() {
        return dutyOtherList;
    }

    public void setDutyOtherList(List<DutyOtherEntity> dutyOtherList) {
        this.dutyOtherList = dutyOtherList;
    }
    public List<DutyUsenumEntity> getDutyUsenumList() {
        return dutyUsenumList;
    }

    public void setDutyUsenumList(List<DutyUsenumEntity> dutyUsenumList) {
        this.dutyUsenumList = dutyUsenumList;
    }
}
