package com.ejianc.business.roadbridge.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.roadbridge.bean.RoadbridgeDutyEntity;
import com.ejianc.business.roadbridge.service.IRoadbridgeDutyService;
import com.ejianc.business.roadbridge.vo.RoadbridgeDutyVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.ComplexParam;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.core.util.ImportTemplate;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * 路桥-目标责任成本
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("roadbridgeDuty")
public class RoadbridgeDutyController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IOrgApi iOrgApi;

    @Autowired
    private IRoadbridgeDutyService service;

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<RoadbridgeDutyVO> saveOrUpdate(@RequestBody RoadbridgeDutyVO saveOrUpdateVO) {
    	return service.saveOrUpdate(saveOrUpdateVO);
    }

    /**
     * @Description ConvertFlag 转换
     * @param id
     */
    @RequestMapping(value = "/ConvertFlag", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<RoadbridgeDutyVO> ConvertFlag(Long id) {
        return CommonResponse.success("转换成功！",service.ConvertFlag(id));
    }

    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<RoadbridgeDutyVO> queryDetail(Long id) {
        return CommonResponse.success("查询详情数据成功！",service.queryDetail(id));
    }

    /**
     * @Description queryChangeDetail 复制为变更单 取详情
     * @param id
     */
    @RequestMapping(value = "/queryChangeDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<RoadbridgeDutyVO> queryChangeDetail(Long id) {
        RoadbridgeDutyVO changeVO = service.queryChangeDetail(id);
        return CommonResponse.success("查询详情数据成功！", changeVO);
    }

    /**
     * @Description queryDetailByProject
     * @param id
     */
    @RequestMapping(value = "/queryDetailByProject", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<RoadbridgeDutyVO> queryDetailByProject(Long id) {
        RoadbridgeDutyVO resVo = new RoadbridgeDutyVO();
        LambdaQueryWrapper<RoadbridgeDutyEntity> queryWrapper = new LambdaQueryWrapper<>();
        queryWrapper.eq(RoadbridgeDutyEntity::getProjectId, id);
        queryWrapper.orderByDesc(RoadbridgeDutyEntity::getCreateTime);
        List<RoadbridgeDutyEntity> roadbridgeDutyEntities = service.list(queryWrapper);
        if(CollectionUtils.isNotEmpty(roadbridgeDutyEntities)){
            resVo = BeanMapper.map(roadbridgeDutyEntities.get(0),RoadbridgeDutyVO.class);
        }
        return CommonResponse.success("查询详情数据成功！",resVo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<RoadbridgeDutyVO> vos) {
        return service.deleteVos(vos);
    }

    /**
     * @Description queryRecordList 查询变更历史记录
     * @param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryRecordList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<List<RoadbridgeDutyVO>> queryRecordList(Long id) {
        List<RoadbridgeDutyVO> list = new ArrayList<>();
        LambdaQueryWrapper<RoadbridgeDutyEntity> queryWrapper = new LambdaQueryWrapper<>();
        queryWrapper.eq(RoadbridgeDutyEntity::getBaseDutyId, id);
        queryWrapper.orderByAsc(RoadbridgeDutyEntity::getCreateTime);
        List<RoadbridgeDutyEntity> roadbridgeDutyEntities = service.list(queryWrapper);
        if(CollectionUtils.isNotEmpty(roadbridgeDutyEntities)){
            list = BeanMapper.mapList(roadbridgeDutyEntities,RoadbridgeDutyVO.class);
        }
        return CommonResponse.success("查询列表数据成功！",list);
    }

    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<RoadbridgeDutyVO>> queryList(@RequestBody QueryParam param) {

        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("projectName");
        fuzzyFields.add("name");
        fuzzyFields.add("feeName");
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        /** 数据隔离 本下 没有组织orgId的删除下面代码-------------开始 */
        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        /** 数据隔离 本下 没有组织orgId的删除上面代码-------------结束！！！ */
       /** 数据隔离 本下 没有组织orgId的删除下面代码 */

        /*  1>【是否生效】为是的 + 第一版本没审批通过的（审批中的+自由态）单据；
            2> 如果生效的目标成本当前存在修订中的单据（未审批通过的），在操作列显示变更按钮跳转到对应单据。（【是否最新版本】=否  【是否生效】=是）
            3>【是否最新版本】=是  【是否生效】=是 时，操作列显示 修订 按钮，点击跳转到单据修订页面*/
        //复合条件
        ComplexParam resultComplexParam = new ComplexParam();
        resultComplexParam.setLogic("and");

        //生效
        ComplexParam c1 = new ComplexParam();
        c1.setLogic("and");
        c1.getParams().put("enableState", new Parameter(QueryParam.EQ, true));//生效

        ComplexParam complex2 = new ComplexParam();
        complex2.setLogic("or");
        //不生效
        ComplexParam c2 = new ComplexParam();
        c2.setLogic("and");
        c2.getParams().put("bill_state", new Parameter(QueryParam.NOT_IN, "1,3"));//非已提交和已通过
        complex2.getComplexParams().add(c2);
        ComplexParam c3 = new ComplexParam();
        c3.setLogic("and");
        c3.getParams().put("enableState", new Parameter(QueryParam.EQ, false));//不生效
        complex2.getComplexParams().add(c3);
        ComplexParam c5 = new ComplexParam();
        c5.setLogic("and");
        c5.getParams().put("dutyVersion", new Parameter(QueryParam.EQ, "1"));//第一版本
        complex2.getComplexParams().add(c5);

        resultComplexParam.getComplexParams().add(c1);
        resultComplexParam.getComplexParams().add(complex2);
        param.getComplexParams().add(resultComplexParam);
        IPage<RoadbridgeDutyEntity> page = service.queryPage(param,false);
        IPage<RoadbridgeDutyVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
  		pageData.setRecords(BeanMapper.mapList(page.getRecords(), RoadbridgeDutyVO.class));

        return CommonResponse.success("查询列表数据成功！",pageData);
    }

    /**
     * 获取RPC数据
     * resp 返回值
     * isMustSuc 是否必须成功
     * errMsg 失败提示
     */
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if(isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }


    /**
     * @Description 导出
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("projectName");
        fuzzyFields.add("name");
        fuzzyFields.add("feeName");
        param.getParams().put("tenant_id",new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
         /*  1>【是否生效】为是的 + 第一版本没审批通过的（审批中的+自由态）单据；
            2> 如果生效的目标成本当前存在修订中的单据（未审批通过的），在操作列显示变更按钮跳转到对应单据。（【是否最新版本】=否  【是否生效】=是）
            3>【是否最新版本】=是  【是否生效】=是 时，操作列显示 修订 按钮，点击跳转到单据修订页面*/
        //复合条件
        ComplexParam resultComplexParam = new ComplexParam();
        resultComplexParam.setLogic("and");

        //生效
        ComplexParam c1 = new ComplexParam();
        c1.setLogic("and");
        c1.getParams().put("enableState", new Parameter(QueryParam.EQ, true));//生效

        ComplexParam complex2 = new ComplexParam();
        complex2.setLogic("or");
        //不生效
        ComplexParam c2 = new ComplexParam();
        c2.setLogic("and");
        c2.getParams().put("bill_state", new Parameter(QueryParam.NOT_IN, "1,3"));//非已提交和已通过
        complex2.getComplexParams().add(c2);
        ComplexParam c3 = new ComplexParam();
        c3.setLogic("and");
        c3.getParams().put("enableState", new Parameter(QueryParam.EQ, false));//不生效
        complex2.getComplexParams().add(c3);
        ComplexParam c5 = new ComplexParam();
        c5.setLogic("and");
        c5.getParams().put("dutyVersion", new Parameter(QueryParam.EQ, "1"));//第一版本
        complex2.getComplexParams().add(c5);

        resultComplexParam.getComplexParams().add(c1);
        resultComplexParam.getComplexParams().add(complex2);
        param.getComplexParams().add(resultComplexParam);
        List<RoadbridgeDutyEntity> list = service.queryList(param);
        //todo:字段翻译等等
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", list);
        ExcelExport.getInstance().export("RoadbridgeDuty-export.xlsx", beans, response);
    }

    /**
     * @Description 参照
     * @Return void
     */
    @RequestMapping(value = "/refRoadbridgeDutyData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<RoadbridgeDutyVO>> refRoadbridgeDutyData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                        String condition,
                                                                        String searchObject,
                                                                        String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if(StringUtils.isNotEmpty(condition)){
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
        }

        IPage<RoadbridgeDutyEntity> page = service.queryPage(param,false);
        IPage<RoadbridgeDutyVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), RoadbridgeDutyVO.class));

        return CommonResponse.success("查询参照数据成功！",pageData);
     }

    /**
     * 导入模板下载(清单模式)
     *
     * @param request
     * @param response
     */
    @RequestMapping(value = "/downloadInfo")
    @ResponseBody
    public void downloadInfo(HttpServletRequest request, HttpServletResponse response) {
        ImportTemplate.initialize(response);
        ImportTemplate.templetdownload(request, "budget-info-import.xlsx", "路桥项目目标责任成本导入模板");
    }

    /**
     * excel导入(清单模式)
     *
     * @param request
     * @return
     */
    @RequestMapping(value = "/excelImportInfo", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<JSONObject> excelImportInfo(HttpServletRequest request, HttpServletResponse response) {
        return service.excelImportInfo(request,response);
    }
}
