package com.ejianc.business.sx2j.build.bean;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
/**
 * 房建-目标责任成本
 *
 * @author generator
 *
 */
 @TableName("ejc_targetcost_build_duty")
public class BuildDutyEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;

    @TableField(value="project_id")
    private Long projectId; // 项目主键
    @TableField(value="project_name")
    private String projectName; // 项目名称
    @TableField(value="units_name")
    private String unitsName; // 建设单位
    @TableField(value="org_id")
    private Long orgId; // 项目部主键
    @TableField(value="org_name")
    private String orgName; // 项目部名称
    @TableField(value="org_code")
    private String orgCode; // 项目组织编码
    @TableField(value="parent_org_id")
    private Long parentOrgId; // 组织ID
    @TableField(value="parent_org_name")
    private String parentOrgName; // 组织名称
    @TableField(value="parent_org_code")
    private String parentOrgCode; // 组织编码
    @TableField(value="bill_code")
    private String billCode; // 单据编码
    @TableField(value="name")
    private String name; // 目标责任成本名称
    @TableField(value="fee_id")
    private Long feeId; // 费用模板主键
    @TableField(value="fee_name")
    private String feeName; // 费用模板名称
    @TableField(value="wbs_id")
    private Long wbsId; // 核算对象主键
    @TableField(value="wbs_code")
    private String wbsCode; // 核算对象编号
    @TableField(value="wbs_name")
    private String wbsName; // 核算对象名称
    @TableField(value="mny")
    private BigDecimal mny; // 目标成本金额(无税)
    @TableField(value="tax_mny")
    private BigDecimal taxMny; // 目标成本金额
    @TableField(value="before_mny")
    private BigDecimal beforeMny; // 变更前金额(无税)
    @TableField(value="before_tax_mny")
    private BigDecimal beforeTaxMny; // 变更前金额
    @TableField(value="convert_flag")
    private Integer convertFlag; // 转换状态 1-是 0-否
    @TableField(value="latest_flag")
    private Boolean latestFlag; // 是否最新版本
    @TableField(value="enable_state")
    private Boolean enableState; // 是否生效
    @TableField(value="memo")
    private String memo; // 备注
    @TableField(value="duty_version")
    private Integer dutyVersion; // 目标责任成本版本
    @TableField(value="last_duty_id")
    private Long lastDutyId; // 上一版本主键
    @TableField(value="change_id")
    private Long changeId; // 变更单主键
    @TableField(value="change_state")
    private Integer changeState; // 变更状态(0-未变更1-变更中2-已变更)
    @TableField(value="bill_state")
    private Integer billState; // 审批状态
    @TableField(value="employee_id")
    private Long employeeId; // 经办人
    @TableField(value="employee_name")
    private String employeeName; // 经办人名称
    @TableField(value="department_id")
    private Long departmentId; // 经办部门
    @TableField(value="department_name")
    private String departmentName; // 经办部门名称
    @TableField(value="before_duty_version")
    private Integer beforeDutyVersion; // 历史版本号
    @TableField(value="one_time")
    private Date oneTime; // 第一版本创建时间
    @TableField(value="base_duty_id")
    private Long baseDutyId; // 原始版本主键
    @TableField(value="project_code")
    private String projectCode; // 项目编码


    @TableField(exist=false)
    @SubEntity(serviceName="buildPlansService", pidName = "dutyId")//此处有pid="xxx"，默认值pid="pid"
    private List<BuildPlansEntity> buildPlansList = new ArrayList<>(); // 房建-目标成本-计划汇总表
    @TableField(exist=false)
    @SubEntity(serviceName="buildRgcostService", pidName = "dutyId")//此处有pid="xxx"，默认值pid="pid"
    private List<BuildRgcostEntity> buildRgcostList = new ArrayList<>(); // 房建-人工费
    @TableField(exist=false)
    @SubEntity(serviceName="buildSubService", pidName = "dutyId")//此处有pid="xxx"，默认值pid="pid"
    private List<BuildSubEntity> buildSubList = new ArrayList<>(); // 房建-专业分包
    @TableField(exist=false)
    @SubEntity(serviceName="buildMaterialService", pidName = "dutyId")//此处有pid="xxx"，默认值pid="pid"
    private List<BuildMaterialEntity> buildMaterialList = new ArrayList<>(); // 房建-主要材料
    @TableField(exist=false)
    @SubEntity(serviceName="buildEquipmentService", pidName = "dutyId")//此处有pid="xxx"，默认值pid="pid"
    private List<BuildEquipmentEntity> buildEquipmentList = new ArrayList<>(); // 房建-机械设备费
    @TableField(exist=false)
    @SubEntity(serviceName="buildSafeService", pidName = "dutyId")//此处有pid="xxx"，默认值pid="pid"
    private List<BuildSafeEntity> buildSafeList = new ArrayList<>(); // 房建-安全文明施工费
    @TableField(exist=false)
    @SubEntity(serviceName="buildMeasureService", pidName = "dutyId")//此处有pid="xxx"，默认值pid="pid"
    private List<BuildMeasureEntity> buildMeasureList = new ArrayList<>(); // 房建-其他措施费
    @TableField(exist=false)
    @SubEntity(serviceName="buildStimulateService", pidName = "dutyId")//此处有pid="xxx"，默认值pid="pid"
    private List<BuildStimulateEntity> buildStimulateList = new ArrayList<>(); // 房建-项目激励奖
    @TableField(exist=false)
    @SubEntity(serviceName="buildIndirectService", pidName = "dutyId")//此处有pid="xxx"，默认值pid="pid"
    private List<BuildIndirectEntity> buildIndirectList = new ArrayList<>(); //房建-间接费
    @TableField(exist=false)
    @SubEntity(serviceName="buildScaffoldService", pidName = "dutyId")//此处有pid="xxx"，默认值pid="pid"
    private List<BuildScaffoldEntity> buildScaffoldList = new ArrayList<>(); //房建-脚手架
    @TableField(exist=false)
    @SubEntity(serviceName="buildTemplatesService", pidName = "dutyId")//此处有pid="xxx"，默认值pid="pid"
    private List<BuildTemplatesEntity> buildTemplatesList = new ArrayList<>(); //房建-项目模板及支撑费用
    @TableField(exist=false)
    @SubEntity(serviceName="buildPrecipitationService", pidName = "dutyId")//此处有pid="xxx"，默认值pid="pid"
    private List<BuildPrecipitationEntity> buildPrecipitationList = new ArrayList<>(); //房建-排水、降水费
    @TableField(exist=false)
    @SubEntity(serviceName="buildCompleteService", pidName = "dutyId")//此处有pid="xxx"，默认值pid="pid"
    private List<BuildCompleteEntity> buildCompleteList = new ArrayList<>(); //房建-已完工程及设备保护测算表
    @TableField(exist=false)
    @SubEntity(serviceName="buildNightService", pidName = "dutyId")//此处有pid="xxx"，默认值pid="pid"
    private List<BuildNightEntity> buildNightList = new ArrayList<>(); //房建-项目冬雨季、夜间施工
    @TableField(exist=false)
    @SubEntity(serviceName="buildAppointService", pidName = "dutyId")//此处有pid="xxx"，默认值pid="pid"
    private List<BuildAppointEntity> buildAppointList = new ArrayList<>(); //房建-甲指分包


    public Long getProjectId() {
        return projectId;
    }

    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    public String getUnitsName() {
        return unitsName;
    }

    public void setUnitsName(String unitsName) {
        this.unitsName = unitsName;
    }
    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    public String getOrgCode() {
        return orgCode;
    }

    public void setOrgCode(String orgCode) {
        this.orgCode = orgCode;
    }
    public Long getParentOrgId() {
        return parentOrgId;
    }

    public void setParentOrgId(Long parentOrgId) {
        this.parentOrgId = parentOrgId;
    }
    public String getParentOrgName() {
        return parentOrgName;
    }

    public void setParentOrgName(String parentOrgName) {
        this.parentOrgName = parentOrgName;
    }
    public String getParentOrgCode() {
        return parentOrgCode;
    }

    public void setParentOrgCode(String parentOrgCode) {
        this.parentOrgCode = parentOrgCode;
    }
    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }
    public Long getFeeId() {
        return feeId;
    }

    public void setFeeId(Long feeId) {
        this.feeId = feeId;
    }
    public String getFeeName() {
        return feeName;
    }

    public void setFeeName(String feeName) {
        this.feeName = feeName;
    }
    public Long getWbsId() {
        return wbsId;
    }

    public void setWbsId(Long wbsId) {
        this.wbsId = wbsId;
    }
    public String getWbsCode() {
        return wbsCode;
    }

    public void setWbsCode(String wbsCode) {
        this.wbsCode = wbsCode;
    }
    public String getWbsName() {
        return wbsName;
    }

    public void setWbsName(String wbsName) {
        this.wbsName = wbsName;
    }
    public BigDecimal getMny() {
        return mny;
    }

    public void setMny(BigDecimal mny) {
        this.mny = mny;
    }
    public BigDecimal getTaxMny() {
        return taxMny;
    }

    public void setTaxMny(BigDecimal taxMny) {
        this.taxMny = taxMny;
    }
    public BigDecimal getBeforeMny() {
        return beforeMny;
    }

    public void setBeforeMny(BigDecimal beforeMny) {
        this.beforeMny = beforeMny;
    }
    public BigDecimal getBeforeTaxMny() {
        return beforeTaxMny;
    }

    public void setBeforeTaxMny(BigDecimal beforeTaxMny) {
        this.beforeTaxMny = beforeTaxMny;
    }
    public Integer getConvertFlag() {
        return convertFlag;
    }

    public void setConvertFlag(Integer convertFlag) {
        this.convertFlag = convertFlag;
    }
    public Boolean getLatestFlag() {
        return latestFlag;
    }

    public void setLatestFlag(Boolean latestFlag) {
        this.latestFlag = latestFlag;
    }
    public Boolean getEnableState() {
        return enableState;
    }

    public void setEnableState(Boolean enableState) {
        this.enableState = enableState;
    }
    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }
    public Integer getDutyVersion() {
        return dutyVersion;
    }

    public void setDutyVersion(Integer dutyVersion) {
        this.dutyVersion = dutyVersion;
    }
    public Long getLastDutyId() {
        return lastDutyId;
    }

    public void setLastDutyId(Long lastDutyId) {
        this.lastDutyId = lastDutyId;
    }
    public Long getChangeId() {
        return changeId;
    }

    public void setChangeId(Long changeId) {
        this.changeId = changeId;
    }
    public Integer getChangeState() {
        return changeState;
    }

    public void setChangeState(Integer changeState) {
        this.changeState = changeState;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    public Long getEmployeeId() {
        return employeeId;
    }

    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }
    public String getEmployeeName() {
        return employeeName;
    }

    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }
    public Long getDepartmentId() {
        return departmentId;
    }

    public void setDepartmentId(Long departmentId) {
        this.departmentId = departmentId;
    }
    public String getDepartmentName() {
        return departmentName;
    }

    public void setDepartmentName(String departmentName) {
        this.departmentName = departmentName;
    }
    public Integer getBeforeDutyVersion() {
        return beforeDutyVersion;
    }

    public void setBeforeDutyVersion(Integer beforeDutyVersion) {
        this.beforeDutyVersion = beforeDutyVersion;
    }
    public Date getOneTime() {
        return oneTime;
    }

    public void setOneTime(Date oneTime) {
        this.oneTime = oneTime;
    }
    public Long getBaseDutyId() {
        return baseDutyId;
    }

    public void setBaseDutyId(Long baseDutyId) {
        this.baseDutyId = baseDutyId;
    }
    public String getProjectCode() {
        return projectCode;
    }

    public void setProjectCode(String projectCode) {
        this.projectCode = projectCode;
    }

    public List<BuildPlansEntity> getBuildPlansList() {
        return buildPlansList;
    }

    public void setBuildPlansList(List<BuildPlansEntity> buildPlansList) {
        this.buildPlansList = buildPlansList;
    }
    public List<BuildRgcostEntity> getBuildRgcostList() {
        return buildRgcostList;
    }

    public void setBuildRgcostList(List<BuildRgcostEntity> buildRgcostList) {
        this.buildRgcostList = buildRgcostList;
    }
    public List<BuildSubEntity> getBuildSubList() {
        return buildSubList;
    }

    public void setBuildSubList(List<BuildSubEntity> buildSubList) {
        this.buildSubList = buildSubList;
    }
    public List<BuildMaterialEntity> getBuildMaterialList() {
        return buildMaterialList;
    }

    public void setBuildMaterialList(List<BuildMaterialEntity> buildMaterialList) {
        this.buildMaterialList = buildMaterialList;
    }

    public List<BuildEquipmentEntity> getBuildEquipmentList() {
        return buildEquipmentList;
    }

    public void setBuildEquipmentList(List<BuildEquipmentEntity> buildEquipmentList) {
        this.buildEquipmentList = buildEquipmentList;
    }
    public List<BuildSafeEntity> getBuildSafeList() {
        return buildSafeList;
    }

    public void setBuildSafeList(List<BuildSafeEntity> buildSafeList) {
        this.buildSafeList = buildSafeList;
    }


    public List<BuildMeasureEntity> getBuildMeasureList() {
        return buildMeasureList;
    }

    public void setBuildMeasureList(List<BuildMeasureEntity> buildMeasureList) {
        this.buildMeasureList = buildMeasureList;
    }
    public List<BuildStimulateEntity> getBuildStimulateList() {
        return buildStimulateList;
    }

    public void setBuildStimulateList(List<BuildStimulateEntity> buildStimulateList) {
        this.buildStimulateList = buildStimulateList;
    }

    public List<BuildIndirectEntity> getBuildIndirectList() {
        return buildIndirectList;
    }

    public void setBuildIndirectList(List<BuildIndirectEntity> buildIndirectList) {
        this.buildIndirectList = buildIndirectList;
    }

    public List<BuildScaffoldEntity> getBuildScaffoldList() {
        return buildScaffoldList;
    }

    public void setBuildScaffoldList(List<BuildScaffoldEntity> buildScaffoldList) {
        this.buildScaffoldList = buildScaffoldList;
    }

    public List<BuildTemplatesEntity> getBuildTemplatesList() {
        return buildTemplatesList;
    }

    public void setBuildTemplatesList(List<BuildTemplatesEntity> buildTemplatesList) {
        this.buildTemplatesList = buildTemplatesList;
    }

    public List<BuildPrecipitationEntity> getBuildPrecipitationList() {
        return buildPrecipitationList;
    }

    public void setBuildPrecipitationList(List<BuildPrecipitationEntity> buildPrecipitationList) {
        this.buildPrecipitationList = buildPrecipitationList;
    }

    public List<BuildCompleteEntity> getBuildCompleteList() {
        return buildCompleteList;
    }

    public void setBuildCompleteList(List<BuildCompleteEntity> buildCompleteList) {
        this.buildCompleteList = buildCompleteList;
    }

    public List<BuildNightEntity> getBuildNightList() {
        return buildNightList;
    }

    public void setBuildNightList(List<BuildNightEntity> buildNightList) {
        this.buildNightList = buildNightList;
    }

    public List<BuildAppointEntity> getBuildAppointList() {
        return buildAppointList;
    }

    public void setBuildAppointList(List<BuildAppointEntity> buildAppointList) {
        this.buildAppointList = buildAppointList;
    }
}
