package com.ejianc.business.sx2j.build.vo;

import com.ejianc.business.targetcost.utils.ITreeNodeB;
import com.ejianc.framework.skeleton.template.BaseVO;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;


/**
 * 房建-主要材料
 *
 * @author generator
 *
 */
public class BuildMaterialVO extends CommonImportDataVO implements ITreeNodeB {
    private static final long serialVersionUID = 1L;

    private Long dutyId; // 目标责任成本主键
    private Long parentId; // pid
    private Boolean leafFlag; // 是否末级
    private String treeIndex; // 序号
    private String materialCode; // 编码
    private String materialName; // 材料名称
    private String materialSpec; // 规格型号
    private String materialUnitName; // 单位
    private BigDecimal materialYsNum; // 预算量
    private BigDecimal materialYsPrice; // 预算收入-单价
    private BigDecimal materialYsMny; // 预算收入-合价
    private BigDecimal materialNum; // 目标量
    private BigDecimal materialPrice; // 不含进项税单价
    private BigDecimal materialTaxPrice; // 含税单价
    private BigDecimal materialRate; // 专项进项税税率(%)
    private BigDecimal materialPriceTax; // 税金
    private BigDecimal materialMny; // 不含进项税合计
    private BigDecimal materialTaxMny; // 含进项税合计
    private BigDecimal materialTax; // 进项税合计
    private String materialMemo; // 备注
    private Long tid; // 前端生成树形主键
    private String tpid; // 前端生成树形父主键
    private String indexCode;//序号
    // 列是否可以导入，true=可以导入，false=不可导入
    private Boolean importFlag;
    //错误信息
    private String warnType;
    private List<ITreeNodeB> children;
    @Override
    public Long getNodeID() {
        return getId();
    }

    @Override
    public Long getParentID() {
        return parentId;
    }

    @Override
    public List<ITreeNodeB> getChildren() {
        if (children == null) {
            children = new ArrayList<>();
        }
        return children;
    }
    public String getIndexCode() {
        return indexCode;
    }

    public void setIndexCode(String indexCode) {
        this.indexCode = indexCode;
    }

    public Boolean getImportFlag() {
        return importFlag;
    }

    public void setImportFlag(Boolean importFlag) {
        this.importFlag = importFlag;
    }

    public String getWarnType() {
        return warnType;
    }

    public void setWarnType(String warnType) {
        this.warnType = warnType;
    }

    public Long getDutyId() {
        return dutyId;
    }

    public void setDutyId(Long dutyId) {
        this.dutyId = dutyId;
    }
    public Long getParentId() {
        return parentId;
    }

    public void setParentId(Long parentId) {
        this.parentId = parentId;
    }
    public Boolean getLeafFlag() {
        return leafFlag;
    }

    public void setLeafFlag(Boolean leafFlag) {
        this.leafFlag = leafFlag;
    }
    public String getTreeIndex() {
        return treeIndex;
    }

    public void setTreeIndex(String treeIndex) {
        this.treeIndex = treeIndex;
    }
    public String getMaterialCode() {
        return materialCode;
    }

    public void setMaterialCode(String materialCode) {
        this.materialCode = materialCode;
    }
    public String getMaterialName() {
        return materialName;
    }

    public void setMaterialName(String materialName) {
        this.materialName = materialName;
    }
    public String getMaterialSpec() {
        return materialSpec;
    }

    public void setMaterialSpec(String materialSpec) {
        this.materialSpec = materialSpec;
    }
    public String getMaterialUnitName() {
        return materialUnitName;
    }

    public void setMaterialUnitName(String materialUnitName) {
        this.materialUnitName = materialUnitName;
    }
    public BigDecimal getMaterialYsNum() {
        return materialYsNum;
    }

    public void setMaterialYsNum(BigDecimal materialYsNum) {
        this.materialYsNum = materialYsNum;
    }
    public BigDecimal getMaterialYsPrice() {
        return materialYsPrice;
    }

    public void setMaterialYsPrice(BigDecimal materialYsPrice) {
        this.materialYsPrice = materialYsPrice;
    }
    public BigDecimal getMaterialYsMny() {
        return materialYsMny;
    }

    public void setMaterialYsMny(BigDecimal materialYsMny) {
        this.materialYsMny = materialYsMny;
    }
    public BigDecimal getMaterialNum() {
        return materialNum;
    }

    public void setMaterialNum(BigDecimal materialNum) {
        this.materialNum = materialNum;
    }
    public BigDecimal getMaterialPrice() {
        return materialPrice;
    }

    public void setMaterialPrice(BigDecimal materialPrice) {
        this.materialPrice = materialPrice;
    }
    public BigDecimal getMaterialTaxPrice() {
        return materialTaxPrice;
    }

    public void setMaterialTaxPrice(BigDecimal materialTaxPrice) {
        this.materialTaxPrice = materialTaxPrice;
    }
    public BigDecimal getMaterialRate() {
        return materialRate;
    }

    public void setMaterialRate(BigDecimal materialRate) {
        this.materialRate = materialRate;
    }
    public BigDecimal getMaterialPriceTax() {
        return materialPriceTax;
    }

    public void setMaterialPriceTax(BigDecimal materialPriceTax) {
        this.materialPriceTax = materialPriceTax;
    }
    public BigDecimal getMaterialMny() {
        return materialMny;
    }

    public void setMaterialMny(BigDecimal materialMny) {
        this.materialMny = materialMny;
    }
    public BigDecimal getMaterialTaxMny() {
        return materialTaxMny;
    }

    public void setMaterialTaxMny(BigDecimal materialTaxMny) {
        this.materialTaxMny = materialTaxMny;
    }
    public BigDecimal getMaterialTax() {
        return materialTax;
    }

    public void setMaterialTax(BigDecimal materialTax) {
        this.materialTax = materialTax;
    }
    public String getMaterialMemo() {
        return materialMemo;
    }

    public void setMaterialMemo(String materialMemo) {
        this.materialMemo = materialMemo;
    }
    public Long getTid() {
        return tid;
    }

    public void setTid(Long tid) {
        this.tid = tid;
    }
    public String getTpid() {
        return tpid;
    }

    public void setTpid(String tpid) {
        this.tpid = tpid;
    }
    /***转换使用**/

    @Override
    public Boolean getcLeafFlag() {
        return this.leafFlag;
    }

    @Override
    public String getcCode() {
        return this.materialCode;
    }

    @Override
    public String getcName() {
        return this.materialName;
    }

    @Override
    public String getcUnitName() {
        return this.materialUnitName;
    }

    @Override
    public Long getcId() {
        return this.getId();
    }

    @Override
    public BigDecimal getcTaxRate() {
        return this.materialRate;
    }

    @Override
    public BigDecimal getcPrice() {
        return this.materialPrice;
    }

    @Override
    public BigDecimal getcTaxPrice() {
        return this.materialTaxPrice;
    }

    @Override
    public BigDecimal getcAmount() {
        return this.materialNum;
    }

    @Override
    public BigDecimal getcMny() {
        return this.materialMny;
    }

    @Override
    public BigDecimal getcTaxMny() {
        return this.materialTaxMny;
    }
}
