package com.ejianc.business.targetcost.bean;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.business.targetcost.utils.ITreeNodeB;
import com.ejianc.business.targetcost.vo.FeeDetailVO;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;

/**
 * 目标成本完工统计明细
 *
 * @author generator
 *
 */
 @TableName("ejc_targetcost_finish_detail")
public class FinishDetailEntity extends BaseEntity implements ITreeNodeB  {
    private static final long serialVersionUID = 1L;

    @TableField(value="finish_id")
    private Long finishId; // 完工统计主键
    @TableField(value="create_user_name")
    private String createUserName; // 创建人名称
    @TableField(value="org_id")
    private Long orgId; // 所属组织，不显示默认当前组织
    @TableField(value="org_name")
    private String orgName; // 项目组织名称
    @TableField(value="project_id")
    private Long projectId; // 所属组织，不显示默认当前组织
    @TableField(value="project_name")
    private String projectName; // 项目组织名称
    @TableField(value="fee_detail_id")
    private Long feeDetailId; // 费用明细主键
    @TableField(value="fee_detail_code")
    private String feeDetailCode; // 费用明细编码
    @TableField(value="fee_detail_name")
    private String feeDetailName; // 费用明细名称
    @TableField(value="mny")
    private BigDecimal mny; // 金额(无税)
    @TableField(value="tax_rate")
    private BigDecimal taxRate; // 税率
    @TableField(value="tax_mny")
    private BigDecimal taxMny; // 金额
    @TableField(value="involve_flag")
    private Boolean involveFlag; // 是否涉及
    @TableField(value="pre_type_amount")
    private BigDecimal preTypeAmount; // 预估分类总量
    @TableField(value="category_id")
    private Long categoryId; // 分类（档案）id
    @TableField(value="category_inner_code")
    private String categoryInnerCode; // 分类（档案）内码
    @TableField(value="doc_type")
    private Integer docType; // 分类（档案）类型：劳务分包方案、专业分包档案、物料档案、设备档案、成本科目
    @TableField(value="self_scope_flag")
    private Boolean selfScopeFlag; // 是否自身设置业务范围
    @TableField(value="self_related_flag")
    private Boolean selfRelatedFlag; // 是否自身设置关联分类
    @TableField(value="parent_id")
    private Long parentId; // pid
    @TableField(value="self_flag")
    private Boolean selfFlag; // 行属性：引入档案、自制（是否自制）
    @TableField(value="leaf_flag")
    private Boolean leafFlag; // 是否末级
    @TableField(value="unit_id")
    private Long unitId; // 单位ID
    @TableField(value="unit_name")
    private String unitName; // 单位名称
    @TableField(value="tree_index")
    private String treeIndex; // 序号
    @TableField(value = "gather_mny")
    private BigDecimal gatherMny;// 汇总金额(无税)
    @TableField(value = "gather_tax_mny")
    private BigDecimal gatherTaxMny;// 汇总金额
    @TableField(value="total_tax_mny")
    private BigDecimal totalTaxMny; // 累计统计金额
    @TableField(value="total_mny")
    private BigDecimal totalMny; // 累计统计金额(无税)
    @TableField(value="total_amount")
    private BigDecimal totalAmount; // 累计统计金额(无税)
    @TableField(exist = false)
    private String tid;
    @TableField(exist = false)
    private String tpid;
    @TableField(exist = false)
    private List<FeeDetailVO> relatedDetailList = new ArrayList<>();
    @TableField(exist = false)
    private List<ITreeNodeB> children;

    @TableField(exist = false)
    @SubEntity(serviceName = "finishDetailItemService",pidName = "finishDetailId")
    private List<FinishDetailItemEntity> finishDetailItemList = new ArrayList<>(); // 目标责任成本明细项

    public List<FinishDetailItemEntity> getFinishDetailItemList() {
        return finishDetailItemList;
    }

    public void setFinishDetailItemList(List<FinishDetailItemEntity> finishDetailItemList) {
        this.finishDetailItemList = finishDetailItemList;
    }

    public Long getFinishId() {
        return finishId;
    }

    public void setFinishId(Long finishId) {
        this.finishId = finishId;
    }
    public String getCreateUserName() {
        return createUserName;
    }

    public void setCreateUserName(String createUserName) {
        this.createUserName = createUserName;
    }
    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    public Long getProjectId() {
        return projectId;
    }

    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    public Long getFeeDetailId() {
        return feeDetailId;
    }

    public void setFeeDetailId(Long feeDetailId) {
        this.feeDetailId = feeDetailId;
    }
    public String getFeeDetailCode() {
        return feeDetailCode;
    }

    public void setFeeDetailCode(String feeDetailCode) {
        this.feeDetailCode = feeDetailCode;
    }
    public String getFeeDetailName() {
        return feeDetailName;
    }

    public void setFeeDetailName(String feeDetailName) {
        this.feeDetailName = feeDetailName;
    }
    public BigDecimal getMny() {
        return mny;
    }

    public void setMny(BigDecimal mny) {
        this.mny = mny;
    }
    public BigDecimal getTaxRate() {
        return taxRate;
    }

    public void setTaxRate(BigDecimal taxRate) {
        this.taxRate = taxRate;
    }
    public BigDecimal getTaxMny() {
        return taxMny;
    }

    public BigDecimal getPreTypeAmount() {
        return preTypeAmount;
    }

    public void setInvolveFlag(Boolean involveFlag) {
        this.involveFlag = involveFlag;
    }

    public void setPreTypeAmount(BigDecimal preTypeAmount) {
        this.preTypeAmount = preTypeAmount;
    }
    public Long getCategoryId() {
        return categoryId;
    }

    public void setCategoryId(Long categoryId) {
        this.categoryId = categoryId;
    }
    public String getCategoryInnerCode() {
        return categoryInnerCode;
    }

    public void setCategoryInnerCode(String categoryInnerCode) {
        this.categoryInnerCode = categoryInnerCode;
    }
    public Integer getDocType() {
        return docType;
    }

    public void setDocType(Integer docType) {
        this.docType = docType;
    }

    public void setTaxMny(BigDecimal taxMny) {
        this.taxMny = taxMny;
    }

    public Boolean getInvolveFlag() {
        return involveFlag;
    }

    public Boolean getSelfScopeFlag() {
        return selfScopeFlag;
    }

    public void setSelfScopeFlag(Boolean selfScopeFlag) {
        this.selfScopeFlag = selfScopeFlag;
    }

    public Boolean getSelfRelatedFlag() {
        return selfRelatedFlag;
    }

    public void setSelfRelatedFlag(Boolean selfRelatedFlag) {
        this.selfRelatedFlag = selfRelatedFlag;
    }

    public Boolean getSelfFlag() {
        return selfFlag;
    }

    public void setSelfFlag(Boolean selfFlag) {
        this.selfFlag = selfFlag;
    }

    public Boolean getLeafFlag() {
        return leafFlag;
    }

    public void setLeafFlag(Boolean leafFlag) {
        this.leafFlag = leafFlag;
    }

    public Long getParentId() {
        return parentId;
    }

    public void setParentId(Long parentId) {
        this.parentId = parentId;
    }

    public Long getUnitId() {
        return unitId;
    }

    public void setUnitId(Long unitId) {
        this.unitId = unitId;
    }
    public String getUnitName() {
        return unitName;
    }

    public void setUnitName(String unitName) {
        this.unitName = unitName;
    }
    public String getTreeIndex() {
        return treeIndex;
    }

    public void setTreeIndex(String treeIndex) {
        this.treeIndex = treeIndex;
    }

    public String getTid() {
        return tid;
    }

    public void setTid(String tid) {
        this.tid = tid;
    }

    public String getTpid() {
        return tpid;
    }

    public void setTpid(String tpid) {
        this.tpid = tpid;
    }

    public List<FeeDetailVO> getRelatedDetailList() {
        return relatedDetailList;
    }

    public void setRelatedDetailList(List<FeeDetailVO> relatedDetailList) {
        this.relatedDetailList = relatedDetailList;
    }

    @Override
    public Long getNodeID() {
        return getId();
    }

    @Override
    public Long getParentID() {
        return parentId;
    }

    @Override
    public List<ITreeNodeB> getChildren() {
        if (children == null) {
            children = new ArrayList<>();
        }
        return children;
    }

    public BigDecimal getGatherMny() {
        return gatherMny;
    }

    public void setGatherMny(BigDecimal gatherMny) {
        this.gatherMny = gatherMny;
    }

    public BigDecimal getGatherTaxMny() {
        return gatherTaxMny;
    }

    public void setGatherTaxMny(BigDecimal gatherTaxMny) {
        this.gatherTaxMny = gatherTaxMny;
    }

    public BigDecimal getTotalTaxMny() {
        return totalTaxMny;
    }

    public void setTotalTaxMny(BigDecimal totalTaxMny) {
        this.totalTaxMny = totalTaxMny;
    }

    public BigDecimal getTotalMny() {
        return totalMny;
    }

    public void setTotalMny(BigDecimal totalMny) {
        this.totalMny = totalMny;
    }

    public BigDecimal getTotalAmount() {
        return totalAmount;
    }

    public void setTotalAmount(BigDecimal totalAmount) {
        this.totalAmount = totalAmount;
    }
}
