package com.ejianc.business.targetcost.bean;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * 目标成本完工统计
 *
 * @author generator
 *
 */
 @TableName("ejc_targetcost_finish")
public class FinishEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;

    @TableField(value="create_user_name")
    private String createUserName; // 创建人名称
    @TableField(value="project_id")
    private Long projectId; // 项目主键
    @TableField(value="project_name")
    private String projectName; // 项目名称
    @TableField(value="org_id")
    private Long orgId; // 组织主键
    @TableField(value="org_name")
    private String orgName; // 组织名称
    @TableField(value="org_code")
    private String orgCode; // 组织编码
    @TableField(value="bill_code")
    private String billCode; // 单据编码
    @TableField(value="name")
    private String name; // 目标责任成本名称
    @TableField(value="finish_date")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date finishDate; // 统计日期
    @TableField(value="finish_tax_mny")
    private BigDecimal finishTaxMny; // 本期统计金额
    @TableField(value="finish_mny")
    private BigDecimal finishMny; // 本期统计金额(无税)
    @TableField(value="total_tax_mny")
    private BigDecimal totalTaxMny; // 累计统计金额
    @TableField(value="total_mny")
    private BigDecimal totalMny; // 累计统计金额(无税)
    @TableField(value="tax")
    private BigDecimal tax; // 税额
    @TableField(value="ratio")
    private BigDecimal ratio; // 累计统计比例
    @TableField(value="bill_state")
    private Integer billState; // 审批状态
    @TableField(value="employee_id")
    private Long employeeId; // 经办人
    @TableField(value="employee_name")
    private String employeeName; // 经办人名称
    @TableField(value="department_id")
    private Long departmentId; // 经办部门
    @TableField(value="department_name")
    private String departmentName; // 经办部门名称
    @TableField(value="mny")
    private BigDecimal mny; // 目标成本金额(无税)
    @TableField(value="tax_mny")
    private BigDecimal taxMny; // 目标成本金额
    @TableField(value = "fee_id")
    private Long feeId; // 费用模板主键
    @TableField(value = "fee_name")
    private String feeName; // 费用模板名称

    @TableField(exist = false)
    @SubEntity(serviceName = "finishDetailService", pidName = "finishId")
    private List<FinishDetailEntity> finishDetailList = new ArrayList<>(); // 目标责任成本明细

    public List<FinishDetailEntity> getFinishDetailList() {
        return finishDetailList;
    }

    public void setFinishDetailList(List<FinishDetailEntity> finishDetailList) {
        this.finishDetailList = finishDetailList;
    }

    public String getCreateUserName() {
        return createUserName;
    }

    public void setCreateUserName(String createUserName) {
        this.createUserName = createUserName;
    }
    public Long getProjectId() {
        return projectId;
    }

    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    public String getOrgCode() {
        return orgCode;
    }

    public void setOrgCode(String orgCode) {
        this.orgCode = orgCode;
    }
    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }
    public Date getFinishDate() {
        return finishDate;
    }

    public void setFinishDate(Date finishDate) {
        this.finishDate = finishDate;
    }
    public BigDecimal getFinishTaxMny() {
        return finishTaxMny;
    }

    public void setFinishTaxMny(BigDecimal finishTaxMny) {
        this.finishTaxMny = finishTaxMny;
    }
    public BigDecimal getFinishMny() {
        return finishMny;
    }

    public void setFinishMny(BigDecimal finishMny) {
        this.finishMny = finishMny;
    }
    public BigDecimal getTotalTaxMny() {
        return totalTaxMny;
    }

    public void setTotalTaxMny(BigDecimal totalTaxMny) {
        this.totalTaxMny = totalTaxMny;
    }
    public BigDecimal getTotalMny() {
        return totalMny;
    }

    public void setTotalMny(BigDecimal totalMny) {
        this.totalMny = totalMny;
    }
    public BigDecimal getTax() {
        return tax;
    }

    public void setTax(BigDecimal tax) {
        this.tax = tax;
    }
    public BigDecimal getRatio() {
        return ratio;
    }

    public void setRatio(BigDecimal ratio) {
        this.ratio = ratio;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    public Long getEmployeeId() {
        return employeeId;
    }

    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }
    public String getEmployeeName() {
        return employeeName;
    }

    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }
    public Long getDepartmentId() {
        return departmentId;
    }

    public void setDepartmentId(Long departmentId) {
        this.departmentId = departmentId;
    }
    public String getDepartmentName() {
        return departmentName;
    }

    public void setDepartmentName(String departmentName) {
        this.departmentName = departmentName;
    }
    public BigDecimal getMny() {
        return mny;
    }

    public void setMny(BigDecimal mny) {
        this.mny = mny;
    }
    public BigDecimal getTaxMny() {
        return taxMny;
    }

    public void setTaxMny(BigDecimal taxMny) {
        this.taxMny = taxMny;
    }

    public Long getFeeId() {
        return feeId;
    }

    public void setFeeId(Long feeId) {
        this.feeId = feeId;
    }

    public String getFeeName() {
        return feeName;
    }

    public void setFeeName(String feeName) {
        this.feeName = feeName;
    }
}
