package com.ejianc.business.targetcost.bean;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;

/**
 * 控制规则明细
 *
 * @author generator
 *
 */
 @TableName("ejc_targetcost_rule_detail")
public class RuleDetailEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;

    @TableField(value="rule_id")
    private Long ruleId; // 主表主键
    @TableField(value="fee_id")
    private Long feeId; // 费用主键
    @TableField(value="fee_detail_id")
    private Long feeDetailId; // 费用明细主键
    @TableField(value="fee_inner_code")
    private String feeInnerCode; // 费用项内码
    @TableField(value="fee_self_flag")
    private Boolean feeSelfFlag; // 行属性：引入档案、自制（是否自制）
    @TableField(value="fee_type")
    private Integer feeType; // 1.总额控2.明细金额控3.明细量控4.目标外明细总金额控5.分类量控
    @TableField(value="null_control_flag")
    private Boolean nullControlFlag; // 目标为空时是否控制：1是0否
    @TableField(value="control_type")
    private Integer controlType; // 1.风险预警2.柔性控制3.刚性控制
    @TableField(value="control_scale")
    private BigDecimal controlScale; // 控制比例
    @TableField(exist = false)
    private String orgName; // 组织名称
    @TableField(value="bill_category")
    private String billCategory; // 受控业务分类，参见BillCategoryEnum
    @TableField(value="subject_id")
    private Long subjectId; // 成本科目主键
    @TableField(value="subject_inner_code")
    private String subjectInnerCode; // 成本科目内码
    @TableField(value="subject_flag")
    private Boolean subjectFlag; // 是否成本科目设置的规则

    @TableField(exist=false)
    @SubEntity(serviceName="ruleReceiverService", pidName = "ruleDetailId")
    private List<RuleReceiverEntity> messageReceiver = new ArrayList<>();


    public Long getRuleId() {
        return ruleId;
    }

    public void setRuleId(Long ruleId) {
        this.ruleId = ruleId;
    }
    public Long getFeeId() {
        return feeId;
    }

    public void setFeeId(Long feeId) {
        this.feeId = feeId;
    }
    public Long getFeeDetailId() {
        return feeDetailId;
    }

    public void setFeeDetailId(Long feeDetailId) {
        this.feeDetailId = feeDetailId;
    }

    public void setFeeInnerCode(String feeInnerCode) {
        this.feeInnerCode = feeInnerCode;
    }
    public Boolean getFeeSelfFlag() {
        return feeSelfFlag;
    }

    public void setFeeSelfFlag(Boolean feeSelfFlag) {
        this.feeSelfFlag = feeSelfFlag;
    }
    public Integer getFeeType() {
        return feeType;
    }

    public void setFeeType(Integer feeType) {
        this.feeType = feeType;
    }
    public Boolean getNullControlFlag() {
        return nullControlFlag;
    }

    public void setNullControlFlag(Boolean nullControlFlag) {
        this.nullControlFlag = nullControlFlag;
    }
    public Integer getControlType() {
        return controlType;
    }

    public void setControlType(Integer controlType) {
        this.controlType = controlType;
    }
    public BigDecimal getControlScale() {
        return controlScale;
    }

    public void setControlScale(BigDecimal controlScale) {
        this.controlScale = controlScale;
    }

    public String getFeeInnerCode() {
        return feeInnerCode;
    }

    public List<RuleReceiverEntity> getMessageReceiver() {
        return messageReceiver;
    }

    public void setMessageReceiver(List<RuleReceiverEntity> messageReceiver) {
        this.messageReceiver = messageReceiver;
    }

    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }

    public String getBillCategory() {
        return billCategory;
    }

    public void setBillCategory(String billCategory) {
        this.billCategory = billCategory;
    }

    public Long getSubjectId() {
        return subjectId;
    }

    public void setSubjectId(Long subjectId) {
        this.subjectId = subjectId;
    }

    public String getSubjectInnerCode() {
        return subjectInnerCode;
    }

    public void setSubjectInnerCode(String subjectInnerCode) {
        this.subjectInnerCode = subjectInnerCode;
    }

    public Boolean getSubjectFlag() {
        return subjectFlag;
    }

    public void setSubjectFlag(Boolean subjectFlag) {
        this.subjectFlag = subjectFlag;
    }
}
