package com.ejianc.business.targetcost.controller;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

import javax.servlet.http.HttpServletRequest;
import java.util.List;
import java.util.stream.Collectors;

/**
 * 报表
 */
@Controller
@RequestMapping("report")
public class ReportController {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IOrgApi orgApi;
    @ResponseBody
    @RequestMapping(value = "/getProjCostQueryParam",method = RequestMethod.GET)
    public CommonResponse<QueryParam> getQueryParam (HttpServletRequest req){

        try {
            String leftTreeId = req.getParameter("leftTreeId");
            Long orgId;
            if (StringUtils.isNotEmpty(leftTreeId)){
                logger.info("leftTreeId:::"+leftTreeId);
                orgId = Long.valueOf(leftTreeId);
            }else {
                orgId = InvocationInfoProxy.getOrgId();
            }
            //若当前上下文为项目部，则根据项目部Id来进行查询
            QueryParam queryParam = new QueryParam();
            OrgVO orgVO = new OrgVO();
            orgVO.setId(orgId);
            CommonResponse<OrgVO> oneByOrgVO = orgApi.findOneByOrgVO(orgVO);
            if (!oneByOrgVO.isSuccess()){
                return CommonResponse.error("查询失败，获取组织信息失败！");
            }
            if(OrgVO.ORG_TYPE_DEPARTMENT.equals(oneByOrgVO.getData().getOrgType())) {
                queryParam.getParams().put("orgId", new Parameter(QueryParam.EQ, orgId));
            } else {
                CommonResponse<List<OrgVO>> orgResp = orgApi.findChildrenByParentIdWithoutProjectDept(orgId);
                if(!orgResp.isSuccess()) {
                    logger.error("分页查询失败，获取当前本下组织信息失败, {}", orgResp.getMsg());
                    return CommonResponse.error("查询失败，获取组织信息失败！");
                }
                queryParam.getParams().put("parentOrgId", new Parameter(QueryParam.IN,
                        orgResp.getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
            }
            logger.info("返回信息 queryParam:"+ JSONObject.toJSONString(queryParam));
            return CommonResponse.success(queryParam);
        }catch (Exception e) {
            logger.error("系统异常："+e.getMessage());
            e.printStackTrace();
        }
        return CommonResponse.error("查询失败");

    }
}
