package com.ejianc.business.targetcost.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.targetcost.bean.RuleEntity;
import com.ejianc.business.targetcost.service.IRuleService;
import com.ejianc.business.targetcost.vo.RuleVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

/**
 * 控制规则
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("rule")
public class RuleController implements Serializable {
	private static final long serialVersionUID = 1L;

	@Autowired
	private IOrgApi orgApi;

    @Autowired
    private IRuleService ruleService;

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<RuleVO> saveOrUpdate(@RequestBody RuleVO ruleVO) {
    	return CommonResponse.success("保存或修改单据成功！", ruleService.insertOrUpdate(ruleVO));
    }

    /**
     * @Description tempSaveOrUpdate 切换行时的保存
     */
    @RequestMapping(value = "/tempSaveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<RuleVO> tempSaveOrUpdate(@RequestBody RuleVO ruleVO) {
        return CommonResponse.success("保存或修改单据成功！", ruleService.tempSaveOrUpdate(ruleVO));
    }

    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<RuleVO> queryDetail(Long id) {
        return CommonResponse.success("查询详情数据成功！", ruleService.queryDetail(id));
    }


    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<RuleVO> vos) {
        if(OrgVO.ORG_TYPE_DEPARTMENT.toString().equals(InvocationInfoProxy.getOrgType())){//如果当前组织为项目部 则不允许删除
            for(RuleVO ruleVO : vos){
                RuleVO ruleVO1 = ruleService.queryDetail(ruleVO.getId());
                if(ruleVO1.getOrgId() == Long.parseLong("1502571152583692289")){
                    throw new BusinessException("组织名称为【郑州一建集团】，只允许查看，不允许删除！");
                }
            }
        }
        ruleService.removeByIds(vos.stream().map(RuleVO::getId).collect(Collectors.toList()),true);
        return CommonResponse.success("删除成功！");
    }

    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<RuleVO>> queryList(@RequestBody QueryParam param) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("name");
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        List<Long> orgIds = new ArrayList<>();
        orgIds.add(InvocationInfoProxy.getOrgId());
        orgIds.add(Long.parseLong("1502571152583692289"));//此处默认拼上郑州一建集团正式环境orgId
        /** 数据隔离，如果当前登录组织为项目部，查询orgId，否则查询parentOrgId本下 */
        if(OrgVO.ORG_TYPE_DEPARTMENT.toString().equals(InvocationInfoProxy.getOrgType())){
            param.getParams().put("orgId", new Parameter(QueryParam.IN, orgIds));
        } else {
            param.getParams().put("parentOrgId", new Parameter(QueryParam.IN, orgApi.findChildrenByParentIdWithoutProjectDept(
                    InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        }

        IPage<RuleEntity> page = ruleService.queryPage(param,false);
        IPage<RuleVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
  		pageData.setRecords(BeanMapper.mapList(page.getRecords(), RuleVO.class));

        return CommonResponse.success("查询列表数据成功！",pageData);
    }

    /**
     * @Description 参照
     * @Return void
     */
    @RequestMapping(value = "/refRuleData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<RuleVO>> refRuleData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                        String condition,
                                                                        String searchObject,
                                                                        String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("name");
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        if (StringUtils.isNotEmpty(condition)) {
            /** 处理condition */
            JSONObject con = JSONObject.parseObject(condition);
            if (con.containsKey("feeId")) {
                param.getParams().put("feeId", new Parameter(QueryParam.EQ, con.get("feeId")));
            }
        }

        //已提交和审批通过的
        List<Integer> billStateList = new ArrayList<>();
        billStateList.add(1);
        billStateList.add(3);
        param.getParams().put("billState", new Parameter(QueryParam.IN, billStateList ));//-1-暂存,0-自由态,1-提交态,2-审批中,3-审批通过,4-审批不通过,5-已提交未审批
        param.getParams().put("tenantId", new Parameter(QueryParam.IN, InvocationInfoProxy.getTenantid()));

        IPage<RuleEntity> page = ruleService.queryPage(param,false);
        IPage<RuleVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), RuleVO.class));

        return CommonResponse.success("查询参照数据成功！",pageData);
     }

    /**
     * @Description updateEnable 更新启用停用
     */
    @RequestMapping(value = "/updateEnable", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<String> updateEnable(@RequestParam(value = "id") Long id, @RequestParam(value = "enabled") Boolean enabled) {
        return CommonResponse.success("查询数据成功！", ruleService.updateEnable(id, enabled));
    }

    /**
     * @Description copySave 复制新增
     */
    @RequestMapping(value = "/copySave", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<RuleVO> copySave(@RequestBody RuleVO ruleVO) {
        return CommonResponse.success("复制新增单据成功！", ruleService.copySave(ruleVO));
    }
}
