package com.ejianc.business.targetcost.mapper;

import com.ejianc.business.targetcost.vo.DutyDetailItemVO;
import com.ejianc.business.targetcost.vo.DutyDetailVO;
import com.ejianc.business.targetcost.vo.DutyVO;
import com.ejianc.business.targetcost.vo.FinishDetailVO;
import org.apache.ibatis.annotations.Delete;
import org.apache.ibatis.annotations.Mapper;

import com.ejianc.framework.skeleton.template.BaseCrudMapper;
import com.ejianc.business.targetcost.bean.DutyEntity;
import org.apache.ibatis.annotations.Param;
import org.apache.ibatis.annotations.Select;
import java.util.List;
import java.util.Map;

/**
 * 目标责任成本
 *
 * @author generator
 *
 */
@Mapper
public interface DutyMapper extends BaseCrudMapper<DutyEntity> {

    @Select("select project_id as projectId,count(*) as costCount from ejc_targetcost_duty where dr=0 and gather_flag=1 and bill_state in(1,3) GROUP BY project_id")
    List<Map<String,Object>> queryDuty();

    @Select("SELECT s.subject_id AS subjectId,s.subject_name AS subjectName,s.subject_code AS subjectCode,d.mny,d.tax_mny AS taxMny,sum( d.mny ) AS sumMny,sum( d.tax_mny ) AS sumTaxMny,d.fee_detail_name AS feeDetailName,d.fee_detail_code AS feeDetailCode,sum(d.amount) AS totalAmount,d.unit_name FROM ejc_targetcost_duty_detail_item d JOIN ejc_targetcost_duty du ON d.duty_id = du.id JOIN ejc_targetcost_fee_detail s ON d.fee_detail_id = s.id WHERE d.project_id = #{projectId} and s.subject_id is not null and du.gather_flag=1 and  du.enable_state =1 and d.dr=0 and du.dr = 0 and s.dr=0 GROUP BY s.subject_id,d.unit_name")
    List<DutyDetailVO> queryDetailSubNew(Long projectId);

    @Select("SELECT d.fee_detail_code AS feeDetailCode,d.fee_detail_name AS feeDetailName,sum(d.finish_tax_mny) AS totalTaxMny,sum(d.finish_mny) AS totalMny,sum(d.finish_amount) as totalAmount,d.unit_name FROM ejc_targetcost_finish f JOIN ejc_targetcost_finish_detail_item d ON f.id = d.finish_id JOIN ejc_targetcost_fee fe ON f.fee_id = fe.id WHERE f.id = (select id from ejc_targetcost_finish f where f.dr = 0 and f.bill_state in (1,3) and f.project_id = #{projectId} and DATE_FORMAT( f.finish_date, '%Y-%m' ) <= #{endDate} and DATE_FORMAT( f.finish_date, '%Y-%m' ) >= #{beginPeriod} ORDER BY create_time DESC LIMIT 1 ) GROUP BY d.unit_name,d.fee_detail_name ")
    List<FinishDetailVO> queryFinDetailSubNew(Long projectId,String endDate,String beginPeriod);

    @Select("SELECT di.doc_id AS docId, sum( di.amount ) AS docSumAmount FROM ejc_targetcost_duty du JOIN ejc_targetcost_duty_detail_item di ON du.id = di.duty_id WHERE di.doc_type = 3 and du.gather_flag=1 AND  du.enable_state = 1 AND du.latest_flag = 1 AND du.dr = 0 AND di.dr = 0 and du.bill_state in (1,3) AND du.project_id = #{projectId} GROUP BY di.doc_id")
    List<DutyDetailItemVO> queryDoc(Long projectId);

    @Select("select de.category_id as categoryId,de.pre_type_amount as preTypeAmount from ejc_targetcost_duty d join ejc_targetcost_duty_detail de on d.id=de.duty_id where d.gather_flag=1 and d.project_id =  #{projectId} and leaf_flag = 1 and  d.dr = 0 and d.bill_state in(1,3) and de.dr = 0 and category_id is not null GROUP BY de.category_id")
    List<DutyDetailVO> querySumPreTypeAmount(Long projectId);

    @Select("SELECT s.subject_id as subjectId,s.subject_name as subjectName,s.subject_code as subjectCode,d.mny,d.tax_mny as taxMny,sum(d.mny) as sumMny,sum(d.tax_mny) as sumTaxMny,d.fee_detail_name as feeDetailName,d.fee_detail_code as feeDetailCode,d.pre_type_amount as totalAmount FROM ejc_targetcost_duty_detail d join ejc_targetcost_duty du on d.duty_id = du.id JOIN  ejc_targetcost_fee_detail  s ON d.fee_detail_id = s.id WHERE du.gather_flag=1 and d.project_id = #{projectId} and s.subject_id is not null and  du.enable_state =1 and d.dr=0 and du.dr = 0 and s.dr=0 GROUP BY s.subject_id")
    List<DutyDetailVO> queryDetailSub(Long projectId);

    @Select("select d.fee_detail_code as feeDetailCode,d.fee_detail_name as feeDetailName,d.total_tax_mny as totalTaxMny,d.total_mny as totalMny,d.total_amount as totalAmount from ejc_targetcost_finish f join ejc_targetcost_finish_detail d on f.id = d.finish_id join ejc_targetcost_fee fe on f.fee_id = fe.id where f.id = (select id from ejc_targetcost_finish f where f.dr = 0 and f.bill_state in (1,3) and f.project_id = #{projectId} ORDER BY create_time DESC LIMIT 1 )")
    List<FinishDetailVO> queryFinDetailSub(Long projectId);

    @Select("select d.fee_detail_code as feeDetailCode,d.fee_detail_name as feeDetailName,d.total_tax_mny as totalTaxMny,d.total_mny as totalMny,d.total_amount as totalAmount from ejc_targetcost_finish f join ejc_targetcost_finish_detail d on f.id = d.finish_id join ejc_targetcost_fee fe on f.fee_id = fe.id where f.id = (select id from ejc_targetcost_finish f where f.dr = 0 and f.bill_state in (1,3) and f.project_id = #{projectId} and DATE_FORMAT( f.finish_date, '%Y-%m' ) <= #{endDate} and DATE_FORMAT( f.finish_date, '%Y-%m' ) >= #{beginPeriod} ORDER BY create_time DESC LIMIT 1 )")
    List<FinishDetailVO> queryFinDetailSub2(Long projectId,String endDate,String beginPeriod);

    @Select("SELECT di.doc_id AS docId,sum( di.amount ) AS docSumAmount,di.doc_type as docType,di.category_name as categoryName,di.code,di.name,di.price,di.tax_price as taxPrice,di.amount,di.mny,di.tax_mny as taxMny FROM ejc_targetcost_duty du JOIN ejc_targetcost_duty_detail_item di ON du.id = di.duty_id WHERE  du.gather_flag=1 and di.doc_type = #{docType} AND du.enable_state = 1 AND du.latest_flag = 1 AND du.dr = 0 AND di.dr = 0 and du.bill_state in (1,3) AND du.project_id = #{projectId} GROUP BY di.doc_id")
    List<DutyDetailItemVO> queryDocDutyDetailItem(Long projectId,Integer docType);

    @Select("select id from ejc_targetcost_finish f where f.dr = 0 and f.bill_state in (1,3) and f.project_id = #{projectId} and DATE_FORMAT( f.finish_date, '%Y-%m' ) <= #{endDate} ORDER BY create_time DESC LIMIT 1")
    Long queryFinishId(Long projectId,String endDate);

    @Delete("delete from ejc_targetcost_duty where id = #{dutyId}")
    int deleteByDutyIdPhy(@Param(value = "dutyId")Long dutyId);
}
