package com.ejianc.business.targetcost.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.ejianc.business.targetcost.bean.DetailExecutionEntity;
import com.ejianc.business.targetcost.enums.BussinessTypeEnum;
import com.ejianc.business.targetcost.mapper.DetailExecutionMapper;
import com.ejianc.business.targetcost.service.IDetailExecutionService;
import com.ejianc.business.targetcost.vo.DetailExecutionVO;
import com.ejianc.business.targetcost.vo.TotalExecutionVO;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * 目标成本明细执行情况
 *
 * @author generator
 *
 */
@Service("detailExecutionService")
public class DetailExecutionServiceImpl extends BaseServiceImpl<DetailExecutionMapper, DetailExecutionEntity> implements IDetailExecutionService{

    @Override
    public CommonResponse<String> push(List<DetailExecutionVO> detailVOList) {
       /* DetailExecutionVO detailExecutionVO = detailVOList.get(0);
        try {
            RedissonUtils.acquire(String.valueOf(detailExecutionVO.getProjectId()), 10, TimeUnit.SECONDS);
        }catch (Exception e){
            return CommonResponse.error("获取锁失败：" + detailExecutionVO.getProjectId());
        }

        List<DetailExecutionVO> detailVOListDb = null;

        detailSaveBatch(detailVOList, detailVOListDb, totalExecutionVO, dbTotalVO);

        //新起线程，推送重算缓存表
        ExecutorService threadPool = null;
        if(CollectionUtils.isNotEmpty(detailVOListDb)){
            threadPool = Executors.newFixedThreadPool(2);
            ExecutionVO executionVO = new ExecutionVO();
            executionVO.setDetailList(detailVOList);
            Callable<CommonResponse<String>> callable = new PushCalcExecCallable(RequestContextHolder.getRequestAttributes(), null, executionVO);
            threadPool.submit(callable);

            ExecutionVO executionVOdb = new ExecutionVO();
            executionVOdb.setDetailList(detailVOListDb);
            Callable<CommonResponse<String>> callabledb = new PushCalcExecCallable(RequestContextHolder.getRequestAttributes(), null, executionVOdb);
            threadPool.submit(callabledb);
        }else{
            threadPool = Executors.newFixedThreadPool(1);
            ExecutionVO executionVO = new ExecutionVO();
            executionVO.setDetailList(detailVOList);
            Callable<CommonResponse<String>> callable = new PushCalcExecCallable(RequestContextHolder.getRequestAttributes(), null, executionVO);
            threadPool.submit(callable);
        }*/

        return CommonResponse.success("推送总金额执行表成功");
    }

    @Override
    public List<DetailExecutionVO>  detailSaveBatch(List<DetailExecutionVO> detailList,  TotalExecutionVO totalExecutionVO, TotalExecutionVO dbTotalVO, Boolean isDb) {
        List<DetailExecutionVO> detailListDb = new ArrayList<>();
        List<DetailExecutionEntity> detailEntityList = null;
        if(CollectionUtils.isNotEmpty(detailList)) {
            detailEntityList =  BeanMapper.mapList(detailList, DetailExecutionEntity.class);
            for (DetailExecutionEntity detailExecutionEntity : detailEntityList) {
                detailExecutionEntity.setBillCode(totalExecutionVO.getBillCode());
                detailExecutionEntity.setOrgId(totalExecutionVO.getOrgId());
                detailExecutionEntity.setProjectId(totalExecutionVO.getProjectId());
                detailExecutionEntity.setBillCategory(totalExecutionVO.getBillCategory());
                detailExecutionEntity.setBillType(totalExecutionVO.getBillType());
                detailExecutionEntity.setBussinessType(totalExecutionVO.getBussinessType());
                detailExecutionEntity.setProperty(totalExecutionVO.getProperty());
                detailExecutionEntity.setLinkUrl(totalExecutionVO.getLinkUrl());
                detailExecutionEntity.setCostFlag(true);
            }
        }
        LambdaQueryWrapper<DetailExecutionEntity> queryWrapper = new LambdaQueryWrapper<>();
        queryWrapper.eq(DetailExecutionEntity::getSourceBillId, totalExecutionVO.getSourceId());
        queryWrapper.eq(DetailExecutionEntity::getBillType, totalExecutionVO.getBillType());
        queryWrapper.eq(DetailExecutionEntity::getBussinessType, totalExecutionVO.getBussinessType());
        queryWrapper.eq(DetailExecutionEntity::getProperty, totalExecutionVO.getProperty());
        List<DetailExecutionEntity> list = list(queryWrapper);
        if (CollectionUtils.isNotEmpty(list)) {
            //该主键前后的项目ID不是同一个,原项目整单红冲，新项目不做处理（相当于整单新增）
            if (null!= dbTotalVO && null != dbTotalVO.getProjectId() && dbTotalVO.getProjectId().compareTo(totalExecutionVO.getProjectId()) != 0) {
                for(DetailExecutionEntity dbDetailEntity : list){
                    DetailExecutionVO executionVO = BeanMapper.map(dbDetailEntity, DetailExecutionVO.class);
                    executionVO.setMoney(ComputeUtil.safeSub(BigDecimal.ZERO, executionVO.getMoney()));
                    executionVO.setTaxMoney(ComputeUtil.safeSub(BigDecimal.ZERO, executionVO.getTaxMoney()));
                    executionVO.setNum(ComputeUtil.safeSub(BigDecimal.ZERO, executionVO.getNum()));
                    detailListDb.add(executionVO);
                }
            }else{
                Map<Long, DetailExecutionEntity> dbMap = list.stream().collect(Collectors.toMap(DetailExecutionEntity::getSourceId, Function.identity(), (key1, key2) -> key2));
                for(DetailExecutionVO detailVO : detailList){
                    if(dbMap.containsKey(detailVO.getSourceId())){
                        DetailExecutionEntity dbEntity = dbMap.get(detailVO.getSourceId());
                        detailVO.setNum(ComputeUtil.safeSub(detailVO.getNum(), dbEntity.getNum()));
                        detailVO.setMoney(ComputeUtil.safeSub(detailVO.getMoney(), dbEntity.getMoney()));
                        detailVO.setTaxMoney(ComputeUtil.safeSub(detailVO.getTaxMoney(), dbEntity.getTaxMoney()));
                        dbMap.remove(detailVO.getSourceId());
                    }
                }
                if(dbMap.size() > 0){
                    for(Long key : dbMap.keySet()){
                        DetailExecutionEntity detailEntity = dbMap.get(key);
                        detailEntity.setNum(ComputeUtil.safeSub(BigDecimal.ZERO, detailEntity.getNum()));
                        detailEntity.setMoney(ComputeUtil.safeSub(BigDecimal.ZERO, detailEntity.getMoney()));
                        detailEntity.setTaxMoney(ComputeUtil.safeSub(BigDecimal.ZERO, detailEntity.getTaxMoney()));
                        detailList.add(BeanMapper.map(detailEntity, DetailExecutionVO.class));
                    }
                }
            }
            if(isDb){
               baseMapper.deletePhy(totalExecutionVO);
            }
        }

        if(!isDb && null != totalExecutionVO.getLastSourceId() && totalExecutionVO.getSourceId().compareTo(totalExecutionVO.getLastSourceId()) != 0) {//是新增变更控制，要模拟删除原单据
            LambdaQueryWrapper<DetailExecutionEntity> lastQueryWrapper = new LambdaQueryWrapper<>();
            lastQueryWrapper.eq(DetailExecutionEntity::getSourceBillId, totalExecutionVO.getLastSourceId());
            lastQueryWrapper.eq(DetailExecutionEntity::getBussinessType, totalExecutionVO.getBussinessType());
            lastQueryWrapper.eq(DetailExecutionEntity::getProperty, totalExecutionVO.getProperty());
            List<DetailExecutionEntity> lastList = list(lastQueryWrapper);
            if (CollectionUtils.isNotEmpty(lastList)) {
                for (DetailExecutionEntity detailEntity : lastList) {
                    detailEntity.setNum(ComputeUtil.safeSub(BigDecimal.ZERO, detailEntity.getNum()));
                    detailEntity.setMoney(ComputeUtil.safeSub(BigDecimal.ZERO, detailEntity.getMoney()));
                    detailEntity.setTaxMoney(ComputeUtil.safeSub(BigDecimal.ZERO, detailEntity.getTaxMoney()));
                    detailList.add(BeanMapper.map(detailEntity, DetailExecutionVO.class));
                }
            }
        }

        if(isDb && CollectionUtils.isNotEmpty(detailEntityList)){
            saveOrUpdateBatch(detailEntityList);
        }
        return detailListDb;
    }

    private void updateCostFlag(Long contractId, List<String> bussinessTypeList, Boolean costFlag) {
        LambdaUpdateWrapper<DetailExecutionEntity> wrapper = new LambdaUpdateWrapper<>();
        wrapper.eq(DetailExecutionEntity::getContractId, contractId);
        wrapper.in(DetailExecutionEntity::getBussinessType, bussinessTypeList);
        wrapper.set(DetailExecutionEntity::getCostFlag, costFlag);
        update(wrapper);
    }

    @Override
    public void detailDeleteBatch(TotalExecutionVO totalExecutionVO) {
        LambdaQueryWrapper<DetailExecutionEntity> queryWrapper = new LambdaQueryWrapper<>();
        queryWrapper.eq(DetailExecutionEntity::getSourceBillId, totalExecutionVO.getSourceId());
        queryWrapper.eq(DetailExecutionEntity::getBillType, totalExecutionVO.getBillType());
        queryWrapper.eq(DetailExecutionEntity::getBussinessType, totalExecutionVO.getBussinessType());
        queryWrapper.eq(DetailExecutionEntity::getProperty, totalExecutionVO.getProperty());
        List<DetailExecutionEntity> list = list(queryWrapper);
        if (CollectionUtils.isNotEmpty(list)) {

            baseMapper.deletePhy(totalExecutionVO);

            if (BussinessTypeEnum.专业分包完工结算单.getCode().equals(totalExecutionVO.getBussinessType())) {
                updateCostFlag(totalExecutionVO.getContractId(), Arrays.asList(new String[]{BussinessTypeEnum.专业分包月度结算单.getCode(), BussinessTypeEnum.专业分包节点结算单.getCode()}), true);
            }else  if (BussinessTypeEnum.劳务分包完工结算单.getCode().equals(totalExecutionVO.getBussinessType())) {
                updateCostFlag(totalExecutionVO.getContractId(), Arrays.asList(new String[]{BussinessTypeEnum.劳务分包月度结算单.getCode(), BussinessTypeEnum.劳务分包节点结算单.getCode()}), true);
            }
        }
    }

    @Override
    public void detailFinishSaveBatch(List<DetailExecutionVO> detailList, TotalExecutionVO totalExecutionVO, TotalExecutionVO dbTotalVO, List<String> subList, boolean isDb) {
        List<DetailExecutionEntity> detailEntityList = null;
        if(CollectionUtils.isNotEmpty(detailList)) {
            detailEntityList =  BeanMapper.mapList(detailList, DetailExecutionEntity.class);
            for (DetailExecutionEntity detailExecutionEntity : detailEntityList) {
                detailExecutionEntity.setBillCode(totalExecutionVO.getBillCode());
                detailExecutionEntity.setOrgId(totalExecutionVO.getOrgId());
                detailExecutionEntity.setProjectId(totalExecutionVO.getProjectId());
                detailExecutionEntity.setBillCategory(totalExecutionVO.getBillCategory());
                detailExecutionEntity.setBillType(totalExecutionVO.getBillType());
                detailExecutionEntity.setBussinessType(totalExecutionVO.getBussinessType());
                detailExecutionEntity.setProperty(totalExecutionVO.getProperty());
                detailExecutionEntity.setLinkUrl(totalExecutionVO.getLinkUrl());
                detailExecutionEntity.setCostFlag(true);
            }
        }
        LambdaQueryWrapper<DetailExecutionEntity> queryWrapper = new LambdaQueryWrapper<>();
        queryWrapper.eq(DetailExecutionEntity::getSourceBillId, totalExecutionVO.getSourceId());
        queryWrapper.eq(DetailExecutionEntity::getBillType, totalExecutionVO.getBillType());
        queryWrapper.eq(DetailExecutionEntity::getBussinessType, totalExecutionVO.getBussinessType());
        queryWrapper.eq(DetailExecutionEntity::getProperty, totalExecutionVO.getProperty());
        List<DetailExecutionEntity> list = list(queryWrapper);
        if (CollectionUtils.isNotEmpty(list)) {
            Map<Long, DetailExecutionEntity> dbMap = list.stream().collect(Collectors.toMap(DetailExecutionEntity::getSourceId, Function.identity(), (key1, key2) -> key2));
            for (DetailExecutionVO detailVO : detailList) {
                if (dbMap.containsKey(detailVO.getSourceId())) {
                    DetailExecutionEntity dbEntity = dbMap.get(detailVO.getSourceId());
                    detailVO.setNum(ComputeUtil.safeSub(detailVO.getNum(), dbEntity.getNum()));
                    detailVO.setMoney(ComputeUtil.safeSub(detailVO.getMoney(), dbEntity.getMoney()));
                    detailVO.setTaxMoney(ComputeUtil.safeSub(detailVO.getTaxMoney(), dbEntity.getTaxMoney()));
                    dbMap.remove(detailVO.getSourceId());
                }
            }
            if (dbMap.size() > 0) {
                for (Long key : dbMap.keySet()) {
                    DetailExecutionEntity detailEntity = dbMap.get(key);
                    detailEntity.setNum(ComputeUtil.safeSub(BigDecimal.ZERO, detailEntity.getNum()));
                    detailEntity.setMoney(ComputeUtil.safeSub(BigDecimal.ZERO, detailEntity.getMoney()));
                    detailEntity.setTaxMoney(ComputeUtil.safeSub(BigDecimal.ZERO, detailEntity.getTaxMoney()));
                    detailList.add(BeanMapper.map(detailEntity, DetailExecutionVO.class));
                }
            }
            if(isDb){
                baseMapper.deletePhy(totalExecutionVO);
            }
        }else{
            if(isDb){
                if (BussinessTypeEnum.专业分包完工结算单.getCode().equals(totalExecutionVO.getBussinessType())) {
                    updateCostFlag(totalExecutionVO.getContractId(), Arrays.asList(new String[]{BussinessTypeEnum.专业分包月度结算单.getCode(), BussinessTypeEnum.专业分包节点结算单.getCode()}), false);
                }else  if (BussinessTypeEnum.劳务分包完工结算单.getCode().equals(totalExecutionVO.getBussinessType())) {
                    updateCostFlag(totalExecutionVO.getContractId(), Arrays.asList(new String[]{BussinessTypeEnum.劳务分包月度结算单.getCode(), BussinessTypeEnum.劳务分包节点结算单.getCode()}), false);
                }
            }else{//第一次新增保存,取与过程结算的差额做控制
                Map<Long, DetailExecutionVO> detailMap = detailList.stream().collect(Collectors.toMap(DetailExecutionVO::getContractDetailId, Function.identity(), (key1, key2) -> key1));
                LambdaQueryWrapper<DetailExecutionEntity> wrapper = new LambdaQueryWrapper<>();
                wrapper.eq(DetailExecutionEntity::getProjectId, totalExecutionVO.getProjectId());
                wrapper.eq(DetailExecutionEntity::getContractId, totalExecutionVO.getContractId());
                wrapper.in(DetailExecutionEntity::getBussinessType, subList);
                List<DetailExecutionEntity> dbList = list(wrapper);
                for(DetailExecutionEntity detailEntity : dbList){
                    if (detailMap.containsKey(detailEntity.getContractDetailId())) {
                        DetailExecutionVO detailExecutionVO = detailMap.get(detailEntity.getContractDetailId());
                        detailExecutionVO.setNum(ComputeUtil.safeSub(detailExecutionVO.getNum(), detailEntity.getNum()));
                        detailExecutionVO.setMoney(ComputeUtil.safeSub(detailExecutionVO.getMoney(), detailEntity.getMoney()));
                        detailExecutionVO.setTaxMoney(ComputeUtil.safeSub(detailExecutionVO.getTaxMoney(), detailEntity.getTaxMoney()));
                    }
                }
//                detailList = new ArrayList<>(detailMap.values());
            }
        }

        if(isDb && CollectionUtils.isNotEmpty(detailEntityList)){
            saveOrUpdateBatch(detailEntityList);
        }
    }

    @Override
    public List<DetailExecutionEntity> detailContSaveBatch(List<DetailExecutionVO> detailList, TotalExecutionVO totalExecutionVO, TotalExecutionVO dbTotalVO, boolean isDb) {
        List<DetailExecutionEntity> detailListDb = new ArrayList<>();
        List<DetailExecutionEntity> detailEntityList = null;
        if(CollectionUtils.isNotEmpty(detailList)) {
            detailEntityList =  BeanMapper.mapList(detailList, DetailExecutionEntity.class);
            for (DetailExecutionEntity detailExecutionEntity : detailEntityList) {
                detailExecutionEntity.setBillCode(totalExecutionVO.getBillCode());
                detailExecutionEntity.setOrgId(totalExecutionVO.getOrgId());
                detailExecutionEntity.setProjectId(totalExecutionVO.getProjectId());
                detailExecutionEntity.setBillCategory(totalExecutionVO.getBillCategory());
                detailExecutionEntity.setBillType(totalExecutionVO.getBillType());
                detailExecutionEntity.setBussinessType(totalExecutionVO.getBussinessType());
                detailExecutionEntity.setProperty(totalExecutionVO.getProperty());
                detailExecutionEntity.setLinkUrl(totalExecutionVO.getLinkUrl());
                detailExecutionEntity.setCostFlag(true);
            }
        }
        LambdaQueryWrapper<DetailExecutionEntity> queryWrapper = new LambdaQueryWrapper<>();
        queryWrapper.eq(DetailExecutionEntity::getSourceBillId, totalExecutionVO.getSourceId());
        queryWrapper.eq(DetailExecutionEntity::getBillType, totalExecutionVO.getBillType());
        queryWrapper.eq(DetailExecutionEntity::getProperty, totalExecutionVO.getProperty());
        List<DetailExecutionEntity> list = list(queryWrapper);
        if (CollectionUtils.isNotEmpty(list)) {
            //改了合同类别
            if(!list.get(0).getBussinessType().equals(totalExecutionVO.getBussinessType())){
                detailListDb.addAll(list);
            }else {
                Map<Long, DetailExecutionEntity> dbMap = list.stream().collect(Collectors.toMap(DetailExecutionEntity::getSourceId, Function.identity(), (key1, key2) -> key2));
                for (DetailExecutionVO detailVO : detailList) {
                    if (dbMap.containsKey(detailVO.getSourceId())) {
                        DetailExecutionEntity dbEntity = dbMap.get(detailVO.getSourceId());
                        detailVO.setNum(ComputeUtil.safeSub(detailVO.getNum(), dbEntity.getNum()));
                        detailVO.setMoney(ComputeUtil.safeSub(detailVO.getMoney(), dbEntity.getMoney()));
                        detailVO.setTaxMoney(ComputeUtil.safeSub(detailVO.getTaxMoney(), dbEntity.getTaxMoney()));
                        dbMap.remove(detailVO.getSourceId());
                    }
                }
                if (dbMap.size() > 0) {
                    for (Long key : dbMap.keySet()) {
                        DetailExecutionEntity detailEntity = dbMap.get(key);
                        detailEntity.setNum(ComputeUtil.safeSub(BigDecimal.ZERO, detailEntity.getNum()));
                        detailEntity.setMoney(ComputeUtil.safeSub(BigDecimal.ZERO, detailEntity.getMoney()));
                        detailEntity.setTaxMoney(ComputeUtil.safeSub(BigDecimal.ZERO, detailEntity.getTaxMoney()));
                        detailList.add(BeanMapper.map(detailEntity, DetailExecutionVO.class));
                    }
                }
            }
            if(isDb){
                baseMapper.deletePhy(totalExecutionVO);
            }
        }

        if(!isDb && null != totalExecutionVO.getLastSourceId() && totalExecutionVO.getSourceId().compareTo(totalExecutionVO.getLastSourceId()) != 0) {//是新增变更控制，要模拟删除原单据
            LambdaQueryWrapper<DetailExecutionEntity> lastQueryWrapper = new LambdaQueryWrapper<>();
            lastQueryWrapper.eq(DetailExecutionEntity::getSourceBillId, totalExecutionVO.getLastSourceId());
            lastQueryWrapper.eq(DetailExecutionEntity::getBussinessType, totalExecutionVO.getBussinessType());
            lastQueryWrapper.eq(DetailExecutionEntity::getProperty, totalExecutionVO.getProperty());
            List<DetailExecutionEntity> lastList = list(lastQueryWrapper);
            if (CollectionUtils.isNotEmpty(lastList)) {
                for (DetailExecutionEntity detailEntity : lastList) {
                    detailEntity.setNum(ComputeUtil.safeSub(BigDecimal.ZERO, detailEntity.getNum()));
                    detailEntity.setMoney(ComputeUtil.safeSub(BigDecimal.ZERO, detailEntity.getMoney()));
                    detailEntity.setTaxMoney(ComputeUtil.safeSub(BigDecimal.ZERO, detailEntity.getTaxMoney()));
                    detailList.add(BeanMapper.map(detailEntity, DetailExecutionVO.class));
                }
            }
        }

        if(isDb && CollectionUtils.isNotEmpty(detailEntityList)){
            saveOrUpdateBatch(detailEntityList);
        }
        return detailListDb;
    }
}
