package com.ejianc.business.targetcost.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.ejianc.business.targetcost.bean.DutyDetailItemEntity;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.targetcost.mapper.FinishDetailItemMapper;
import com.ejianc.business.targetcost.bean.FinishDetailItemEntity;
import com.ejianc.business.targetcost.service.IFinishDetailItemService;

import java.util.List;

/**
 * 目标成本完工统计明细项
 *
 * @author generator
 *
 */
@Service("finishDetailItemService")
public class FinishDetailItemServiceImpl extends BaseServiceImpl<FinishDetailItemMapper, FinishDetailItemEntity> implements IFinishDetailItemService{

    @Override
    public List<FinishDetailItemEntity> findByFinishDetailId(Long finishDetailId) {
        LambdaQueryWrapper<FinishDetailItemEntity> queryWrapper = new LambdaQueryWrapper<>();
        queryWrapper.eq(FinishDetailItemEntity::getFinishDetailId, finishDetailId);
        return list(queryWrapper);
    }
}
