package com.ejianc.business.targetcost.utils;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.ejianc.business.center.api.IWarnCenterApi;
import com.ejianc.business.center.vo.EarlyWarnTransVO;
import com.ejianc.business.targetcost.bean.*;
import com.ejianc.business.targetcost.enums.ControlTypeEnum;
import com.ejianc.business.targetcost.enums.DocTypeEnum;
import com.ejianc.business.targetcost.enums.FeeTypeEnum;
import com.ejianc.business.targetcost.service.*;
import com.ejianc.business.warn.vo.WarningReceiveVO;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.ComputeUtil;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.redisson.api.RLock;
import org.redisson.api.RedissonClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.RequestContextHolder;

import java.math.BigDecimal;
import java.util.*;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * 目标成本控制预警
 */
public class TargetcostWarnCallable implements Callable<CommonResponse<String>> {

    private final Logger logger = LoggerFactory.getLogger(getClass());

    private static  final  String  TC_LOCK = "TC_LOCK::";

    private static final String PC_URL = "/ejc-targetcost-frontend/#/execution?";

    private static final String WARN_ID = "584793299912114241";
    private static final String WARN_PARAM_ID = "584793299912114241";

    private String authority;
    private RequestAttributes context;
    private IWarnCenterApi warnCenterApi;
    private RedissonClient redissonClient;
    private ITotalCacheService totalCacheService;
    private IDetailCacheService detailCacheService;
    private List<DutyEntity> dutyEntities;
    private IRuleService ruleService;
    private IRuleDetailService ruleDetailService;
    private IRuleReceiverService ruleReceiverService;
    private IFeeDetailService feeDetailService;
    private IFeeDetailScopeService feeDetailScopeService;

    public TargetcostWarnCallable(String authority, RequestAttributes context, IWarnCenterApi warnCenterApi, RedissonClient redissonClient, ITotalCacheService totalCacheService,
                                  IDetailCacheService detailCacheService, List<DutyEntity> dutyEntities, IRuleService ruleService,  IRuleDetailService ruleDetailService,
                                  IRuleReceiverService ruleReceiverService, IFeeDetailService feeDetailService, IFeeDetailScopeService feeDetailScopeService) {
        this.authority = authority;
        this.context = context;
        this.warnCenterApi = warnCenterApi;
        this.redissonClient = redissonClient;
        this.totalCacheService = totalCacheService;
        this.detailCacheService = detailCacheService;
        this.dutyEntities = dutyEntities;
        this.ruleService = ruleService;
        this.ruleDetailService = ruleDetailService;
        this.ruleReceiverService = ruleReceiverService;
        this.feeDetailService = feeDetailService;
        this.feeDetailScopeService = feeDetailScopeService;
    }

    @Override
    public CommonResponse<String> call() throws Exception {
        context.setAttribute("authority", authority, RequestAttributes.SCOPE_REQUEST);
        RequestContextHolder.setRequestAttributes(context);
        InvocationInfoProxy.setExtendAttribute("authority", authority);
        List<EarlyWarnTransVO> warnList = new ArrayList<>();
        for(DutyEntity dutyEntity: dutyEntities) {
            //获取锁对象
            String lockKey = TC_LOCK + dutyEntity.getProjectId();
            RLock mylock = redissonClient.getLock(lockKey);
            try {
                //加锁，并且设置锁过期时间，防止死锁的产生
                boolean lock = mylock.tryLock(20, TimeUnit.SECONDS);
                if (!lock) {
                    logger.error("获取锁失败 is " + dutyEntity.getProjectId());
                    return CommonResponse.error("获取锁失败：" + dutyEntity.getProjectId());
                }
                List<OrgVO> orgVOList = dutyEntity.getOrgList();
                Set<Long> ruleIdSet = new HashSet<>();
                List<RuleEntity> ruleEntities = null;
                Map<Long, RuleEntity> ruleMap = new HashMap<>();
                if (CollectionUtils.isNotEmpty(orgVOList)) {
                    List<Long> orgList = orgVOList.stream().map(OrgVO::getId).collect(Collectors.toList());
                    LambdaQueryWrapper<RuleEntity> queryWrapper = new LambdaQueryWrapper<>();
                    queryWrapper.eq(RuleEntity::getFeeId, dutyEntity.getFeeId());
                    List<Integer> billStatusList = new ArrayList<>();
                    billStatusList.add(BillStateEnum.PASSED_STATE.getBillStateCode());
                    billStatusList.add(BillStateEnum.COMMITED_STATE.getBillStateCode());
                    queryWrapper.in(RuleEntity::getBillState, billStatusList);
                    queryWrapper.in(RuleEntity::getOrgId, orgList);
                    ruleEntities = ruleService.list(queryWrapper);
                    if (CollectionUtils.isNotEmpty(ruleEntities)) {
                        for (RuleEntity ruleEntity : ruleEntities) {
                            ruleIdSet.add(ruleEntity.getId());
                            ruleMap.put(ruleEntity.getId(), ruleEntity);
                        }
                    }
                }

                if (CollectionUtils.isEmpty(ruleIdSet)) {
                    logger.error("该责任成本没有控制规则：" + JSONObject.toJSONString(dutyEntity.getProjectId()));
                    continue;
                }

                LambdaQueryWrapper<FeeDetailScopeEntity> scopeQuery = new LambdaQueryWrapper<>();
                scopeQuery.eq(FeeDetailScopeEntity::getFeeId, dutyEntity.getFeeId());
                List<FeeDetailScopeEntity> scopeEntities = feeDetailScopeService.list(scopeQuery);
                Map<String, String> scopeMap = new HashMap<>();
                if(CollectionUtils.isNotEmpty(scopeEntities) ){
                    for(FeeDetailScopeEntity scopeEntity : scopeEntities){
                        scopeMap.put(scopeEntity.getBillCode(), scopeEntity.getMemoValue());
                    }
                }

                LambdaQueryWrapper<DetailCacheEntity> queryWrapper = new LambdaQueryWrapper<>();
                queryWrapper.eq(DetailCacheEntity::getProjectId, dutyEntity.getProjectId());
                List<DetailCacheEntity> detailCacheEntities = detailCacheService.list(queryWrapper);
                LambdaQueryWrapper<TotalCacheEntity> queryWrapper1 = new LambdaQueryWrapper<>();
                queryWrapper1.eq(TotalCacheEntity::getProjectId, dutyEntity.getProjectId());
                List<TotalCacheEntity> totalCacheEntities = totalCacheService.list(queryWrapper1);

                List<Long> feeDetailPks = totalCacheEntities.stream().map(TotalCacheEntity::getFeeDetailId).collect(Collectors.toList());

                Map<String, List<RuleDetailEntity>> ruleDetailMap = new HashMap<>();
                List<Long> ruleDetailList = new ArrayList<>();
                LambdaQueryWrapper<RuleDetailEntity> ruleDetailQuery = new LambdaQueryWrapper<>();
                ruleDetailQuery.eq(RuleDetailEntity::getSubjectFlag, false);
                ruleDetailQuery.in(RuleDetailEntity::getControlType, ControlTypeEnum.风险预警.getCode());
                ruleDetailQuery.in(RuleDetailEntity::getRuleId, ruleIdSet);
                ruleDetailQuery.in(RuleDetailEntity::getFeeDetailId, feeDetailPks);
                List<RuleDetailEntity> ruleDetailEntities = ruleDetailService.list(ruleDetailQuery);
                for (RuleDetailEntity entity : ruleDetailEntities) {
                    String key = entity.getFeeInnerCode();
                    List<RuleDetailEntity> list = ruleDetailMap.containsKey(key) ? ruleDetailMap.get(key) : new ArrayList<>();
                    list.add(entity);
                    ruleDetailMap.put(key, list);
                    ruleDetailList.add(entity.getId());
                }

                if (CollectionUtils.isEmpty(ruleDetailList)) {
                    logger.error("该责任成本没有费用项风险预警控制规则：" + JSONObject.toJSONString(dutyEntity.getProjectId()));
                    continue;
                }

                LambdaQueryWrapper<RuleReceiverEntity> query = new LambdaQueryWrapper<>();
                query.in(RuleReceiverEntity::getRuleDetailId, ruleDetailList);
                List<RuleReceiverEntity> receiverEntities = ruleReceiverService.list(query);
                Map<Long, List<RuleReceiverEntity>> receiverMap = new HashMap<>();
                if (CollectionUtils.isNotEmpty(receiverEntities)) {
                    for (RuleReceiverEntity receiverEntity : receiverEntities) {
                        List<RuleReceiverEntity> list = null;
                        if (receiverMap.containsKey(receiverEntity.getRuleDetailId())) {
                            list = receiverMap.get(receiverEntity.getRuleDetailId());
                        } else {
                            list = new ArrayList<>();
                        }
                        list.add(receiverEntity);
                        receiverMap.put(receiverEntity.getRuleDetailId(), list);
                    }
                }
                List<EarlyWarnTransVO> warnTransVOS = ctrl(detailCacheEntities, totalCacheEntities, ruleMap, ruleDetailMap, dutyEntity, receiverMap, scopeMap);
                logger.error("warnTransVOS is " + JSONObject.toJSONString(warnTransVOS));
                if (CollectionUtils.isNotEmpty(warnTransVOS)) {
                    warnList.addAll(warnTransVOS);
                }
            } catch (Exception e) {
                logger.error("目标成本预警失败:" + JSONObject.toJSONString(e));
            } finally {
                mylock.unlock();
            }
            if (CollectionUtils.isNotEmpty(warnList)) {
                CommonResponse<String> warnResp = warnCenterApi.sendToWarnCenterWithReceive(warnList, Long.valueOf(WARN_ID));
                if(!warnResp.isSuccess()) {
                    logger.error("回调预警任务服务失败，{}", warnResp.getMsg());
                    logger.error("dutyEntity" + JSONObject.toJSONString(dutyEntity));
                    continue;
                }
            }
        }
        return CommonResponse.success("目标成本预警成功");
    }

    private List<EarlyWarnTransVO> ctrl(List<DetailCacheEntity> detailCacheEntities, List<TotalCacheEntity> totalCacheEntities,  Map<Long, RuleEntity> ruleMap, Map<String, List<RuleDetailEntity>> ruleDetailMap, DutyEntity dutyEntity, Map<Long, List<RuleReceiverEntity>> receiverMap, Map<String, String> scopeMap){
        Set<Long> feeDetailPkSet = new HashSet<>();
        for(TotalCacheEntity cacheEntity : totalCacheEntities){
            feeDetailPkSet.add(cacheEntity.getFeeDetailId());
        }
        for(DetailCacheEntity detailCacheEntity: detailCacheEntities){
            feeDetailPkSet.add(detailCacheEntity.getFeeDetailId());
        }
        LambdaQueryWrapper<FeeDetailEntity> queryWrapper = new LambdaQueryWrapper<>();
        queryWrapper.in(FeeDetailEntity::getId, feeDetailPkSet);
        List<FeeDetailEntity> feeDetalilist = feeDetailService.list(queryWrapper);
        Map<Long, String> innerCodeMap = feeDetalilist.stream().collect(Collectors.toMap(FeeDetailEntity::getId, FeeDetailEntity::getInnerCode, (key1, key2) -> key1));

        List<EarlyWarnTransVO> warnList = new ArrayList<>();
        Map<Long, List<DetailCacheEntity>> detailCacheMap = new HashMap<>();
        for(DetailCacheEntity detailCacheEntity: detailCacheEntities){
            Long feeDetailId = detailCacheEntity.getFeeDetailId();
            List<RuleDetailEntity> ruleDetailEntityList = getRuleDetailList(ruleDetailMap, innerCodeMap.get(feeDetailId));
            List<EarlyWarnTransVO> warnTransVOS = detailCtrl(ruleDetailEntityList, detailCacheEntity, dutyEntity,  receiverMap, ruleMap);
            if(CollectionUtils.isNotEmpty(warnTransVOS)){
                warnList.addAll(warnTransVOS);
            }
            Long key = detailCacheEntity.getFeeDetailId();
            List<DetailCacheEntity> list = detailCacheMap.containsKey(key) ? detailCacheMap.get(key) : new ArrayList<>();
            list.add(detailCacheEntity);
            detailCacheMap.put(key, list);
        }


        for(TotalCacheEntity cacheEntity : totalCacheEntities){
            Long feeDetailId = cacheEntity.getFeeDetailId();
            List<DetailCacheEntity> detailCacheEntityList = detailCacheMap.get(feeDetailId);
            List<RuleDetailEntity> ruleDetailEntityList = getRuleDetailList(ruleDetailMap, innerCodeMap.get(feeDetailId));
            if(CollectionUtils.isNotEmpty(ruleDetailEntityList)){
                List<List<RuleDetailEntity>> ruleListAll = splitToMap(ruleDetailEntityList);
                List<RuleDetailEntity> ruleList = ruleListAll.get(0); //目标为空时不控制
                List<EarlyWarnTransVO> warnTransVOS = totalCtrl(ruleList, false, cacheEntity, dutyEntity, detailCacheEntityList, receiverMap, ruleMap);
                if(CollectionUtils.isNotEmpty(warnTransVOS)){
                    warnList.addAll(warnTransVOS);
                }
                List<RuleDetailEntity> ruleNullList = ruleListAll.get(1); //目标为空时控制
                List<EarlyWarnTransVO> warnTransVOList = totalCtrl(ruleNullList, true, cacheEntity, dutyEntity, detailCacheEntityList, receiverMap, ruleMap);
                if(CollectionUtils.isNotEmpty(warnTransVOList)){
                    warnList.addAll(warnTransVOList);
                }
            }
        }
        return warnList;
    }

    private List<EarlyWarnTransVO> detailCtrl(List<RuleDetailEntity> ruleDetailEntityList, DetailCacheEntity detailCacheEntity,
                                              DutyEntity dutyEntity,  Map<Long, List<RuleReceiverEntity>> receiverMap,  Map<Long, RuleEntity> ruleMap) {
        List<EarlyWarnTransVO> list = new ArrayList<>();
        if(CollectionUtils.isNotEmpty(ruleDetailEntityList)){
            for(RuleDetailEntity ruleDetailEntity : ruleDetailEntityList){
                if(!receiverMap.containsKey(ruleDetailEntity.getId())){
                    continue;
                }
                BigDecimal controlScale = ruleDetailEntity.getControlScale();
                EarlyWarnTransVO earlyWarnTransVO = dutyDetailRuleToWarnVO(detailCacheEntity, ruleDetailEntity, controlScale, dutyEntity, receiverMap.get(ruleDetailEntity.getId()), ruleMap);
                if (null != earlyWarnTransVO) {
                    list.add(earlyWarnTransVO);
                }
            }
        }
        return list;
    }

    private List<EarlyWarnTransVO> totalCtrl(List<RuleDetailEntity> ruleList, Boolean isNullCtrl, TotalCacheEntity cacheEntity, DutyEntity dutyEntity,
                                             List<DetailCacheEntity> detailCacheEntities, Map<Long, List<RuleReceiverEntity>> receiverMap,  Map<Long, RuleEntity> ruleMap){
        List<EarlyWarnTransVO> list = new ArrayList<>();
        if(CollectionUtils.isNotEmpty(ruleList)){
            for(RuleDetailEntity ruleDetailEntity : ruleList){
                if(!receiverMap.containsKey(ruleDetailEntity.getId())){
                    continue;
                }
                BigDecimal controlScale = ruleDetailEntity.getControlScale();
                EarlyWarnTransVO earlyWarnTransVO = dutyRuleToWarnVO(cacheEntity, ruleDetailEntity, controlScale, dutyEntity, detailCacheEntities, isNullCtrl, receiverMap.get(ruleDetailEntity.getId()), ruleMap);
                if (null != earlyWarnTransVO) {
                    list.add(earlyWarnTransVO);
                }
            }
        }
        return list;
    }

    private EarlyWarnTransVO dutyRuleToWarnVO(TotalCacheEntity totalCacheEntity, RuleDetailEntity detailEntity, BigDecimal controlScale, DutyEntity dutyEntity,
                                              List<DetailCacheEntity> detailCacheEntities, Boolean isNullCtrl, List<RuleReceiverEntity> receiverEntities,  Map<Long, RuleEntity> ruleMap) {
        List<WarningReceiveVO> receiveList = new ArrayList<>();
        if(CollectionUtils.isNotEmpty(receiverEntities)){
            for(RuleReceiverEntity receiverEntity : receiverEntities){
                WarningReceiveVO receiveVO = new WarningReceiveVO();
                receiveVO.setNameId(receiverEntity.getNameId());
                receiveVO.setName(receiverEntity.getName());
                receiveVO.setType(receiverEntity.getType());
                receiveVO.setWarningId(detailEntity.getId());
                receiveList.add(receiveVO);
            }
        }
        EarlyWarnTransVO vo = null;
        BigDecimal num = totalCacheEntity.getPreTypeAmount();
        BigDecimal costTaxMny = totalCacheEntity.getTaxMny();
        if(FeeTypeEnum.总额控.getCode().equals(detailEntity.getFeeType())){
            BigDecimal comPlanTaxScale = ComputeUtil.safeMultiply(ComputeUtil.safeDiv(totalCacheEntity.getPlanTaxMoney(), costTaxMny), BigDecimal.valueOf(100));
            BigDecimal comContTaxScale = ComputeUtil.safeMultiply(ComputeUtil.safeDiv(totalCacheEntity.getContTaxMoney(), costTaxMny), BigDecimal.valueOf(100));
            BigDecimal comStoreTaxScale = ComputeUtil.safeMultiply(ComputeUtil.safeDiv(totalCacheEntity.getStoreTaxMoney(), costTaxMny), BigDecimal.valueOf(100));
            BigDecimal comOtherTaxScale = ComputeUtil.safeMultiply(ComputeUtil.safeDiv(totalCacheEntity.getOtherTaxMoney(), costTaxMny), BigDecimal.valueOf(100));
            BigDecimal comSettleTaxScale = ComputeUtil.safeMultiply(ComputeUtil.safeDiv(totalCacheEntity.getSettleTaxMoney(), costTaxMny), BigDecimal.valueOf(100));
            if(isNullCtrl){
                if( ComputeUtil.isLessThan(controlScale, comPlanTaxScale) || ComputeUtil.isLessThan(controlScale, comContTaxScale)
                        || ComputeUtil.isLessThan(controlScale, comStoreTaxScale) || ComputeUtil.isLessThan(controlScale, comOtherTaxScale)
                        || ComputeUtil.isLessThan(controlScale, comSettleTaxScale)){

                    vo = new EarlyWarnTransVO();
                }
            }else{
                if(null != costTaxMny && (ComputeUtil.isLessThan(controlScale, comPlanTaxScale) ||
                         ComputeUtil.isLessThan(controlScale, comContTaxScale)
                        || ComputeUtil.isLessThan(controlScale, comStoreTaxScale)
                        || ComputeUtil.isLessThan(controlScale, comOtherTaxScale)
                        || ComputeUtil.isLessThan(controlScale, comSettleTaxScale))){

                    vo = new EarlyWarnTransVO();

                }
            }
            if(null != vo){
                vo.setBillName(dutyEntity.getBillCode());
                vo.setPcTitle("目标成本执行情况");
                vo.setPcUrl(PC_URL + "projectId=" + dutyEntity.getProjectId() + "&&" + "projectName=" + dutyEntity.getProjectName());
                RuleEntity ruleEntity = ruleMap.get(detailEntity.getRuleId());
                vo.setOrgId(ruleEntity.getOrgId());
                vo.setOrgName(ruleEntity.getOrgName());
                vo.setSourceId(String.valueOf(dutyEntity.getId()));
                vo.setTenantId(dutyEntity.getTenantId());
                vo.setWarnLevel("中");
                vo.setWarnSetId(Long.valueOf(WARN_ID));
                vo.setWarnSetParamId(Long.valueOf(WARN_ID));
                vo.setWarnType("1");
                vo.setSendOrgId(String.valueOf(ruleEntity.getOrgId()));
                vo.setDef1(String.valueOf(detailEntity.getId()) + totalCacheEntity.getId());
                vo.setEarlywarnName(totalCacheEntity.getName() + "总额控预警");
                vo.setReceiveList(receiveList);
                StringBuffer warnStr = new StringBuffer();
                if(ComputeUtil.isLessThan(controlScale, comPlanTaxScale)){
                    warnStr.append(totalCacheEntity.getName());
                    warnStr.append("计划总金额(").append(ComputeUtil.scale(totalCacheEntity.getPlanMoney(), 2)).append("元)已占用目标成本中该费用金额");
                    warnStr.append("(").append(ComputeUtil.scale(costTaxMny, 2)).append("元)").append(ComputeUtil.scale(comPlanTaxScale, 2)).append("%! \n");
                }
                if(ComputeUtil.isLessThan(controlScale, comContTaxScale)){
                    warnStr.append(totalCacheEntity.getName());
                    warnStr.append("合同总金额(").append(ComputeUtil.scale(totalCacheEntity.getContTaxMoney(), 2)).append("元)已占用目标成本中该费用金额");
                    warnStr.append("(").append(ComputeUtil.scale(costTaxMny, 2)).append("元)").append(ComputeUtil.scale(comContTaxScale, 2)).append("%! \n");
                }
                if(ComputeUtil.isLessThan(controlScale, comStoreTaxScale)){
                    warnStr.append(totalCacheEntity.getName());
                    warnStr.append("入库总金额(").append(ComputeUtil.scale(totalCacheEntity.getStoreTaxMoney(), 2)).append("元)已占用目标成本中该费用金额");
                    warnStr.append("(").append(ComputeUtil.scale(costTaxMny, 2)).append("元)").append(ComputeUtil.scale(comStoreTaxScale, 2)).append("%! \n");
                }
                if(ComputeUtil.isLessThan(controlScale, comOtherTaxScale)){
                    warnStr.append(totalCacheEntity.getName());
                    warnStr.append("其他总金额(").append(ComputeUtil.scale(totalCacheEntity.getOtherTaxMoney(), 2)).append("元)已占用目标成本中该费用金额");
                    warnStr.append("(").append(ComputeUtil.scale(costTaxMny, 2)).append("元)").append(ComputeUtil.scale(comOtherTaxScale, 2)).append("%! \n");
                }
                if(ComputeUtil.isLessThan(controlScale, comSettleTaxScale)){
                    warnStr.append(totalCacheEntity.getName());
                    warnStr.append("结算总金额(").append(ComputeUtil.scale(totalCacheEntity.getSettleTaxMoney(), 2)).append("元)已占用目标成本中该费用金额");
                    warnStr.append("(").append(ComputeUtil.scale(costTaxMny, 2)).append("元)").append(ComputeUtil.scale(comSettleTaxScale, 2)).append("%! \n");
                }
                vo.setEarlywarnContent(warnStr.toString());
            }
        }else if(FeeTypeEnum.分类量控.getCode().equals(detailEntity.getFeeType())){
            if (DocTypeEnum.物料档案.getCode().equals(totalCacheEntity.getDocType()) && totalCacheEntity.getLeafFlag()) {
                BigDecimal comPlanNum = null;
                BigDecimal comContNum = null;
                BigDecimal comStoreNum = null;
                BigDecimal comOtherNum = null;
                BigDecimal comSettleNum = null;
                if(CollectionUtils.isNotEmpty(detailCacheEntities)){
                    for(DetailCacheEntity detailCacheEntity : detailCacheEntities){
                        comPlanNum = ComputeUtil.safeAdd(comPlanNum, detailCacheEntity.getPlanNum());
                        comContNum = ComputeUtil.safeAdd(comContNum, detailCacheEntity.getContNum());
                        comStoreNum = ComputeUtil.safeAdd(comStoreNum, detailCacheEntity.getStoreNum());
                        comOtherNum = ComputeUtil.safeAdd(comOtherNum, detailCacheEntity.getOtherNum());
                        comSettleNum = ComputeUtil.safeAdd(comSettleNum, detailCacheEntity.getSettleNum());
                    }
                }
                BigDecimal comPlanScale = ComputeUtil.safeMultiply(ComputeUtil.safeDiv(comPlanNum, num), BigDecimal.valueOf(100));
                BigDecimal comContScale = ComputeUtil.safeMultiply(ComputeUtil.safeDiv(comContNum, num), BigDecimal.valueOf(100));
                BigDecimal comStoreScale = ComputeUtil.safeMultiply(ComputeUtil.safeDiv(comStoreNum, num), BigDecimal.valueOf(100));
                BigDecimal comOtherScale = ComputeUtil.safeMultiply(ComputeUtil.safeDiv(comOtherNum, num), BigDecimal.valueOf(100));
                BigDecimal comSettleScale = ComputeUtil.safeMultiply(ComputeUtil.safeDiv(comSettleNum, num), BigDecimal.valueOf(100));

                if(isNullCtrl) {
                    if (ComputeUtil.isLessThan(controlScale, comPlanScale)
                            || ComputeUtil.isLessThan(controlScale, comContScale)
                            || ComputeUtil.isLessThan(controlScale, comStoreScale)
                            || ComputeUtil.isLessThan(controlScale, comOtherScale)
                            || ComputeUtil.isLessThan(controlScale, comSettleScale)) {

                        vo = new EarlyWarnTransVO();
                    }
                }else {
                    if (null != num && (ComputeUtil.isLessThan(controlScale, comPlanScale)
                            || ComputeUtil.isLessThan(controlScale, comContScale)
                            || ComputeUtil.isLessThan(controlScale, comStoreScale)
                            || ComputeUtil.isLessThan(controlScale, comOtherScale)
                            || ComputeUtil.isLessThan(controlScale, comSettleScale))) {

                        vo = new EarlyWarnTransVO();
                    }
                }
                if(null != vo){
                    vo.setBillName(dutyEntity.getBillCode());
                    vo.setPcTitle("目标成本执行情况");
                    vo.setPcUrl(PC_URL + "projectId=" + dutyEntity.getProjectId() + "&&" + "projectName=" + dutyEntity.getProjectName());
                    RuleEntity ruleEntity = ruleMap.get(detailEntity.getRuleId());
                    vo.setOrgId(ruleEntity.getOrgId());
                    vo.setOrgName(ruleEntity.getOrgName());
                    vo.setSourceId(String.valueOf(dutyEntity.getId()));
                    vo.setTenantId(dutyEntity.getTenantId());
                    vo.setWarnLevel("中");
                    vo.setWarnSetId(Long.valueOf(WARN_ID));
                    vo.setWarnSetParamId(Long.valueOf(WARN_ID));
                    vo.setWarnType("1");
                    vo.setSendOrgId(String.valueOf(ruleEntity.getOrgId()));
                    vo.setDef1(String.valueOf(detailEntity.getId()) + totalCacheEntity.getId());
                    vo.setEarlywarnName(totalCacheEntity.getName() + "分类量控预警");
                    vo.setReceiveList(receiveList);
                    StringBuffer warnStr = new StringBuffer();
                    if(ComputeUtil.isLessThan(controlScale, comPlanScale)){
                        warnStr.append(totalCacheEntity.getName());
                        warnStr.append("计划总数量(").append(ComputeUtil.scale(totalCacheEntity.getPlanNum(), 2)).append(")已占用目标成本中该分类预估数量");
                        warnStr.append("(").append(ComputeUtil.scale(num, 2)).append(")").append(ComputeUtil.scale(comPlanScale, 2)).append("%! \n");
                    }
                    if(ComputeUtil.isLessThan(controlScale, comContScale)){
                        warnStr.append(totalCacheEntity.getName());
                        warnStr.append("合同总数量(").append(ComputeUtil.scale(totalCacheEntity.getContNum(), 2)).append(")已占用目标成本中该分类预估数量");
                        warnStr.append("(").append(ComputeUtil.scale(num, 2)).append(")").append(ComputeUtil.scale(comContScale, 2)).append("%! \n");
                    }
                    if(ComputeUtil.isLessThan(controlScale, comStoreScale)){
                        warnStr.append(totalCacheEntity.getName());
                        warnStr.append("入库总数量(").append(ComputeUtil.scale(totalCacheEntity.getStoreNum(), 2)).append(")已占用目标成本中该分类预估数量");
                        warnStr.append("(").append(ComputeUtil.scale(num, 2)).append(")").append(ComputeUtil.scale(comStoreScale, 2)).append("%! \n");
                    }
                    if(ComputeUtil.isLessThan(controlScale, comOtherScale)){
                        warnStr.append(totalCacheEntity.getName());
                        warnStr.append("其他总数量(").append(ComputeUtil.scale(totalCacheEntity.getOtherNum(), 2)).append(")已占用目标成本中该分类预估数量");
                        warnStr.append("(").append(ComputeUtil.scale(num, 2)).append(")").append(ComputeUtil.scale(comOtherScale, 2)).append("%! \n");
                    }
                    if(ComputeUtil.isLessThan(controlScale, comSettleScale)){
                        warnStr.append(totalCacheEntity.getName());
                        warnStr.append("结算总数量(").append(ComputeUtil.scale(totalCacheEntity.getSettleNum(), 2)).append(")已占用目标成本中该分类预估数量");
                        warnStr.append("(").append(ComputeUtil.scale(num, 2)).append(")").append(ComputeUtil.scale(comSettleScale, 2)).append("%! \n");
                    }
                    vo.setEarlywarnContent(warnStr.toString());
                }
            }
        }else if(FeeTypeEnum.目标外明细总金额控.getCode().equals(detailEntity.getFeeType())){
            BigDecimal comPlanTaxScale = ComputeUtil.safeMultiply(ComputeUtil.safeDiv(totalCacheEntity.getOutPlanTaxMoney(), costTaxMny), BigDecimal.valueOf(100));
            BigDecimal comContTaxScale = ComputeUtil.safeMultiply(ComputeUtil.safeDiv(totalCacheEntity.getOutContTaxMoney(), costTaxMny), BigDecimal.valueOf(100));
            BigDecimal comStoreTaxScale = ComputeUtil.safeMultiply(ComputeUtil.safeDiv(totalCacheEntity.getOutStoreTaxMoney(), costTaxMny), BigDecimal.valueOf(100));
            BigDecimal comOtherTaxScale = ComputeUtil.safeMultiply(ComputeUtil.safeDiv(totalCacheEntity.getOutOtherTaxMoney(), costTaxMny), BigDecimal.valueOf(100));
            BigDecimal comSettleTaxScale = ComputeUtil.safeMultiply(ComputeUtil.safeDiv(totalCacheEntity.getOutSettleTaxMoney(), costTaxMny), BigDecimal.valueOf(100));

            if(isNullCtrl){
                if(ComputeUtil.isLessThan(controlScale, comPlanTaxScale)
                        || ComputeUtil.isLessThan(controlScale, comContTaxScale)
                        || ComputeUtil.isLessThan(controlScale, comStoreTaxScale)
                        || ComputeUtil.isLessThan(controlScale, comOtherTaxScale)
                        || ComputeUtil.isLessThan(controlScale, comSettleTaxScale)){

                    vo = new EarlyWarnTransVO();
                }
            }else{
                if(null != costTaxMny && (ComputeUtil.isLessThan(controlScale, comPlanTaxScale)
                        || ComputeUtil.isLessThan(controlScale, comContTaxScale)
                        || ComputeUtil.isLessThan(controlScale, comStoreTaxScale)
                        || ComputeUtil.isLessThan(controlScale, comOtherTaxScale)
                        || ComputeUtil.isLessThan(controlScale, comSettleTaxScale))){

                    vo = new EarlyWarnTransVO();
                }
            }
            if(null != vo){
                vo.setBillName(dutyEntity.getBillCode());
                vo.setPcTitle("目标成本执行情况");
                vo.setPcUrl(PC_URL + "projectId=" + dutyEntity.getProjectId() + "&&" + "projectName=" + dutyEntity.getProjectName());
                RuleEntity ruleEntity = ruleMap.get(detailEntity.getRuleId());
                vo.setOrgId(ruleEntity.getOrgId());
                vo.setOrgName(ruleEntity.getOrgName());
                vo.setSourceId(String.valueOf(dutyEntity.getId()));
                vo.setTenantId(dutyEntity.getTenantId());
                vo.setWarnLevel("中");
                vo.setWarnSetId(Long.valueOf(WARN_ID));
                vo.setWarnSetParamId(Long.valueOf(WARN_ID));
                vo.setWarnType("1");
                vo.setSendOrgId(String.valueOf(ruleEntity.getOrgId()));
                vo.setDef1(String.valueOf(detailEntity.getId()) + totalCacheEntity.getId());
                vo.setEarlywarnName(totalCacheEntity.getName() + "目标外明细总金额控预警");
                vo.setReceiveList(receiveList);
                StringBuffer warnStr = new StringBuffer();
                if(ComputeUtil.isLessThan(controlScale, comPlanTaxScale)){
                    warnStr.append(totalCacheEntity.getName());
                    warnStr.append("目标外明细计划总金额(").append(ComputeUtil.scale(totalCacheEntity.getOutPlanMoney(), 2)).append("元)已占用目标成本中").append(totalCacheEntity.getName());
                    warnStr.append("(").append(ComputeUtil.scale(costTaxMny, 2)).append("元)").append(ComputeUtil.scale(comPlanTaxScale, 2)).append("%! \n");
                }
                if(ComputeUtil.isLessThan(controlScale, comContTaxScale)){
                    warnStr.append(totalCacheEntity.getName());
                    warnStr.append("目标外明细合同总金额(").append(ComputeUtil.scale(totalCacheEntity.getOutContTaxMoney(), 2)).append("元)已占用目标成本中").append(totalCacheEntity.getName());
                    warnStr.append("(").append(ComputeUtil.scale(costTaxMny, 2)).append("元)").append(ComputeUtil.scale(comContTaxScale, 2)).append("%! \n");
                }
                if(ComputeUtil.isLessThan(controlScale, comStoreTaxScale)){
                    warnStr.append(totalCacheEntity.getName());
                    warnStr.append("目标外明细入库总金额(").append(ComputeUtil.scale(totalCacheEntity.getOutStoreTaxMoney(), 2)).append("元)已占用目标成本中").append(totalCacheEntity.getName());
                    warnStr.append("(").append(ComputeUtil.scale(costTaxMny, 2)).append("元)").append(ComputeUtil.scale(comStoreTaxScale, 2)).append("%! \n");
                }
                if(ComputeUtil.isLessThan(controlScale, comOtherTaxScale)){
                    warnStr.append(totalCacheEntity.getName());
                    warnStr.append("目标外明细其他总金额(").append(ComputeUtil.scale(totalCacheEntity.getOutOtherTaxMoney(), 2)).append("元)已占用目标成本中").append(totalCacheEntity.getName());
                    warnStr.append("(").append(ComputeUtil.scale(costTaxMny, 2)).append("元)").append(ComputeUtil.scale(comOtherTaxScale, 2)).append("%! \n");
                }
                if(ComputeUtil.isLessThan(controlScale, comSettleTaxScale)){
                    warnStr.append(totalCacheEntity.getName());
                    warnStr.append("目标外明细结算总金额(").append(ComputeUtil.scale(totalCacheEntity.getOutSettleTaxMoney(), 2)).append("元)已占用目标成本中").append(totalCacheEntity.getName());
                    warnStr.append("(").append(ComputeUtil.scale(costTaxMny, 2)).append("元)").append(ComputeUtil.scale(comSettleTaxScale, 2)).append("%! \n");
                }
                vo.setEarlywarnContent(warnStr.toString());
            }
        }
        return vo;
    }


    private List<List<RuleDetailEntity>> splitToMap(List<RuleDetailEntity> ruleDetailEntityList) {
        List<List<RuleDetailEntity>> resulte = new ArrayList<>();
        List<RuleDetailEntity> list = new ArrayList<>();
        List<RuleDetailEntity> listNull = new ArrayList<>();
        for(RuleDetailEntity entity : ruleDetailEntityList){
                if(entity.getNullControlFlag()){
                    listNull.add(entity);
                }else{
                    list.add(entity);
                }
        }
        resulte.add(list);
        resulte.add(listNull);
        return  resulte;
    }

    private EarlyWarnTransVO dutyDetailRuleToWarnVO(DetailCacheEntity detailCacheEntity, RuleDetailEntity detailEntity,
                                                    BigDecimal controlScale, DutyEntity dutyEntity, List<RuleReceiverEntity> receiverEntities,  Map<Long, RuleEntity> ruleMap) {
        List<WarningReceiveVO> receiveList = new ArrayList<>();
        if(CollectionUtils.isNotEmpty(receiverEntities)){
            for(RuleReceiverEntity receiverEntity : receiverEntities){
                WarningReceiveVO receiveVO = new WarningReceiveVO();
                receiveVO.setNameId(receiverEntity.getNameId());
                receiveVO.setName(receiverEntity.getName());
                receiveVO.setType(receiverEntity.getType());
                receiveVO.setWarningId(detailEntity.getId());
                receiveList.add(receiveVO);
            }
        }
        EarlyWarnTransVO vo = null;
        BigDecimal costNum = detailCacheEntity.getAmount();
        BigDecimal costTaxMny = detailCacheEntity.getTaxMny();
        if(FeeTypeEnum.明细金额控.getCode().equals(detailEntity.getFeeType())){
            BigDecimal comPlanTaxScale = ComputeUtil.safeMultiply(ComputeUtil.safeDiv(detailCacheEntity.getPlanTaxMoney(), costTaxMny), BigDecimal.valueOf(100));
            BigDecimal comContTaxScale = ComputeUtil.safeMultiply(ComputeUtil.safeDiv(detailCacheEntity.getContTaxMoney(), costTaxMny), BigDecimal.valueOf(100));
            BigDecimal comStoreTaxScale = ComputeUtil.safeMultiply(ComputeUtil.safeDiv(detailCacheEntity.getStoreTaxMoney(), costTaxMny), BigDecimal.valueOf(100));
            BigDecimal comOtherTaxScale = ComputeUtil.safeMultiply(ComputeUtil.safeDiv(detailCacheEntity.getOtherTaxMoney(), costTaxMny), BigDecimal.valueOf(100));
            BigDecimal comSettleTaxScale = ComputeUtil.safeMultiply(ComputeUtil.safeDiv(detailCacheEntity.getSettleTaxMoney(), costTaxMny), BigDecimal.valueOf(100));
            if(ComputeUtil.isLessThan(controlScale, comPlanTaxScale) || ComputeUtil.isLessThan(controlScale, comContTaxScale)
                    || ComputeUtil.isLessThan(controlScale, comStoreTaxScale)  || ComputeUtil.isLessThan(controlScale, comOtherTaxScale)
                    || ComputeUtil.isLessThan(controlScale, comSettleTaxScale)){

                vo = new EarlyWarnTransVO();
            }
            if(null != vo){
                vo.setBillName(dutyEntity.getBillCode());
                vo.setPcTitle("目标成本执行情况");
                vo.setPcUrl(PC_URL + "projectId=" + dutyEntity.getProjectId() + "&&" + "projectName=" + dutyEntity.getProjectName());
                RuleEntity ruleEntity = ruleMap.get(detailEntity.getRuleId());
                vo.setOrgId(ruleEntity.getOrgId());
                vo.setOrgName(ruleEntity.getOrgName());
                vo.setSourceId(String.valueOf(dutyEntity.getId()));
                vo.setTenantId(dutyEntity.getTenantId());
                vo.setWarnLevel("中");
                vo.setWarnSetId(Long.valueOf(WARN_ID));
                vo.setWarnSetParamId(Long.valueOf(WARN_ID));
                vo.setWarnType("1");
                vo.setSendOrgId(String.valueOf(ruleEntity.getOrgId()));
                vo.setDef1(String.valueOf(detailEntity.getId()) + detailCacheEntity.getId());
                vo.setEarlywarnName(detailCacheEntity.getName() + "明细金额控预警");
                vo.setReceiveList(receiveList);
                StringBuffer warnStr = new StringBuffer();
                if(ComputeUtil.isLessThan(controlScale, comPlanTaxScale)){
                    warnStr.append(detailCacheEntity.getName());
                    if(StringUtils.isNotBlank(detailCacheEntity.getModel())){
                        warnStr.append(detailCacheEntity.getModel());
                    }
                    warnStr.append("计划总金额(").append(ComputeUtil.scale(detailCacheEntity.getPlanMoney(), 2)).append("元)已占用目标成本中该档案金额");
                    warnStr.append("(").append(ComputeUtil.scale(costTaxMny, 2)).append("元)").append(ComputeUtil.scale(comPlanTaxScale, 2)).append("%! \n");
                }
                if(ComputeUtil.isLessThan(controlScale, comContTaxScale)){
                    warnStr.append(detailCacheEntity.getName());
                    if(StringUtils.isNotBlank(detailCacheEntity.getModel())){
                        warnStr.append(detailCacheEntity.getModel());
                    }
                    warnStr.append("合同总金额(").append(ComputeUtil.scale(detailCacheEntity.getContTaxMoney(), 2)).append("元)已占用目标成本中该档案金额");
                    warnStr.append("(").append(ComputeUtil.scale(costTaxMny, 2)).append("元)").append(ComputeUtil.scale(comContTaxScale, 2)).append("%! \n");
                }
                if(ComputeUtil.isLessThan(controlScale, comStoreTaxScale)){
                    warnStr.append(detailCacheEntity.getName());
                    if(StringUtils.isNotBlank(detailCacheEntity.getModel())){
                        warnStr.append(detailCacheEntity.getModel());
                    }
                    warnStr.append("入库总金额(").append(ComputeUtil.scale(detailCacheEntity.getStoreTaxMoney(), 2)).append("元)已占用目标成本中该档案金额");
                    warnStr.append("(").append(ComputeUtil.scale(costTaxMny, 2)).append("元)").append(ComputeUtil.scale(comStoreTaxScale, 2)).append("%! \n");
                }
                if(ComputeUtil.isLessThan(controlScale, comOtherTaxScale)){
                    warnStr.append(detailCacheEntity.getName());
                    if(StringUtils.isNotBlank(detailCacheEntity.getModel())){
                        warnStr.append(detailCacheEntity.getModel());
                    }
                    warnStr.append("其他总金额(").append(ComputeUtil.scale(detailCacheEntity.getOtherTaxMoney(), 2)).append("元)已占用目标成本中该档案金额");
                    warnStr.append("(").append(ComputeUtil.scale(costTaxMny, 2)).append("元)").append(ComputeUtil.scale(comOtherTaxScale, 2)).append("%! \n");
                }
                if(ComputeUtil.isLessThan(controlScale, comSettleTaxScale)){
                    warnStr.append(detailCacheEntity.getName());
                    if(StringUtils.isNotBlank(detailCacheEntity.getModel())){
                        warnStr.append(detailCacheEntity.getModel());
                    }
                    warnStr.append("结算总金额(").append(ComputeUtil.scale(detailCacheEntity.getSettleTaxMoney(), 2)).append("元)已占用目标成本中该档案金额");
                    warnStr.append("(").append(ComputeUtil.scale(costTaxMny, 2)).append("元)").append(ComputeUtil.scale(comSettleTaxScale, 2)).append("%! \n");
                }
                vo.setEarlywarnContent(warnStr.toString());
            }
        }else if(FeeTypeEnum.明细量控.getCode().equals(detailEntity.getFeeType())){
            BigDecimal comPlanScale = ComputeUtil.safeMultiply(ComputeUtil.safeDiv(detailCacheEntity.getPlanNum(), costNum), BigDecimal.valueOf(100));
            BigDecimal comContScale = ComputeUtil.safeMultiply(ComputeUtil.safeDiv(detailCacheEntity.getContNum(), costNum), BigDecimal.valueOf(100));
            BigDecimal comStoreScale = ComputeUtil.safeMultiply(ComputeUtil.safeDiv(detailCacheEntity.getStoreNum(), costNum), BigDecimal.valueOf(100));
            BigDecimal comOtherScale = ComputeUtil.safeMultiply(ComputeUtil.safeDiv(detailCacheEntity.getOtherNum(), costNum), BigDecimal.valueOf(100));
            BigDecimal comSettleTaxScale = ComputeUtil.safeMultiply(ComputeUtil.safeDiv(detailCacheEntity.getSettleNum(), costNum), BigDecimal.valueOf(100));
            if(ComputeUtil.isLessThan(controlScale, comPlanScale)
                    || ComputeUtil.isLessThan(controlScale, comContScale)
                    || ComputeUtil.isLessThan(controlScale, comStoreScale)
                    || ComputeUtil.isLessThan(controlScale, comOtherScale)
                    || ComputeUtil.isLessThan(controlScale, comSettleTaxScale)){

                vo = new EarlyWarnTransVO();
            }
            if(null != vo){
                vo.setBillName(dutyEntity.getBillCode());
                vo.setPcTitle("目标成本执行情况");
                vo.setPcUrl(PC_URL + "projectId=" + dutyEntity.getProjectId() + "&&" + "projectName=" + dutyEntity.getProjectName());
                RuleEntity ruleEntity = ruleMap.get(detailEntity.getRuleId());
                vo.setOrgId(ruleEntity.getOrgId());
                vo.setOrgName(ruleEntity.getOrgName());
                vo.setSourceId(String.valueOf(dutyEntity.getId()));
                vo.setTenantId(dutyEntity.getTenantId());
                vo.setWarnLevel("中");
                vo.setWarnSetId(Long.valueOf(WARN_ID));
                vo.setWarnSetParamId(Long.valueOf(WARN_ID));
                vo.setWarnType("1");
                vo.setSendOrgId(String.valueOf(ruleEntity.getOrgId()));
                vo.setDef1(String.valueOf(detailEntity.getId()) + detailCacheEntity.getId());
                vo.setEarlywarnName(detailCacheEntity.getName() + "明细量控预警");
                vo.setReceiveList(receiveList);
                StringBuffer warnStr = new StringBuffer();
                if(ComputeUtil.isLessThan(controlScale, comPlanScale)){
                    warnStr.append(detailCacheEntity.getName());
                    if(StringUtils.isNotBlank(detailCacheEntity.getModel())){
                        warnStr.append(detailCacheEntity.getModel());
                    }
                    warnStr.append("计划总数量(").append(ComputeUtil.scale(detailCacheEntity.getPlanNum(), 2)).append(")已占用目标成本中该档案数量");
                    warnStr.append("(").append(ComputeUtil.scale(costNum, 2)).append(")").append(ComputeUtil.scale(comPlanScale, 2)).append("%! \n");
                }
                if(ComputeUtil.isLessThan(controlScale, comContScale)){
                    warnStr.append(detailCacheEntity.getName());
                    if(StringUtils.isNotBlank(detailCacheEntity.getModel())){
                        warnStr.append(detailCacheEntity.getModel());
                    }
                    warnStr.append("合同总数量(").append(ComputeUtil.scale(detailCacheEntity.getContNum(), 2)).append(")已占用目标成本中该档案数量");
                    warnStr.append("(").append(ComputeUtil.scale(costNum, 2)).append(")").append(ComputeUtil.scale(comContScale, 2)).append("%! \n");
                }
                if(ComputeUtil.isLessThan(controlScale, comStoreScale)){
                    warnStr.append(detailCacheEntity.getName());
                    if(StringUtils.isNotBlank(detailCacheEntity.getModel())){
                        warnStr.append(detailCacheEntity.getModel());
                    }
                    warnStr.append("入库总数量(").append(ComputeUtil.scale(detailCacheEntity.getStoreNum(), 2)).append(")已占用目标成本中该档案数量");
                    warnStr.append("(").append(ComputeUtil.scale(costNum, 2)).append(")").append(ComputeUtil.scale(comStoreScale, 2)).append("%! \n");
                }
                if(ComputeUtil.isLessThan(controlScale, comOtherScale)){
                    warnStr.append(detailCacheEntity.getName());
                    if(StringUtils.isNotBlank(detailCacheEntity.getModel())){
                        warnStr.append(detailCacheEntity.getModel());
                    }
                    warnStr.append("其他总数量(").append(ComputeUtil.scale(detailCacheEntity.getOtherNum(), 2)).append(")已占用目标成本中该档案数量");
                    warnStr.append("(").append(ComputeUtil.scale(costNum, 2)).append(")").append(ComputeUtil.scale(comOtherScale, 2)).append("%! \n");
                }
                if(ComputeUtil.isLessThan(controlScale, comSettleTaxScale)){
                    warnStr.append(detailCacheEntity.getName());
                    if(StringUtils.isNotBlank(detailCacheEntity.getModel())){
                        warnStr.append(detailCacheEntity.getModel());
                    }
                    warnStr.append("结算总数量(").append(ComputeUtil.scale(detailCacheEntity.getSettleNum(), 2)).append(")已占用目标成本中该档案数量");
                    warnStr.append("(").append(ComputeUtil.scale(costNum, 2)).append(")").append(ComputeUtil.scale(comSettleTaxScale, 2)).append("%! \n");
                }
                vo.setEarlywarnContent(warnStr.toString());
            }
        }
        return vo;
    }

    private List<RuleDetailEntity> getRuleDetailList(Map<String, List<RuleDetailEntity>> ruleDetailMap, String innerCode) {
        List<RuleDetailEntity> list = new ArrayList<>();
        for (String key : ruleDetailMap.keySet()) {
            if (innerCode.contains(key)) {
                List<RuleDetailEntity> ruleDetailEntities = ruleDetailMap.get(key);
                if (key.equals(innerCode)) {
                    for(RuleDetailEntity detailEntity : ruleDetailEntities){
                            list.add(detailEntity);
                    }
                } else {
                    for(RuleDetailEntity detailEntity : ruleDetailEntities){
                        if((FeeTypeEnum.明细量控.getCode().equals(detailEntity.getFeeType()) || FeeTypeEnum.明细金额控.getCode().equals(detailEntity.getFeeType()))){
                            list.add(detailEntity);
                        }
                    }
                }
            }
        }
        return list;
    }
}
