package com.ejianc.business.targetcost.vo;

import com.ejianc.business.targetcost.utils.ITreeNodeB;
import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;

/**
 * 目标责任成本明细
 *
 * @author generator
 */
public class DutyDetailVO extends BaseVO implements ITreeNodeB {
    private static final long serialVersionUID = 1L;

    private Long dutyId; // 目标责任成本
    private Long orgId; // 所属组织，不显示默认当前组织
    private String orgName; // 项目组织名称
    private Long projectId; // 所属项目
    private String projectName; // 项目名称
    private BigDecimal mny; // 金额(无税)
    private BigDecimal taxRate; // 税率
    private BigDecimal taxMny; // 金额
    private Boolean involveFlag; // 是否涉及
    private Long feeDetailId; // 费用明细主键
    private String feeDetailCode; // 费用明细编码
    private String feeDetailName; // 费用明细名称
    private Long unitId; // 单位ID
    private String unitName; // 单位名称
    private Long categoryId; // 分类id
    private String categoryName; // 分类id
    private String categoryInnerCode; // 分类内码
    private Integer docType; // 分类（档案）类型：劳务分包方案、专业分包档案、物料档案、设备档案、成本科目
    private Boolean leafFlag; // 是否末级
    private Boolean selfFlag; // 行属性：引入档案、自制（是否自制）
    private Boolean selfScopeFlag; // 是否自身设置业务范围
    private BigDecimal preTypeAmount; // 预估分类总量
    private BigDecimal gatherMny;// 汇总金额(无税)
    private BigDecimal gatherTaxMny;// 汇总金额
    private BigDecimal beforeMny; // 变更前金额(无税)
    private BigDecimal beforeTaxMny; // 变更前金额
    private BigDecimal beforeTaxRate; // 变更前税率
    private BigDecimal beforeGatherMny; // 变更前汇总金额(无税)
    private BigDecimal beforeGatherTaxRate; // 变更前汇总金额
    private Integer changeFlag;
    private Boolean selfRelatedFlag; // 是否自身设置关联分类
    private BigDecimal sumMny; // 成本汇总金额(无税)
    private BigDecimal sumTaxMny; // 成本汇总金额
    private BigDecimal totalAmount; // 成本汇总数量
    private Long subjectId; // 成本科目主键
    private String subjectCode; // 成本科目编码
    private String subjectName; // 成本科目名称

    private List<FeeDetailVO> relatedDetailList = new ArrayList<>();

    private List<DutyDetailItemVO> dutyDetailItemList = new ArrayList<>(); // 目标责任成本明细项

    private Long parentId; // pid
    private String treeIndex;
    private String tid;
    private String tpid;
    private List<ITreeNodeB> children;

    public String getCategoryName() {
        return categoryName;
    }

    public void setCategoryName(String categoryName) {
        this.categoryName = categoryName;
    }

    public Boolean getLeafFlag() {
        return leafFlag;
    }

    public void setLeafFlag(Boolean leafFlag) {
        this.leafFlag = leafFlag;
    }

    public Boolean getSelfFlag() {
        return selfFlag;
    }

    public void setSelfFlag(Boolean selfFlag) {
        this.selfFlag = selfFlag;
    }

    public Boolean getSelfScopeFlag() {
        return selfScopeFlag;
    }

    public void setSelfScopeFlag(Boolean selfScopeFlag) {
        this.selfScopeFlag = selfScopeFlag;
    }

    public Long getUnitId() {
        return unitId;
    }

    public void setUnitId(Long unitId) {
        this.unitId = unitId;
    }

    public String getUnitName() {
        return unitName;
    }

    public void setUnitName(String unitName) {
        this.unitName = unitName;
    }

    public Long getProjectId() {
        return projectId;
    }

    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }

    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }

    public Long getCategoryId() {
        return categoryId;
    }

    public void setCategoryId(Long categoryId) {
        this.categoryId = categoryId;
    }

    public String getCategoryInnerCode() {
        return categoryInnerCode;
    }

    public void setCategoryInnerCode(String categoryInnerCode) {
        this.categoryInnerCode = categoryInnerCode;
    }

    public Integer getDocType() {
        return docType;
    }

    public void setDocType(Integer docType) {
        this.docType = docType;
    }

    public String getTreeIndex() {
        return treeIndex;
    }

    public void setTreeIndex(String treeIndex) {
        this.treeIndex = treeIndex;
    }

    public String getTid() {
        return tid;
    }

    public void setTid(String tid) {
        this.tid = tid;
    }

    public String getTpid() {
        return tpid;
    }

    public void setTpid(String tpid) {
        this.tpid = tpid;
    }

    public Long getParentId() {
        return parentId;
    }

    public void setParentId(Long parentId) {
        this.parentId = parentId;
    }

    public Long getDutyId() {
        return dutyId;
    }

    public void setDutyId(Long dutyId) {
        this.dutyId = dutyId;
    }

    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }

    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }

    public BigDecimal getMny() {
        return mny;
    }

    public void setMny(BigDecimal mny) {
        this.mny = mny;
    }

    public BigDecimal getTaxRate() {
        return taxRate;
    }

    public void setTaxRate(BigDecimal taxRate) {
        this.taxRate = taxRate;
    }

    public BigDecimal getTaxMny() {
        return taxMny;
    }

    public void setTaxMny(BigDecimal taxMny) {
        this.taxMny = taxMny;
    }

    public Boolean getInvolveFlag() {
        return involveFlag;
    }

    public void setInvolveFlag(Boolean involveFlag) {
        this.involveFlag = involveFlag;
    }

    public Long getFeeDetailId() {
        return feeDetailId;
    }

    public void setFeeDetailId(Long feeDetailId) {
        this.feeDetailId = feeDetailId;
    }

    public String getFeeDetailCode() {
        return feeDetailCode;
    }

    public void setFeeDetailCode(String feeDetailCode) {
        this.feeDetailCode = feeDetailCode;
    }

    public String getFeeDetailName() {
        return feeDetailName;
    }

    public void setFeeDetailName(String feeDetailName) {
        this.feeDetailName = feeDetailName;
    }

    public BigDecimal getPreTypeAmount() {
        return preTypeAmount;
    }

    public void setPreTypeAmount(BigDecimal preTypeAmount) {
        this.preTypeAmount = preTypeAmount;
    }

    public BigDecimal getGatherMny() {
        return gatherMny;
    }

    public void setGatherMny(BigDecimal gatherMny) {
        this.gatherMny = gatherMny;
    }

    public BigDecimal getGatherTaxMny() {
        return gatherTaxMny;
    }

    public void setGatherTaxMny(BigDecimal gatherTaxMny) {
        this.gatherTaxMny = gatherTaxMny;
    }

    public Boolean getSelfRelatedFlag() {
        return selfRelatedFlag;
    }

    public void setSelfRelatedFlag(Boolean selfRelatedFlag) {
        this.selfRelatedFlag = selfRelatedFlag;
    }

    public BigDecimal getBeforeMny() {
        return beforeMny;
    }

    public void setBeforeMny(BigDecimal beforeMny) {
        this.beforeMny = beforeMny;
    }

    public BigDecimal getBeforeTaxMny() {
        return beforeTaxMny;
    }

    public void setBeforeTaxMny(BigDecimal beforeTaxMny) {
        this.beforeTaxMny = beforeTaxMny;
    }

    public BigDecimal getBeforeTaxRate() {
        return beforeTaxRate;
    }

    public void setBeforeTaxRate(BigDecimal beforeTaxRate) {
        this.beforeTaxRate = beforeTaxRate;
    }

    public BigDecimal getBeforeGatherMny() {
        return beforeGatherMny;
    }

    public void setBeforeGatherMny(BigDecimal beforeGatherMny) {
        this.beforeGatherMny = beforeGatherMny;
    }

    public BigDecimal getBeforeGatherTaxRate() {
        return beforeGatherTaxRate;
    }

    public void setBeforeGatherTaxRate(BigDecimal beforeGatherTaxRate) {
        this.beforeGatherTaxRate = beforeGatherTaxRate;
    }

    public List<DutyDetailItemVO> getDutyDetailItemList() {
        return dutyDetailItemList;
    }

    public void setDutyDetailItemList(List<DutyDetailItemVO> dutyDetailItemList) {
        this.dutyDetailItemList = dutyDetailItemList;
    }

    public Integer getChangeFlag() {
        return changeFlag;
    }

    public void setChangeFlag(Integer changeFlag) {
        this.changeFlag = changeFlag;
    }

    public List<FeeDetailVO> getRelatedDetailList() {
        return relatedDetailList;
    }

    public void setRelatedDetailList(List<FeeDetailVO> relatedDetailList) {
        this.relatedDetailList = relatedDetailList;
    }

    public BigDecimal getSumMny() {
        return sumMny;
    }

    public void setSumMny(BigDecimal sumMny) {
        this.sumMny = sumMny;
    }

    public BigDecimal getSumTaxMny() {
        return sumTaxMny;
    }

    public void setSumTaxMny(BigDecimal sumTaxMny) {
        this.sumTaxMny = sumTaxMny;
    }

    public BigDecimal getTotalAmount() {
        return totalAmount;
    }

    public void setTotalAmount(BigDecimal totalAmount) {
        this.totalAmount = totalAmount;
    }
    @ReferSerialTransfer(referCode = "subject-project-org-ref")
    public Long getSubjectId() {
        return subjectId;
    }
    @ReferDeserialTransfer
    public void setSubjectId(Long subjectId) {
        this.subjectId = subjectId;
    }

    public String getSubjectCode() {
        return subjectCode;
    }

    public void setSubjectCode(String subjectCode) {
        this.subjectCode = subjectCode;
    }

    public String getSubjectName() {
        return subjectName;
    }

    public void setSubjectName(String subjectName) {
        this.subjectName = subjectName;
    }

    @Override
    public Long getNodeID() {
        return getId();
    }

    @Override
    public Long getParentID() {
        return parentId;
    }

    @Override
    public List<ITreeNodeB> getChildren() {
        if (children == null) {
            children = new ArrayList<>();
        }
        return children;
    }

    public void setChildren(Object children) {
        this.children = null;
    }
}
