/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.targetcost.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.ejianc.business.contractbase.pool.enums.ContractTypeEnum;
import com.ejianc.business.contractbase.pool.settlepool.api.ISettlePoolApi;
import com.ejianc.business.pro.income.api.IProincomeContractApi;
import com.ejianc.business.procost.api.ICostDetailApi;
import com.ejianc.business.procost.vo.CostDetailVO;
import com.ejianc.business.profinance.api.IReceiptAndPaymentRegisterApi;
import com.ejianc.business.targetcost.bean.FeeDetailScopeEntity;
import com.ejianc.business.targetcost.bean.TotalCacheEntity;
import com.ejianc.business.targetcost.enums.BussinessTypeEnum;
import com.ejianc.business.targetcost.mapper.TotalCacheMapper;
import com.ejianc.business.targetcost.service.IDutyDetailItemService;
import com.ejianc.business.targetcost.service.IFeeDetailScopeService;
import com.ejianc.business.targetcost.service.ITotalCacheService;
import com.ejianc.business.targetcost.utils.TreeNodeBUtil;
import com.ejianc.business.targetcost.vo.DutyDetailItemVO;
import com.ejianc.business.targetcost.vo.ExecutionLinkVO;
import com.ejianc.business.targetcost.vo.ExecutionReportVO;
import com.ejianc.business.targetcost.vo.ExecutionSubjectVO;
import com.ejianc.business.targetcost.vo.TotalCacheVO;
import com.ejianc.foundation.share.api.IShareSubjectOrgApi;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.core.util.ResultAsTree;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="totalCacheService")
public class TotalCacheServiceImpl
extends BaseServiceImpl<TotalCacheMapper, TotalCacheEntity>
implements ITotalCacheService {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private ISettlePoolApi settlePoolApi;
    @Autowired
    private IReceiptAndPaymentRegisterApi receiptAndPaymentRegisterApi;
    @Autowired
    private IProincomeContractApi proincomeContractApi;
    @Autowired
    private IFeeDetailScopeService feeDetailScopeService;
    @Autowired
    private IShareSubjectOrgApi shareSubjectOrgApi;
    @Autowired
    private ICostDetailApi costDetailApi;
    @Autowired
    private IDutyDetailItemService dutyDetailItemService;

    @Override
    public ExecutionReportVO queryReport(Long projectId) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put(BussinessTypeEnum.\u4e13\u4e1a\u5206\u5305\u5408\u540c.getCode(), ContractTypeEnum.\u4e13\u4e1a\u5206\u5305\u5408\u540c.getTypeCode());
        map.put(BussinessTypeEnum.\u52b3\u52a1\u5206\u5305\u5408\u540c.getCode(), ContractTypeEnum.\u52b3\u52a1\u5206\u5305\u5408\u540c.getTypeCode());
        map.put(BussinessTypeEnum.\u5176\u4ed6\u652f\u51fa\u5408\u540c.getCode(), ContractTypeEnum.\u5176\u4ed6\u652f\u51fa.getTypeCode());
        map.put("WZCGHT", ContractTypeEnum.\u7269\u8d44\u91c7\u8d2d\u5408\u540c.getTypeCode());
        map.put(BussinessTypeEnum.\u6df7\u51dd\u571f\u91c7\u8d2d\u5408\u540c.getCode(), ContractTypeEnum.\u6df7\u51dd\u571f\u5408\u540c.getTypeCode());
        map.put(BussinessTypeEnum.\u5468\u8f6c\u6750\u79df\u8d41\u5408\u540c.getCode(), ContractTypeEnum.\u5468\u8f6c\u6750\u5408\u540c.getTypeCode());
        map.put(BussinessTypeEnum.\u8bbe\u5907\u91c7\u8d2d\u5408\u540c.getCode(), ContractTypeEnum.\u8bbe\u5907\u91c7\u8d2d.getTypeCode());
        map.put(BussinessTypeEnum.\u8bbe\u5907\u79df\u8d41\u5408\u540c.getCode(), ContractTypeEnum.\u8bbe\u5907\u79df\u8d41.getTypeCode());
        map.put(BussinessTypeEnum.\u4e34\u65f6\u8bbe\u5907\u79df\u8d41\u5408\u540c.getCode(), ContractTypeEnum.\u4e34\u65f6\u8bbe\u5907.getTypeCode());
        map.put(BussinessTypeEnum.\u5927\u578b\u8bbe\u5907\u5b89\u62c6\u5408\u540c.getCode(), ContractTypeEnum.\u5b89\u62c6\u5408\u540c.getTypeCode());
        ExecutionReportVO reportVO = new ExecutionReportVO();
        reportVO.setId(11111L);
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(TotalCacheEntity::getProjectId, (Object)projectId);
        queryWrapper.orderByAsc(TotalCacheEntity::getCode);
        List list = this.list((Wrapper)queryWrapper);
        for (TotalCacheEntity totalCacheEntity : list) {
            totalCacheEntity.setId(totalCacheEntity.getDutyDetailId());
            totalCacheEntity.setTid(totalCacheEntity.getId().toString());
            totalCacheEntity.setTpid(totalCacheEntity.getParentId() != null && totalCacheEntity.getParentId() > 0L ? totalCacheEntity.getParentId().toString() : "");
            if (null != totalCacheEntity.getParentId()) continue;
            this.fullPayAndSettleMny(map, totalCacheEntity);
        }
        this.logger.info("\u67e5\u8be2\u5230\u7684\u7f13\u5b58\u6570\u636e" + JSONObject.toJSONString((Object)list));
        List resultMapList = BeanMapper.mapList((Iterable)list, TotalCacheVO.class);
        Collections.sort(resultMapList, new DetailCompareVO());
        reportVO.setDetailList(TreeNodeBUtil.buildTree(resultMapList));
        CommonResponse subjectResponse = this.shareSubjectOrgApi.shareSubjectOrgApi();
        if (subjectResponse.isSuccess()) {
            CommonResponse listCommonResponse = this.costDetailApi.queryMnyBySubjectId(null, projectId, new ArrayList());
            Map<Object, Object> costMap = new HashMap();
            if (listCommonResponse.isSuccess() && CollectionUtils.isNotEmpty((Collection)((Collection)listCommonResponse.getData()))) {
                costMap = ((List)listCommonResponse.getData()).stream().collect(Collectors.toMap(CostDetailVO::getSubjectId, Function.identity(), (key1, key2) -> key1));
            }
            List<DutyDetailItemVO> dutyCostList = this.dutyDetailItemService.queryCostMny(projectId, null);
            HashMap<Long, DutyDetailItemVO> dutyCostMap = new HashMap<Long, DutyDetailItemVO>();
            if (CollectionUtils.isNotEmpty(dutyCostList)) {
                for (DutyDetailItemVO dutyDetailItemVO : dutyCostList) {
                    String[] innerArr;
                    for (String innerCode : innerArr = dutyDetailItemVO.getSubjectInnerCode().split(",")) {
                        DutyDetailItemVO value;
                        Long key = Long.valueOf(innerCode);
                        if (dutyCostMap.containsKey(key)) {
                            value = (DutyDetailItemVO)((Object)dutyCostMap.get(key));
                        } else {
                            value = new DutyDetailItemVO();
                            value.setSubjectId(key);
                        }
                        value.setMny(ComputeUtil.safeAdd((BigDecimal)value.getMny(), (BigDecimal)dutyDetailItemVO.getMny()));
                        value.setTaxMny(ComputeUtil.safeAdd((BigDecimal)value.getTaxMny(), (BigDecimal)dutyDetailItemVO.getTaxMny()));
                        dutyCostMap.put(key, value);
                    }
                }
            }
            List subjectDetailVOS = BeanMapper.mapList((Iterable)((Iterable)subjectResponse.getData()), ExecutionSubjectVO.class);
            for (ExecutionSubjectVO subjectDetailVO : subjectDetailVOS) {
                subjectDetailVO.setSubjectId(subjectDetailVO.getId());
                subjectDetailVO.setTid(String.valueOf(subjectDetailVO.getId()));
                subjectDetailVO.setTpid(String.valueOf(subjectDetailVO.getParentId()));
                if (dutyCostMap.containsKey(subjectDetailVO.getSubjectId())) {
                    DutyDetailItemVO itemVO = (DutyDetailItemVO)((Object)dutyCostMap.get(subjectDetailVO.getSubjectId()));
                    subjectDetailVO.setMny(itemVO.getMny());
                    subjectDetailVO.setTaxMny(itemVO.getTaxMny());
                }
                if (!costMap.containsKey(subjectDetailVO.getSubjectId())) continue;
                CostDetailVO costDetailVO = (CostDetailVO)costMap.get(subjectDetailVO.getSubjectId());
                subjectDetailVO.setCostMny(costDetailVO.getHappenMny());
                subjectDetailVO.setCostTaxMny(costDetailVO.getHappenTaxMny());
            }
            List list2 = BeanMapper.mapList((Iterable)subjectDetailVOS, Map.class);
            List treeData = ResultAsTree.createTreeData((List)list2);
            this.gatherMny(null, treeData);
            reportVO.setSubjectList(BeanMapper.mapList((Iterable)treeData, ExecutionSubjectVO.class));
        }
        this.logger.info("\u67e5\u8be2\u5230\u7684\u7f13\u5b58\u6570\u636e" + JSONObject.toJSONString(reportVO.getDetailList()));
        return reportVO;
    }

    private void gatherMny(Map<String, Object> now, List<Map<String, Object>> list) {
        BigDecimal costMny = null;
        BigDecimal costTaxMny = null;
        for (Map<String, Object> ypd : list) {
            if (ypd.get("children") != null) {
                this.gatherMny(ypd, (List)ypd.get("children"));
            }
            costMny = ComputeUtil.safeAdd(costMny, (BigDecimal)this.getBigDecimalValue(ypd, "costMny"));
            costTaxMny = ComputeUtil.safeAdd(costTaxMny, (BigDecimal)this.getBigDecimalValue(ypd, "costTaxMny"));
        }
        if (now != null) {
            now.put("costMny", costMny);
            now.put("costTaxMny", costTaxMny);
        }
    }

    private BigDecimal getBigDecimalValue(Map<String, Object> ypd, String code) {
        return ypd.get(code) == null ? null : (BigDecimal)ypd.get(code);
    }

    private void fullPayAndSettleMny(Map<String, String> map, TotalCacheEntity cacheEntity) {
        LambdaQueryWrapper scopeQuery = new LambdaQueryWrapper();
        scopeQuery.eq(FeeDetailScopeEntity::getFeeDetailId, (Object)cacheEntity.getFeeDetailId());
        List list = this.feeDetailScopeService.list((Wrapper)scopeQuery);
        BigDecimal settleMny = null;
        BigDecimal payMny = null;
        Boolean isFirstWzcg = true;
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            HashSet<String> billTypeSet = new HashSet<String>();
            Map settleMnyMap = new HashMap();
            for (FeeDetailScopeEntity scopeEntity : list) {
                String billType = map.get(scopeEntity.getBillCode().contains("WZCGHT") ? "WZCGHT" : scopeEntity.getBillCode());
                if (!StringUtils.isNotBlank((CharSequence)billType)) continue;
                billTypeSet.add(billType);
            }
            if (!billTypeSet.isEmpty()) {
                QueryParam queryParam = new QueryParam();
                queryParam.getParams().put("projectId", new Parameter("eq", (Object)cacheEntity.getProjectId()));
                queryParam.getParams().put("contractType", new Parameter("in", billTypeSet));
                this.logger.info("settlePoolApi.queryContractsTotalSettleMny queryParam is" + JSONObject.toJSONString((Object)queryParam));
                CommonResponse response = this.settlePoolApi.queryContractsTotalSettleMny(queryParam);
                this.logger.info("settlePoolApi.queryContractsTotalSettleMny result is" + JSONObject.toJSONString((Object)response));
                if (response.isSuccess() && null != response.getData()) {
                    settleMnyMap = (Map)response.getData();
                }
            }
            for (FeeDetailScopeEntity scopeEntity : list) {
                CommonResponse payResponse;
                String billCode = scopeEntity.getBillCode();
                if (scopeEntity.getBillCode().contains("WZCGHT")) {
                    if (!isFirstWzcg.booleanValue()) continue;
                    billCode = "WZCGHT";
                    isFirstWzcg = false;
                }
                this.logger.info("settleMnyMap" + JSONObject.toJSONString(settleMnyMap));
                String billType = map.get(billCode);
                if (!StringUtils.isNotBlank((CharSequence)billType)) continue;
                if (null != settleMnyMap && settleMnyMap.containsKey(billType)) {
                    settleMny = ComputeUtil.safeAdd(settleMny, (BigDecimal)((BigDecimal)settleMnyMap.get(billType)));
                }
                if (!(payResponse = this.receiptAndPaymentRegisterApi.queryPayMnyByProjAndContType(cacheEntity.getProjectId(), billType)).isSuccess()) continue;
                payMny = ComputeUtil.safeAdd(payMny, (BigDecimal)((JSONObject)payResponse.getData()).getBigDecimal("payMny"));
            }
        }
        cacheEntity.setSettleMny(settleMny);
        cacheEntity.setPayMny(payMny);
    }

    @Override
    public List<ExecutionLinkVO> linkFeeScale(Long projectId) {
        ArrayList<ExecutionLinkVO> linkVOS = new ArrayList<ExecutionLinkVO>();
        CommonResponse commonResponse = this.proincomeContractApi.queryContranct(projectId);
        BigDecimal incomeMny = commonResponse.isSuccess() ? (BigDecimal)commonResponse.getData() : null;
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(TotalCacheEntity::getProjectId, (Object)projectId);
        queryWrapper.orderByAsc(TotalCacheEntity::getTreeIndex);
        List list = this.list((Wrapper)queryWrapper);
        BigDecimal totalMny = BigDecimal.ZERO;
        for (TotalCacheEntity totalCacheEntity : list) {
            if (null != totalCacheEntity.getParentId()) continue;
            ExecutionLinkVO linkVO = (ExecutionLinkVO)((Object)BeanMapper.map((Object)((Object)totalCacheEntity), ExecutionLinkVO.class));
            totalMny = ComputeUtil.safeAdd((BigDecimal)totalMny, (BigDecimal)linkVO.getTaxMny());
            linkVO.setIncomeMny(incomeMny);
            linkVO.setContMnyScale(ComputeUtil.safeMultiply((BigDecimal)BigDecimal.valueOf(100L), (BigDecimal)ComputeUtil.safeDiv((BigDecimal)linkVO.getContTaxMoney(), (BigDecimal)incomeMny)));
            linkVOS.add(linkVO);
        }
        if (CollectionUtils.isNotEmpty(linkVOS)) {
            for (ExecutionLinkVO linkVO : linkVOS) {
                linkVO.setMnyScale(ComputeUtil.safeMultiply((BigDecimal)BigDecimal.valueOf(100L), (BigDecimal)ComputeUtil.safeDiv((BigDecimal)linkVO.getTaxMny(), (BigDecimal)incomeMny)));
            }
        }
        if (linkVOS.size() >= 7) {
            int i;
            BigDecimal sumDirectMny = new BigDecimal(0);
            BigDecimal sumDirecttaxMny = new BigDecimal(0);
            BigDecimal sumDirectMnyScale = new BigDecimal(0);
            BigDecimal sumDirectContMnyScale = new BigDecimal(0);
            BigDecimal sumContMoney = new BigDecimal(0);
            BigDecimal sumContTaxMoney = new BigDecimal(0);
            for (ExecutionLinkVO linkVO : linkVOS) {
                if (!linkVO.getName().equals("\u4eba\u5de5\u8d39") && !linkVO.getName().equals("\u6750\u6599\u8d39") && !linkVO.getName().equals("\u673a\u68b0\u8bbe\u5907\u8d39") && linkVO.getName().indexOf("\u5176\u4ed6\u652f\u51fa\u5408\u540c\u8d39\u7528") == -1 && !linkVO.getName().equals("\u4e13\u4e1a\u5206\u5305\u8d39") && !linkVO.getName().equals("\u4e13\u4e1a\u5206\u5305") || linkVO.getMny() == null) continue;
                sumContMoney = ComputeUtil.safeAdd((BigDecimal)sumContMoney, (BigDecimal)linkVO.getContMoney());
                sumContTaxMoney = ComputeUtil.safeAdd((BigDecimal)sumContTaxMoney, (BigDecimal)linkVO.getContTaxMoney());
                sumDirectMny = sumDirectMny.add(linkVO.getMny());
                if (linkVO.getTaxMny() == null) continue;
                sumDirecttaxMny = sumDirecttaxMny.add(linkVO.getTaxMny());
            }
            sumDirectMnyScale = ComputeUtil.safeMultiply((BigDecimal)BigDecimal.valueOf(100L), (BigDecimal)ComputeUtil.safeDiv((BigDecimal)sumDirecttaxMny, (BigDecimal)incomeMny));
            sumDirectContMnyScale = ComputeUtil.safeMultiply((BigDecimal)BigDecimal.valueOf(100L), (BigDecimal)ComputeUtil.safeDiv((BigDecimal)sumContTaxMoney, (BigDecimal)incomeMny));
            ExecutionLinkVO executionLinkVO = new ExecutionLinkVO();
            executionLinkVO.setId(Long.parseLong("99999"));
            executionLinkVO.setName("\u5c0f\u8ba1(\u76f4\u63a5\u8d39)");
            executionLinkVO.setMny(sumDirectMny);
            executionLinkVO.setTaxMny(sumDirecttaxMny);
            executionLinkVO.setMnyScale(sumDirectMnyScale);
            executionLinkVO.setContMnyScale(sumDirectContMnyScale);
            executionLinkVO.setContMoney(sumContMoney);
            executionLinkVO.setContTaxMoney(sumContTaxMoney);
            BigDecimal sumIndirectMny = new BigDecimal(0);
            BigDecimal sumIndirecttaxMny = new BigDecimal(0);
            BigDecimal sumIndirectMnyScale = new BigDecimal(0);
            BigDecimal sumIndirectContMnyScale = new BigDecimal(0);
            BigDecimal sumIndirectContMoney = new BigDecimal(0);
            BigDecimal sumIndirectContTaxMoney = new BigDecimal(0);
            for (ExecutionLinkVO linkVO : linkVOS) {
                if (!linkVO.getName().equals("\u7a0e\u91d1") && !linkVO.getName().equals("\u95f4\u63a5\u8d39") || linkVO.getMny() == null) continue;
                sumIndirectContMoney = ComputeUtil.safeAdd((BigDecimal)sumIndirectContMoney, (BigDecimal)linkVO.getContMoney());
                sumIndirectContTaxMoney = ComputeUtil.safeAdd((BigDecimal)sumIndirectContTaxMoney, (BigDecimal)linkVO.getContTaxMoney());
                sumIndirectMny = sumIndirectMny.add(linkVO.getMny());
                if (linkVO.getTaxMny() == null) continue;
                sumIndirecttaxMny = sumIndirecttaxMny.add(linkVO.getTaxMny());
            }
            sumIndirectMnyScale = ComputeUtil.safeMultiply((BigDecimal)BigDecimal.valueOf(100L), (BigDecimal)ComputeUtil.safeDiv((BigDecimal)sumIndirecttaxMny, (BigDecimal)incomeMny));
            sumIndirectContMnyScale = ComputeUtil.safeMultiply((BigDecimal)BigDecimal.valueOf(100L), (BigDecimal)ComputeUtil.safeDiv((BigDecimal)sumIndirectContTaxMoney, (BigDecimal)incomeMny));
            ExecutionLinkVO executionLinkVO2 = new ExecutionLinkVO();
            executionLinkVO2.setId(Long.parseLong("88888"));
            executionLinkVO2.setName("\u5c0f\u8ba1(\u95f4\u63a5\u8d39)");
            executionLinkVO2.setMny(sumIndirectMny);
            executionLinkVO2.setTaxMny(sumIndirecttaxMny);
            executionLinkVO2.setMnyScale(sumIndirectMnyScale);
            executionLinkVO2.setContMnyScale(sumIndirectContMnyScale);
            executionLinkVO2.setContMoney(sumIndirectContMoney);
            executionLinkVO2.setContTaxMoney(sumIndirectContTaxMoney);
            BigDecimal sumTotalMny = new BigDecimal(0);
            BigDecimal sumTotaltaxMny = new BigDecimal(0);
            BigDecimal sumTotalMnyScale = new BigDecimal(0);
            BigDecimal sumTotalContMnyScale = new BigDecimal(0);
            BigDecimal sumTotalContMoney = new BigDecimal(0);
            BigDecimal sumTotalContTaxMoney = new BigDecimal(0);
            for (ExecutionLinkVO linkVO : linkVOS) {
                if (linkVO.getMny() != null) {
                    sumTotalMny = sumTotalMny.add(linkVO.getMny());
                }
                if (linkVO.getTaxMny() != null) {
                    sumTotaltaxMny = sumTotaltaxMny.add(linkVO.getTaxMny());
                }
                if (linkVO.getMnyScale() != null) {
                    sumTotalMnyScale = sumTotalMnyScale.add(linkVO.getMnyScale());
                }
                sumTotalContMoney = ComputeUtil.safeAdd((BigDecimal)sumTotalContMoney, (BigDecimal)linkVO.getContMoney());
                sumTotalContTaxMoney = ComputeUtil.safeAdd((BigDecimal)sumTotalContTaxMoney, (BigDecimal)linkVO.getContTaxMoney());
            }
            sumTotalContMnyScale = ComputeUtil.safeMultiply((BigDecimal)BigDecimal.valueOf(100L), (BigDecimal)ComputeUtil.safeDiv((BigDecimal)sumTotaltaxMny, (BigDecimal)incomeMny));
            sumIndirectMnyScale = ComputeUtil.safeMultiply((BigDecimal)BigDecimal.valueOf(100L), (BigDecimal)ComputeUtil.safeDiv((BigDecimal)sumTotaltaxMny, (BigDecimal)incomeMny));
            sumIndirectContMnyScale = ComputeUtil.safeMultiply((BigDecimal)BigDecimal.valueOf(100L), (BigDecimal)ComputeUtil.safeDiv((BigDecimal)sumTotalContTaxMoney, (BigDecimal)incomeMny));
            ExecutionLinkVO executionLinkVO3 = new ExecutionLinkVO();
            executionLinkVO3.setId(Long.parseLong("66666"));
            executionLinkVO3.setName("\u5408\u8ba1");
            executionLinkVO3.setMny(sumTotalMny);
            executionLinkVO3.setTaxMny(sumTotaltaxMny);
            executionLinkVO3.setMnyScale(sumIndirectMnyScale);
            executionLinkVO3.setContMnyScale(sumIndirectContMnyScale);
            executionLinkVO3.setContMoney(sumTotalContMoney);
            executionLinkVO3.setContTaxMoney(sumTotalContTaxMoney);
            ArrayList<ExecutionLinkVO> linkVOList = new ArrayList<ExecutionLinkVO>();
            for (i = 0; i <= 4; ++i) {
                linkVOList.add((ExecutionLinkVO)((Object)linkVOS.get(i)));
            }
            linkVOList.add(executionLinkVO);
            for (i = 5; i <= 6; ++i) {
                linkVOList.add((ExecutionLinkVO)((Object)linkVOS.get(i)));
            }
            linkVOList.add(executionLinkVO2);
            linkVOList.add(executionLinkVO3);
            return linkVOList;
        }
        return linkVOS;
    }

    @Override
    public void deleteByProjectIdPhy(Long projectId) {
        ((TotalCacheMapper)this.baseMapper).deleteByProjectIdPhy(projectId);
    }

    class DetailCompareVO
    implements Comparator<TotalCacheVO> {
        DetailCompareVO() {
        }

        @Override
        public int compare(TotalCacheVO o1, TotalCacheVO o2) {
            String[] parts1 = o1.getTreeIndex().split("\\.");
            String[] parts2 = o2.getTreeIndex().split("\\.");
            int minLength = Math.min(parts1.length, parts2.length);
            for (int i = 0; i < minLength; ++i) {
                int part2;
                int part1 = Integer.parseInt(parts1[i]);
                if (part1 < (part2 = Integer.parseInt(parts2[i]))) {
                    return -1;
                }
                if (part1 <= part2) continue;
                return 1;
            }
            return Integer.compare(parts1.length, parts2.length);
        }
    }
}

