/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.targetcost.utils;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.ejianc.business.center.api.IWarnCenterApi;
import com.ejianc.business.center.vo.EarlyWarnTransVO;
import com.ejianc.business.procost.api.ICostDetailApi;
import com.ejianc.business.procost.vo.CostDetailVO;
import com.ejianc.business.targetcost.bean.DutyEntity;
import com.ejianc.business.targetcost.bean.RuleDetailEntity;
import com.ejianc.business.targetcost.bean.RuleEntity;
import com.ejianc.business.targetcost.bean.RuleReceiverEntity;
import com.ejianc.business.targetcost.enums.ControlTypeEnum;
import com.ejianc.business.targetcost.service.IDutyDetailItemService;
import com.ejianc.business.targetcost.service.IRuleDetailService;
import com.ejianc.business.targetcost.service.IRuleReceiverService;
import com.ejianc.business.targetcost.service.IRuleService;
import com.ejianc.business.targetcost.vo.DutyDetailItemVO;
import com.ejianc.business.warn.vo.WarningReceiveVO;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.share.api.IShareSubjectOrgApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.redisson.api.RLock;
import org.redisson.api.RedissonClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.RequestContextHolder;

public class SubjectWarnCallable
implements Callable<CommonResponse<String>> {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final String TC_LOCK = "TC_LOCK::";
    private static final String PC_URL = "/ejc-targetcost-frontend/#/execution?";
    private static final String WARN_ID = "584793299912114241";
    private static final String WARN_PARAM_ID = "584793299912114241";
    private String authority;
    private RequestAttributes context;
    private IWarnCenterApi warnCenterApi;
    private RedissonClient redissonClient;
    private IDutyDetailItemService dutyDetailItemService;
    private List<DutyEntity> dutyEntities;
    private IRuleService ruleService;
    private IRuleDetailService ruleDetailService;
    private IRuleReceiverService ruleReceiverService;
    private ICostDetailApi costDetailApi;
    private IShareSubjectOrgApi shareSubjectOrgApi;

    public SubjectWarnCallable(String authority, RequestAttributes context, IWarnCenterApi warnCenterApi, RedissonClient redissonClient, IDutyDetailItemService dutyDetailItemService, List<DutyEntity> dutyEntities, IRuleService ruleService, IRuleDetailService ruleDetailService, IRuleReceiverService ruleReceiverService, ICostDetailApi costDetailApi, IShareSubjectOrgApi shareSubjectOrgApi) {
        this.authority = authority;
        this.context = context;
        this.warnCenterApi = warnCenterApi;
        this.redissonClient = redissonClient;
        this.dutyDetailItemService = dutyDetailItemService;
        this.dutyEntities = dutyEntities;
        this.ruleService = ruleService;
        this.ruleDetailService = ruleDetailService;
        this.ruleReceiverService = ruleReceiverService;
        this.costDetailApi = costDetailApi;
        this.shareSubjectOrgApi = shareSubjectOrgApi;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CommonResponse<String> call() throws Exception {
        this.context.setAttribute("authority", (Object)this.authority, 0);
        RequestContextHolder.setRequestAttributes((RequestAttributes)this.context);
        InvocationInfoProxy.setExtendAttribute((Object)"authority", (Object)this.authority);
        ArrayList warnList = new ArrayList();
        for (DutyEntity dutyEntity : this.dutyEntities) {
            CommonResponse warnResp;
            block23: {
                String lockKey = TC_LOCK + dutyEntity.getProjectId();
                RLock mylock = this.redissonClient.getLock(lockKey);
                try {
                    boolean lock = mylock.tryLock(20L, TimeUnit.SECONDS);
                    if (!lock) {
                        this.logger.error("\u83b7\u53d6\u9501\u5931\u8d25 is " + dutyEntity.getProjectId());
                        CommonResponse commonResponse = CommonResponse.error((String)("\u83b7\u53d6\u9501\u5931\u8d25\uff1a" + dutyEntity.getProjectId()));
                        return commonResponse;
                    }
                    List<OrgVO> orgVOList = dutyEntity.getOrgList();
                    HashSet<Long> ruleIdSet = new HashSet<Long>();
                    List ruleEntities = null;
                    HashMap<Long, RuleEntity> ruleMap = new HashMap<Long, RuleEntity>();
                    if (CollectionUtils.isNotEmpty(orgVOList)) {
                        List orgList = orgVOList.stream().map(BaseVO::getId).collect(Collectors.toList());
                        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
                        queryWrapper.eq(RuleEntity::getFeeId, (Object)dutyEntity.getFeeId());
                        ArrayList<Integer> billStatusList = new ArrayList<Integer>();
                        billStatusList.add(BillStateEnum.PASSED_STATE.getBillStateCode());
                        billStatusList.add(BillStateEnum.COMMITED_STATE.getBillStateCode());
                        queryWrapper.in(RuleEntity::getBillState, billStatusList);
                        queryWrapper.in(RuleEntity::getOrgId, orgList);
                        ruleEntities = this.ruleService.list((Wrapper)queryWrapper);
                        if (CollectionUtils.isNotEmpty((Collection)ruleEntities)) {
                            for (RuleEntity ruleEntity : ruleEntities) {
                                ruleIdSet.add(ruleEntity.getId());
                                ruleMap.put(ruleEntity.getId(), ruleEntity);
                            }
                        }
                    }
                    if (CollectionUtils.isEmpty(ruleIdSet)) {
                        this.logger.error("\u8be5\u8d23\u4efb\u6210\u672c\u6ca1\u6709\u8bbe\u7f6e\u63a7\u5236\u89c4\u5219\uff1a" + JSONObject.toJSONString((Object)dutyEntity.getProjectId()));
                        continue;
                    }
                    LambdaQueryWrapper ruleDetailQuery = new LambdaQueryWrapper();
                    ruleDetailQuery.eq(RuleDetailEntity::getSubjectFlag, (Object)true);
                    ruleDetailQuery.in(RuleDetailEntity::getControlType, new Object[]{ControlTypeEnum.\u98ce\u9669\u9884\u8b66.getCode()});
                    ruleDetailQuery.in(RuleDetailEntity::getRuleId, ruleIdSet);
                    List ruleDetailEntities = this.ruleDetailService.list((Wrapper)ruleDetailQuery);
                    if (CollectionUtils.isEmpty((Collection)ruleDetailEntities)) {
                        this.logger.error("\u8be5\u8d23\u4efb\u6210\u672c\u6ca1\u6709\u8bbe\u7f6e\u6210\u672c\u79d1\u76ee\u63a7\u5236\u89c4\u5219" + JSONObject.toJSONString((Object)dutyEntity.getProjectId()));
                        continue;
                    }
                    HashMap ruleDetailMap = new HashMap();
                    ArrayList<Long> ruleDetailList = new ArrayList<Long>();
                    HashSet<Long> costQuerySet = new HashSet<Long>();
                    for (RuleDetailEntity entity : ruleDetailEntities) {
                        Long key = entity.getSubjectId();
                        List<RuleDetailEntity> list = ruleDetailMap.containsKey(key) ? (List)ruleDetailMap.get(key) : new ArrayList();
                        list.add(entity);
                        ruleDetailMap.put(key, list);
                        ruleDetailList.add(entity.getId());
                        costQuerySet.add(key);
                    }
                    CommonResponse listCommonResponse = this.costDetailApi.queryDetailByProjectId(null, dutyEntity.getProjectId(), new ArrayList(costQuerySet));
                    if (!listCommonResponse.isSuccess() || CollectionUtils.isEmpty((Collection)((Collection)listCommonResponse.getData()))) {
                        this.logger.error(JSONObject.toJSONString((Object)dutyEntity.getProjectId()));
                        continue;
                    }
                    List costDetailVOS = (List)listCommonResponse.getData();
                    LambdaQueryWrapper query = new LambdaQueryWrapper();
                    query.in(RuleReceiverEntity::getRuleDetailId, ruleDetailList);
                    List receiverEntities = this.ruleReceiverService.list((Wrapper)query);
                    HashMap<Long, List<RuleReceiverEntity>> receiverMap = new HashMap<Long, List<RuleReceiverEntity>>();
                    if (CollectionUtils.isNotEmpty((Collection)receiverEntities)) {
                        for (RuleReceiverEntity receiverEntity : receiverEntities) {
                            List<RuleReceiverEntity> list = null;
                            list = receiverMap.containsKey(receiverEntity.getRuleDetailId()) ? (List)receiverMap.get(receiverEntity.getRuleDetailId()) : new ArrayList<RuleReceiverEntity>();
                            list.add(receiverEntity);
                            receiverMap.put(receiverEntity.getRuleDetailId(), list);
                        }
                    }
                    HashMap<Long, DutyDetailItemVO> dutyCostMap = new HashMap<Long, DutyDetailItemVO>();
                    ArrayList<EarlyWarnTransVO> warnTransVOS = new ArrayList<EarlyWarnTransVO>();
                    for (CostDetailVO detailVO : costDetailVOS) {
                        DutyDetailItemVO dutyDetailItemVO;
                        Long subjectId = detailVO.getSubjectId();
                        if (!ruleDetailMap.containsKey(subjectId)) continue;
                        if (dutyCostMap.containsKey(subjectId)) {
                            dutyDetailItemVO = (DutyDetailItemVO)((Object)dutyCostMap.get(subjectId));
                        } else {
                            dutyDetailItemVO = this.dutyDetailItemService.queryCostMnyBySubjectId(dutyEntity.getProjectId(), subjectId);
                            dutyCostMap.put(subjectId, dutyDetailItemVO);
                        }
                        warnTransVOS.addAll(this.ctrlCost(dutyDetailItemVO, (List)ruleDetailMap.get(subjectId), dutyEntity, detailVO, receiverMap, ruleMap));
                    }
                    this.logger.error("warnTransVOS is " + JSONObject.toJSONString(warnTransVOS));
                    if (!CollectionUtils.isNotEmpty(warnTransVOS)) break block23;
                    warnList.addAll(warnTransVOS);
                }
                catch (Exception e) {
                    this.logger.error("\u76ee\u6807\u6210\u672c\u9884\u8b66\u5931\u8d25:" + JSONObject.toJSONString((Object)e));
                }
                finally {
                    mylock.unlock();
                    continue;
                }
            }
            if (!CollectionUtils.isNotEmpty(warnList) || (warnResp = this.warnCenterApi.sendToWarnCenterWithReceive(warnList, Long.valueOf("584793299912114241"))).isSuccess()) continue;
            this.logger.error("\u56de\u8c03\u9884\u8b66\u4efb\u52a1\u670d\u52a1\u5931\u8d25\uff0c{}", (Object)warnResp.getMsg());
            this.logger.error("dutyEntity" + JSONObject.toJSONString((Object)((Object)dutyEntity)));
        }
        return CommonResponse.success((String)"\u76ee\u6807\u6210\u672c\u9884\u8b66\u6210\u529f");
    }

    private List<EarlyWarnTransVO> ctrlCost(DutyDetailItemVO detailItemVO, List<RuleDetailEntity> ruleList, DutyEntity dutyEntity, CostDetailVO costDetailVO, Map<Long, List<RuleReceiverEntity>> receiverMap, Map<Long, RuleEntity> ruleMap) {
        ArrayList<EarlyWarnTransVO> list = new ArrayList<EarlyWarnTransVO>();
        if (CollectionUtils.isNotEmpty(ruleList)) {
            for (RuleDetailEntity ruleDetailEntity : ruleList) {
                BigDecimal controlScale;
                EarlyWarnTransVO earlyWarnTransVO;
                if (!receiverMap.containsKey(ruleDetailEntity.getId()) || null == (earlyWarnTransVO = this.dutyRuleToWarnVO(detailItemVO, ruleDetailEntity, controlScale = ruleDetailEntity.getControlScale(), dutyEntity, costDetailVO, receiverMap.get(ruleDetailEntity.getId()), ruleMap))) continue;
                list.add(earlyWarnTransVO);
            }
        }
        return list;
    }

    private EarlyWarnTransVO dutyRuleToWarnVO(DutyDetailItemVO detailItemVO, RuleDetailEntity ruleDetailEntity, BigDecimal controlScale, DutyEntity dutyEntity, CostDetailVO costDetailVO, List<RuleReceiverEntity> receiverEntities, Map<Long, RuleEntity> ruleMap) {
        ArrayList<WarningReceiveVO> receiveList = new ArrayList<WarningReceiveVO>();
        if (CollectionUtils.isNotEmpty(receiverEntities)) {
            for (RuleReceiverEntity receiverEntity : receiverEntities) {
                WarningReceiveVO receiveVO = new WarningReceiveVO();
                receiveVO.setNameId(receiverEntity.getNameId());
                receiveVO.setName(receiverEntity.getName());
                receiveVO.setType(receiverEntity.getType());
                receiveVO.setWarningId(ruleDetailEntity.getId());
                receiveList.add(receiveVO);
            }
        }
        EarlyWarnTransVO vo = null;
        BigDecimal taxMny = null != detailItemVO ? detailItemVO.getTaxMny() : null;
        BigDecimal comTaxMny = costDetailVO.getHappenTaxMny();
        BigDecimal comTaxScale = ComputeUtil.safeMultiply((BigDecimal)ComputeUtil.safeDiv((BigDecimal)comTaxMny, (BigDecimal)taxMny), (BigDecimal)BigDecimal.valueOf(100L));
        if (ComputeUtil.isLessThan((BigDecimal)controlScale, (BigDecimal)comTaxScale)) {
            vo = new EarlyWarnTransVO();
            vo.setBillName(dutyEntity.getProjectName());
            vo.setPcTitle("\u76ee\u6807\u6210\u672c\u6267\u884c\u60c5\u51b5");
            vo.setPcUrl("/ejc-targetcost-frontend/#/execution?projectId=" + dutyEntity.getProjectId() + "&&projectName=" + dutyEntity.getProjectName());
            RuleEntity ruleEntity = ruleMap.get(ruleDetailEntity.getRuleId());
            vo.setOrgId(ruleEntity.getOrgId());
            vo.setOrgName(ruleEntity.getOrgName());
            vo.setSourceId(String.valueOf(dutyEntity.getId()));
            vo.setTenantId(dutyEntity.getTenantId());
            vo.setWarnLevel("\u4e2d");
            vo.setWarnSetId(Long.valueOf("584793299912114241"));
            vo.setWarnSetParamId(Long.valueOf("584793299912114241"));
            vo.setWarnType("1");
            vo.setSendOrgId(String.valueOf(ruleEntity.getOrgId()));
            vo.setDef1(String.valueOf(ruleDetailEntity.getId()));
            vo.setEarlywarnName("\u6210\u672c\u79d1\u76ee-[" + costDetailVO.getSubjectName() + "]\u603b\u989d\u63a7\u9884\u8b66");
            vo.setReceiveList(receiveList);
            StringBuffer warnStr = new StringBuffer();
            warnStr.append("\u6210\u672c\u79d1\u76ee-[" + costDetailVO.getSubjectName() + "]");
            warnStr.append("\u91d1\u989d(").append(ComputeUtil.scale((BigDecimal)costDetailVO.getHappenTaxMny(), (int)2)).append("\u5143)\u5df2\u5360\u7528\u76ee\u6807\u6210\u672c\u4e2d\u8be5\u6210\u672c\u79d1\u76ee\u91d1\u989d");
            warnStr.append("(").append(ComputeUtil.scale((BigDecimal)taxMny, (int)2)).append("\u5143)").append(ComputeUtil.scale((BigDecimal)comTaxScale, (int)2)).append("%! \n");
            vo.setEarlywarnContent(warnStr.toString());
        }
        return vo;
    }
}

