package com.ejianc.business.build.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.ejianc.business.build.bean.*;
import com.ejianc.business.build.mapper.BuildDutyMapper;
import com.ejianc.business.build.service.*;
import com.ejianc.business.build.vo.*;
import com.ejianc.business.targetcost.bean.DutyEntity;
import com.ejianc.business.targetcost.enums.ChangeStateEnum;
import com.ejianc.business.targetcost.enums.ConversionEnum;
import com.ejianc.business.targetcost.service.IDutyService;
import com.ejianc.business.targetcost.utils.DetailIndexExcelReader2;
import com.ejianc.business.targetcost.utils.TreeNodeBUtil;
import com.ejianc.business.targetcost.vo.ImportBuildVo;
import com.ejianc.business.targetcost.vo.ImportErrorVo;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.FileUtils;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * 房建-目标责任成本
 *
 * @author generator
 *
 */
@Service("buildDutyService")
public class BuildDutyServiceImpl extends BaseServiceImpl<BuildDutyMapper, BuildDutyEntity> implements IBuildDutyService{
    private static final String BILL_CODE = "BUILDDUTY";//此处需要根据实际修改
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IBuildPlansService buildPlansService;
    @Autowired
    private IBuildRgcostService buildRgcostService;
    @Autowired
    private IBuildSubService buildSubService;
    @Autowired
    private IBuildMaterialService buildMaterialService;
    @Autowired
    private IBuildRmatService buildRmatService;
    @Autowired
    private IBuildEquipmentService buildEquipmentService;
    @Autowired
    private IBuildSafeService buildSafeService;
    @Autowired
    private IBuildTemporaryService buildTemporaryService;
    @Autowired
    private IBuildMeasureService buildMeasureService;
    @Autowired
    private IBuildManageService buildManageService;
    @Autowired
    private IBuildFeesService buildFeesService;
    @Autowired
    private IBuildOtherService buildOtherService;
    @Autowired
    private IDutyService dutyService;

    @Override
    public CommonResponse<BuildDutyVO> saveOrUpdate(BuildDutyVO saveOrUpdateVO) {
        BuildDutyEntity entity = BeanMapper.map(saveOrUpdateVO, BuildDutyEntity.class);
        if(entity.getLastDutyId()!=null){
            LambdaQueryWrapper<DutyEntity> queryWrapper = new LambdaQueryWrapper<>();
            queryWrapper.eq(DutyEntity::getFirstImportId, entity.getBaseDutyId());
            queryWrapper.isNotNull(DutyEntity::getLastDutyId);
            queryWrapper.notIn(DutyEntity::getBillState, "1,3");
            if (dutyService.count(queryWrapper) > 0) {
                throw new BusinessException("该单据存在变更中的【目标责任成本】单，不允许新增变更！");
            }
        }
        if(entity.getId() == null || entity.getId() == 0){
            entity.setLatestFlag(true);//新增时默认最新版本
            entity.setEnableState(false);//新增时默认不生效
            BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE,InvocationInfoProxy.getTenantid(),saveOrUpdateVO);
            CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
            if(billCode.isSuccess()) {
                entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }
        if(null==entity.getDutyVersion()){
            entity.setDutyVersion(1);
        }
        entity.setConvertFlag(0);
        super.saveOrUpdate(entity, false);


        //更新实体

        if(entity.getBaseDutyId()==null&&0==entity.getChangeState()){
            entity.setBaseDutyId(entity.getId());
            entity.setOneTime(entity.getCreateTime());
        }
        //变更单保存
        if(entity.getLastDutyId()!=null){
            BuildDutyEntity revise = super.getById(entity.getLastDutyId());
            revise.setLatestFlag(false);
            revise.setChangeId(entity.getId());
            revise.setChangeState(ChangeStateEnum.变更中.getCode());
            super.saveOrUpdate(revise);
        }

        if(CollectionUtils.isNotEmpty(entity.getBuildPlansList())){
            //说明有子表信息，不是第一次点下一步保存   需要重新计算 计划汇总表
            BuildDutyVO buildDutyVO = BeanMapper.map(entity, BuildDutyVO.class);
            List<BuildPlansEntity> dutyPlansEntityList = SumPlanDetail(buildDutyVO);
            if(CollectionUtils.isNotEmpty(dutyPlansEntityList)){
                buildPlansService.remove(new QueryWrapper<BuildPlansEntity>().eq("duty_id", entity.getId()));
                buildPlansService.saveOrUpdateBatch(dutyPlansEntityList, dutyPlansEntityList.size(), false);
//                entity.setDutyPlansList(dutyPlansEntityList);
                BuildPlansEntity plansEntity = dutyPlansEntityList.get(dutyPlansEntityList.size()-1);
                BuildPlansEntity lastPlansEntity = dutyPlansEntityList.get(dutyPlansEntityList.size()-6);//第一个合计行
                entity.setTaxMny(plansEntity.getPlansMny());
                entity.setMny(lastPlansEntity.getPlansMny());
            }
        }
        super.updateById(entity);
        //维护父子级关系
        updateByPid(entity);

        BuildDutyVO vo = queryDetail(entity.getId());
        return CommonResponse.success("保存或修改单据成功！",vo);
    }

    @Override
    public CommonResponse<JSONObject> excelImportInfo(HttpServletRequest request, HttpServletResponse response) {
        Long dutyId = null;
        if (StringUtils.isNotEmpty(request.getParameter("dutyId"))) {
            dutyId = Long.valueOf(request.getParameter("dutyId"));
        } else {
            return CommonResponse.error("主表主键为空！");
        }
        BuildDutyEntity buildDutyEntity = super.selectById(dutyId);
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest) request;
        Map<String, MultipartFile> fileMap = multipartRequest.getFileMap();
        boolean isFailed = false;
        MultipartFile mf = null;
        for (Map.Entry<String, MultipartFile> entity : fileMap.entrySet()) {
            mf = entity.getValue();
            String originalFileName = mf.getOriginalFilename();
            String extName = null;
            originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
            originalFileName.replaceAll("00.", "");
            extName = FileUtils.getFileExt(originalFileName, false);
            if (!"xls".equals(extName) && !"xlsx".equals(extName)) {
                isFailed = true;
                break;
            }
        }
        JSONObject resp = new JSONObject();

        if (isFailed) {
            return CommonResponse.error("文件格式不合法！");
        } else {
            Integer size = DetailIndexExcelReader2.getNumberOfSheets(mf);
            if (size == null || size != 17) {
                return CommonResponse.error("文件页签数应该为17个，请检查是否有隐藏页签！");
            }
            List<List<List<String>>> resList = DetailIndexExcelReader2.readExcel(mf);

            List<List<String>> result1 = resList.get(1);
            if (result1.size() > 0 && result1.get(0).size() < 12) {
                return CommonResponse.error("[目标成本计划汇总表]数据不完整，请下载最新模板！");
            }
            List<List<String>> result2 = resList.get(4);
            if (result2.size() > 0 && result2.get(0).size() < 13) {
                return CommonResponse.error("[人工费目标成本控制计划表]数据不完整，请下载最新模板！");
            }
            List<List<String>> result3 = resList.get(5);
            if (result3.size() > 0 && result3.get(0).size() < 14) {
                return CommonResponse.error("[分包工程目标成本控制计划表]数据不完整，请下载最新模板！");
            }
            List<List<String>> result4 = resList.get(6);
            if (result4.size() > 0 && result4.get(0).size() < 16) {
                return CommonResponse.error("[主要材料目标成本控制计划表]数据不完整，请下载最新模板！");
            }

            List<List<String>> result5 = resList.get(13);
            if (result5.size() > 0 && result5.get(0).size() < 14) {
                return CommonResponse.error("[周转材料目标成本控制计划表]数据不完整，请下载最新模板！");
            }

            List<List<String>> result6 = resList.get(14);
            if (result6.size() > 0 && result6.get(0).size() < 14) {
                return CommonResponse.error("[机械使用费目标成本控制计划表]数据不完整，请下载最新模板！");
            }

            List<List<String>> result7 = resList.get(9);
            if (result7.size() > 0 && result7.get(0).size() < 13) {
                return CommonResponse.error("[安全文明施工费目标成本计划表]数据不完整，请下载最新模板！");
            }

            List<List<String>> result8 = resList.get(10);
            if (result8.size() > 0 && result8.get(0).size() < 13) {
                return CommonResponse.error("[临时设施费目标成本计划表]数据不完整，请下载最新模板！");
            }

            List<List<String>> result9 = resList.get(11);
            if (result9.size() > 0 && result9.get(0).size() < 13) {
                return CommonResponse.error("[其他措施费目标成本计划表]数据不完整，请下载最新模板！");
            }

            List<List<String>> result10 = resList.get(12);
            if (result10.size() > 0 && result10.get(0).size() < 14) {
                return CommonResponse.error("[现场管理费目标成本控制计划表]数据不完整，请下载最新模板！");
            }

            List<List<String>> result11 = resList.get(15);
            if (result11.size() > 0 && result11.get(0).size() < 7) {
                return CommonResponse.error("[规费目标成本控制计划表]数据不完整，请下载最新模板！");
            }

            List<List<String>> result12 = resList.get(16);
            if (result12.size() > 0 && result12.get(0).size() < 7) {
                return CommonResponse.error("[其它费目标成本控制计划表]数据不完整，请下载最新模板！");
            }
            ImportBuildVo importVo1 = excelImportPlan(result1, dutyId);//汇总
            ImportBuildVo importVo2 = excelImportRgcost(result2, dutyId);//人工费
            ImportBuildVo importVo3 = excelImportSub(result3, dutyId);//分包
            ImportBuildVo importVo4 = excelImportMaterial(result4, dutyId);//材料
            ImportBuildVo importVo5 = excelImportRmat(result5, dutyId);//周转材
            ImportBuildVo importVo6 = excelImportEquipment(result6, dutyId);//设备
            ImportBuildVo importVo7 = excelImportSafe(result7, dutyId);//安全
            ImportBuildVo importVo8 = excelImportTemporary(result8, dutyId);//临时
            ImportBuildVo importVo9 = excelImportMeasure(result9, dutyId);//其他措施费
            ImportBuildVo importVo10 = excelImportManage(result10, dutyId);//现场管理费
            ImportBuildVo importVo11 = excelImportFees(result11, dutyId);//规费
            ImportBuildVo importVo12 = excelImportOther(result12, dutyId);//其他

            List<ImportErrorVo> errorList = new ArrayList<>();
            errorList.addAll(importVo1.getErrorList());
            errorList.addAll(importVo2.getErrorList());
            errorList.addAll(importVo3.getErrorList());
            errorList.addAll(importVo4.getErrorList());
            errorList.addAll(importVo5.getErrorList());
            errorList.addAll(importVo6.getErrorList());
            errorList.addAll(importVo7.getErrorList());
            errorList.addAll(importVo8.getErrorList());
            errorList.addAll(importVo9.getErrorList());
            errorList.addAll(importVo10.getErrorList());
            errorList.addAll(importVo11.getErrorList());
            errorList.addAll(importVo12.getErrorList());

            if (errorList.size() > 0) {
                resp.put("successList", null);
                resp.put("successNum", 0);
                resp.put("errorNum", errorList.size());
                if (errorList.size() > 100) {
                    resp.put("errorList", errorList.subList(0, 100));
                } else {
                    resp.put("errorList", errorList);
                }
            } else {
                List<BuildPlansVO> buildPlansList = importVo1.getBuildPlansList(); // 房建-目标成本-计划汇总表
                List<BuildRgcostVO> buildRgcostList = importVo2.getBuildRgcostList(); // 房建-人工费
                List<BuildSubVO> buildSubList = importVo3.getBuildSubList(); // 房建-专业分包
                List<BuildMaterialVO> buildMaterialList = importVo4.getBuildMaterialList(); // 房建-主要材料
                List<BuildRmatVO> buildRmatList = importVo5.getBuildRmatList(); // 房建-周转材
                List<BuildEquipmentVO> buildEquipmentList = importVo6.getBuildEquipmentList(); // 房建-机械设备费
                List<BuildSafeVO> buildSafeList = importVo7.getBuildSafeList(); // 房建-安全文明施工费
                List<BuildTemporaryVO> buildTemporaryList = importVo8.getBuildTemporaryList(); // 房建-临时设施费
                List<BuildMeasureVO> buildMeasureList = importVo9.getBuildMeasureList(); // 房建-其他措施费
                List<BuildManageVO> buildManageList = importVo10.getBuildManageList(); // 房建-现场管理费
                List<BuildFeesVO> buildFeesList = importVo11.getBuildFeesList(); // 房建-规费
                List<BuildOtherVO> buildOtherList = importVo12.getBuildOtherList(); // 房建-其他费用
                int sucNum = buildPlansList.size()+buildRgcostList.size()+buildSubList.size()+buildMaterialList.size()+buildRmatList.size()+buildEquipmentList.size()+buildSafeList.size()+buildTemporaryList.size()+buildMeasureList.size()+buildManageList.size()+buildFeesList.size()+buildOtherList.size();
                resp.put("successList", null);
                resp.put("errorList", null);
                resp.put("successNum", sucNum);
                resp.put("errorNum", 0);

                buildPlansService.remove(new QueryWrapper<BuildPlansEntity>().eq("duty_id", dutyId));
                if (buildPlansList.size() > 0) {
                    List<BuildPlansEntity> buildPlansEntities = BeanMapper.mapList(buildPlansList, BuildPlansEntity.class);
                    buildPlansService.saveOrUpdateBatch(buildPlansEntities, buildPlansEntities.size(), false);

                    //更新主表字段
                    BigDecimal plansMny = buildPlansEntities.get(buildPlansEntities.size()-6).getPlansMny();
                    buildDutyEntity.setMny(plansMny);

                    BigDecimal plansTaxMny = buildPlansEntities.get(buildPlansEntities.size()-1).getPlansMny();
                    buildDutyEntity.setTaxMny(plansTaxMny);
                    buildDutyEntity.setConvertFlag(0);//设置未转换
                    super.updateById(buildDutyEntity);
                }

                buildRgcostService.remove(new QueryWrapper<BuildRgcostEntity>().eq("duty_id", dutyId));
                if (buildRgcostList.size() > 0) {
                    List<BuildRgcostEntity> buildRgcostEntities = BeanMapper.mapList(buildRgcostList, BuildRgcostEntity.class);
                    buildRgcostService.saveOrUpdateBatch(buildRgcostEntities, buildRgcostEntities.size(), false);
                }

                buildSubService.remove(new QueryWrapper<BuildSubEntity>().eq("duty_id", dutyId));
                if (buildSubList.size() > 0) {
                    List<BuildSubEntity> buildSubEntities = BeanMapper.mapList(buildSubList, BuildSubEntity.class);
                    buildSubService.saveOrUpdateBatch(buildSubEntities, buildSubEntities.size(), false);
                }

                buildMaterialService.remove(new QueryWrapper<BuildMaterialEntity>().eq("duty_id", dutyId));
                if (buildMaterialList.size() > 0) {
                    List<BuildMaterialEntity> buildMaterialEntities = BeanMapper.mapList(buildMaterialList, BuildMaterialEntity.class);
                    buildMaterialService.saveOrUpdateBatch(buildMaterialEntities, buildMaterialEntities.size(), false);
                }

                buildRmatService.remove(new QueryWrapper<BuildRmatEntity>().eq("duty_id", dutyId));
                if (buildRmatList.size() > 0) {
                    List<BuildRmatEntity> buildRmatEntities = BeanMapper.mapList(buildRmatList, BuildRmatEntity.class);
                    buildRmatService.saveOrUpdateBatch(buildRmatEntities, buildRmatEntities.size(), false);
                }

                buildEquipmentService.remove(new QueryWrapper<BuildEquipmentEntity>().eq("duty_id", dutyId));
                if (buildEquipmentList.size() > 0) {
                    List<BuildEquipmentEntity> buildEquipmentEntities = BeanMapper.mapList(buildEquipmentList, BuildEquipmentEntity.class);
                    buildEquipmentService.saveOrUpdateBatch(buildEquipmentEntities, buildEquipmentEntities.size(), false);
                }

                buildSafeService.remove(new QueryWrapper<BuildSafeEntity>().eq("duty_id", dutyId));
                if (buildSafeList.size() > 0) {
                    List<BuildSafeEntity> buildSafeEntities = BeanMapper.mapList(buildSafeList, BuildSafeEntity.class);
                    buildSafeService.saveOrUpdateBatch(buildSafeEntities, buildSafeEntities.size(), false);
                }

                buildTemporaryService.remove(new QueryWrapper<BuildTemporaryEntity>().eq("duty_id", dutyId));
                if (buildTemporaryList.size() > 0) {
                    List<BuildTemporaryEntity> buildTemporaryEntities = BeanMapper.mapList(buildTemporaryList, BuildTemporaryEntity.class);
                    buildTemporaryService.saveOrUpdateBatch(buildTemporaryEntities, buildTemporaryEntities.size(), false);
                }

                buildMeasureService.remove(new QueryWrapper<BuildMeasureEntity>().eq("duty_id", dutyId));
                if (buildMeasureList.size() > 0) {
                    List<BuildMeasureEntity> buildMeasureEntities = BeanMapper.mapList(buildMeasureList, BuildMeasureEntity.class);
                    buildMeasureService.saveOrUpdateBatch(buildMeasureEntities, buildMeasureEntities.size(), false);
                }

                buildManageService.remove(new QueryWrapper<BuildManageEntity>().eq("duty_id", dutyId));
                if (buildManageList.size() > 0) {
                    List<BuildManageEntity> buildManageEntities = BeanMapper.mapList(buildManageList, BuildManageEntity.class);
                    buildManageService.saveOrUpdateBatch(buildManageEntities, buildManageEntities.size(), false);
                }

                buildFeesService.remove(new QueryWrapper<BuildFeesEntity>().eq("duty_id", dutyId));
                if (buildFeesList.size() > 0) {
                    List<BuildFeesEntity> buildFeesEntities = BeanMapper.mapList(buildFeesList, BuildFeesEntity.class);
                    buildFeesService.saveOrUpdateBatch(buildFeesEntities, buildFeesEntities.size(), false);
                }

                buildOtherService.remove(new QueryWrapper<BuildOtherEntity>().eq("duty_id", dutyId));
                if (buildOtherList.size() > 0) {
                    List<BuildOtherEntity> buildOtherEntities = BeanMapper.mapList(buildOtherList, BuildOtherEntity.class);
                    buildOtherService.saveOrUpdateBatch(buildOtherEntities, buildOtherEntities.size(), false);
                }


            }
            return CommonResponse.success(resp);
        }
    }

    @Override
    public BuildDutyVO queryDetail(Long id) {
        BuildDutyEntity entity = super.selectById(id);
        BuildDutyVO vo = BeanMapper.map(entity, BuildDutyVO.class);

        List<BuildRgcostVO> buildRgcostList = vo.getBuildRgcostList(); // 房建-人工费
        vo.setBuildRgcostList(TreeNodeBUtil.buildTree(buildRgcostList));
        List<BuildSubVO> buildSubList = vo.getBuildSubList(); // 房建-专业分包
        vo.setBuildSubList(TreeNodeBUtil.buildTree(buildSubList));
        List<BuildMaterialVO> buildMaterialList = vo.getBuildMaterialList(); // 房建-主要材料
        vo.setBuildMaterialList(TreeNodeBUtil.buildTree(buildMaterialList));
        List<BuildRmatVO> buildRmatList = vo.getBuildRmatList(); // 房建-周转材
        vo.setBuildRmatList(TreeNodeBUtil.buildTree(buildRmatList));
        List<BuildEquipmentVO> buildEquipmentList = vo.getBuildEquipmentList(); // 房建-机械设备费
        vo.setBuildEquipmentList(TreeNodeBUtil.buildTree(buildEquipmentList));
        List<BuildSafeVO> buildSafeList = vo.getBuildSafeList(); // 房建-安全文明施工费
        vo.setBuildSafeList(TreeNodeBUtil.buildTree(buildSafeList));
        List<BuildTemporaryVO> buildTemporaryList = vo.getBuildTemporaryList(); // 房建-临时设施费
        vo.setBuildTemporaryList(TreeNodeBUtil.buildTree(buildTemporaryList));
        List<BuildMeasureVO> buildMeasureList = vo.getBuildMeasureList(); // 房建-其他措施费
        vo.setBuildMeasureList(TreeNodeBUtil.buildTree(buildMeasureList));
        List<BuildManageVO> buildManageList = vo.getBuildManageList(); // 房建-现场管理费
        vo.setBuildManageList(TreeNodeBUtil.buildTree(buildManageList));
        List<BuildFeesVO> buildFeesList = vo.getBuildFeesList(); // 房建-规费
        vo.setBuildFeesList(TreeNodeBUtil.buildTree(buildFeesList));
        List<BuildOtherVO> buildOtherList = vo.getBuildOtherList(); // 房建-其他费用
        vo.setBuildOtherList(TreeNodeBUtil.buildTree(buildOtherList));

        List<BuildDutyRecordVO> list = new ArrayList<>();
        LambdaQueryWrapper<BuildDutyEntity> queryWrapper = new LambdaQueryWrapper<>();
        queryWrapper.eq(BuildDutyEntity::getBaseDutyId, entity.getBaseDutyId());
        List<Integer> billStatusList = new ArrayList<>();
        billStatusList.add(BillStateEnum.PASSED_STATE.getBillStateCode());
        billStatusList.add(BillStateEnum.COMMITED_STATE.getBillStateCode());
        queryWrapper.in(BuildDutyEntity::getBillState,billStatusList);
        queryWrapper.ne(BuildDutyEntity::getId, id);
        queryWrapper.orderByAsc(BuildDutyEntity::getCreateTime);
        List<BuildDutyEntity> roadbridgeDutyEntities = super.list(queryWrapper);
        if(CollectionUtils.isNotEmpty(roadbridgeDutyEntities)){
            list = BeanMapper.mapList(roadbridgeDutyEntities,BuildDutyRecordVO.class);
        }
        vo.setRecordList(list);
        return vo;
    }

    @Override
    public BuildDutyVO queryChangeDetail(Long id) {
        BuildDutyEntity entity = super.selectById(id);
        BuildDutyVO vo = BeanMapper.map(entity, BuildDutyVO.class);
        vo.setId(null);
        vo.setBillCode(null);
        vo.setBillState(null);
        vo.setCreateTime(null);
        vo.setCreateUserCode(null);
        vo.setUpdateTime(null);
        vo.setUpdateUserCode(null);
        vo.setDutyVersion(vo.getDutyVersion() + 1);
        vo.setChangeState(ChangeStateEnum.未变更.getCode());
        vo.setLastDutyId(id);
        vo.setBaseDutyId(vo.getBaseDutyId());
        vo.setLatestFlag(true);
        vo.setEnableState(false);
        vo.setBeforeMny(vo.getMny());
        vo.setBeforeTaxMny(vo.getTaxMny());
        vo.setBeforeDutyVersion(vo.getDutyVersion()-1);

        List<BuildPlansVO> buildPlansList = vo.getBuildPlansList();
        if(CollectionUtils.isNotEmpty(buildPlansList)){
            buildPlansList.forEach(changeDetailVO ->{
                changeDetailVO.setCreateTime(null);
                changeDetailVO.setCreateUserCode(null);
                changeDetailVO.setUpdateTime(null);
                changeDetailVO.setUpdateUserCode(null);
                changeDetailVO.setRowState("edit");
                changeDetailVO.setId(IdWorker.getId());
            });
            vo.setBuildPlansList(buildPlansList);
        }

        List<BuildRgcostVO> buildRgcostList = vo.getBuildRgcostList();
        if(CollectionUtils.isNotEmpty(buildRgcostList)){
            Map<Long,Long> idMap=new HashMap<>();
            buildRgcostList.forEach(changeDetailVO ->{
                changeDetailVO.setCreateTime(null);
                changeDetailVO.setCreateUserCode(null);
                changeDetailVO.setUpdateTime(null);
                changeDetailVO.setUpdateUserCode(null);
                changeDetailVO.setTpid(changeDetailVO.getParentId()!= null&&changeDetailVO.getParentId()>0?changeDetailVO.getParentId().toString():"");
                changeDetailVO.setRowState("edit");
                changeDetailVO.setId(IdWorker.getId());
                idMap.put(changeDetailVO.getTid(),changeDetailVO.getId());
            });
            for(BuildRgcostVO cdEntity : buildRgcostList){
                if(null!=cdEntity.getParentId()){
                    cdEntity.setParentId(idMap.get(cdEntity.getParentId()));
                }
                cdEntity.setTid(cdEntity.getId());
            }
            vo.setBuildRgcostList(TreeNodeBUtil.buildTree(buildRgcostList));
        }

        List<BuildSubVO> buildSubList = vo.getBuildSubList(); // 房建-专业分包
        if(CollectionUtils.isNotEmpty(buildSubList)){
            Map<Long,Long> idMap=new HashMap<>();
            buildSubList.forEach(changeDetailVO ->{
                changeDetailVO.setCreateTime(null);
                changeDetailVO.setCreateUserCode(null);
                changeDetailVO.setUpdateTime(null);
                changeDetailVO.setUpdateUserCode(null);
                changeDetailVO.setTpid(changeDetailVO.getParentId()!= null&&changeDetailVO.getParentId()>0?changeDetailVO.getParentId().toString():"");
                changeDetailVO.setRowState("edit");
                changeDetailVO.setId(IdWorker.getId());
                idMap.put(changeDetailVO.getTid(),changeDetailVO.getId());
            });
            for(BuildSubVO cdEntity : buildSubList){
                if(null!=cdEntity.getParentId()){
                    cdEntity.setParentId(idMap.get(cdEntity.getParentId()));
                }
                cdEntity.setTid(cdEntity.getId());
            }
            vo.setBuildSubList(TreeNodeBUtil.buildTree(buildSubList));
        }

        List<BuildMaterialVO> buildMaterialList = vo.getBuildMaterialList(); // 房建-主要材料
        if(CollectionUtils.isNotEmpty(buildMaterialList)){
            Map<Long,Long> idMap=new HashMap<>();
            buildMaterialList.forEach(changeDetailVO ->{
                changeDetailVO.setCreateTime(null);
                changeDetailVO.setCreateUserCode(null);
                changeDetailVO.setUpdateTime(null);
                changeDetailVO.setUpdateUserCode(null);
                changeDetailVO.setTpid(changeDetailVO.getParentId()!= null&&changeDetailVO.getParentId()>0?changeDetailVO.getParentId().toString():"");
                changeDetailVO.setRowState("edit");
                changeDetailVO.setId(IdWorker.getId());
                idMap.put(changeDetailVO.getTid(),changeDetailVO.getId());
            });
            for(BuildMaterialVO cdEntity : buildMaterialList){
                if(null!=cdEntity.getParentId()){
                    cdEntity.setParentId(idMap.get(cdEntity.getParentId()));
                }
                cdEntity.setTid(cdEntity.getId());
            }
            vo.setBuildMaterialList(TreeNodeBUtil.buildTree(buildMaterialList));
        }

        List<BuildRmatVO> buildRmatList = vo.getBuildRmatList(); // 房建-周转材
        if(CollectionUtils.isNotEmpty(buildRmatList)){
            Map<Long,Long> idMap=new HashMap<>();
            buildRmatList.forEach(changeDetailVO ->{
                changeDetailVO.setCreateTime(null);
                changeDetailVO.setCreateUserCode(null);
                changeDetailVO.setUpdateTime(null);
                changeDetailVO.setUpdateUserCode(null);
                changeDetailVO.setTpid(changeDetailVO.getParentId()!= null&&changeDetailVO.getParentId()>0?changeDetailVO.getParentId().toString():"");
                changeDetailVO.setRowState("edit");
                changeDetailVO.setId(IdWorker.getId());
                idMap.put(changeDetailVO.getTid(),changeDetailVO.getId());
            });
            for(BuildRmatVO cdEntity : buildRmatList){
                if(null!=cdEntity.getParentId()){
                    cdEntity.setParentId(idMap.get(cdEntity.getParentId()));
                }
                cdEntity.setTid(cdEntity.getId());
            }
            vo.setBuildRmatList(TreeNodeBUtil.buildTree(buildRmatList));
        }

        List<BuildEquipmentVO> buildEquipmentList = vo.getBuildEquipmentList(); // 房建-机械设备费
        if(CollectionUtils.isNotEmpty(buildEquipmentList)){
            Map<Long,Long> idMap=new HashMap<>();
            buildEquipmentList.forEach(changeDetailVO ->{
                changeDetailVO.setCreateTime(null);
                changeDetailVO.setCreateUserCode(null);
                changeDetailVO.setUpdateTime(null);
                changeDetailVO.setUpdateUserCode(null);
                changeDetailVO.setTpid(changeDetailVO.getParentId()!= null&&changeDetailVO.getParentId()>0?changeDetailVO.getParentId().toString():"");
                changeDetailVO.setRowState("edit");
                changeDetailVO.setId(IdWorker.getId());
                idMap.put(changeDetailVO.getTid(),changeDetailVO.getId());
            });
            for(BuildEquipmentVO cdEntity : buildEquipmentList){
                if(null!=cdEntity.getParentId()){
                    cdEntity.setParentId(idMap.get(cdEntity.getParentId()));
                }
                cdEntity.setTid(cdEntity.getId());
            }
            vo.setBuildEquipmentList(TreeNodeBUtil.buildTree(buildEquipmentList));
        }

        List<BuildSafeVO> buildSafeList = vo.getBuildSafeList(); // 房建-安全文明施工费
        if(CollectionUtils.isNotEmpty(buildSafeList)){
            Map<Long,Long> idMap=new HashMap<>();
            buildSafeList.forEach(changeDetailVO ->{
                changeDetailVO.setCreateTime(null);
                changeDetailVO.setCreateUserCode(null);
                changeDetailVO.setUpdateTime(null);
                changeDetailVO.setUpdateUserCode(null);
                changeDetailVO.setTpid(changeDetailVO.getParentId()!= null&&changeDetailVO.getParentId()>0?changeDetailVO.getParentId().toString():"");
                changeDetailVO.setRowState("edit");
                changeDetailVO.setId(IdWorker.getId());
                idMap.put(changeDetailVO.getTid(),changeDetailVO.getId());
            });
            for(BuildSafeVO cdEntity : buildSafeList){
                if(null!=cdEntity.getParentId()){
                    cdEntity.setParentId(idMap.get(cdEntity.getParentId()));
                }
                cdEntity.setTid(cdEntity.getId());
            }
            vo.setBuildSafeList(TreeNodeBUtil.buildTree(buildSafeList));
        }

        List<BuildTemporaryVO> buildTemporaryList = vo.getBuildTemporaryList(); // 房建-临时设施费
        if(CollectionUtils.isNotEmpty(buildTemporaryList)){
            Map<Long,Long> idMap=new HashMap<>();
            buildTemporaryList.forEach(changeDetailVO ->{
                changeDetailVO.setCreateTime(null);
                changeDetailVO.setCreateUserCode(null);
                changeDetailVO.setUpdateTime(null);
                changeDetailVO.setUpdateUserCode(null);
                changeDetailVO.setTpid(changeDetailVO.getParentId()!= null&&changeDetailVO.getParentId()>0?changeDetailVO.getParentId().toString():"");
                changeDetailVO.setRowState("edit");
                changeDetailVO.setId(IdWorker.getId());
                idMap.put(changeDetailVO.getTid(),changeDetailVO.getId());
            });
            for(BuildTemporaryVO cdEntity : buildTemporaryList){
                if(null!=cdEntity.getParentId()){
                    cdEntity.setParentId(idMap.get(cdEntity.getParentId()));
                }
                cdEntity.setTid(cdEntity.getId());
            }
            vo.setBuildTemporaryList(TreeNodeBUtil.buildTree(buildTemporaryList));
        }

        List<BuildMeasureVO> buildMeasureList = vo.getBuildMeasureList(); // 房建-其他措施费
        if(CollectionUtils.isNotEmpty(buildMeasureList)){
            Map<Long,Long> idMap=new HashMap<>();
            buildMeasureList.forEach(changeDetailVO ->{
                changeDetailVO.setCreateTime(null);
                changeDetailVO.setCreateUserCode(null);
                changeDetailVO.setUpdateTime(null);
                changeDetailVO.setUpdateUserCode(null);
                changeDetailVO.setTpid(changeDetailVO.getParentId()!= null&&changeDetailVO.getParentId()>0?changeDetailVO.getParentId().toString():"");
                changeDetailVO.setRowState("edit");
                changeDetailVO.setId(IdWorker.getId());
                idMap.put(changeDetailVO.getTid(),changeDetailVO.getId());
            });
            for(BuildMeasureVO cdEntity : buildMeasureList){
                if(null!=cdEntity.getParentId()){
                    cdEntity.setParentId(idMap.get(cdEntity.getParentId()));
                }
                cdEntity.setTid(cdEntity.getId());
            }
            vo.setBuildMeasureList(TreeNodeBUtil.buildTree(buildMeasureList));
        }

        List<BuildManageVO> buildManageList = vo.getBuildManageList(); // 房建-现场管理费
        if(CollectionUtils.isNotEmpty(buildManageList)){
            Map<Long,Long> idMap=new HashMap<>();
            buildManageList.forEach(changeDetailVO ->{
                changeDetailVO.setCreateTime(null);
                changeDetailVO.setCreateUserCode(null);
                changeDetailVO.setUpdateTime(null);
                changeDetailVO.setUpdateUserCode(null);
                changeDetailVO.setTpid(changeDetailVO.getParentId()!= null&&changeDetailVO.getParentId()>0?changeDetailVO.getParentId().toString():"");
                changeDetailVO.setRowState("edit");
                changeDetailVO.setId(IdWorker.getId());
                idMap.put(changeDetailVO.getTid(),changeDetailVO.getId());
            });
            for(BuildManageVO cdEntity : buildManageList){
                if(null!=cdEntity.getParentId()){
                    cdEntity.setParentId(idMap.get(cdEntity.getParentId()));
                }
                cdEntity.setTid(cdEntity.getId());
            }
            vo.setBuildManageList(TreeNodeBUtil.buildTree(buildManageList));
        }

        List<BuildFeesVO> buildFeesList = vo.getBuildFeesList(); // 房建-规费
        if(CollectionUtils.isNotEmpty(buildFeesList)){
            Map<Long,Long> idMap=new HashMap<>();
            buildFeesList.forEach(changeDetailVO ->{
                changeDetailVO.setCreateTime(null);
                changeDetailVO.setCreateUserCode(null);
                changeDetailVO.setUpdateTime(null);
                changeDetailVO.setUpdateUserCode(null);
                changeDetailVO.setTpid(changeDetailVO.getParentId()!= null&&changeDetailVO.getParentId()>0?changeDetailVO.getParentId().toString():"");
                changeDetailVO.setRowState("edit");
                changeDetailVO.setId(IdWorker.getId());
                idMap.put(changeDetailVO.getTid(),changeDetailVO.getId());
            });
            for(BuildFeesVO cdEntity : buildFeesList){
                if(null!=cdEntity.getParentId()){
                    cdEntity.setParentId(idMap.get(cdEntity.getParentId()));
                }
                cdEntity.setTid(cdEntity.getId());
            }
            vo.setBuildFeesList(TreeNodeBUtil.buildTree(buildFeesList));
        }

        List<BuildOtherVO> buildOtherList = vo.getBuildOtherList(); // 房建-其他费用
        if(CollectionUtils.isNotEmpty(buildOtherList)){
            Map<Long,Long> idMap=new HashMap<>();
            buildOtherList.forEach(changeDetailVO ->{
                changeDetailVO.setCreateTime(null);
                changeDetailVO.setCreateUserCode(null);
                changeDetailVO.setUpdateTime(null);
                changeDetailVO.setUpdateUserCode(null);
                changeDetailVO.setTpid(changeDetailVO.getParentId()!= null&&changeDetailVO.getParentId()>0?changeDetailVO.getParentId().toString():"");
                changeDetailVO.setRowState("edit");
                changeDetailVO.setId(IdWorker.getId());
                idMap.put(changeDetailVO.getTid(),changeDetailVO.getId());
            });
            for(BuildOtherVO cdEntity : buildOtherList){
                if(null!=cdEntity.getParentId()){
                    cdEntity.setParentId(idMap.get(cdEntity.getParentId()));
                }
                cdEntity.setTid(cdEntity.getId());
            }
            vo.setBuildOtherList(TreeNodeBUtil.buildTree(buildOtherList));
        }

        return vo;
    }

    @Override
    public BuildDutyVO ConvertFlag(Long id) {
        BuildDutyEntity entity = super.selectById(id);
        entity.setConvertFlag(1);
        super.updateById(entity);
        BuildDutyVO vo = BeanMapper.map(entity, BuildDutyVO.class);
        dutyService.pushFromImport(vo,false, ConversionEnum.云南房建.getCode());
        return queryDetail(id);
    }

    @Override
    public CommonResponse<String> deleteVos(List<BuildDutyVO> vos) {
        if(ListUtil.isNotEmpty(vos)){
            for(BuildDutyVO dutyVO : vos){
                BuildDutyEntity dutyEntity = super.getById(dutyVO.getId());
                if(dutyEntity.getLastDutyId()!=null){
                    BuildDutyEntity revise = super.getById(dutyEntity.getLastDutyId());
                    revise.setChangeId(null);
                    revise.setChangeState(ChangeStateEnum.未变更.getCode());
                    revise.setLatestFlag(true);
                    super.saveOrUpdate(revise);
                }

                //删除转换的数据
                dutyService.deleteFromImport(dutyVO.getId(),ConversionEnum.云南房建.getCode());
            }
        }
        super.removeByIds(vos.stream().map(BuildDutyVO::getId).collect(Collectors.toList()),true);

        return CommonResponse.success("删除成功！");
    }

    private ImportBuildVo excelImportPlan(List<List<String>> result, Long dutyId) {
        ImportBuildVo res = new ImportBuildVo();
        List<ImportErrorVo> errorList = new ArrayList<>();
        if (result != null && result.size() > 0) {
            List<BuildPlansVO> detailVoList = new ArrayList<>();
            boolean importFlag = true;
            for (int i = 0; i < result.size(); i++) {

                if((i==3) || (i==5)){ //4、6 行不导入
                    continue;
                }
                List<String> datas = result.get(i);
                BuildPlansVO vo = new BuildPlansVO();
                boolean flag = false;
                String warnType = "";

                String plansName = datas.get(1); // 名称
                String plansUnitName = datas.get(3); // 单位
                String plansYsMny = datas.get(4); // 预算收入
                String plansYsSquare = datas.get(5); // 预算平米造价
                String plansMny = datas.get(6); // 目标成本
                String plansMnySquare = datas.get(7); // 目标成本平米造价
                String plansJcMny = datas.get(8); // 节超额
                String plansJcRate = datas.get(9); // 节超率(%)
                String plansRate = datas.get(10); // 单项成本占总成本比率(%)
                String plansMemo = datas.get(11); // 备注

                Long id = IdWorker.getId();
                vo.setId(id);
                vo.setDutyId(dutyId);

                if (StringUtils.isEmpty(plansName)) {// 编码为空
                    vo.setPlansName(null);
                    warnType = warnType + "[名称为空]";
                    flag = true;
                } else {
                    vo.setPlansName(plansName);
                }
                vo.setPlansUnitName(plansUnitName);

                if (StringUtils.isEmpty(plansYsMny)) {
                    vo.setPlansYsMny(null);
                } else {
                    try {
                        vo.setPlansYsMny(new BigDecimal(plansYsMny));
                    } catch (Exception e) {
                        vo.setPlansYsMny(null);
                        warnType = warnType + "[预算收入只能为数字或小数]";
                        flag = true;
                    }
                }
                if (StringUtils.isEmpty(plansYsSquare)) {
                    vo.setPlansYsSquare(null);
                } else {
                    try {
                        vo.setPlansYsSquare(new BigDecimal(plansYsSquare));
                    } catch (Exception e) {
                        vo.setPlansYsSquare(null);
                        warnType = warnType + "[预算平米造价只能为数字或小数]";
                        flag = true;
                    }
                }


                if (StringUtils.isEmpty(plansMny)) {
                    vo.setPlansMny(null);
                } else {
                    try {
                        vo.setPlansMny(new BigDecimal(plansMny));
                    } catch (Exception e) {
                        vo.setPlansMny(null);
                        warnType = warnType + "[目标成本只能为数字或小数]";
                        flag = true;
                    }
                }

                if (StringUtils.isEmpty(plansMnySquare)) {
                    vo.setPlansMnySquare(null);
                } else {
                    try {
                        vo.setPlansMnySquare(new BigDecimal(plansMnySquare));
                    } catch (Exception e) {
                        vo.setPlansMnySquare(null);
                        warnType = warnType + "[目标成本平米造价只能为数字或小数]";
                        flag = true;
                    }
                }

                if (StringUtils.isEmpty(plansJcMny)) {
                    vo.setPlansJcMny(null);
                } else {
                    try {
                        vo.setPlansJcMny(new BigDecimal(plansJcMny));
                    } catch (Exception e) {
                        vo.setPlansJcMny(null);
                        warnType = warnType + "[节超额只能为数字或小数]";
                        flag = true;
                    }
                }

                if (StringUtils.isEmpty(plansJcRate)) {
                    vo.setPlansJcRate(null);
                } else {
                    try {
                        vo.setPlansJcRate(new BigDecimal(plansJcRate));
                    } catch (Exception e) {
                        vo.setPlansJcRate(null);
                        warnType = warnType + "[节超率(%)只能为数字或小数]";
                        flag = true;
                    }
                }

                if (StringUtils.isEmpty(plansRate)) {
                    vo.setPlansRate(null);
                } else {
                    try {
                        vo.setPlansRate(new BigDecimal(plansRate));
                    } catch (Exception e) {
                        vo.setPlansRate(null);
                        warnType = warnType + "[单项成本占总成本比率只能为数字或小数]";
                        flag = true;
                    }
                }

                vo.setPlansMemo(plansMemo);
                vo.setImportFlag(!flag);// true=可以导入，false=不可导入
                if (importFlag) {// 如果能导入
                    importFlag = !flag;
                }
                vo.setWarnType(warnType);
                detailVoList.add(vo);
            }
            List<BuildPlansVO> successList = new ArrayList<>();
            for (BuildPlansVO vo : detailVoList) {
                if (vo.getImportFlag()) {
                    if (importFlag) {
                        successList.add(vo);
                    }
                } else {
                    ImportErrorVo errorVo = new ImportErrorVo();
                    errorVo.setPageName("目标成本计划汇总表");
                    errorVo.setId(vo.getId());
                    errorVo.setName(vo.getPlansName());
                    errorVo.setWarnType(vo.getWarnType());
                    errorList.add(errorVo);
                }
            }
            res.setErrorList(errorList);
            res.setBuildPlansList(successList);
        }
        return res;
    }

    private ImportBuildVo excelImportRgcost(List<List<String>> result, Long dutyId) {
        ImportBuildVo res = new ImportBuildVo();
        List<ImportErrorVo> errorList = new ArrayList<>();
        if (result != null && result.size() > 0) {
            List<String> detailIndexList = new ArrayList<>();// 树形编码不能重复
            Map<String, Long> parentMap = new HashMap<>();
            List<BuildRgcostVO> detailVoList = new ArrayList<>();
            boolean importFlag = true;
            for (int i = 0; i < result.size()-2; i++) {
                List<String> datas = result.get(i);
                BuildRgcostVO vo = new BuildRgcostVO();
                boolean flag = false;
                String warnType = "";

                String indexCode = datas.get(0);//序号
                String rgcostCode = datas.get(1); // 编码
                String rgcostName = datas.get(2); // 费用项名称
                String rgcostUnitName = datas.get(3); // 单位
                String rgcostNum = datas.get(4); // 工程量
                String rgcostPrice = datas.get(5); // 不含税单价
                String rgcostTaxPrice = datas.get(6); // 含税单价
                String rgcostRate = datas.get(7); // 增值税率(%)
                String rgcostPriceTax = datas.get(8); // 税金
                String rgcostMny = datas.get(9); // 不含税合价
                String rgcostTaxMny = datas.get(11); // 含税合价
                String rgcostTax = datas.get(12); // 税金合价
//                String rgcostMemo = datas.get(12); // 备注

                Long id = IdWorker.getId();
                vo.setId(id);
                vo.setTid(id);
                vo.setDutyId(dutyId);

                if (StringUtils.isNotEmpty(indexCode)) {//序号不为空
                    indexCode = indexCode.trim();// 去除导入时树形编码空格
                    vo.setIndexCode(indexCode);
                    vo.setTreeIndex(indexCode);
                    parentMap.put(indexCode, id);
                    String[] split = indexCode.split("[-/.]");
                    if (split.length > 1) {
                        vo.setTpid(indexCode.substring(0, indexCode.length() - split[split.length - 1].length() - 1));
                    }
//                    vo.setTreeIndex(i + "");
                    if (detailIndexList.contains(indexCode)) {
                        warnType = warnType + "[序号重复]";
                        flag = true;
                    } else {
                        detailIndexList.add(indexCode);
                    }
                } else {
                    vo.setIndexCode(null);
                    warnType = warnType + "[序号为空]";
                    flag = true;
                }

                if (StringUtils.isEmpty(rgcostCode)) {// 编码为空
                    vo.setRgcostCode(null);
                } else {
                    vo.setRgcostCode(rgcostCode);
                }

                if (StringUtils.isEmpty(rgcostName)) {//名称为空
                    vo.setRgcostName(null);
                    warnType = warnType + "[费用项名称为空]";
                    flag = true;
                } else {
                    vo.setRgcostName(rgcostName);
                }

                vo.setRgcostUnitName(rgcostUnitName);

                if (StringUtils.isEmpty(rgcostNum)) {
                    vo.setRgcostNum(null);
                } else {
                    try {
                        vo.setRgcostNum(new BigDecimal(rgcostNum));
                    } catch (Exception e) {
                        vo.setRgcostNum(null);
                        warnType = warnType + "[工程量只能为数字或小数]";
                        flag = true;
                    }
                }

                if (StringUtils.isEmpty(rgcostPrice)) {
                    vo.setRgcostPrice(null);
                } else {
                    try {
                        vo.setRgcostPrice(new BigDecimal(rgcostPrice));
                    } catch (Exception e) {
                        vo.setRgcostPrice(null);
                        warnType = warnType + "[不含税单价只能为数字或小数]";
                        flag = true;
                    }
                }

                if (StringUtils.isEmpty(rgcostTaxPrice)) {
                    vo.setRgcostTaxPrice(null);
                } else {
                    try {
                        vo.setRgcostTaxPrice(new BigDecimal(rgcostTaxPrice));
                    } catch (Exception e) {
                        vo.setRgcostTaxPrice(null);
                        warnType = warnType + "[含税单价只能为数字或小数]";
                        flag = true;
                    }
                }

                if (StringUtils.isEmpty(rgcostRate)) {
                    vo.setRgcostRate(null);
                } else {
                    try {
                        vo.setRgcostRate(new BigDecimal(rgcostRate));
                    } catch (Exception e) {
                        vo.setRgcostRate(null);
                        warnType = warnType + "[增值税率(%)只能为数字或小数]";
                        flag = true;
                    }
                }

                if (StringUtils.isEmpty(rgcostPriceTax)) {
                    vo.setRgcostPriceTax(null);
                } else {
                    try {
                        vo.setRgcostPriceTax(new BigDecimal(rgcostPriceTax));
                    } catch (Exception e) {
                        vo.setRgcostPriceTax(null);
                        warnType = warnType + "[税金只能为数字或小数]";
                        flag = true;
                    }
                }

                if (StringUtils.isEmpty(rgcostMny)) {
                    vo.setRgcostMny(null);
                } else {
                    try {
                        vo.setRgcostMny(new BigDecimal(rgcostMny));
                    } catch (Exception e) {
                        vo.setRgcostMny(null);
                        warnType = warnType + "[不含税合价只能为数字或小数]";
                        flag = true;
                    }
                }

                if (StringUtils.isEmpty(rgcostTaxMny)) {
                    vo.setRgcostTaxMny(null);
                } else {
                    try {
                        vo.setRgcostTaxMny(new BigDecimal(rgcostTaxMny));
                    } catch (Exception e) {
                        vo.setRgcostTaxMny(null);
                        warnType = warnType + "[含税合价只能为数字或小数]";
                        flag = true;
                    }
                }

                if (StringUtils.isEmpty(rgcostTax)) {
                    vo.setRgcostTax(null);
                } else {
                    try {
                        vo.setRgcostTax(new BigDecimal(rgcostTax));
                    } catch (Exception e) {
                        vo.setRgcostTax(null);
                        warnType = warnType + "[税金合价只能为数字或小数]";
                        flag = true;
                    }
                }
//                vo.setRgcostMemo(rgcostMemo);
                vo.setImportFlag(!flag);// true=可以导入，false=不可导入
                if (importFlag) {// 如果能导入
                    importFlag = !flag;
                }
                vo.setWarnType(warnType);
                detailVoList.add(vo);
            }
            List<BuildRgcostVO> successList = new ArrayList<>();
            for (BuildRgcostVO vo : detailVoList) {
                if (vo.getImportFlag()) {
                    if (importFlag) {
                        String indexCode = vo.getIndexCode();
                        Boolean leafFlag = true;
                        for (String code : detailIndexList) {
                            if (code.startsWith(indexCode) && !code.equals(indexCode)) {
                                String sub = code.substring(indexCode.length(), indexCode.length() + 1);
                                if ("-/.".indexOf(sub) != -1) {
                                    leafFlag = false;
                                    break;
                                }
                            }
                        }
                        vo.setLeafFlag(leafFlag);//0-否，1-是
                        vo.setParentId(parentMap.get(vo.getTpid()));
                        successList.add(vo);
                    }
                } else {
                    ImportErrorVo errorVo = new ImportErrorVo();
                    errorVo.setPageName("人工费目标成本控制计划表");
                    errorVo.setId(vo.getId());
                    errorVo.setIndexCode(vo.getIndexCode());
                    errorVo.setCode(vo.getRgcostCode());
                    errorVo.setName(vo.getRgcostName());
                    errorVo.setWarnType(vo.getWarnType());
                    errorList.add(errorVo);
                }
            }
            res.setErrorList(errorList);
            res.setBuildRgcostList(successList);
        }
        return res;
    }

    private ImportBuildVo excelImportSub(List<List<String>> result, Long dutyId) {
        ImportBuildVo res = new ImportBuildVo();
        List<ImportErrorVo> errorList = new ArrayList<>();
        if (result != null && result.size() > 0) {
            List<String> detailIndexList = new ArrayList<>();// 树形编码不能重复
            Map<String, Long> parentMap = new HashMap<>();
            List<BuildSubVO> detailVoList = new ArrayList<>();
            boolean importFlag = true;
            for (int i = 0; i < result.size()-2; i++) {
                List<String> datas = result.get(i);
                BuildSubVO vo = new BuildSubVO();
                boolean flag = false;
                String warnType = "";

                String indexCode = datas.get(0);//序号
                String subCode = datas.get(1); // 编码
                String subName = datas.get(3); // 费用项名称
                String subUnitName = datas.get(4); // 单位
                String subNum = datas.get(5); // 工程量
                String subYsPrice = datas.get(6); // 预算综合单价
                String subYsMny = datas.get(7); // 预算收入-合价
                String subPrice = datas.get(8); // 不含税单价
                String subTaxPrice = datas.get(9); // 含税单价
                String subRate = datas.get(10); // 增值税率(%)
                String subPriceTax = datas.get(11); // 税金
                String subMny = datas.get(12); // 不含税合价
                String subTaxMny = datas.get(14); // 含税合价
                String subTax = datas.get(15); // 税金合价
//                String subMemo = datas.get(14); // 备注

                Long id = IdWorker.getId();
                vo.setId(id);
                vo.setTid(id);
                vo.setDutyId(dutyId);

                if (StringUtils.isNotEmpty(indexCode)) {//序号不为空
                    indexCode = indexCode.trim();// 去除导入时树形编码空格
                    vo.setIndexCode(indexCode);
                    vo.setTreeIndex(indexCode);
                    parentMap.put(indexCode, id);
                    String[] split = indexCode.split("[-/.]");
                    if (split.length > 1) {
                        vo.setTpid(indexCode.substring(0, indexCode.length() - split[split.length - 1].length() - 1));
                    }
//                    vo.setTreeIndex(i + "");
                    if (detailIndexList.contains(indexCode)) {
                        warnType = warnType + "[序号重复]";
                        flag = true;
                    } else {
                        detailIndexList.add(indexCode);
                    }
                } else {
                    vo.setIndexCode(null);
                    warnType = warnType + "[序号为空]";
                    flag = true;
                }

                if (StringUtils.isEmpty(subCode)) {// 编码为空
                    vo.setSubCode(null);
                } else {
                    vo.setSubCode(subCode);
                }

                if (StringUtils.isEmpty(subName)) {//名称为空
                    vo.setSubName(null);
                    warnType = warnType + "[费用项名称为空]";
                    flag = true;
                } else {
                    vo.setSubName(subName);
                }

                vo.setSubUnitName(subUnitName);

                if (StringUtils.isEmpty(subNum)) {
                    vo.setSubNum(null);
                } else {
                    try {
                        vo.setSubNum(new BigDecimal(subNum));
                    } catch (Exception e) {
                        vo.setSubNum(null);
                        warnType = warnType + "[工程量只能为数字或小数]";
                        flag = true;
                    }
                }

                if (StringUtils.isEmpty(subYsPrice)) {
                    vo.setSubYsPrice(null);
                } else {
                    try {
                        vo.setSubYsPrice(new BigDecimal(subYsPrice));
                    } catch (Exception e) {
                        vo.setSubYsPrice(null);
                        warnType = warnType + "[预算综合单价（不含税）只能为数字或小数]";
                        flag = true;
                    }
                }

                if (StringUtils.isEmpty(subYsMny)) {
                    vo.setSubYsMny(null);
                } else {
                    try {
                        vo.setSubYsMny(new BigDecimal(subYsMny));
                    } catch (Exception e) {
                        vo.setSubYsMny(null);
                        warnType = warnType + "[合价只能为数字或小数]";
                        flag = true;
                    }
                }

                if (StringUtils.isEmpty(subPrice)) {
                    vo.setSubPrice(null);
                } else {
                    try {
                        vo.setSubPrice(new BigDecimal(subPrice));
                    } catch (Exception e) {
                        vo.setSubPrice(null);
                        warnType = warnType + "[不含税单价只能为数字或小数]";
                        flag = true;
                    }
                }

                if (StringUtils.isEmpty(subTaxPrice)) {
                    vo.setSubTaxPrice(null);
                } else {
                    try {
                        vo.setSubTaxPrice(new BigDecimal(subTaxPrice));
                    } catch (Exception e) {
                        vo.setSubTaxPrice(null);
                        warnType = warnType + "[含税单价只能为数字或小数]";
                        flag = true;
                    }
                }

                if (StringUtils.isEmpty(subRate)) {
                    vo.setSubRate(null);
                } else {
                    try {
                        vo.setSubRate(new BigDecimal(subRate));
                    } catch (Exception e) {
                        vo.setSubRate(null);
                        warnType = warnType + "[增值税率(%)只能为数字或小数]";
                        flag = true;
                    }
                }

                if (StringUtils.isEmpty(subPriceTax)) {
                    vo.setSubPriceTax(null);
                } else {
                    try {
                        vo.setSubPriceTax(new BigDecimal(subPriceTax));
                    } catch (Exception e) {
                        vo.setSubPriceTax(null);
                        warnType = warnType + "[税金只能为数字或小数]";
                        flag = true;
                    }
                }

                if (StringUtils.isEmpty(subMny)) {
                    vo.setSubMny(null);
                } else {
                    try {
                        vo.setSubMny(new BigDecimal(subMny));
                    } catch (Exception e) {
                        vo.setSubMny(null);
                        warnType = warnType + "[不含税合价只能为数字或小数]";
                        flag = true;
                    }
                }

                if (StringUtils.isEmpty(subTaxMny)) {
                    vo.setSubTaxMny(null);
                } else {
                    try {
                        vo.setSubTaxMny(new BigDecimal(subTaxMny));
                    } catch (Exception e) {
                        vo.setSubTaxMny(null);
                        warnType = warnType + "[含税合价只能为数字或小数]";
                        flag = true;
                    }
                }

                if (StringUtils.isEmpty(subTax)) {
                    vo.setSubTax(null);
                } else {
                    try {
                        vo.setSubTax(new BigDecimal(subTax));
                    } catch (Exception e) {
                        vo.setSubTax(null);
                        warnType = warnType + "[税金合价只能为数字或小数]";
                        flag = true;
                    }
                }
//                vo.setSubMemo(subMemo);
                vo.setImportFlag(!flag);// true=可以导入，false=不可导入
                if (importFlag) {// 如果能导入
                    importFlag = !flag;
                }
                vo.setWarnType(warnType);
                detailVoList.add(vo);
            }
            List<BuildSubVO> successList = new ArrayList<>();
            for (BuildSubVO vo : detailVoList) {
                if (vo.getImportFlag()) {
                    if (importFlag) {
                        String indexCode = vo.getIndexCode();
                        Boolean leafFlag = true;
                        for (String code : detailIndexList) {
                            if (code.startsWith(indexCode) && !code.equals(indexCode)) {
                                String sub = code.substring(indexCode.length(), indexCode.length() + 1);
                                if ("-/.".indexOf(sub) != -1) {
                                    leafFlag = false;
                                    break;
                                }
                            }
                        }
                        vo.setLeafFlag(leafFlag);//0-否，1-是
                        vo.setParentId(parentMap.get(vo.getTpid()));
                        successList.add(vo);
                    }
                } else {
                    ImportErrorVo errorVo = new ImportErrorVo();
                    errorVo.setPageName("分包工程目标成本控制计划表");
                    errorVo.setId(vo.getId());
                    errorVo.setIndexCode(vo.getIndexCode());
                    errorVo.setCode(vo.getSubCode());
                    errorVo.setName(vo.getSubName());
                    errorVo.setWarnType(vo.getWarnType());
                    errorList.add(errorVo);
                }
            }
            res.setErrorList(errorList);
            res.setBuildSubList(successList);
        }
        return res;
    }

    private ImportBuildVo excelImportMaterial(List<List<String>> result, Long dutyId) {
        ImportBuildVo res = new ImportBuildVo();
        List<ImportErrorVo> errorList = new ArrayList<>();
        if (result != null && result.size() > 0) {
            List<String> detailIndexList = new ArrayList<>();// 树形编码不能重复
            Map<String, Long> parentMap = new HashMap<>();
            List<BuildMaterialVO> detailVoList = new ArrayList<>();
            boolean importFlag = true;
            for (int i = 0; i < result.size()-2; i++) {
                List<String> datas = result.get(i);
                BuildMaterialVO vo = new BuildMaterialVO();
                boolean flag = false;
                String warnType = "";

                String indexCode = datas.get(0);//序号
                String materialCode = datas.get(1); // 编码
                String materialName = datas.get(3); // 费用项名称
                String materialSpec = datas.get(4); // 规格型号
                String materialUnitName = datas.get(5); // 单位
                String materialYsNum = datas.get(6); // 预算量
                String materialNum = datas.get(7); // 目标量
                String materialYsPrice = datas.get(8); // 预算收入-单价
                String materialYsMny = datas.get(9); // 预算收入-合价
                String materialPrice = datas.get(10); // 不含税单价
                String materialTaxPrice = datas.get(11); // 含税单价
                String materialRate = datas.get(12); // 增值税率(%)
                String materialPriceTax = datas.get(13); // 税金
                String materialMny = datas.get(14); // 不含税合价
                String materialTaxMny = datas.get(16); // 含税合价
                String materialTax = datas.get(17); // 税金合价
//                String materialMemo = datas.get(12); // 备注

                Long id = IdWorker.getId();
                vo.setId(id);
                vo.setTid(id);
                vo.setDutyId(dutyId);

                if (StringUtils.isNotEmpty(indexCode)) {//序号不为空
                    indexCode = indexCode.trim();// 去除导入时树形编码空格
                    vo.setIndexCode(indexCode);
                    vo.setTreeIndex(indexCode);
                    parentMap.put(indexCode, id);
                    String[] split = indexCode.split("[-/.]");
                    if (split.length > 1) {
                        vo.setTpid(indexCode.substring(0, indexCode.length() - split[split.length - 1].length() - 1));
                    }
//                    vo.setTreeIndex(i + "");
                    if (detailIndexList.contains(indexCode)) {
                        warnType = warnType + "[序号重复]";
                        flag = true;
                    } else {
                        detailIndexList.add(indexCode);
                    }
                } else {
                    vo.setIndexCode(null);
                    warnType = warnType + "[序号为空]";
                    flag = true;
                }

                if (StringUtils.isEmpty(materialCode)) {// 编码为空
                    vo.setMaterialCode(null);
                } else {
                    vo.setMaterialCode(materialCode);
                }

                if (StringUtils.isEmpty(materialName)) {//名称为空
                    vo.setMaterialName(null);
                    warnType = warnType + "[费用项名称为空]";
                    flag = true;
                } else {
                    vo.setMaterialName(materialName);
                }

                vo.setMaterialUnitName(materialUnitName);
                vo.setMaterialSpec(materialSpec);

                if (StringUtils.isEmpty(materialNum)) {
                    vo.setMaterialNum(null);
                } else {
                    try {
                        vo.setMaterialNum(new BigDecimal(materialNum));
                    } catch (Exception e) {
                        vo.setMaterialNum(null);
                        warnType = warnType + "[工程量只能为数字或小数]";
                        flag = true;
                    }
                }

                if (StringUtils.isEmpty(materialYsNum)) {
                    vo.setMaterialYsNum(null);
                } else {
                    try {
                        vo.setMaterialYsNum(new BigDecimal(materialYsNum));
                    } catch (Exception e) {
                        vo.setMaterialYsNum(null);
                        warnType = warnType + "[预算量只能为数字或小数]";
                        flag = true;
                    }
                }

                if (StringUtils.isEmpty(materialYsPrice)) {
                    vo.setMaterialYsPrice(null);
                } else {
                    try {
                        vo.setMaterialYsPrice(new BigDecimal(materialYsPrice));
                    } catch (Exception e) {
                        vo.setMaterialYsPrice(null);
                        warnType = warnType + "[预算-单价只能为数字或小数]";
                        flag = true;
                    }
                }

                if (StringUtils.isEmpty(materialYsMny)) {
                    vo.setMaterialYsMny(null);
                } else {
                    try {
                        vo.setMaterialYsMny(new BigDecimal(materialYsMny));
                    } catch (Exception e) {
                        vo.setMaterialYsMny(null);
                        warnType = warnType + "[合价只能为数字或小数]";
                        flag = true;
                    }
                }

                if (StringUtils.isEmpty(materialPrice)) {
                    vo.setMaterialPrice(null);
                } else {
                    try {
                        vo.setMaterialPrice(new BigDecimal(materialPrice));
                    } catch (Exception e) {
                        vo.setMaterialPrice(null);
                        warnType = warnType + "[不含税单价只能为数字或小数]";
                        flag = true;
                    }
                }

                if (StringUtils.isEmpty(materialTaxPrice)) {
                    vo.setMaterialTaxPrice(null);
                } else {
                    try {
                        vo.setMaterialTaxPrice(new BigDecimal(materialTaxPrice));
                    } catch (Exception e) {
                        vo.setMaterialTaxPrice(null);
                        warnType = warnType + "[含税单价只能为数字或小数]";
                        flag = true;
                    }
                }

                if (StringUtils.isEmpty(materialRate)) {
                    vo.setMaterialRate(null);
                } else {
                    try {
                        vo.setMaterialRate(new BigDecimal(materialRate));
                    } catch (Exception e) {
                        vo.setMaterialRate(null);
                        warnType = warnType + "[增值税率(%)只能为数字或小数]";
                        flag = true;
                    }
                }

                if (StringUtils.isEmpty(materialPriceTax)) {
                    vo.setMaterialPriceTax(null);
                } else {
                    try {
                        vo.setMaterialPriceTax(new BigDecimal(materialPriceTax));
                    } catch (Exception e) {
                        vo.setMaterialPriceTax(null);
                        warnType = warnType + "[税金只能为数字或小数]";
                        flag = true;
                    }
                }

                if (StringUtils.isEmpty(materialMny)) {
                    vo.setMaterialMny(null);
                } else {
                    try {
                        vo.setMaterialMny(new BigDecimal(materialMny));
                    } catch (Exception e) {
                        vo.setMaterialMny(null);
                        warnType = warnType + "[不含税合价只能为数字或小数]";
                        flag = true;
                    }
                }

                if (StringUtils.isEmpty(materialTaxMny)) {
                    vo.setMaterialTaxMny(null);
                } else {
                    try {
                        vo.setMaterialTaxMny(new BigDecimal(materialTaxMny));
                    } catch (Exception e) {
                        vo.setMaterialTaxMny(null);
                        warnType = warnType + "[含税合价只能为数字或小数]";
                        flag = true;
                    }
                }

                if (StringUtils.isEmpty(materialTax)) {
                    vo.setMaterialTax(null);
                } else {
                    try {
                        vo.setMaterialTax(new BigDecimal(materialTax));
                    } catch (Exception e) {
                        vo.setMaterialTax(null);
                        warnType = warnType + "[税金合价只能为数字或小数]";
                        flag = true;
                    }
                }
//                vo.setMaterialMemo(materialMemo);
                vo.setImportFlag(!flag);// true=可以导入，false=不可导入
                if (importFlag) {// 如果能导入
                    importFlag = !flag;
                }
                vo.setWarnType(warnType);
                detailVoList.add(vo);
            }
            List<BuildMaterialVO> successList = new ArrayList<>();
            for (BuildMaterialVO vo : detailVoList) {
                if (vo.getImportFlag()) {
                    if (importFlag) {
                        String indexCode = vo.getIndexCode();
                        Boolean leafFlag = true;
                        for (String code : detailIndexList) {
                            if (code.startsWith(indexCode) && !code.equals(indexCode)) {
                                String sub = code.substring(indexCode.length(), indexCode.length() + 1);
                                if ("-/.".indexOf(sub) != -1) {
                                    leafFlag = false;
                                    break;
                                }
                            }
                        }
                        vo.setLeafFlag(leafFlag);//0-否，1-是
                        vo.setParentId(parentMap.get(vo.getTpid()));
                        successList.add(vo);
                    }
                } else {
                    ImportErrorVo errorVo = new ImportErrorVo();
                    errorVo.setPageName("主要材料目标成本控制计划表");
                    errorVo.setId(vo.getId());
                    errorVo.setIndexCode(vo.getIndexCode());
                    errorVo.setCode(vo.getMaterialCode());
                    errorVo.setName(vo.getMaterialName());
                    errorVo.setWarnType(vo.getWarnType());
                    errorList.add(errorVo);
                }
            }
            res.setErrorList(errorList);
            res.setBuildMaterialList(successList);
        }
        return res;
    }

    private ImportBuildVo excelImportRmat(List<List<String>> result, Long dutyId) {
        ImportBuildVo res = new ImportBuildVo();
        List<ImportErrorVo> errorList = new ArrayList<>();
        if (result != null && result.size() > 0) {
            List<String> detailIndexList = new ArrayList<>();// 树形编码不能重复
            Map<String, Long> parentMap = new HashMap<>();
            List<BuildRmatVO> detailVoList = new ArrayList<>();
            boolean importFlag = true;
            for (int i = 0; i < result.size()-2; i++) {
                List<String> datas = result.get(i);
                BuildRmatVO vo = new BuildRmatVO();
                boolean flag = false;
                String warnType = "";

                String indexCode = datas.get(0);//序号
                String rmatCode = datas.get(1); // 编码
                String rmatName = datas.get(3); // 费用项名称
                String rmatUnitName = datas.get(4); // 单位
                String rmatNum = datas.get(5); // 工程量
                String rmatRentMonth = datas.get(6); // 租用时间
                String rmatCostScale = datas.get(7); // 摊销率(%)
                String rmatPrice = datas.get(8); // 不含税单价
                String rmatTaxPrice = datas.get(9); // 含税单价
                String rmatRate = datas.get(10); // 增值税率(%)
                String rmatPriceTax = datas.get(11); // 税金
                String rmatMny = datas.get(12); // 不含税合价
                String rmatTaxMny = datas.get(14); // 含税合价
                String rmatTax = datas.get(15); // 税金合价

                Long id = IdWorker.getId();
                vo.setId(id);
                vo.setTid(id);
                vo.setDutyId(dutyId);

                if (StringUtils.isNotEmpty(indexCode)) {//序号不为空
                    indexCode = indexCode.trim();// 去除导入时树形编码空格
                    vo.setIndexCode(indexCode);
                    vo.setTreeIndex(indexCode);
                    parentMap.put(indexCode, id);
                    String[] split = indexCode.split("[-/.]");
                    if (split.length > 1) {
                        vo.setTpid(indexCode.substring(0, indexCode.length() - split[split.length - 1].length() - 1));
                    }
//                    vo.setTreeIndex(i + "");
                    if (detailIndexList.contains(indexCode)) {
                        warnType = warnType + "[序号重复]";
                        flag = true;
                    } else {
                        detailIndexList.add(indexCode);
                    }
                } else {
                    vo.setIndexCode(null);
                    warnType = warnType + "[序号为空]";
                    flag = true;
                }

                if (StringUtils.isEmpty(rmatCode)) {// 编码为空
                    vo.setRmatCode(null);
                } else {
                    vo.setRmatCode(rmatCode);
                }

                if (StringUtils.isEmpty(rmatName)) {//名称为空
                    vo.setRmatName(null);
                    warnType = warnType + "[费用项名称为空]";
                    flag = true;
                } else {
                    vo.setRmatName(rmatName);
                }

                vo.setRmatUnitName(rmatUnitName);

                if (StringUtils.isEmpty(rmatNum)) {
                    vo.setRmatNum(null);
                } else {
                    try {
                        vo.setRmatNum(new BigDecimal(rmatNum));
                    } catch (Exception e) {
                        vo.setRmatNum(null);
                        warnType = warnType + "[工程量只能为数字或小数]";
                        flag = true;
                    }
                }

                if (StringUtils.isEmpty(rmatRentMonth)) {
                    vo.setRmatRentMonth(null);
                } else {
                    try {
                        vo.setRmatRentMonth(new BigDecimal(rmatRentMonth));
                    } catch (Exception e) {
                        vo.setRmatRentMonth(null);
                        warnType = warnType + "[租用时间只能为数字或小数]";
                        flag = true;
                    }
                }

                if (StringUtils.isEmpty(rmatCostScale)) {
                    vo.setRmatCostScale(null);
                } else {
                    try {
                        vo.setRmatCostScale(new BigDecimal(rmatCostScale));
                    } catch (Exception e) {
                        vo.setRmatCostScale(null);
                        warnType = warnType + "[摊销率(%)只能为数字或小数]";
                        flag = true;
                    }
                }

                if (StringUtils.isEmpty(rmatPrice)) {
                    vo.setRmatPrice(null);
                } else {
                    try {
                        vo.setRmatPrice(new BigDecimal(rmatPrice));
                    } catch (Exception e) {
                        vo.setRmatPrice(null);
                        warnType = warnType + "[不含税单价只能为数字或小数]";
                        flag = true;
                    }
                }

                if (StringUtils.isEmpty(rmatTaxPrice)) {
                    vo.setRmatTaxPrice(null);
                } else {
                    try {
                        vo.setRmatTaxPrice(new BigDecimal(rmatTaxPrice));
                    } catch (Exception e) {
                        vo.setRmatTaxPrice(null);
                        warnType = warnType + "[含税单价只能为数字或小数]";
                        flag = true;
                    }
                }

                if (StringUtils.isEmpty(rmatRate)) {
                    vo.setRmatRate(null);
                } else {
                    try {
                        vo.setRmatRate(new BigDecimal(rmatRate));
                    } catch (Exception e) {
                        vo.setRmatRate(null);
                        warnType = warnType + "[增值税率(%)只能为数字或小数]";
                        flag = true;
                    }
                }

                if (StringUtils.isEmpty(rmatPriceTax)) {
                    vo.setRmatPriceTax(null);
                } else {
                    try {
                        vo.setRmatPriceTax(new BigDecimal(rmatPriceTax));
                    } catch (Exception e) {
                        vo.setRmatPriceTax(null);
                        warnType = warnType + "[税金只能为数字或小数]";
                        flag = true;
                    }
                }

                if (StringUtils.isEmpty(rmatMny)) {
                    vo.setRmatMny(null);
                } else {
                    try {
                        vo.setRmatMny(new BigDecimal(rmatMny));
                    } catch (Exception e) {
                        vo.setRmatMny(null);
                        warnType = warnType + "[不含税合价只能为数字或小数]";
                        flag = true;
                    }
                }

                if (StringUtils.isEmpty(rmatTaxMny)) {
                    vo.setRmatTaxMny(null);
                } else {
                    try {
                        vo.setRmatTaxMny(new BigDecimal(rmatTaxMny));
                    } catch (Exception e) {
                        vo.setRmatTaxMny(null);
                        warnType = warnType + "[含税合价只能为数字或小数]";
                        flag = true;
                    }
                }

                if (StringUtils.isEmpty(rmatTax)) {
                    vo.setRmatTax(null);
                } else {
                    try {
                        vo.setRmatTax(new BigDecimal(rmatTax));
                    } catch (Exception e) {
                        vo.setRmatTax(null);
                        warnType = warnType + "[税金合价只能为数字或小数]";
                        flag = true;
                    }
                }
//                vo.setRmatMemo(rmatMemo);
                vo.setImportFlag(!flag);// true=可以导入，false=不可导入
                if (importFlag) {// 如果能导入
                    importFlag = !flag;
                }
                vo.setWarnType(warnType);
                detailVoList.add(vo);
            }
            List<BuildRmatVO> successList = new ArrayList<>();
            for (BuildRmatVO vo : detailVoList) {
                if (vo.getImportFlag()) {
                    if (importFlag) {
                        String indexCode = vo.getIndexCode();
                        Boolean leafFlag = true;
                        for (String code : detailIndexList) {
                            if (code.startsWith(indexCode) && !code.equals(indexCode)) {
                                String sub = code.substring(indexCode.length(), indexCode.length() + 1);
                                if ("-/.".indexOf(sub) != -1) {
                                    leafFlag = false;
                                    break;
                                }
                            }
                        }
                        vo.setLeafFlag(leafFlag);//0-否，1-是
                        vo.setParentId(parentMap.get(vo.getTpid()));
                        successList.add(vo);
                    }
                } else {
                    ImportErrorVo errorVo = new ImportErrorVo();
                    errorVo.setPageName("周转材料目标成本控制计划表");
                    errorVo.setId(vo.getId());
                    errorVo.setIndexCode(vo.getIndexCode());
                    errorVo.setCode(vo.getRmatCode());
                    errorVo.setName(vo.getRmatName());
                    errorVo.setWarnType(vo.getWarnType());
                    errorList.add(errorVo);
                }
            }
            res.setErrorList(errorList);
            res.setBuildRmatList(successList);
        }
        return res;
    }

    private ImportBuildVo excelImportEquipment(List<List<String>> result, Long dutyId) {
        ImportBuildVo res = new ImportBuildVo();
        List<ImportErrorVo> errorList = new ArrayList<>();
        if (result != null && result.size() > 0) {
            List<String> detailIndexList = new ArrayList<>();// 树形编码不能重复
            Map<String, Long> parentMap = new HashMap<>();
            List<BuildEquipmentVO> detailVoList = new ArrayList<>();
            boolean importFlag = true;
            for (int i = 0; i < result.size()-2; i++) {
                List<String> datas = result.get(i);
                BuildEquipmentVO vo = new BuildEquipmentVO();
                boolean flag = false;
                String warnType = "";

                String indexCode = datas.get(0);//序号
                String equipmentCode = datas.get(1); // 编码
                String equipmentName = datas.get(3); // 费用项名称
                String equipmentUnitName = datas.get(4); // 单位
                String equipmentNum = datas.get(5); // 工程量
                String equipmentRentMonth = datas.get(6); // 租用时间
                String equipmentCostScale = datas.get(7); // 摊销率(%)
                String equipmentPrice = datas.get(8); // 不含税单价
                String equipmentTaxPrice = datas.get(9); // 含税单价
                String equipmentRate = datas.get(10); // 增值税率(%)
                String equipmentPriceTax = datas.get(11); // 税金
                String equipmentMny = datas.get(12); // 不含税合价
                String equipmentTaxMny = datas.get(14); // 含税合价
                String equipmentTax = datas.get(15); // 税金合价

                Long id = IdWorker.getId();
                vo.setId(id);
                vo.setTid(id);
                vo.setDutyId(dutyId);

                if (StringUtils.isNotEmpty(indexCode)) {//序号不为空
                    indexCode = indexCode.trim();// 去除导入时树形编码空格
                    vo.setIndexCode(indexCode);
                    vo.setTreeIndex(indexCode);
                    parentMap.put(indexCode, id);
                    String[] split = indexCode.split("[-/.]");
                    if (split.length > 1) {
                        vo.setTpid(indexCode.substring(0, indexCode.length() - split[split.length - 1].length() - 1));
                    }
//                    vo.setTreeIndex(i + "");
                    if (detailIndexList.contains(indexCode)) {
                        warnType = warnType + "[序号重复]";
                        flag = true;
                    } else {
                        detailIndexList.add(indexCode);
                    }
                } else {
                    vo.setIndexCode(null);
                    warnType = warnType + "[序号为空]";
                    flag = true;
                }

                if (StringUtils.isEmpty(equipmentCode)) {// 编码为空
                    vo.setEquipmentCode(null);
                } else {
                    vo.setEquipmentCode(equipmentCode);
                }

                if (StringUtils.isEmpty(equipmentName)) {//名称为空
                    vo.setEquipmentName(null);
                    warnType = warnType + "[费用项名称为空]";
                    flag = true;
                } else {
                    vo.setEquipmentName(equipmentName);
                }

                vo.setEquipmentUnitName(equipmentUnitName);

                if (StringUtils.isEmpty(equipmentNum)) {
                    vo.setEquipmentNum(null);
                } else {
                    try {
                        vo.setEquipmentNum(new BigDecimal(equipmentNum));
                    } catch (Exception e) {
                        vo.setEquipmentNum(null);
                        warnType = warnType + "[工程量只能为数字或小数]";
                        flag = true;
                    }
                }

                if (StringUtils.isEmpty(equipmentRentMonth)) {
                    vo.setEquipmentRentMonth(null);
                } else {
                    try {
                        vo.setEquipmentRentMonth(new BigDecimal(equipmentRentMonth));
                    } catch (Exception e) {
                        vo.setEquipmentRentMonth(null);
                        warnType = warnType + "[租用时间只能为数字或小数]";
                        flag = true;
                    }
                }

                if (StringUtils.isEmpty(equipmentCostScale)) {
                    vo.setEquipmentCostScale(null);
                } else {
                    try {
                        vo.setEquipmentCostScale(new BigDecimal(equipmentCostScale));
                    } catch (Exception e) {
                        vo.setEquipmentCostScale(null);
                        warnType = warnType + "[摊销率(%)只能为数字或小数]";
                        flag = true;
                    }
                }

                if (StringUtils.isEmpty(equipmentPrice)) {
                    vo.setEquipmentPrice(null);
                } else {
                    try {
                        vo.setEquipmentPrice(new BigDecimal(equipmentPrice));
                    } catch (Exception e) {
                        vo.setEquipmentPrice(null);
                        warnType = warnType + "[不含税单价只能为数字或小数]";
                        flag = true;
                    }
                }

                if (StringUtils.isEmpty(equipmentTaxPrice)) {
                    vo.setEquipmentTaxPrice(null);
                } else {
                    try {
                        vo.setEquipmentTaxPrice(new BigDecimal(equipmentTaxPrice));
                    } catch (Exception e) {
                        vo.setEquipmentTaxPrice(null);
                        warnType = warnType + "[含税单价只能为数字或小数]";
                        flag = true;
                    }
                }

                if (StringUtils.isEmpty(equipmentRate)) {
                    vo.setEquipmentRate(null);
                } else {
                    try {
                        vo.setEquipmentRate(new BigDecimal(equipmentRate));
                    } catch (Exception e) {
                        vo.setEquipmentRate(null);
                        warnType = warnType + "[增值税率(%)只能为数字或小数]";
                        flag = true;
                    }
                }

                if (StringUtils.isEmpty(equipmentPriceTax)) {
                    vo.setEquipmentPriceTax(null);
                } else {
                    try {
                        vo.setEquipmentPriceTax(new BigDecimal(equipmentPriceTax));
                    } catch (Exception e) {
                        vo.setEquipmentPriceTax(null);
                        warnType = warnType + "[税金只能为数字或小数]";
                        flag = true;
                    }
                }

                if (StringUtils.isEmpty(equipmentMny)) {
                    vo.setEquipmentMny(null);
                } else {
                    try {
                        vo.setEquipmentMny(new BigDecimal(equipmentMny));
                    } catch (Exception e) {
                        vo.setEquipmentMny(null);
                        warnType = warnType + "[不含税合价只能为数字或小数]";
                        flag = true;
                    }
                }

                if (StringUtils.isEmpty(equipmentTaxMny)) {
                    vo.setEquipmentTaxMny(null);
                } else {
                    try {
                        vo.setEquipmentTaxMny(new BigDecimal(equipmentTaxMny));
                    } catch (Exception e) {
                        vo.setEquipmentTaxMny(null);
                        warnType = warnType + "[含税合价只能为数字或小数]";
                        flag = true;
                    }
                }

                if (StringUtils.isEmpty(equipmentTax)) {
                    vo.setEquipmentTax(null);
                } else {
                    try {
                        vo.setEquipmentTax(new BigDecimal(equipmentTax));
                    } catch (Exception e) {
                        vo.setEquipmentTax(null);
                        warnType = warnType + "[税金合价只能为数字或小数]";
                        flag = true;
                    }
                }
//                vo.setEquipmentMemo(equipmentMemo);
                vo.setImportFlag(!flag);// true=可以导入，false=不可导入
                if (importFlag) {// 如果能导入
                    importFlag = !flag;
                }
                vo.setWarnType(warnType);
                detailVoList.add(vo);
            }
            List<BuildEquipmentVO> successList = new ArrayList<>();
            for (BuildEquipmentVO vo : detailVoList) {
                if (vo.getImportFlag()) {
                    if (importFlag) {
                        String indexCode = vo.getIndexCode();
                        Boolean leafFlag = true;
                        for (String code : detailIndexList) {
                            if (code.startsWith(indexCode) && !code.equals(indexCode)) {
                                String sub = code.substring(indexCode.length(), indexCode.length() + 1);
                                if ("-/.".indexOf(sub) != -1) {
                                    leafFlag = false;
                                    break;
                                }
                            }
                        }
                        vo.setLeafFlag(leafFlag);//0-否，1-是
                        vo.setParentId(parentMap.get(vo.getTpid()));
                        successList.add(vo);
                    }
                } else {
                    ImportErrorVo errorVo = new ImportErrorVo();
                    errorVo.setPageName("机械使用费目标成本控制计划表");
                    errorVo.setId(vo.getId());
                    errorVo.setIndexCode(vo.getIndexCode());
                    errorVo.setCode(vo.getEquipmentCode());
                    errorVo.setName(vo.getEquipmentName());
                    errorVo.setWarnType(vo.getWarnType());
                    errorList.add(errorVo);
                }
            }
            res.setErrorList(errorList);
            res.setBuildEquipmentList(successList);
        }
        return res;
    }

    private ImportBuildVo excelImportSafe(List<List<String>> result, Long dutyId) {
        ImportBuildVo res = new ImportBuildVo();
        List<ImportErrorVo> errorList = new ArrayList<>();
        if (result != null && result.size() > 0) {
            List<String> detailIndexList = new ArrayList<>();// 树形编码不能重复
            Map<String, Long> parentMap = new HashMap<>();
            List<BuildSafeVO> detailVoList = new ArrayList<>();
            boolean importFlag = true;
            for (int i = 0; i < result.size()-2; i++) {
                List<String> datas = result.get(i);
                BuildSafeVO vo = new BuildSafeVO();
                boolean flag = false;
                String warnType = "";

                String indexCode = datas.get(0);//序号
                String safeCode = datas.get(1); // 编码
                String safeName = datas.get(3); // 费用项名称
                String safeUnitName = datas.get(4); // 单位
                String safeNum = datas.get(5); // 工程量
                String safeCostScale = datas.get(6); // 摊销率(%)
                String safePrice = datas.get(7); // 不含税单价
                String safeTaxPrice = datas.get(8); // 含税单价
                String safeRate = datas.get(9); // 增值税率(%)
                String safePriceTax = datas.get(10); // 税金
                String safeMny = datas.get(11); // 不含税合价
                String safeTaxMny = datas.get(13); // 含税合价
                String safeTax = datas.get(14); // 税金合价
//                String safeMemo = datas.get(13); // 备注

                Long id = IdWorker.getId();
                vo.setId(id);
                vo.setTid(id);
                vo.setDutyId(dutyId);

                if (StringUtils.isNotEmpty(indexCode)) {//序号不为空
                    indexCode = indexCode.trim();// 去除导入时树形编码空格
                    vo.setIndexCode(indexCode);
                    vo.setTreeIndex(indexCode);
                    parentMap.put(indexCode, id);
                    String[] split = indexCode.split("[-/.]");
                    if (split.length > 1) {
                        vo.setTpid(indexCode.substring(0, indexCode.length() - split[split.length - 1].length() - 1));
                    }
//                    vo.setTreeIndex(i + "");
                    if (detailIndexList.contains(indexCode)) {
                        warnType = warnType + "[序号重复]";
                        flag = true;
                    } else {
                        detailIndexList.add(indexCode);
                    }
                } else {
                    vo.setIndexCode(null);
                    warnType = warnType + "[序号为空]";
                    flag = true;
                }

                if (StringUtils.isEmpty(safeCode)) {// 编码为空
                    vo.setSafeCode(null);
                } else {
                    vo.setSafeCode(safeCode);
                }

                if (StringUtils.isEmpty(safeName)) {//名称为空
                    vo.setSafeName(null);
                    warnType = warnType + "[费用项名称为空]";
                    flag = true;
                } else {
                    vo.setSafeName(safeName);
                }

                vo.setSafeUnitName(safeUnitName);

                if (StringUtils.isEmpty(safeNum)) {
                    vo.setSafeNum(null);
                } else {
                    try {
                        vo.setSafeNum(new BigDecimal(safeNum));
                    } catch (Exception e) {
                        vo.setSafeNum(null);
                        warnType = warnType + "[工程量只能为数字或小数]";
                        flag = true;
                    }
                }


                if (StringUtils.isEmpty(safeCostScale)) {
                    vo.setSafeCostScale(null);
                } else {
                    try {
                        vo.setSafeCostScale(new BigDecimal(safeCostScale));
                    } catch (Exception e) {
                        vo.setSafeCostScale(null);
                        warnType = warnType + "[ 摊销率(%)只能为数字或小数]";
                        flag = true;
                    }
                }
                if (StringUtils.isEmpty(safePrice)) {
                    vo.setSafePrice(null);
                } else {
                    try {
                        vo.setSafePrice(new BigDecimal(safePrice));
                    } catch (Exception e) {
                        vo.setSafePrice(null);
                        warnType = warnType + "[不含税单价只能为数字或小数]";
                        flag = true;
                    }
                }

                if (StringUtils.isEmpty(safeTaxPrice)) {
                    vo.setSafeTaxPrice(null);
                } else {
                    try {
                        vo.setSafeTaxPrice(new BigDecimal(safeTaxPrice));
                    } catch (Exception e) {
                        vo.setSafeTaxPrice(null);
                        warnType = warnType + "[含税单价只能为数字或小数]";
                        flag = true;
                    }
                }

                if (StringUtils.isEmpty(safeRate)) {
                    vo.setSafeRate(null);
                } else {
                    try {
                        vo.setSafeRate(new BigDecimal(safeRate));
                    } catch (Exception e) {
                        vo.setSafeRate(null);
                        warnType = warnType + "[增值税率(%)只能为数字或小数]";
                        flag = true;
                    }
                }

                if (StringUtils.isEmpty(safePriceTax)) {
                    vo.setSafePriceTax(null);
                } else {
                    try {
                        vo.setSafePriceTax(new BigDecimal(safePriceTax));
                    } catch (Exception e) {
                        vo.setSafePriceTax(null);
                        warnType = warnType + "[税金只能为数字或小数]";
                        flag = true;
                    }
                }

                if (StringUtils.isEmpty(safeMny)) {
                    vo.setSafeMny(null);
                } else {
                    try {
                        vo.setSafeMny(new BigDecimal(safeMny));
                    } catch (Exception e) {
                        vo.setSafeMny(null);
                        warnType = warnType + "[不含税合价只能为数字或小数]";
                        flag = true;
                    }
                }

                if (StringUtils.isEmpty(safeTaxMny)) {
                    vo.setSafeTaxMny(null);
                } else {
                    try {
                        vo.setSafeTaxMny(new BigDecimal(safeTaxMny));
                    } catch (Exception e) {
                        vo.setSafeTaxMny(null);
                        warnType = warnType + "[含税合价只能为数字或小数]";
                        flag = true;
                    }
                }

                if (StringUtils.isEmpty(safeTax)) {
                    vo.setSafeTax(null);
                } else {
                    try {
                        vo.setSafeTax(new BigDecimal(safeTax));
                    } catch (Exception e) {
                        vo.setSafeTax(null);
                        warnType = warnType + "[税金合价只能为数字或小数]";
                        flag = true;
                    }
                }
//                vo.setSafeMemo(safeMemo);
                vo.setImportFlag(!flag);// true=可以导入，false=不可导入
                if (importFlag) {// 如果能导入
                    importFlag = !flag;
                }
                vo.setWarnType(warnType);
                detailVoList.add(vo);
            }
            List<BuildSafeVO> successList = new ArrayList<>();
            for (BuildSafeVO vo : detailVoList) {
                if (vo.getImportFlag()) {
                    if (importFlag) {
                        String indexCode = vo.getIndexCode();
                        Boolean leafFlag = true;
                        for (String code : detailIndexList) {
                            if (code.startsWith(indexCode) && !code.equals(indexCode)) {
                                String sub = code.substring(indexCode.length(), indexCode.length() + 1);
                                if ("-/.".indexOf(sub) != -1) {
                                    leafFlag = false;
                                    break;
                                }
                            }
                        }
                        vo.setLeafFlag(leafFlag);//0-否，1-是
                        vo.setParentId(parentMap.get(vo.getTpid()));
                        successList.add(vo);
                    }
                } else {
                    ImportErrorVo errorVo = new ImportErrorVo();
                    errorVo.setPageName("安全文明施工费目标成本计划表");
                    errorVo.setId(vo.getId());
                    errorVo.setIndexCode(vo.getIndexCode());
                    errorVo.setCode(vo.getSafeCode());
                    errorVo.setName(vo.getSafeName());
                    errorVo.setWarnType(vo.getWarnType());
                    errorList.add(errorVo);
                }
            }
            res.setErrorList(errorList);
            res.setBuildSafeList(successList);
        }
        return res;
    }

    private ImportBuildVo excelImportTemporary(List<List<String>> result, Long dutyId) {
        ImportBuildVo res = new ImportBuildVo();
        List<ImportErrorVo> errorList = new ArrayList<>();
        if (result != null && result.size() > 0) {
            List<String> detailIndexList = new ArrayList<>();// 树形编码不能重复
            Map<String, Long> parentMap = new HashMap<>();
            List<BuildTemporaryVO> detailVoList = new ArrayList<>();
            boolean importFlag = true;
            for (int i = 0; i < result.size()-2; i++) {
                List<String> datas = result.get(i);
                BuildTemporaryVO vo = new BuildTemporaryVO();
                boolean flag = false;
                String warnType = "";

                String indexCode = datas.get(0);//序号
                String temporaryCode = datas.get(1); // 编码
                String temporaryName = datas.get(3); // 费用项名称
                String temporaryUnitName = datas.get(4); // 单位
                String temporaryNum = datas.get(5); // 工程量
                String temporaryCostScale = datas.get(6); // 摊销率(%)
                String temporaryPrice = datas.get(7); // 不含税单价
                String temporaryTaxPrice = datas.get(8); // 含税单价
                String temporaryRate = datas.get(9); // 增值税率(%)
                String temporaryPriceTax = datas.get(10); // 税金
                String temporaryMny = datas.get(11); // 不含税合价
                String temporaryTaxMny = datas.get(13); // 含税合价
                String temporaryTax = datas.get(14); // 税金合价
//                String temporaryMemo = datas.get(13); // 备注

                Long id = IdWorker.getId();
                vo.setId(id);
                vo.setTid(id);
                vo.setDutyId(dutyId);

                if (StringUtils.isNotEmpty(indexCode)) {//序号不为空
                    indexCode = indexCode.trim();// 去除导入时树形编码空格
                    vo.setIndexCode(indexCode);
                    vo.setTreeIndex(indexCode);
                    parentMap.put(indexCode, id);
                    String[] split = indexCode.split("[-/.]");
                    if (split.length > 1) {
                        vo.setTpid(indexCode.substring(0, indexCode.length() - split[split.length - 1].length() - 1));
                    }
//                    vo.setTreeIndex(i + "");
                    if (detailIndexList.contains(indexCode)) {
                        warnType = warnType + "[序号重复]";
                        flag = true;
                    } else {
                        detailIndexList.add(indexCode);
                    }
                } else {
                    vo.setIndexCode(null);
                    warnType = warnType + "[序号为空]";
                    flag = true;
                }

                if (StringUtils.isEmpty(temporaryCode)) {// 编码为空
                    vo.setTemporaryCode(null);
                } else {
                    vo.setTemporaryCode(temporaryCode);
                }

                if (StringUtils.isEmpty(temporaryName)) {//名称为空
                    vo.setTemporaryName(null);
                    warnType = warnType + "[费用项名称为空]";
                    flag = true;
                } else {
                    vo.setTemporaryName(temporaryName);
                }

                vo.setTemporaryUnitName(temporaryUnitName);

                if (StringUtils.isEmpty(temporaryNum)) {
                    vo.setTemporaryNum(null);
                } else {
                    try {
                        vo.setTemporaryNum(new BigDecimal(temporaryNum));
                    } catch (Exception e) {
                        vo.setTemporaryNum(null);
                        warnType = warnType + "[工程量只能为数字或小数]";
                        flag = true;
                    }
                }


                if (StringUtils.isEmpty(temporaryCostScale)) {
                    vo.setTemporaryCostScale(null);
                } else {
                    try {
                        vo.setTemporaryCostScale(new BigDecimal(temporaryCostScale));
                    } catch (Exception e) {
                        vo.setTemporaryCostScale(null);
                        warnType = warnType + "[ 摊销率(%)只能为数字或小数]";
                        flag = true;
                    }
                }
                if (StringUtils.isEmpty(temporaryPrice)) {
                    vo.setTemporaryPrice(null);
                } else {
                    try {
                        vo.setTemporaryPrice(new BigDecimal(temporaryPrice));
                    } catch (Exception e) {
                        vo.setTemporaryPrice(null);
                        warnType = warnType + "[不含税单价只能为数字或小数]";
                        flag = true;
                    }
                }

                if (StringUtils.isEmpty(temporaryTaxPrice)) {
                    vo.setTemporaryTaxPrice(null);
                } else {
                    try {
                        vo.setTemporaryTaxPrice(new BigDecimal(temporaryTaxPrice));
                    } catch (Exception e) {
                        vo.setTemporaryTaxPrice(null);
                        warnType = warnType + "[含税单价只能为数字或小数]";
                        flag = true;
                    }
                }

                if (StringUtils.isEmpty(temporaryRate)) {
                    vo.setTemporaryRate(null);
                } else {
                    try {
                        vo.setTemporaryRate(new BigDecimal(temporaryRate));
                    } catch (Exception e) {
                        vo.setTemporaryRate(null);
                        warnType = warnType + "[增值税率(%)只能为数字或小数]";
                        flag = true;
                    }
                }

                if (StringUtils.isEmpty(temporaryPriceTax)) {
                    vo.setTemporaryPriceTax(null);
                } else {
                    try {
                        vo.setTemporaryPriceTax(new BigDecimal(temporaryPriceTax));
                    } catch (Exception e) {
                        vo.setTemporaryPriceTax(null);
                        warnType = warnType + "[税金只能为数字或小数]";
                        flag = true;
                    }
                }

                if (StringUtils.isEmpty(temporaryMny)) {
                    vo.setTemporaryMny(null);
                } else {
                    try {
                        vo.setTemporaryMny(new BigDecimal(temporaryMny));
                    } catch (Exception e) {
                        vo.setTemporaryMny(null);
                        warnType = warnType + "[不含税合价只能为数字或小数]";
                        flag = true;
                    }
                }

                if (StringUtils.isEmpty(temporaryTaxMny)) {
                    vo.setTemporaryTaxMny(null);
                } else {
                    try {
                        vo.setTemporaryTaxMny(new BigDecimal(temporaryTaxMny));
                    } catch (Exception e) {
                        vo.setTemporaryTaxMny(null);
                        warnType = warnType + "[含税合价只能为数字或小数]";
                        flag = true;
                    }
                }

                if (StringUtils.isEmpty(temporaryTax)) {
                    vo.setTemporaryTax(null);
                } else {
                    try {
                        vo.setTemporaryTax(new BigDecimal(temporaryTax));
                    } catch (Exception e) {
                        vo.setTemporaryTax(null);
                        warnType = warnType + "[税金合价只能为数字或小数]";
                        flag = true;
                    }
                }
//                vo.setTemporaryMemo(temporaryMemo);
                vo.setImportFlag(!flag);// true=可以导入，false=不可导入
                if (importFlag) {// 如果能导入
                    importFlag = !flag;
                }
                vo.setWarnType(warnType);
                detailVoList.add(vo);
            }
            List<BuildTemporaryVO> successList = new ArrayList<>();
            for (BuildTemporaryVO vo : detailVoList) {
                if (vo.getImportFlag()) {
                    if (importFlag) {
                        String indexCode = vo.getIndexCode();
                        Boolean leafFlag = true;
                        for (String code : detailIndexList) {
                            if (code.startsWith(indexCode) && !code.equals(indexCode)) {
                                String sub = code.substring(indexCode.length(), indexCode.length() + 1);
                                if ("-/.".indexOf(sub) != -1) {
                                    leafFlag = false;
                                    break;
                                }
                            }
                        }
                        vo.setLeafFlag(leafFlag);//0-否，1-是
                        vo.setParentId(parentMap.get(vo.getTpid()));
                        successList.add(vo);
                    }
                } else {
                    ImportErrorVo errorVo = new ImportErrorVo();
                    errorVo.setPageName("临时设施费目标成本计划表");
                    errorVo.setId(vo.getId());
                    errorVo.setIndexCode(vo.getIndexCode());
                    errorVo.setCode(vo.getTemporaryCode());
                    errorVo.setName(vo.getTemporaryName());
                    errorVo.setWarnType(vo.getWarnType());
                    errorList.add(errorVo);
                }
            }
            res.setErrorList(errorList);
            res.setBuildTemporaryList(successList);
        }
        return res;
    }

    private ImportBuildVo excelImportMeasure(List<List<String>> result, Long dutyId) {
        ImportBuildVo res = new ImportBuildVo();
        List<ImportErrorVo> errorList = new ArrayList<>();
        if (result != null && result.size() > 0) {
            List<String> detailIndexList = new ArrayList<>();// 树形编码不能重复
            Map<String, Long> parentMap = new HashMap<>();
            List<BuildMeasureVO> detailVoList = new ArrayList<>();
            boolean importFlag = true;
            for (int i = 0; i < result.size()-2; i++) {
                List<String> datas = result.get(i);
                BuildMeasureVO vo = new BuildMeasureVO();
                boolean flag = false;
                String warnType = "";

                String indexCode = datas.get(0);//序号
                String measureCode = datas.get(1); // 编码
                String measureName = datas.get(3); // 费用项名称
                String measureUnitName = datas.get(4); // 单位
                String measureNum = datas.get(5); // 工程量
                String measureCostScale = datas.get(6); // 摊销率(%)
                String measurePrice = datas.get(7); // 不含税单价
                String measureTaxPrice = datas.get(8); // 含税单价
                String measureRate = datas.get(9); // 增值税率(%)
                String measurePriceTax = datas.get(10); // 税金
                String measureMny = datas.get(11); // 不含税合价
                String measureTaxMny = datas.get(13); // 含税合价
                String measureTax = datas.get(14); // 税金合价
//                String measureMemo = datas.get(13); // 备注

                Long id = IdWorker.getId();
                vo.setId(id);
                vo.setTid(id);
                vo.setDutyId(dutyId);

                if (StringUtils.isNotEmpty(indexCode)) {//序号不为空
                    indexCode = indexCode.trim();// 去除导入时树形编码空格
                    vo.setIndexCode(indexCode);
                    vo.setTreeIndex(indexCode);
                    parentMap.put(indexCode, id);
                    String[] split = indexCode.split("[-/.]");
                    if (split.length > 1) {
                        vo.setTpid(indexCode.substring(0, indexCode.length() - split[split.length - 1].length() - 1));
                    }
//                    vo.setTreeIndex(i + "");
                    if (detailIndexList.contains(indexCode)) {
                        warnType = warnType + "[序号重复]";
                        flag = true;
                    } else {
                        detailIndexList.add(indexCode);
                    }
                } else {
                    vo.setIndexCode(null);
                    warnType = warnType + "[序号为空]";
                    flag = true;
                }

                if (StringUtils.isEmpty(measureCode)) {// 编码为空
                    vo.setMeasureCode(null);
                } else {
                    vo.setMeasureCode(measureCode);
                }

                if (StringUtils.isEmpty(measureName)) {//名称为空
                    vo.setMeasureName(null);
                    warnType = warnType + "[费用项名称为空]";
                    flag = true;
                } else {
                    vo.setMeasureName(measureName);
                }

                vo.setMeasureUnitName(measureUnitName);

                if (StringUtils.isEmpty(measureNum)) {
                    vo.setMeasureNum(null);
                } else {
                    try {
                        vo.setMeasureNum(new BigDecimal(measureNum));
                    } catch (Exception e) {
                        vo.setMeasureNum(null);
                        warnType = warnType + "[工程量只能为数字或小数]";
                        flag = true;
                    }
                }


                if (StringUtils.isEmpty(measureCostScale)) {
                    vo.setMeasureCostScale(null);
                } else {
                    try {
                        vo.setMeasureCostScale(new BigDecimal(measureCostScale));
                    } catch (Exception e) {
                        vo.setMeasureCostScale(null);
                        warnType = warnType + "[ 摊销率(%)只能为数字或小数]";
                        flag = true;
                    }
                }
                if (StringUtils.isEmpty(measurePrice)) {
                    vo.setMeasurePrice(null);
                } else {
                    try {
                        vo.setMeasurePrice(new BigDecimal(measurePrice));
                    } catch (Exception e) {
                        vo.setMeasurePrice(null);
                        warnType = warnType + "[不含税单价只能为数字或小数]";
                        flag = true;
                    }
                }

                if (StringUtils.isEmpty(measureTaxPrice)) {
                    vo.setMeasureTaxPrice(null);
                } else {
                    try {
                        vo.setMeasureTaxPrice(new BigDecimal(measureTaxPrice));
                    } catch (Exception e) {
                        vo.setMeasureTaxPrice(null);
                        warnType = warnType + "[含税单价只能为数字或小数]";
                        flag = true;
                    }
                }

                if (StringUtils.isEmpty(measureRate)) {
                    vo.setMeasureRate(null);
                } else {
                    try {
                        vo.setMeasureRate(new BigDecimal(measureRate));
                    } catch (Exception e) {
                        vo.setMeasureRate(null);
                        warnType = warnType + "[增值税率(%)只能为数字或小数]";
                        flag = true;
                    }
                }

                if (StringUtils.isEmpty(measurePriceTax)) {
                    vo.setMeasurePriceTax(null);
                } else {
                    try {
                        vo.setMeasurePriceTax(new BigDecimal(measurePriceTax));
                    } catch (Exception e) {
                        vo.setMeasurePriceTax(null);
                        warnType = warnType + "[税金只能为数字或小数]";
                        flag = true;
                    }
                }

                if (StringUtils.isEmpty(measureMny)) {
                    vo.setMeasureMny(null);
                } else {
                    try {
                        vo.setMeasureMny(new BigDecimal(measureMny));
                    } catch (Exception e) {
                        vo.setMeasureMny(null);
                        warnType = warnType + "[不含税合价只能为数字或小数]";
                        flag = true;
                    }
                }

                if (StringUtils.isEmpty(measureTaxMny)) {
                    vo.setMeasureTaxMny(null);
                } else {
                    try {
                        vo.setMeasureTaxMny(new BigDecimal(measureTaxMny));
                    } catch (Exception e) {
                        vo.setMeasureTaxMny(null);
                        warnType = warnType + "[含税合价只能为数字或小数]";
                        flag = true;
                    }
                }

                if (StringUtils.isEmpty(measureTax)) {
                    vo.setMeasureTax(null);
                } else {
                    try {
                        vo.setMeasureTax(new BigDecimal(measureTax));
                    } catch (Exception e) {
                        vo.setMeasureTax(null);
                        warnType = warnType + "[税金合价只能为数字或小数]";
                        flag = true;
                    }
                }
//                vo.setMeasureMemo(measureMemo);
                vo.setImportFlag(!flag);// true=可以导入，false=不可导入
                if (importFlag) {// 如果能导入
                    importFlag = !flag;
                }
                vo.setWarnType(warnType);
                detailVoList.add(vo);
            }
            List<BuildMeasureVO> successList = new ArrayList<>();
            for (BuildMeasureVO vo : detailVoList) {
                if (vo.getImportFlag()) {
                    if (importFlag) {
                        String indexCode = vo.getIndexCode();
                        Boolean leafFlag = true;
                        for (String code : detailIndexList) {
                            if (code.startsWith(indexCode) && !code.equals(indexCode)) {
                                String sub = code.substring(indexCode.length(), indexCode.length() + 1);
                                if ("-/.".indexOf(sub) != -1) {
                                    leafFlag = false;
                                    break;
                                }
                            }
                        }
                        vo.setLeafFlag(leafFlag);//0-否，1-是
                        vo.setParentId(parentMap.get(vo.getTpid()));
                        successList.add(vo);
                    }
                } else {
                    ImportErrorVo errorVo = new ImportErrorVo();
                    errorVo.setPageName("其他措施费目标成本计划表");
                    errorVo.setId(vo.getId());
                    errorVo.setIndexCode(vo.getIndexCode());
                    errorVo.setCode(vo.getMeasureCode());
                    errorVo.setName(vo.getMeasureName());
                    errorVo.setWarnType(vo.getWarnType());
                    errorList.add(errorVo);
                }
            }
            res.setErrorList(errorList);
            res.setBuildMeasureList(successList);
        }
        return res;
    }

    private ImportBuildVo excelImportManage(List<List<String>> result, Long dutyId) {
        ImportBuildVo res = new ImportBuildVo();
        List<ImportErrorVo> errorList = new ArrayList<>();
        if (result != null && result.size() > 0) {
            List<String> detailIndexList = new ArrayList<>();// 树形编码不能重复
            Map<String, Long> parentMap = new HashMap<>();
            List<BuildManageVO> detailVoList = new ArrayList<>();
            boolean importFlag = true;
            for (int i = 0; i < result.size()-2; i++) {
                List<String> datas = result.get(i);
                BuildManageVO vo = new BuildManageVO();
                boolean flag = false;
                String warnType = "";

                String indexCode = datas.get(0);//序号
                String manageCode = datas.get(1); // 编码
                String manageName = datas.get(3); // 费用项名称
                String manageUnitName = datas.get(4); // 单位
                String manageNum = datas.get(5); // 工程量
                String manageDuration = datas.get(6); // 工期
                String manageCostScale = datas.get(7); // 摊销率(%)
                String managePrice = datas.get(8); // 不含税单价
                String manageTaxPrice = datas.get(9); // 含税单价
                String manageRate = datas.get(10); // 增值税率(%)
                String managePriceTax = datas.get(11); // 税金
                String manageMny = datas.get(12); // 不含税合价
                String manageTaxMny = datas.get(14); // 含税合价
                String manageTax = datas.get(15); // 税金合价
//                String manageMemo = datas.get(13); // 备注

                Long id = IdWorker.getId();
                vo.setId(id);
                vo.setTid(id);
                vo.setDutyId(dutyId);

                if (StringUtils.isNotEmpty(indexCode)) {//序号不为空
                    indexCode = indexCode.trim();// 去除导入时树形编码空格
                    vo.setIndexCode(indexCode);
                    vo.setTreeIndex(indexCode);
                    parentMap.put(indexCode, id);
                    String[] split = indexCode.split("[-/.]");
                    if (split.length > 1) {
                        vo.setTpid(indexCode.substring(0, indexCode.length() - split[split.length - 1].length() - 1));
                    }
//                    vo.setTreeIndex(i + "");
                    if (detailIndexList.contains(indexCode)) {
                        warnType = warnType + "[序号重复]";
                        flag = true;
                    } else {
                        detailIndexList.add(indexCode);
                    }
                } else {
                    vo.setIndexCode(null);
                    warnType = warnType + "[序号为空]";
                    flag = true;
                }

                if (StringUtils.isEmpty(manageCode)) {// 编码为空
                    vo.setManageCode(null);
                } else {
                    vo.setManageCode(manageCode);
                }

                if (StringUtils.isEmpty(manageName)) {//名称为空
                    vo.setManageName(null);
                    warnType = warnType + "[费用项名称为空]";
                    flag = true;
                } else {
                    vo.setManageName(manageName);
                }

                vo.setManageUnitName(manageUnitName);

                if (StringUtils.isEmpty(manageNum)) {
                    vo.setManageNum(null);
                } else {
                    try {
                        vo.setManageNum(new BigDecimal(manageNum));
                    } catch (Exception e) {
                        vo.setManageNum(null);
                        warnType = warnType + "[工程量只能为数字或小数]";
                        flag = true;
                    }
                }

                if (StringUtils.isEmpty(manageDuration)) {
                    vo.setManageDuration(null);
                } else {
                    try {
                        vo.setManageDuration(new BigDecimal(manageDuration));
                    } catch (Exception e) {
                        vo.setManageDuration(null);
                        warnType = warnType + "[工期只能为数字或小数]";
                        flag = true;
                    }
                }
                if (StringUtils.isEmpty(manageCostScale)) {
                    vo.setManageCostScale(null);
                } else {
                    try {
                        vo.setManageCostScale(new BigDecimal(manageCostScale));
                    } catch (Exception e) {
                        vo.setManageCostScale(null);
                        warnType = warnType + "[ 摊销率(%)只能为数字或小数]";
                        flag = true;
                    }
                }
                if (StringUtils.isEmpty(managePrice)) {
                    vo.setManagePrice(null);
                } else {
                    try {
                        vo.setManagePrice(new BigDecimal(managePrice));
                    } catch (Exception e) {
                        vo.setManagePrice(null);
                        warnType = warnType + "[不含税单价只能为数字或小数]";
                        flag = true;
                    }
                }

                if (StringUtils.isEmpty(manageTaxPrice)) {
                    vo.setManageTaxPrice(null);
                } else {
                    try {
                        vo.setManageTaxPrice(new BigDecimal(manageTaxPrice));
                    } catch (Exception e) {
                        vo.setManageTaxPrice(null);
                        warnType = warnType + "[含税单价只能为数字或小数]";
                        flag = true;
                    }
                }

                if (StringUtils.isEmpty(manageRate)) {
                    vo.setManageRate(null);
                } else {
                    try {
                        vo.setManageRate(new BigDecimal(manageRate));
                    } catch (Exception e) {
                        vo.setManageRate(null);
                        warnType = warnType + "[增值税率(%)只能为数字或小数]";
                        flag = true;
                    }
                }

                if (StringUtils.isEmpty(managePriceTax)) {
                    vo.setManagePriceTax(null);
                } else {
                    try {
                        vo.setManagePriceTax(new BigDecimal(managePriceTax));
                    } catch (Exception e) {
                        vo.setManagePriceTax(null);
                        warnType = warnType + "[税金只能为数字或小数]";
                        flag = true;
                    }
                }

                if (StringUtils.isEmpty(manageMny)) {
                    vo.setManageMny(null);
                } else {
                    try {
                        vo.setManageMny(new BigDecimal(manageMny));
                    } catch (Exception e) {
                        vo.setManageMny(null);
                        warnType = warnType + "[不含税合价只能为数字或小数]";
                        flag = true;
                    }
                }

                if (StringUtils.isEmpty(manageTaxMny)) {
                    vo.setManageTaxMny(null);
                } else {
                    try {
                        vo.setManageTaxMny(new BigDecimal(manageTaxMny));
                    } catch (Exception e) {
                        vo.setManageTaxMny(null);
                        warnType = warnType + "[含税合价只能为数字或小数]";
                        flag = true;
                    }
                }

                if (StringUtils.isEmpty(manageTax)) {
                    vo.setManageTax(null);
                } else {
                    try {
                        vo.setManageTax(new BigDecimal(manageTax));
                    } catch (Exception e) {
                        vo.setManageTax(null);
                        warnType = warnType + "[税金合价只能为数字或小数]";
                        flag = true;
                    }
                }
//                vo.setManageMemo(manageMemo);
                vo.setImportFlag(!flag);// true=可以导入，false=不可导入
                if (importFlag) {// 如果能导入
                    importFlag = !flag;
                }
                vo.setWarnType(warnType);
                detailVoList.add(vo);
            }
            List<BuildManageVO> successList = new ArrayList<>();
            for (BuildManageVO vo : detailVoList) {
                if (vo.getImportFlag()) {
                    if (importFlag) {
                        String indexCode = vo.getIndexCode();
                        Boolean leafFlag = true;
                        for (String code : detailIndexList) {
                            if (code.startsWith(indexCode) && !code.equals(indexCode)) {
                                String sub = code.substring(indexCode.length(), indexCode.length() + 1);
                                if ("-/.".indexOf(sub) != -1) {
                                    leafFlag = false;
                                    break;
                                }
                            }
                        }
                        vo.setLeafFlag(leafFlag);//0-否，1-是
                        vo.setParentId(parentMap.get(vo.getTpid()));
                        successList.add(vo);
                    }
                } else {
                    ImportErrorVo errorVo = new ImportErrorVo();
                    errorVo.setPageName("现场管理费目标成本控制计划表");
                    errorVo.setId(vo.getId());
                    errorVo.setIndexCode(vo.getIndexCode());
                    errorVo.setCode(vo.getManageCode());
                    errorVo.setName(vo.getManageName());
                    errorVo.setWarnType(vo.getWarnType());
                    errorList.add(errorVo);
                }
            }
            res.setErrorList(errorList);
            res.setBuildManageList(successList);
        }
        return res;
    }

    private ImportBuildVo excelImportFees(List<List<String>> result, Long dutyId) {
        ImportBuildVo res = new ImportBuildVo();
        List<ImportErrorVo> errorList = new ArrayList<>();
        if (result != null && result.size() > 0) {
            List<String> detailIndexList = new ArrayList<>();// 树形编码不能重复
            Map<String, Long> parentMap = new HashMap<>();
            List<BuildFeesVO> detailVoList = new ArrayList<>();
            boolean importFlag = true;
            for (int i = 0; i < result.size()-2; i++) {
                List<String> datas = result.get(i);
                BuildFeesVO vo = new BuildFeesVO();
                boolean flag = false;
                String warnType = "";

                String indexCode = datas.get(0);//序号
                String feesCode = datas.get(1); // 编码
                String feesName = datas.get(3); // 费用项名称
                String feesUnitName = datas.get(4); // 单位
                String feesNum = datas.get(5); // 工程量
                String feesPrice = datas.get(6); // 单价
                String feesMny = datas.get(8); // 合价

                Long id = IdWorker.getId();
                vo.setId(id);
                vo.setTid(id);
                vo.setDutyId(dutyId);

                if (StringUtils.isNotEmpty(indexCode)) {//序号不为空
                    indexCode = indexCode.trim();// 去除导入时树形编码空格
                    vo.setIndexCode(indexCode);
                    vo.setTreeIndex(indexCode);
                    parentMap.put(indexCode, id);
                    String[] split = indexCode.split("[-/.]");
                    if (split.length > 1) {
                        vo.setTpid(indexCode.substring(0, indexCode.length() - split[split.length - 1].length() - 1));
                    }
//                    vo.setTreeIndex(i + "");
                    if (detailIndexList.contains(indexCode)) {
                        warnType = warnType + "[序号重复]";
                        flag = true;
                    } else {
                        detailIndexList.add(indexCode);
                    }
                } else {
                    vo.setIndexCode(null);
                    warnType = warnType + "[序号为空]";
                    flag = true;
                }

                if (StringUtils.isEmpty(feesCode)) {// 编码为空
                    vo.setFeesCode(null);
                } else {
                    vo.setFeesCode(feesCode);
                }

                if (StringUtils.isEmpty(feesName)) {//名称为空
                    vo.setFeesName(null);
                    warnType = warnType + "[费用项名称为空]";
                    flag = true;
                } else {
                    vo.setFeesName(feesName);
                }

                vo.setFeesUnitName(feesUnitName);

                if (StringUtils.isEmpty(feesNum)) {
                    vo.setFeesNum(null);
                } else {
                    try {
                        vo.setFeesNum(new BigDecimal(feesNum));
                    } catch (Exception e) {
                        vo.setFeesNum(null);
                        warnType = warnType + "[工程量只能为数字或小数]";
                        flag = true;
                    }
                }

                if (StringUtils.isEmpty(feesPrice)) {
                    vo.setFeesPrice(null);
                } else {
                    try {
                        vo.setFeesPrice(new BigDecimal(feesPrice));
                    } catch (Exception e) {
                        vo.setFeesPrice(null);
                        warnType = warnType + "[不含税单价只能为数字或小数]";
                        flag = true;
                    }
                }

                if (StringUtils.isEmpty(feesMny)) {
                    vo.setFeesMny(null);
                } else {
                    try {
                        vo.setFeesMny(new BigDecimal(feesMny));
                    } catch (Exception e) {
                        vo.setFeesMny(null);
                        warnType = warnType + "[合价只能为数字或小数]";
                        flag = true;
                    }
                }

                vo.setImportFlag(!flag);// true=可以导入，false=不可导入
                if (importFlag) {// 如果能导入
                    importFlag = !flag;
                }
                vo.setWarnType(warnType);
                detailVoList.add(vo);
            }
            List<BuildFeesVO> successList = new ArrayList<>();
            for (BuildFeesVO vo : detailVoList) {
                if (vo.getImportFlag()) {
                    if (importFlag) {
                        String indexCode = vo.getIndexCode();
                        Boolean leafFlag = true;
                        for (String code : detailIndexList) {
                            if (code.startsWith(indexCode) && !code.equals(indexCode)) {
                                String sub = code.substring(indexCode.length(), indexCode.length() + 1);
                                if ("-/.".indexOf(sub) != -1) {
                                    leafFlag = false;
                                    break;
                                }
                            }
                        }
                        vo.setLeafFlag(leafFlag);//0-否，1-是
                        vo.setParentId(parentMap.get(vo.getTpid()));
                        successList.add(vo);
                    }
                } else {
                    ImportErrorVo errorVo = new ImportErrorVo();
                    errorVo.setPageName("规费目标成本控制计划表");
                    errorVo.setId(vo.getId());
                    errorVo.setIndexCode(vo.getIndexCode());
                    errorVo.setCode(vo.getFeesCode());
                    errorVo.setName(vo.getFeesName());
                    errorVo.setWarnType(vo.getWarnType());
                    errorList.add(errorVo);
                }
            }
            res.setErrorList(errorList);
            res.setBuildFeesList(successList);
        }
        return res;
    }

    private ImportBuildVo excelImportOther(List<List<String>> result, Long dutyId) {
        ImportBuildVo res = new ImportBuildVo();
        List<ImportErrorVo> errorList = new ArrayList<>();
        if (result != null && result.size() > 0) {
            List<String> detailIndexList = new ArrayList<>();// 树形编码不能重复
            Map<String, Long> parentMap = new HashMap<>();
            List<BuildOtherVO> detailVoList = new ArrayList<>();
            boolean importFlag = true;
            for (int i = 0; i < result.size()-2; i++) {
                List<String> datas = result.get(i);
                BuildOtherVO vo = new BuildOtherVO();
                boolean flag = false;
                String warnType = "";

                String indexCode = datas.get(0);//序号
                String otherCode = datas.get(1); // 编码
                String otherName = datas.get(3); // 费用项名称
                String otherUnitName = datas.get(4); // 单位
                String otherNum = datas.get(5); // 工程量
                String otherPrice = datas.get(6); // 单价
                String otherMny = datas.get(8); // 合价

                Long id = IdWorker.getId();
                vo.setId(id);
                vo.setTid(id);
                vo.setDutyId(dutyId);

                if (StringUtils.isNotEmpty(indexCode)) {//序号不为空
                    indexCode = indexCode.trim();// 去除导入时树形编码空格
                    vo.setIndexCode(indexCode);
                    vo.setTreeIndex(indexCode);
                    parentMap.put(indexCode, id);
                    String[] split = indexCode.split("[-/.]");
                    if (split.length > 1) {
                        vo.setTpid(indexCode.substring(0, indexCode.length() - split[split.length - 1].length() - 1));
                    }
//                    vo.setTreeIndex(i + "");
                    if (detailIndexList.contains(indexCode)) {
                        warnType = warnType + "[序号重复]";
                        flag = true;
                    } else {
                        detailIndexList.add(indexCode);
                    }
                } else {
                    vo.setIndexCode(null);
                    warnType = warnType + "[序号为空]";
                    flag = true;
                }

                if (StringUtils.isEmpty(otherCode)) {// 编码为空
                    vo.setOtherCode(null);
                } else {
                    vo.setOtherCode(otherCode);
                }

                if (StringUtils.isEmpty(otherName)) {//名称为空
                    vo.setOtherName(null);
                    warnType = warnType + "[费用项名称为空]";
                    flag = true;
                } else {
                    vo.setOtherName(otherName);
                }

                vo.setOtherUnitName(otherUnitName);

                if (StringUtils.isEmpty(otherNum)) {
                    vo.setOtherNum(null);
                } else {
                    try {
                        vo.setOtherNum(new BigDecimal(otherNum));
                    } catch (Exception e) {
                        vo.setOtherNum(null);
                        warnType = warnType + "[工程量只能为数字或小数]";
                        flag = true;
                    }
                }

                if (StringUtils.isEmpty(otherPrice)) {
                    vo.setOtherPrice(null);
                } else {
                    try {
                        vo.setOtherPrice(new BigDecimal(otherPrice));
                    } catch (Exception e) {
                        vo.setOtherPrice(null);
                        warnType = warnType + "[不含税单价只能为数字或小数]";
                        flag = true;
                    }
                }

                if (StringUtils.isEmpty(otherMny)) {
                    vo.setOtherMny(null);
                } else {
                    try {
                        vo.setOtherMny(new BigDecimal(otherMny));
                    } catch (Exception e) {
                        vo.setOtherMny(null);
                        warnType = warnType + "[合价只能为数字或小数]";
                        flag = true;
                    }
                }

                vo.setImportFlag(!flag);// true=可以导入，false=不可导入
                if (importFlag) {// 如果能导入
                    importFlag = !flag;
                }
                vo.setWarnType(warnType);
                detailVoList.add(vo);
            }
            List<BuildOtherVO> successList = new ArrayList<>();
            for (BuildOtherVO vo : detailVoList) {
                if (vo.getImportFlag()) {
                    if (importFlag) {
                        String indexCode = vo.getIndexCode();
                        Boolean leafFlag = true;
                        for (String code : detailIndexList) {
                            if (code.startsWith(indexCode) && !code.equals(indexCode)) {
                                String sub = code.substring(indexCode.length(), indexCode.length() + 1);
                                if ("-/.".indexOf(sub) != -1) {
                                    leafFlag = false;
                                    break;
                                }
                            }
                        }
                        vo.setLeafFlag(leafFlag);//0-否，1-是
                        vo.setParentId(parentMap.get(vo.getTpid()));
                        successList.add(vo);
                    }
                } else {
                    ImportErrorVo errorVo = new ImportErrorVo();
                    errorVo.setPageName("其它费目标成本控制计划表");
                    errorVo.setId(vo.getId());
                    errorVo.setIndexCode(vo.getIndexCode());
                    errorVo.setCode(vo.getOtherCode());
                    errorVo.setName(vo.getOtherName());
                    errorVo.setWarnType(vo.getWarnType());
                    errorList.add(errorVo);
                }
            }
            res.setErrorList(errorList);
            res.setBuildOtherList(successList);
        }
        return res;
    }

    public void updateByPid(BuildDutyEntity entity){
        Map<Long,Long> rgcostMap=new HashMap<>();
        List<BuildRgcostEntity> rgcostEntities = entity.getBuildRgcostList();// 房建-人工费
        if(CollectionUtils.isNotEmpty(rgcostEntities)){
            for(BuildRgcostEntity twoEntity:rgcostEntities){
                rgcostMap.put(twoEntity.getTid(),twoEntity.getId());
            }
            for(BuildRgcostEntity cdEntity:rgcostEntities){
                if(null!=cdEntity.getParentId()){
                    cdEntity.setParentId(rgcostMap.get(cdEntity.getParentId()));
                }
                cdEntity.setTid(cdEntity.getId());
            }
            buildRgcostService.saveOrUpdateBatch(rgcostEntities,rgcostEntities.size(),false);
        }

        Map<Long,Long> subMap=new HashMap<>();
        List<BuildSubEntity> dutySubEntities = entity.getBuildSubList();
        if(CollectionUtils.isNotEmpty(dutySubEntities)){
            for(BuildSubEntity rmatEntity:dutySubEntities){
                subMap.put(rmatEntity.getTid(),rmatEntity.getId());
            }
            for(BuildSubEntity cdEntity:dutySubEntities){
                if(null!=cdEntity.getParentId()){
                    cdEntity.setParentId(subMap.get(cdEntity.getParentId()));
                }
                cdEntity.setTid(cdEntity.getId());
            }
            buildSubService.saveOrUpdateBatch(dutySubEntities,dutySubEntities.size(),false);
        }

        Map<Long,Long> materialMap=new HashMap<>();
        List<BuildMaterialEntity> materialEntities = entity.getBuildMaterialList();// 房建-材料
        if(CollectionUtils.isNotEmpty(materialEntities)){
            for(BuildMaterialEntity twoEntity:materialEntities){
                materialMap.put(twoEntity.getTid(),twoEntity.getId());
            }
            for(BuildMaterialEntity cdEntity:materialEntities){
                if(null!=cdEntity.getParentId()){
                    cdEntity.setParentId(materialMap.get(cdEntity.getParentId()));
                }
                cdEntity.setTid(cdEntity.getId());
            }
            buildMaterialService.saveOrUpdateBatch(materialEntities,materialEntities.size(),false);
        }

        Map<Long,Long> rmatMap=new HashMap<>();
        List<BuildRmatEntity> rmatEntities = entity.getBuildRmatList();// 房建-周转材
        if(CollectionUtils.isNotEmpty(rmatEntities)){
            for(BuildRmatEntity twoEntity:rmatEntities){
                rmatMap.put(twoEntity.getTid(),twoEntity.getId());
            }
            for(BuildRmatEntity cdEntity:rmatEntities){
                if(null!=cdEntity.getParentId()){
                    cdEntity.setParentId(rmatMap.get(cdEntity.getParentId()));
                }
                cdEntity.setTid(cdEntity.getId());
            }
            buildRmatService.saveOrUpdateBatch(rmatEntities,rmatEntities.size(),false);
        }

        Map<Long,Long> equipmentMap=new HashMap<>();
        List<BuildEquipmentEntity> equipmentEntities = entity.getBuildEquipmentList();// 房建-机械设备
        if(CollectionUtils.isNotEmpty(equipmentEntities)){
            for(BuildEquipmentEntity twoEntity:equipmentEntities){
                equipmentMap.put(twoEntity.getTid(),twoEntity.getId());
            }
            for(BuildEquipmentEntity cdEntity:equipmentEntities){
                if(null!=cdEntity.getParentId()){
                    cdEntity.setParentId(equipmentMap.get(cdEntity.getParentId()));
                }
                cdEntity.setTid(cdEntity.getId());
            }
            buildEquipmentService.saveOrUpdateBatch(equipmentEntities,equipmentEntities.size(),false);
        }

        Map<Long,Long> safeMap=new HashMap<>();
        List<BuildSafeEntity> safeEntities = entity.getBuildSafeList();// 房建-安全文明施工费
        if(CollectionUtils.isNotEmpty(safeEntities)){
            for(BuildSafeEntity twoEntity:safeEntities){
                safeMap.put(twoEntity.getTid(),twoEntity.getId());
            }
            for(BuildSafeEntity cdEntity:safeEntities){
                if(null!=cdEntity.getParentId()){
                    cdEntity.setParentId(safeMap.get(cdEntity.getParentId()));
                }
                cdEntity.setTid(cdEntity.getId());
            }
            buildSafeService.saveOrUpdateBatch(safeEntities,safeEntities.size(),false);
        }

        Map<Long,Long> temporaryMap=new HashMap<>();
        List<BuildTemporaryEntity> temporaryEntities = entity.getBuildTemporaryList();// 房建-临时设施费
        if(CollectionUtils.isNotEmpty(temporaryEntities)){
            for(BuildTemporaryEntity twoEntity:temporaryEntities){
                temporaryMap.put(twoEntity.getTid(),twoEntity.getId());
            }
            for(BuildTemporaryEntity cdEntity:temporaryEntities){
                if(null!=cdEntity.getParentId()){
                    cdEntity.setParentId(temporaryMap.get(cdEntity.getParentId()));
                }
                cdEntity.setTid(cdEntity.getId());
            }
            buildTemporaryService.saveOrUpdateBatch(temporaryEntities,temporaryEntities.size(),false);
        }

        Map<Long,Long> measureMap=new HashMap<>();
        List<BuildMeasureEntity> measureEntities = entity.getBuildMeasureList();// 房建-其他措施费
        if(CollectionUtils.isNotEmpty(measureEntities)){
            for(BuildMeasureEntity twoEntity:measureEntities){
                measureMap.put(twoEntity.getTid(),twoEntity.getId());
            }
            for(BuildMeasureEntity cdEntity:measureEntities){
                if(null!=cdEntity.getParentId()){
                    cdEntity.setParentId(measureMap.get(cdEntity.getParentId()));
                }
                cdEntity.setTid(cdEntity.getId());
            }
            buildMeasureService.saveOrUpdateBatch(measureEntities,measureEntities.size(),false);
        }

        Map<Long,Long> manageMap=new HashMap<>();
        List<BuildManageEntity> manageEntities = entity.getBuildManageList();// 房建-现场管理费
        if(CollectionUtils.isNotEmpty(manageEntities)){
            for(BuildManageEntity twoEntity:manageEntities){
                manageMap.put(twoEntity.getTid(),twoEntity.getId());
            }
            for(BuildManageEntity cdEntity:manageEntities){
                if(null!=cdEntity.getParentId()){
                    cdEntity.setParentId(manageMap.get(cdEntity.getParentId()));
                }
                cdEntity.setTid(cdEntity.getId());
            }
            buildManageService.saveOrUpdateBatch(manageEntities,manageEntities.size(),false);
        }

        Map<Long,Long> feesMap=new HashMap<>();
        List<BuildFeesEntity> feesEntities = entity.getBuildFeesList();// 房建-规费
        if(CollectionUtils.isNotEmpty(feesEntities)){
            for(BuildFeesEntity twoEntity:feesEntities){
                feesMap.put(twoEntity.getTid(),twoEntity.getId());
            }
            for(BuildFeesEntity cdEntity:feesEntities){
                if(null!=cdEntity.getParentId()){
                    cdEntity.setParentId(feesMap.get(cdEntity.getParentId()));
                }
                cdEntity.setTid(cdEntity.getId());
            }
            buildFeesService.saveOrUpdateBatch(feesEntities,feesEntities.size(),false);
        }

        Map<Long,Long> otherMap=new HashMap<>();
        List<BuildOtherEntity> otherEntities = entity.getBuildOtherList();// 房建-其他费用
        if(CollectionUtils.isNotEmpty(otherEntities)){
            for(BuildOtherEntity twoEntity:otherEntities){
                otherMap.put(twoEntity.getTid(),twoEntity.getId());
            }
            for(BuildOtherEntity cdEntity:otherEntities){
                if(null!=cdEntity.getParentId()){
                    cdEntity.setParentId(otherMap.get(cdEntity.getParentId()));
                }
                cdEntity.setTid(cdEntity.getId());
            }
            buildOtherService.saveOrUpdateBatch(otherEntities,otherEntities.size(),false);
        }
    }

    public List<BuildPlansEntity> SumPlanDetail(BuildDutyVO vo){
        List<BuildPlansVO> buildPlansList = vo.getBuildPlansList(); //计划汇总表
        List<BuildRgcostVO> buildRgcostList = vo.getBuildRgcostList();//人工费
        List<BuildSubVO> buildSubList = vo.getBuildSubList(); // 房建-专业分包
        List<BuildMaterialVO> buildMaterialList = vo.getBuildMaterialList(); // 房建-主要材料
        List<BuildRmatVO> buildRmatList = vo.getBuildRmatList(); // 房建-周转材
        List<BuildEquipmentVO> buildEquipmentList = vo.getBuildEquipmentList(); // 房建-机械设备费
        List<BuildSafeVO> buildSafeList = vo.getBuildSafeList(); // 房建-安全文明施工费
        List<BuildTemporaryVO> buildTemporaryList = vo.getBuildTemporaryList(); // 房建-临时设施费
        List<BuildMeasureVO> buildMeasureList = vo.getBuildMeasureList(); // 房建-其他措施费
        List<BuildManageVO> buildManageList = vo.getBuildManageList(); // 房建-现场管理费
        List<BuildFeesVO> buildFeesList = vo.getBuildFeesList(); // 房建-规费
        List<BuildOtherVO> buildOtherList = vo.getBuildOtherList(); // 房建-其他费用

        //生成汇总表
        List<BuildPlansEntity> dutyPlansEntityList = new ArrayList<>();
        BigDecimal sumPlansMny = BigDecimal.ZERO;
        BigDecimal sumTaxMny = BigDecimal.ZERO;//税金
        BigDecimal sumPlansMny2 = BigDecimal.ZERO;

        for(int i=0;i<buildPlansList.size();i++){
            BuildPlansEntity buildPlansEntity = BeanMapper.map(buildPlansList.get(i),BuildPlansEntity.class);
            buildPlansEntity.setId(null);
            if(i==0){
                BigDecimal plansMny = buildRgcostList.stream().filter(item -> null == item.getParentId()&& null != item.getRgcostMny()).map(BuildRgcostVO::getRgcostMny).reduce(BigDecimal.ZERO, BigDecimal::add);
                buildPlansEntity.setPlansMny(plansMny);
                BigDecimal priceTax = buildRgcostList.stream().filter(item -> null == item.getParentId()&& null != item.getRgcostTax()).map(BuildRgcostVO::getRgcostTax).reduce(BigDecimal.ZERO, BigDecimal::add);
                sumTaxMny = sumTaxMny.add(priceTax);
            }else if(i==1){
                BigDecimal plansMny = buildSubList.stream().filter(item -> null == item.getParentId()&& null != item.getSubMny()).map(BuildSubVO::getSubMny).reduce(BigDecimal.ZERO, BigDecimal::add);
                buildPlansEntity.setPlansMny(plansMny);
                BigDecimal priceTax = buildSubList.stream().filter(item -> null == item.getParentId()&& null != item.getSubTax()).map(BuildSubVO::getSubTax).reduce(BigDecimal.ZERO, BigDecimal::add);
                sumTaxMny = sumTaxMny.add(priceTax);
            }else if(i==2){
                BigDecimal plansMny = buildMaterialList.stream().filter(item -> null == item.getParentId()&& null != item.getMaterialMny()).map(BuildMaterialVO::getMaterialMny).reduce(BigDecimal.ZERO, BigDecimal::add);
                buildPlansEntity.setPlansMny(plansMny);
                BigDecimal priceTax = buildMaterialList.stream().filter(item -> null == item.getParentId()&& null != item.getMaterialTax()).map(BuildMaterialVO::getMaterialTax).reduce(BigDecimal.ZERO, BigDecimal::add);
                sumTaxMny = sumTaxMny.add(priceTax);
            }else if(i==3){
                BigDecimal plansMny = buildRmatList.stream().filter(item -> null == item.getParentId()&& null != item.getRmatMny()).map(BuildRmatVO::getRmatMny).reduce(BigDecimal.ZERO, BigDecimal::add);
                buildPlansEntity.setPlansMny(plansMny);
                BigDecimal priceTax = buildRmatList.stream().filter(item -> null == item.getParentId()&& null != item.getRmatTax()).map(BuildRmatVO::getRmatTax).reduce(BigDecimal.ZERO, BigDecimal::add);
                sumTaxMny = sumTaxMny.add(priceTax);
            }else if(i==4){
                BigDecimal plansMny = buildEquipmentList.stream().filter(item -> null == item.getParentId()&& null != item.getEquipmentMny()).map(BuildEquipmentVO::getEquipmentMny).reduce(BigDecimal.ZERO, BigDecimal::add);
                buildPlansEntity.setPlansMny(plansMny);
                BigDecimal priceTax = buildEquipmentList.stream().filter(item -> null == item.getParentId()&& null != item.getEquipmentTax()).map(BuildEquipmentVO::getEquipmentTax).reduce(BigDecimal.ZERO, BigDecimal::add);
                sumTaxMny = sumTaxMny.add(priceTax);
            }else if(i==5){
                BigDecimal plansMny = buildSafeList.stream().filter(item -> null == item.getParentId()&& null != item.getSafeMny()).map(BuildSafeVO::getSafeMny).reduce(BigDecimal.ZERO, BigDecimal::add);
                buildPlansEntity.setPlansMny(plansMny);
                BigDecimal priceTax = buildSafeList.stream().filter(item -> null == item.getParentId()&& null != item.getSafeTax()).map(BuildSafeVO::getSafeTax).reduce(BigDecimal.ZERO, BigDecimal::add);
                sumTaxMny = sumTaxMny.add(priceTax);
            }else if(i==6){
                BigDecimal plansMny = buildTemporaryList.stream().filter(item -> null == item.getParentId()&& null != item.getTemporaryMny()).map(BuildTemporaryVO::getTemporaryMny).reduce(BigDecimal.ZERO, BigDecimal::add);
                buildPlansEntity.setPlansMny(plansMny);
                BigDecimal priceTax = buildTemporaryList.stream().filter(item -> null == item.getParentId()&& null != item.getTemporaryTax()).map(BuildTemporaryVO::getTemporaryTax).reduce(BigDecimal.ZERO, BigDecimal::add);
                sumTaxMny = sumTaxMny.add(priceTax);
            }else if(i==7){
                BigDecimal plansMny = buildMeasureList.stream().filter(item -> null == item.getParentId()&& null != item.getMeasureMny()).map(BuildMeasureVO::getMeasureMny).reduce(BigDecimal.ZERO, BigDecimal::add);
                buildPlansEntity.setPlansMny(plansMny);
                BigDecimal priceTax = buildMeasureList.stream().filter(item -> null == item.getParentId()&& null != item.getMeasureTax()).map(BuildMeasureVO::getMeasureTax).reduce(BigDecimal.ZERO, BigDecimal::add);
                sumTaxMny = sumTaxMny.add(priceTax);
            }else if(i==8){
                BigDecimal plansMny = buildFeesList.stream().filter(item -> null == item.getParentId()&& null != item.getFeesMny()).map(BuildFeesVO::getFeesMny).reduce(BigDecimal.ZERO, BigDecimal::add);
                buildPlansEntity.setPlansMny(plansMny);
            }else if(i==9){
                BigDecimal plansMny = buildManageList.stream().filter(item -> null == item.getParentId()&& null != item.getManageMny()).map(BuildManageVO::getManageMny).reduce(BigDecimal.ZERO, BigDecimal::add);
                buildPlansEntity.setPlansMny(plansMny);
                BigDecimal priceTax = buildManageList.stream().filter(item -> null == item.getParentId()&& null != item.getManageTax()).map(BuildManageVO::getManageTax).reduce(BigDecimal.ZERO, BigDecimal::add);
                sumTaxMny = sumTaxMny.add(priceTax);
            }else if(i==11){
                BigDecimal plansMny = buildOtherList.stream().filter(item -> null == item.getParentId()&& null != item.getOtherMny()).map(BuildOtherVO::getOtherMny).reduce(BigDecimal.ZERO, BigDecimal::add);
                buildPlansEntity.setPlansMny(plansMny);
            }else if(i==13){
                //第一个合计行
                buildPlansEntity.setPlansMny(sumPlansMny);
            }else if(i==18){
                //第二个合计行
                buildPlansEntity.setPlansMny(sumPlansMny2);
            }else if(i==15){
                //税金合计行
                buildPlansEntity.setPlansMny(sumTaxMny);
            }
            if(i<13){
                sumPlansMny = sumPlansMny.add(buildPlansEntity.getPlansMny()==null?BigDecimal.ZERO:buildPlansEntity.getPlansMny());//合计行1累加
            }else if(i>12&&i<18){
                sumPlansMny2 = sumPlansMny2.add(buildPlansEntity.getPlansMny()==null?BigDecimal.ZERO:buildPlansEntity.getPlansMny());//合计行2累加
            }
            BigDecimal plansYsMny = buildPlansEntity.getPlansYsMny()==null?BigDecimal.ZERO:buildPlansEntity.getPlansYsMny();
            if(null!=buildPlansEntity.getPlansMny()){
                buildPlansEntity.setPlansJcMny(plansYsMny.subtract(buildPlansEntity.getPlansMny()));
                if(BigDecimal.ZERO.compareTo(plansYsMny)!=0){
                    buildPlansEntity.setPlansJcRate((plansYsMny.subtract(buildPlansEntity.getPlansMny())).multiply(new BigDecimal(100)).divide(plansYsMny,2,BigDecimal.ROUND_HALF_DOWN));
                }
            }
            dutyPlansEntityList.add(buildPlansEntity);
        }

        if(CollectionUtils.isNotEmpty(dutyPlansEntityList)){
            for(BuildPlansEntity buildPlansEntity:dutyPlansEntityList){
                if(BigDecimal.ZERO.compareTo(sumPlansMny2)!=0){
                    BigDecimal plansMny = buildPlansEntity.getPlansMny()==null?BigDecimal.ZERO:buildPlansEntity.getPlansMny();
                    buildPlansEntity.setPlansRate(plansMny.multiply(new BigDecimal(100)).divide(sumPlansMny2,2,BigDecimal.ROUND_HALF_DOWN));
                }else{
                    buildPlansEntity.setPlansRate(BigDecimal.ZERO);
                }
            }
        }
        return dutyPlansEntityList;
    }


}
