package com.ejianc.business.zhht.service.impl;

import com.ejianc.business.targetcost.enums.ChangeStateEnum;
import com.ejianc.business.targetcost.enums.ConversionEnum;
import com.ejianc.business.targetcost.service.IDutyService;
import com.ejianc.business.zhht.bean.BuildDutyEntity;
import com.ejianc.business.zhht.service.IBuildDutyService;
import com.ejianc.business.zhht.vo.BuildDutyVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.Map;

@Service("buildDuty") 
public class BuildDutyBpmServiceImpl implements ICommonBusinessService {

	@Autowired
	private IDutyService dutyService;

	@Autowired
	private IBuildDutyService service;

	/**
	 * 提交前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
		BuildDutyEntity buildDutyEntity =service.selectById(billId);
		if(CollectionUtils.isNotEmpty(buildDutyEntity.getSumDetailList())){
			return CommonResponse.error("单据需有子表信息后才能提交");
		}
		return CommonResponse.success();
	};

	/**
	 * 提交完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode){
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 有审批流的撤回前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
		BuildDutyEntity buildDutyEntity =service.selectById(billId);
		if (state == 0){ // 点击撤回进入流程，   驳回state传4，直接成功
			if(buildDutyEntity.getLastDutyId()==null) {
				if (Integer.valueOf(1).equals(buildDutyEntity.getLatestFlag()) || (1 != buildDutyEntity.getDutyVersion() && Integer.valueOf(0).equals(buildDutyEntity.getEnableState()))) {
					throw new BusinessException("非最新生效版本，不能撤回！");
				}
			}
		}

		return CommonResponse.success();
	};

	/**
	 * 有审批流的撤回后回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode){
		//弃审是否生效修改为否
		updateEnableAndWriteBack(billId, false);
		return CommonResponse.success();
	};

	/**
	 * 审批节点审批中时节点审批前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
		return CommonResponse.success();
	};

	/**
	 * 审批节点审批中时节点审批后回调
	 *
	 * @param billId	//单据id
	 * @param state		//单据状态
	 * @param billTypeCode		//单据类型code
	 * @param taskId		//该流程id
	 * @param isEnd		//该节点是否结束
	 * @return
	 */
	@Override
	public CommonResponse<String> afterInApprovalBack(Long billId, Integer state, String billTypeCode, String taskId, Boolean isEnd, String sign, Map<String,Object> other){
		return CommonResponse.success();
	};

	/**
	 * 终审审核前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 终审审核完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		BuildDutyEntity buildDutyEntity =service.selectById(billId);

		if(null != buildDutyEntity.getChangeState() && ChangeStateEnum.变更中.getCode().equals(buildDutyEntity.getChangeState())) {
			handleChangeBillPass(buildDutyEntity);
		} else {
			//新增审批
			handleNewBillPass(buildDutyEntity);
		}

		//审核完成是否生效修改为是
		updateEnableAndWriteBack(billId, true);

		return CommonResponse.success();
	}

	/**
	 * 单据新增生效
	 *
	 * @param buildDutyEntity
	 */
	private void handleNewBillPass(BuildDutyEntity buildDutyEntity) {
		//1、生成目标责任成本
		dutyService.pushFromImport(BeanMapper.map(buildDutyEntity, BuildDutyVO.class), false, ConversionEnum.中核华泰房建.getCode());
		//将生成的目标责任成本置为生效状态
		dutyService.handleBill(buildDutyEntity.getId(), true, "add", InvocationInfoProxy.getUserid());
	}

	/**
	 * 单据变更生效
	 *
	 * @param buildDutyEntity
	 */
	private void handleChangeBillPass(BuildDutyEntity buildDutyEntity) {
		//变更审批
		dutyService.pushFromImport(BeanMapper.map(buildDutyEntity, BuildDutyVO.class),true, ConversionEnum.中核华泰房建.getCode());
		//将生成的目标责任成本置为生效状态
		dutyService.handleBill(buildDutyEntity.getId(), true, "change", InvocationInfoProxy.getUserid());
	}


	/**
	 * 弃审前事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		BuildDutyEntity dutyEntity =service.selectById(billId);
		if(!(Integer.valueOf(1).equals(dutyEntity.getEnableState()) && Integer.valueOf(1).equals(dutyEntity.getLatestFlag()))){
			throw new BusinessException("非最新生效版本，不能弃审！");
		}
		return CommonResponse.success();
	}

	/**
	 * 弃审后事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		BuildDutyEntity dutyEntity =service.selectById(billId);
		updateEnableAndWriteBack(billId, false);
		dutyService.pushFromImport(BeanMapper.map(dutyEntity,BuildDutyVO.class),false, ConversionEnum.中核华泰房建.getCode());

		//删除对应的目标责任成本单
		dutyService.deleteFromImport(billId, ConversionEnum.中核华泰房建.getCode());
		return CommonResponse.success();
	}

	private void updateEnableAndWriteBack(Long billId, Boolean isPass){
		BuildDutyEntity dutyEntity =service.selectById(billId);
		dutyEntity.setEnableState(isPass ? 1 : 0);
		service.saveOrUpdate(dutyEntity);

		//弃审,存在前版本，单据是否生效为是
		if(dutyEntity.getLastDutyId()!=null){
			BuildDutyEntity revise = service.getById(dutyEntity.getLastDutyId());
			revise.setChangeState(isPass ? ChangeStateEnum.已变更.getCode() : ChangeStateEnum.变更中.getCode());
			revise.setEnableState(isPass ? 0 : 1);
			service.saveOrUpdate(revise);
		}
	}

}
