package com.ejianc.business.zhht.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.ejianc.business.targetcost.enums.ChangeStateEnum;
import com.ejianc.business.targetcost.enums.ConversionEnum;
import com.ejianc.business.targetcost.service.IDutyService;
import com.ejianc.business.targetcost.utils.TreeNodeBUtil;
import com.ejianc.business.zhht.bean.BuildDutyEntity;
import com.ejianc.business.zhht.mapper.BuildDutyMapper;
import com.ejianc.business.zhht.service.IBuildDutyService;
import com.ejianc.business.zhht.vo.*;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

/**
 * 项目策划
 * 
 * @author generator
 * 
 */
@Service("buildDutyService")
public class BuildDutyServiceImpl extends BaseServiceImpl<BuildDutyMapper, BuildDutyEntity> implements IBuildDutyService{

    @Autowired
    private IDutyService dutyService;

    @Override
    public BuildDutyVO getByProjectId(Long projectId) {
        QueryWrapper<BuildDutyEntity> query = new QueryWrapper<>();
        query.eq("project_id", projectId);
        query.eq("latest_flag", 1); //最新
        query.in("bill_state", new Integer[]{BillStateEnum.PASSED_STATE.getBillStateCode(), BillStateEnum.COMMITED_STATE.getBillStateCode()});

        List<BuildDutyEntity> dbEntityList = super.list(query);

        return CollectionUtils.isNotEmpty(dbEntityList) ? BeanMapper.map(dbEntityList.get(0), BuildDutyVO.class) : null;
    }

    @Override
    public BuildDutyVO queryChangeDetail(Long id) {
        BuildDutyEntity entity = super.selectById(id);
        BuildDutyVO vo = BeanMapper.map(entity, BuildDutyVO.class);
        vo.setId(null);
        vo.setBillCode(null);
        vo.setBillState(null);
        vo.setCreateTime(null);
        vo.setCreateUserCode(null);
        vo.setUpdateTime(null);
        vo.setUpdateUserCode(null);
        vo.setDutyVersion(vo.getDutyVersion() + 1);
        vo.setChangeState(ChangeStateEnum.未变更.getCode());
        vo.setLastDutyId(id);
        vo.setBaseDutyId(vo.getBaseDutyId());
        vo.setLatestFlag(1);
        vo.setEnableState(0);
        vo.setBeforeMny(vo.getMny());
        vo.setBeforeTaxMny(vo.getTaxMny());
        vo.setBeforeDutyVersion(vo.getDutyVersion() - 1);

        vo.setBeforePlanedTotalCostMny(vo.getPlanedTotalCostMny());
        vo.setBeforePlanedTotalCostTaxMny(vo.getPlanedTotalCostTaxMny());
        vo.setBeforePlanProfitRate(vo.getPlanProfitRate());
        vo.setBeforeProfitAndLossTaxMny(vo.getProfitAndLossTaxMny());

        List<BuildDutySumDetailVO> buildPlansList = vo.getSumDetailList();
        if (CollectionUtils.isNotEmpty(buildPlansList)) {
            buildPlansList.forEach(changeDetailVO -> {
                changeDetailVO.setCreateTime(null);
                changeDetailVO.setCreateUserCode(null);
                changeDetailVO.setUpdateTime(null);
                changeDetailVO.setUpdateUserCode(null);
                changeDetailVO.setRowState("edit");
                changeDetailVO.setId(IdWorker.getId());

                changeDetailVO.setBeforeSumPlanTotalRevenueMny(changeDetailVO.getSumPlanTotalRevenueMny());
                changeDetailVO.setBeforeSumPlanTotalCostMny(changeDetailVO.getSumPlanTotalCostMny());
                changeDetailVO.setBeforeSumProfitAndLossMny(changeDetailVO.getSumProfitAndLossMny());
                changeDetailVO.setBeforeSumPlanTotalTax(changeDetailVO.getSumPlanTotalTax());
                changeDetailVO.setBeforeSumProfitAndLossRate(changeDetailVO.getSumProfitAndLossRate());
                changeDetailVO.setChangeType(null);
                changeDetailVO.setChangeFlag("0");
            });
            vo.setSumDetailList(buildPlansList);
        }

        //人工费
        List<BuildDutyLaborCostDetailVO> buildRgcostList = vo.getLaborDetailList();
        if (CollectionUtils.isNotEmpty(buildRgcostList)) {
            buildRgcostList.forEach(changeDetailVO -> {
                changeDetailVO.setCreateTime(null);
                changeDetailVO.setCreateUserCode(null);
                changeDetailVO.setUpdateTime(null);
                changeDetailVO.setUpdateUserCode(null);
                changeDetailVO.setRowState("edit");
                changeDetailVO.setId(IdWorker.getId());


                changeDetailVO.setBeforeLaborDocCode(changeDetailVO.getLaborDocCode());
                changeDetailVO.setBeforeLaborDocName(changeDetailVO.getLaborDocName());
                changeDetailVO.setBeforeLaborUnitName(changeDetailVO.getLaborUnitName());
                changeDetailVO.setBeforeLaborNum(changeDetailVO.getLaborNum());
                changeDetailVO.setBeforeLaborIncomeTaxPrice(changeDetailVO.getLaborIncomeTaxPrice());
                changeDetailVO.setBeforeLaborIncomePrice(changeDetailVO.getLaborIncomePrice());
                changeDetailVO.setBeforeLaborCostRate(changeDetailVO.getLaborCostRate());
                changeDetailVO.setBeforeLaborCostPrice(changeDetailVO.getLaborCostPrice());
                changeDetailVO.setBeforeLaborCostTaxPrice(changeDetailVO.getLaborCostTaxPrice());
                changeDetailVO.setBeforeLaborCostMny(changeDetailVO.getLaborCostMny());
                changeDetailVO.setBeforeLaborCostTaxMny(changeDetailVO.getLaborCostTaxMny());
                changeDetailVO.setBeforeLaborUnitId(changeDetailVO.getLaborUnitId());
                changeDetailVO.setChangeType(null);
                changeDetailVO.setChangeFlag("0");

            });
            vo.setLaborDetailList(TreeNodeBUtil.buildTreeS(buildRgcostList));
        }

        List<BuildDutyProSubDetailVO> buildSubList = vo.getProSubDetailList(); // 专业
        if (CollectionUtils.isNotEmpty(buildSubList)) {
            buildSubList.forEach(changeDetailVO -> {
                changeDetailVO.setCreateTime(null);
                changeDetailVO.setCreateUserCode(null);
                changeDetailVO.setUpdateTime(null);
                changeDetailVO.setUpdateUserCode(null);
                changeDetailVO.setRowState("edit");
                changeDetailVO.setId(IdWorker.getId());

                changeDetailVO.setBeforeProSubDocCode(changeDetailVO.getProSubDocCode());
                changeDetailVO.setBeforeProSubDocName(changeDetailVO.getProSubDocName());
                changeDetailVO.setBeforeProSubUnitName(changeDetailVO.getProSubUnitName());
                changeDetailVO.setBeforeProSubUnitId(changeDetailVO.getProSubUnitId());
                changeDetailVO.setBeforeProSubNum(changeDetailVO.getProSubNum());
                changeDetailVO.setBeforeProSubIncomePrice(changeDetailVO.getProSubIncomePrice());
                changeDetailVO.setBeforeProSubIncomeMny(changeDetailVO.getProSubIncomeMny());
                changeDetailVO.setBeforeProSubCostRate(changeDetailVO.getProSubCostRate());
                changeDetailVO.setBeforeProSubCostPrice(changeDetailVO.getProSubCostPrice());
                changeDetailVO.setBeforeProSubCostTaxPrice(changeDetailVO.getProSubCostTaxPrice());
                changeDetailVO.setBeforeProSubCostMny(changeDetailVO.getProSubCostMny());
                changeDetailVO.setBeforeProSubCostTaxMny(changeDetailVO.getProSubCostTaxMny());
                changeDetailVO.setBeforeProSubTax(changeDetailVO.getProSubTax());
                changeDetailVO.setBeforeProSubProfitAndLossMny(changeDetailVO.getProSubProfitAndLossMny());
                changeDetailVO.setChangeType(null);
                changeDetailVO.setChangeFlag("0");
            });
            vo.setProSubDetailList(TreeNodeBUtil.buildTreeS(buildSubList));
        }

        List<BuildDutyMaterialDetailVO> buildMaterialList = vo.getMaterialDetailList(); // 材料费
        if (CollectionUtils.isNotEmpty(buildMaterialList)) {
            buildMaterialList.forEach(changeDetailVO -> {
                changeDetailVO.setCreateTime(null);
                changeDetailVO.setCreateUserCode(null);
                changeDetailVO.setUpdateTime(null);
                changeDetailVO.setUpdateUserCode(null);
                changeDetailVO.setRowState("edit");
                changeDetailVO.setId(IdWorker.getId());

                changeDetailVO.setBeforeMaterialDocCode(changeDetailVO.getMaterialDocCode());
                changeDetailVO.setBeforeMaterialDocName(changeDetailVO.getMaterialDocName());
                changeDetailVO.setBeforeMaterialDocSpec(changeDetailVO.getMaterialDocSpec());
                changeDetailVO.setBeforeMaterialUnitName(changeDetailVO.getMaterialUnitName());
                changeDetailVO.setBeforeMaterialUnitId(changeDetailVO.getMaterialUnitId());
                changeDetailVO.setBeforeMaterialNum(changeDetailVO.getMaterialNum());
                changeDetailVO.setBeforeMaterialIncomePrice(changeDetailVO.getMaterialIncomePrice());
                changeDetailVO.setBeforeMaterialIncomeTaxPrice(changeDetailVO.getMaterialIncomeTaxPrice());
                changeDetailVO.setBeforeMaterialCostRate(changeDetailVO.getMaterialCostRate());
                changeDetailVO.setBeforeMaterialCostPrice(changeDetailVO.getMaterialCostPrice());
                changeDetailVO.setBeforeMaterialCostMny(changeDetailVO.getMaterialCostMny());
                changeDetailVO.setBeforeMaterialCostTaxMny(changeDetailVO.getMaterialCostTaxMny());
                changeDetailVO.setBeforeMaterialCostTax(changeDetailVO.getMaterialCostTax());
                changeDetailVO.setBeforeMaterialCostTaxPrice(changeDetailVO.getMaterialCostTaxPrice());
                changeDetailVO.setBeforeMaterialProfitAndLossMny(changeDetailVO.getMaterialProfitAndLossMny());
                changeDetailVO.setBeforeMaterialProfitAndLossMny(changeDetailVO.getMaterialProfitAndLossMny());
                changeDetailVO.setChangeFlag("0");
                changeDetailVO.setChangeType(null);
            });
            vo.setMaterialDetailList(TreeNodeBUtil.buildTreeS(buildMaterialList));
        }

        List<BuildDutyEquipDetailVO> equipList = vo.getEquipDetailList(); // 机械费
        if (CollectionUtils.isNotEmpty(equipList)) {
            equipList.forEach(changeDetailVO -> {
                changeDetailVO.setCreateTime(null);
                changeDetailVO.setCreateUserCode(null);
                changeDetailVO.setUpdateTime(null);
                changeDetailVO.setUpdateUserCode(null);
                changeDetailVO.setRowState("edit");
                changeDetailVO.setId(IdWorker.getId());

                changeDetailVO.setBeforeEquipDocCode(changeDetailVO.getEquipDocCode());
                changeDetailVO.setBeforeEquipDocName(changeDetailVO.getEquipDocName());
                changeDetailVO.setBeforeEquipUnitName(changeDetailVO.getEquipUnitName());
                changeDetailVO.setBeforeEquipNum(changeDetailVO.getEquipNum());
                changeDetailVO.setBeforeEquipRentDays(changeDetailVO.getEquipRentDays());
                changeDetailVO.setBeforeEquipIncomeMny(changeDetailVO.getEquipIncomeMny());
                changeDetailVO.setBeforeEquipIncomePrice(changeDetailVO.getEquipIncomePrice());
                changeDetailVO.setBeforeEquipCostRate(changeDetailVO.getEquipCostRate());
                changeDetailVO.setBeforeEquipCostPrice(changeDetailVO.getEquipCostPrice());
                changeDetailVO.setBeforeEquipCostTaxPrice(changeDetailVO.getEquipCostTaxPrice());
                changeDetailVO.setBeforeEquipCostMny(changeDetailVO.getEquipCostMny());
                changeDetailVO.setBeforeEquipCostTaxMny(changeDetailVO.getEquipCostTaxMny());
                changeDetailVO.setBeforeEquipCostTax(changeDetailVO.getEquipCostTax());
                changeDetailVO.setBeforeEquipUnitId(changeDetailVO.getEquipUnitId());
                changeDetailVO.setChangeType(null);
                changeDetailVO.setChangeFlag("0");
            });
            vo.setEquipDetailList(TreeNodeBUtil.buildTreeS(equipList));
        }

        List<BuildDutyMeasureDetailVO> buildStimulateList = vo.getMeasureDetailList(); // 措施费
        if (CollectionUtils.isNotEmpty(buildStimulateList)) {
            buildStimulateList.forEach(changeDetailVO -> {
                changeDetailVO.setCreateTime(null);
                changeDetailVO.setCreateUserCode(null);
                changeDetailVO.setUpdateTime(null);
                changeDetailVO.setUpdateUserCode(null);
                changeDetailVO.setRowState("edit");
                changeDetailVO.setId(IdWorker.getId());

                changeDetailVO.setBeforeMeasureCode(changeDetailVO.getMeasureCode());
                changeDetailVO.setBeforeMeasureName(changeDetailVO.getMeasureName());
                changeDetailVO.setBeforeMeasureUnitName(changeDetailVO.getMeasureUnitName());
                changeDetailVO.setBeforeMeasureNum(changeDetailVO.getMeasureNum());
                changeDetailVO.setBeforeMeasureUnitId(changeDetailVO.getMeasureUnitId());
                changeDetailVO.setBeforeMeasureIncomePrice(changeDetailVO.getMeasureIncomePrice());
                changeDetailVO.setBeforeMeasureIncomeMny(changeDetailVO.getBeforeMeasureIncomeMny());
                changeDetailVO.setBeforeMeasureCostRate(changeDetailVO.getMeasureCostRate());
                changeDetailVO.setBeforeMeasureCostPrice(changeDetailVO.getMeasureCostPrice());
                changeDetailVO.setBeforeMeasureCostTaxPrice(changeDetailVO.getMeasureCostTaxPrice());
                changeDetailVO.setBeforeMeasureCostTaxMny(changeDetailVO.getMeasureCostTaxMny());
                changeDetailVO.setBeforeMeasureCostMny(changeDetailVO.getMeasureCostMny());
                changeDetailVO.setBeforeMeasureCostTax(changeDetailVO.getMeasureCostTax());
                changeDetailVO.setBeforeMeasureProfitAndLossMny(changeDetailVO.getMeasureProfitAndLossMny());
                changeDetailVO.setChangeType(null);
                changeDetailVO.setChangeFlag("0");
            });
            vo.setMeasureDetailList(TreeNodeBUtil.buildTreeS(buildStimulateList));
        }
        List<BuildDutyOtherDetailVO> otherList = vo.getOtherDetailList(); //其他费
        if (CollectionUtils.isNotEmpty(otherList)) {
            otherList.forEach(changeDetailVO -> {
                changeDetailVO.setCreateTime(null);
                changeDetailVO.setCreateUserCode(null);
                changeDetailVO.setUpdateTime(null);
                changeDetailVO.setUpdateUserCode(null);
                changeDetailVO.setRowState("edit");
                changeDetailVO.setId(IdWorker.getId());

                changeDetailVO.setBeforeOtherCode(changeDetailVO.getOtherCode());
                changeDetailVO.setBeforeOtherName(changeDetailVO.getOtherName());
                changeDetailVO.setBeforeOtherUnitName(changeDetailVO.getOtherUnitName());
                changeDetailVO.setBeforeOtherUnitId(changeDetailVO.getOtherUnitId());
                changeDetailVO.setBeforeOtherNum(changeDetailVO.getOtherNum());
                changeDetailVO.setBeforeOtherIncomeMny(changeDetailVO.getOtherIncomeMny());
                changeDetailVO.setBeforeOtherCostRate(changeDetailVO.getOtherCostRate());
                changeDetailVO.setBeforeOtherCostPrice(changeDetailVO.getOtherCostPrice());
                changeDetailVO.setBeforeOtherCostTaxPrice(changeDetailVO.getOtherCostTaxPrice());
                changeDetailVO.setBeforeOtherCostMny(changeDetailVO.getOtherCostMny());
                changeDetailVO.setBeforeOtherCostTaxMny(changeDetailVO.getOtherCostTaxMny());
                changeDetailVO.setBeforeOtherCostTax(changeDetailVO.getOtherCostTax());
                changeDetailVO.setBeforeOtherProfitAndLossMny(changeDetailVO.getOtherProfitAndLossMny());
                changeDetailVO.setChangeType(null);
                changeDetailVO.setChangeFlag("0");
            });
            vo.setOtherDetailList(TreeNodeBUtil.buildTreeS(otherList));
        }
        return vo;
    }

    @Override
    public BuildDutyVO ConvertFlag(Long id) {
        BuildDutyEntity entity = super.selectById(id);
        entity.setConvertFlag(1);
        super.updateById(entity);
        BuildDutyVO vo = BeanMapper.map(entity, BuildDutyVO.class);
        dutyService.pushFromImport(vo, false, ConversionEnum.中核华泰房建.getCode());
        return queryDetail(id);
    }

    @Override
    public BuildDutyVO queryDetail(Long id) {
        Map<String, LinkedHashMap<String, String>> subOrderMap = new HashMap<>();

        LinkedHashMap<String, String> sumOrder = new LinkedHashMap<>();
        sumOrder.put("sumTreeIndex", "asc");
        subOrderMap.put("sumDetailList", sumOrder);

        LinkedHashMap<String, String> laborOrder = new LinkedHashMap<>();
        laborOrder.put("laborTreeIndex", "asc");
        subOrderMap.put("laborDetailList", laborOrder);

        LinkedHashMap<String, String> materialOrder = new LinkedHashMap<>();
        materialOrder.put("materialTreeIndex", "asc");
        subOrderMap.put("materialDetailList", materialOrder);

        LinkedHashMap<String, String> equipOrder = new LinkedHashMap<>();
        equipOrder.put("equipTreeIndex", "asc");
        subOrderMap.put("equipDetailList", equipOrder);

        LinkedHashMap<String, String> proSubOrder = new LinkedHashMap<>();
        proSubOrder.put("proSubTreeIndex", "asc");
        subOrderMap.put("proSubDetailList", proSubOrder);

        LinkedHashMap<String, String> measureOrder = new LinkedHashMap<>();
        measureOrder.put("measureTreeIndex", "asc");
        subOrderMap.put("measureDetailList", measureOrder);

        LinkedHashMap<String, String> otherOrder = new LinkedHashMap<>();
        otherOrder.put("otherTreeIndex", "asc");
        subOrderMap.put("otherDetailList", otherOrder);

        BuildDutyEntity entity = super.selectById(id, subOrderMap);

        BuildDutyVO vo = BeanMapper.map(entity, BuildDutyVO.class);

        //子表树形处理
        if(CollectionUtils.isNotEmpty(vo.getEquipDetailList())) {
            vo.setEquipDetailList(TreeNodeBUtil.buildTreeS(vo.getEquipDetailList()));
        }
        if(CollectionUtils.isNotEmpty(vo.getLaborDetailList())) {
            vo.setLaborDetailList(TreeNodeBUtil.buildTreeS(vo.getLaborDetailList()));
        }
        if(CollectionUtils.isNotEmpty(vo.getMaterialDetailList())) {
            vo.setMaterialDetailList(TreeNodeBUtil.buildTreeS(vo.getMaterialDetailList()));
        }
        if(CollectionUtils.isNotEmpty(vo.getSumDetailList())) {
            vo.setSumDetailList(TreeNodeBUtil.buildTreeS(vo.getSumDetailList()));
        }
        if(CollectionUtils.isNotEmpty(vo.getMeasureDetailList())) {
            vo.setMeasureDetailList(TreeNodeBUtil.buildTreeS(vo.getMeasureDetailList()));
        }
        if(CollectionUtils.isNotEmpty(vo.getOtherDetailList())) {
            vo.setOtherDetailList(TreeNodeBUtil.buildTreeS(vo.getOtherDetailList()));
        }
        if(CollectionUtils.isNotEmpty(vo.getProSubDetailList())) {
            vo.setProSubDetailList(TreeNodeBUtil.buildTreeS(vo.getProSubDetailList()));
        }

        return vo;
    }
}
