package com.ejianc.business.targetcost.vo;

import com.ejianc.business.targetcost.utils.ITreeNodeB;
import com.fasterxml.jackson.annotation.JsonFormat.Shape;
import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * 目标责任成本
 *
 * @author generator
 */
public class DutyVO extends BaseVO implements ITreeNodeB {
    private static final long serialVersionUID = 1L;

    private Long orgId; // 所属组织，不显示默认当前组织
    private String orgName; // 项目组织名称
    private String orgCode; // 项目组织编码
    private Long parentOrgId; // 组织ID
    private String parentOrgName; // 组织名称
    private String parentOrgCode; // 组织编码
    private Long projectId; // 所属项目
    private String projectName; // 项目名称
    private String billCode; // 单据编码
    private String name; // 目标责任成本名称
    private Boolean latestFlag; // 是否最新版本
    private Boolean enableState; // 是否生效
    private BigDecimal mny; // 金额(无税)
    private BigDecimal taxMny; // 金额
    private Integer billState; // 审批状态
    private Long employeeId; // 经办人
    private String employeeName; // 经办人名称
    private Long departmentId; // 经办部门
    private String departmentName; // 经办部门名称
    private String memo; // 备注
    private Long feeId; // 费用模板主键
    private String feeName; // 费用模板名称
    private Long ruleId; // 控制规则主键
    private String ruleName; // 控制规则名称
    private Integer dutyVersion; // 责任成本版本号
    private Long lastDutyId; // 上一版本主键
    private Long changeId; // 变更单主键
    private Integer changeState; // 变更状态(0-未变更1-变更中2-已变更)
    private String changeStateName; // 变更状态名称(0-未变更1-变更中2-已变更)
    private BigDecimal completeScale;//完整度
    private BigDecimal beforeMny; // 变更前金额(无税)
    private BigDecimal beforeTaxMny; // 变更前金额
    private Integer beforeDutyVersion; // 变更前责任成本历史版本号
    private Integer costCount;
    private BigDecimal floatRate; // 目标成本管理责任书下浮率
    private String billStateName; // 单据状态名称
    @JsonFormat(
            shape = Shape.STRING,
            pattern = "yyyy-MM-dd HH:mm:ss",
            timezone = "GMT+8"
    )
    private Date oneTime; //1 版本创建时间
    private Boolean proFlag; // 暂估目标
    private Boolean gatherFlag; // 汇总标识
    private Long firstDutyId; //初始版本主键
    private Long wbsId; //核算对象ID
    private String wbsName; //核算对象名称
    private Long firstImportId; //初始导入单主键
    private Long importId; //导入单主键
    private String importType;//导入类型
    private Boolean showFlag;//是否显示

    private Long parentId; // pid
    private List<ITreeNodeB> children;

    private List<DutyDetailVO> dutyDetailList = new ArrayList<>(); // 目标责任成本明细

    public Long getLastDutyId() {
        return lastDutyId;
    }

    public void setLastDutyId(Long lastDutyId) {
        this.lastDutyId = lastDutyId;
    }

    public Long getChangeId() {
        return changeId;
    }

    public void setChangeId(Long changeId) {
        this.changeId = changeId;
    }

    public Integer getChangeState() {
        return changeState;
    }

    public void setChangeState(Integer changeState) {
        this.changeState = changeState;
    }

    public Integer getDutyVersion() {
        return dutyVersion;
    }

    public void setDutyVersion(Integer dutyVersion) {
        this.dutyVersion = dutyVersion;
    }

    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }

    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }

    public String getOrgCode() {
        return orgCode;
    }

    public void setOrgCode(String orgCode) {
        this.orgCode = orgCode;
    }

    public Long getParentOrgId() {
        return parentOrgId;
    }

    public void setParentOrgId(Long parentOrgId) {
        this.parentOrgId = parentOrgId;
    }

    public String getParentOrgName() {
        return parentOrgName;
    }

    public void setParentOrgName(String parentOrgName) {
        this.parentOrgName = parentOrgName;
    }

    public String getParentOrgCode() {
        return parentOrgCode;
    }

    public void setParentOrgCode(String parentOrgCode) {
        this.parentOrgCode = parentOrgCode;
    }

    @ReferSerialTransfer(referCode = "project-set")
    public Long getProjectId() {
        return projectId;
    }

    @ReferDeserialTransfer
    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }

    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }

    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Boolean getLatestFlag() {
        return latestFlag;
    }

    public void setLatestFlag(Boolean latestFlag) {
        this.latestFlag = latestFlag;
    }

    public Boolean getEnableState() {
        return enableState;
    }

    public void setEnableState(Boolean enableState) {
        this.enableState = enableState;
    }

    public BigDecimal getMny() {
        return mny;
    }

    public void setMny(BigDecimal mny) {
        this.mny = mny;
    }

    public BigDecimal getTaxMny() {
        return taxMny;
    }

    public void setTaxMny(BigDecimal taxMny) {
        this.taxMny = taxMny;
    }

    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }

    @ReferSerialTransfer(referCode = "idm-employee")
    public Long getEmployeeId() {
        return employeeId;
    }

    @ReferDeserialTransfer
    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }

    public String getEmployeeName() {
        return employeeName;
    }

    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }

    @ReferSerialTransfer(referCode = "idm-dept")
    public Long getDepartmentId() {
        return departmentId;
    }

    @ReferDeserialTransfer
    public void setDepartmentId(Long departmentId) {
        this.departmentId = departmentId;
    }

    public String getDepartmentName() {
        return departmentName;
    }

    public void setDepartmentName(String departmentName) {
        this.departmentName = departmentName;
    }

    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }

    @ReferSerialTransfer(referCode = "tc-fee")
    public Long getFeeId() {
        return feeId;
    }

    @ReferDeserialTransfer
    public void setFeeId(Long feeId) {
        this.feeId = feeId;
    }

    public String getFeeName() {
        return feeName;
    }

    public void setFeeName(String feeName) {
        this.feeName = feeName;
    }

    @ReferSerialTransfer(referCode = "tc-rule")
    public Long getRuleId() {
        return ruleId;
    }

    @ReferDeserialTransfer
    public void setRuleId(Long ruleId) {
        this.ruleId = ruleId;
    }

    public String getRuleName() {
        return ruleName;
    }

    public void setRuleName(String ruleName) {
        this.ruleName = ruleName;
    }

    public BigDecimal getCompleteScale() {
        return completeScale;
    }

    public void setCompleteScale(BigDecimal completeScale) {
        this.completeScale = completeScale;
    }

    public BigDecimal getBeforeMny() {
        return beforeMny;
    }

    public void setBeforeMny(BigDecimal beforeMny) {
        this.beforeMny = beforeMny;
    }

    public BigDecimal getBeforeTaxMny() {
        return beforeTaxMny;
    }

    public void setBeforeTaxMny(BigDecimal beforeTaxMny) {
        this.beforeTaxMny = beforeTaxMny;
    }

    public Integer getBeforeDutyVersion() {
        return beforeDutyVersion;
    }

    public void setBeforeDutyVersion(Integer beforeDutyVersion) {
        this.beforeDutyVersion = beforeDutyVersion;
    }

    public List<DutyDetailVO> getDutyDetailList() {
        return dutyDetailList;
    }

    public void setDutyDetailList(List<DutyDetailVO> dutyDetailList) {
        this.dutyDetailList = dutyDetailList;
    }

    public Integer getCostCount() {
        return costCount;
    }

    public void setCostCount(Integer costCount) {
        this.costCount = costCount;
    }

    public BigDecimal getFloatRate() {
        return floatRate;
    }

    public void setFloatRate(BigDecimal floatRate) {
        this.floatRate = floatRate;
    }

    public String getBillStateName() {
        return billStateName;
    }

    public void setBillStateName(String billStateName) {
        this.billStateName = billStateName;
    }

    public String getChangeStateName() {
        return changeStateName;
    }

    public void setChangeStateName(String changeStateName) {
        this.changeStateName = changeStateName;
    }

    public Date getOneTime() {
        return oneTime;
    }

    public void setOneTime(Date oneTime) {
        this.oneTime = oneTime;
    }

    public Boolean getProFlag() {
        return proFlag;
    }

    public void setProFlag(Boolean proFlag) {
        this.proFlag = proFlag;
    }

    public Boolean getGatherFlag() {
        return gatherFlag;
    }

    public void setGatherFlag(Boolean gatherFlag) {
        this.gatherFlag = gatherFlag;
    }

    public Long getFirstDutyId() {
        return firstDutyId;
    }

    public void setFirstDutyId(Long firstDutyId) {
        this.firstDutyId = firstDutyId;
    }

    @ReferSerialTransfer(referCode = "subject-project-wbs-ref")
    public Long getWbsId() {
        return wbsId;
    }

    @ReferDeserialTransfer
    public void setWbsId(Long wbsId) {
        this.wbsId = wbsId;
    }

    public String getWbsName() {
        return wbsName;
    }

    public void setWbsName(String wbsName) {
        this.wbsName = wbsName;
    }

    public Long getFirstImportId() {
        return firstImportId;
    }

    public void setFirstImportId(Long firstImportId) {
        this.firstImportId = firstImportId;
    }

    public Long getImportId() {
        return importId;
    }

    public void setImportId(Long importId) {
        this.importId = importId;
    }

    public String getImportType() {
        return importType;
    }

    public void setImportType(String importType) {
        this.importType = importType;
    }

    public Boolean getShowFlag() {
        return showFlag;
    }

    public void setShowFlag(Boolean showFlag) {
        this.showFlag = showFlag;
    }

    @Override
    public Long getNodeID() {
        return getId();
    }

    @Override
    public Long getParentID() {
        return parentId;
    }

    @Override
    public List<ITreeNodeB> getChildren() {
        if (children == null) {
            children = new ArrayList<>();
        }
        return children;
    }

    public Long getParentId() {
        return parentId;
    }

    public void setParentId(Long parentId) {
        this.parentId = parentId;
    }

    public void setChildren(List<ITreeNodeB> children) {
        this.children = children;
    }
}
